/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Comparators {
    private Comparators() {
    }

    public static <T> Comparator<T> chain(Comparator<? super T> c1, Comparator<? super T> c2) {
        return (o1, o2) -> {
            int x = c1.compare(o1, o2);
            return x == 0 ? c2.compare(o1, o2) : x;
        };
    }

    public static <T> Comparator<T> chain(List<Comparator<? super T>> c) {
        return (o1, o2) -> {
            int x = 0;
            Iterator it = c.iterator();
            while (x == 0 && it.hasNext()) {
                x = ((Comparator)it.next()).compare(o1, o2);
            }
            return x;
        };
    }

    @SafeVarargs
    public static <T> Comparator<T> chain(Comparator<T> ... c) {
        return Comparators.chain(Arrays.asList(c));
    }

    public static <T> Comparator<T> reverse(Comparator<? super T> c) {
        return (o1, o2) -> -c.compare(o1, o2);
    }

    public static <T extends Comparable<? super T>> Comparator<T> nullSafeNaturalComparator() {
        return Comparators::nullSafeCompare;
    }

    public static <T extends Comparable<? super T>> int nullSafeCompare(T one, T two) {
        if (one == null) {
            if (two == null) {
                return 0;
            }
            return -1;
        }
        if (two == null) {
            return 1;
        }
        return one.compareTo(two);
    }

    private static <X extends Comparable<X>> int compareLists(List<? extends X> list1, List<? extends X> list2) {
        if (list1 == null || list2 == null) {
            throw new IllegalArgumentException();
        }
        int size1 = list1.size();
        int size2 = list2.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            int c = ((Comparable)list1.get(i)).compareTo(list2.get(i));
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(size1, size2);
    }

    public static <C extends Comparable> Comparator<List<C>> getListComparator() {
        return Comparators::compareLists;
    }

    public static Comparator getStringRepresentationComparator() {
        return Comparator.comparing(Object::toString);
    }

    public static Comparator<boolean[]> getBooleanArrayComparator() {
        return ArrayUtils::compareBooleanArrays;
    }

    public static <C extends Comparable> Comparator<C[]> getArrayComparator() {
        return (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compareArrays(java.lang.Comparable[] java.lang.Comparable[] ), ([Ljava/lang/Comparable;[Ljava/lang/Comparable;)I)();
    }
}

