/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure;
import java.util.function.Predicate;

public class ChineseGrammaticalStructureFactory
implements GrammaticalStructureFactory {
    private final Predicate<String> puncFilter;
    private final HeadFinder hf;

    public ChineseGrammaticalStructureFactory() {
        this(null, null);
    }

    public ChineseGrammaticalStructureFactory(Predicate<String> puncFilter) {
        this(puncFilter, null);
    }

    public ChineseGrammaticalStructureFactory(Predicate<String> puncFilter, HeadFinder hf) {
        this.puncFilter = puncFilter;
        this.hf = hf;
    }

    @Override
    public ChineseGrammaticalStructure newGrammaticalStructure(Tree t) {
        if (this.puncFilter == null && this.hf == null) {
            return new ChineseGrammaticalStructure(t);
        }
        if (this.hf == null) {
            return new ChineseGrammaticalStructure(t, this.puncFilter);
        }
        return new ChineseGrammaticalStructure(t, this.puncFilter, this.hf);
    }
}

