/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.semgraph.semgrex.Alignment;
import edu.stanford.nlp.semgraph.semgrex.ParseException;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParseException;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParser;
import edu.stanford.nlp.semgraph.semgrex.TokenMgrError;
import edu.stanford.nlp.semgraph.semgrex.VariableStrings;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class SemgrexPattern
implements Serializable {
    private static final long serialVersionUID = 1722052832350596732L;
    private boolean neg = false;
    private boolean opt = false;
    private String patternString;
    static final String PATTERN = "-pattern";
    static final String TREE_FILE = "-treeFile";
    static final String MODE = "-mode";
    static final String DEFAULT_MODE = "BASIC";
    static final String EXTRAS = "-extras";

    SemgrexPattern() {
    }

    abstract List<SemgrexPattern> getChildren();

    abstract String localString();

    abstract void setChild(SemgrexPattern var1);

    void negate() {
        if (this.opt) {
            throw new RuntimeException("Node cannot be both negated and optional.");
        }
        this.neg = true;
    }

    void makeOptional() {
        if (this.neg) {
            throw new RuntimeException("Node cannot be both negated and optional.");
        }
        this.opt = true;
    }

    boolean isNegated() {
        return this.neg;
    }

    boolean isOptional() {
        return this.opt;
    }

    abstract SemgrexMatcher matcher(SemanticGraph var1, IndexedWord var2, Map<String, IndexedWord> var3, Map<String, String> var4, VariableStrings var5, boolean var6);

    abstract SemgrexMatcher matcher(SemanticGraph var1, Alignment var2, SemanticGraph var3, boolean var4, IndexedWord var5, Map<String, IndexedWord> var6, Map<String, String> var7, VariableStrings var8, boolean var9);

    public SemgrexMatcher matcher(SemanticGraph sg) {
        return this.matcher(sg, sg.getFirstRoot(), Generics.newHashMap(), Generics.newHashMap(), new VariableStrings(), false);
    }

    public SemgrexMatcher matcher(SemanticGraph sg, Map<String, IndexedWord> variables) {
        return this.matcher(sg, sg.getFirstRoot(), variables, Generics.newHashMap(), new VariableStrings(), false);
    }

    public SemgrexMatcher matcher(SemanticGraph sg, boolean ignoreCase) {
        return this.matcher(sg, sg.getFirstRoot(), Generics.newHashMap(), Generics.newHashMap(), new VariableStrings(), ignoreCase);
    }

    public SemgrexMatcher matcher(SemanticGraph hypGraph, Alignment alignment, SemanticGraph txtGraph) {
        return this.matcher(hypGraph, alignment, txtGraph, true, hypGraph.getFirstRoot(), Generics.newHashMap(), Generics.newHashMap(), new VariableStrings(), false);
    }

    public SemgrexMatcher matcher(SemanticGraph hypGraph, Alignment alignment, SemanticGraph txtGraph, boolean ignoreCase) {
        return this.matcher(hypGraph, alignment, txtGraph, true, hypGraph.getFirstRoot(), Generics.newHashMap(), Generics.newHashMap(), new VariableStrings(), ignoreCase);
    }

    public static SemgrexPattern compile(String semgrex) {
        try {
            SemgrexParser parser = new SemgrexParser(new StringReader(semgrex + "\n"));
            SemgrexPattern newPattern = parser.Root();
            newPattern.patternString = semgrex;
            return newPattern;
        }
        catch (ParseException ex) {
            throw new SemgrexParseException("Error parsing semgrex pattern " + semgrex, ex);
        }
        catch (TokenMgrError er) {
            throw new SemgrexParseException("Error parsing semgrex pattern " + semgrex, er);
        }
    }

    public String pattern() {
        return this.patternString;
    }

    public abstract String toString();

    public abstract String toString(boolean var1);

    private void prettyPrint(PrintWriter pw, int indent) {
        for (int i = 0; i < indent; ++i) {
            pw.print("   ");
        }
        pw.println(this.localString());
        for (SemgrexPattern child : this.getChildren()) {
            child.prettyPrint(pw, indent + 1);
        }
    }

    public void prettyPrint(PrintWriter pw) {
        this.prettyPrint(pw, 0);
    }

    public void prettyPrint(PrintStream ps) {
        this.prettyPrint(new PrintWriter((Writer)new OutputStreamWriter(ps), true));
    }

    public void prettyPrint() {
        this.prettyPrint(System.out);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SemgrexPattern)) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static void help() {
        System.err.println("Possible arguments for SemgrexPattern:");
        System.err.println("-pattern: what pattern to use for matching");
        System.err.println("-treeFile: a file of trees to process");
        System.err.println("-mode: what mode for dependencies.  basic, collapsed, or ccprocessed.  To get 'noncollapsed', use basic with extras");
        System.err.println("-extras: whether or not to use extras");
        System.err.println();
        System.err.println("-pattern is required");
    }

    public static void main(String[] args) {
        Map<String, Integer> flagMap = Generics.newHashMap();
        flagMap.put(PATTERN, 1);
        flagMap.put(TREE_FILE, 1);
        flagMap.put(MODE, 1);
        flagMap.put(EXTRAS, 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (!argsMap.containsKey(PATTERN) || argsMap.get(PATTERN).length == 0) {
            SemgrexPattern.help();
            System.exit(2);
        }
        SemgrexPattern semgrex = SemgrexPattern.compile(argsMap.get(PATTERN)[0]);
        String modeString = DEFAULT_MODE;
        if (argsMap.containsKey(MODE) && argsMap.get(MODE).length > 0) {
            modeString = argsMap.get(MODE)[0].toUpperCase();
        }
        SemanticGraphFactory.Mode mode = SemanticGraphFactory.Mode.valueOf(modeString);
        boolean useExtras = true;
        if (argsMap.containsKey(EXTRAS) && argsMap.get(EXTRAS).length > 0) {
            useExtras = Boolean.valueOf(argsMap.get(EXTRAS)[0]);
        }
        ArrayList<SemanticGraph> graphs = Generics.newArrayList();
        if (argsMap.containsKey(TREE_FILE) && argsMap.get(TREE_FILE).length > 0) {
            for (String treeFile : argsMap.get(TREE_FILE)) {
                System.err.println("Loading file " + treeFile);
                MemoryTreebank treebank = new MemoryTreebank(new TreeNormalizer());
                treebank.loadPath(treeFile);
                for (Tree tree : treebank) {
                    SemanticGraph graph = SemanticGraphFactory.makeFromTree(tree, mode, useExtras, true, null);
                    graphs.add(graph);
                }
            }
        }
        for (SemanticGraph graph : graphs) {
            SemgrexMatcher matcher = semgrex.matcher(graph);
            if (!matcher.find()) continue;
            System.err.println("Matched graph:");
            System.err.println(graph.toString(SemanticGraph.OutputFormat.LIST));
            boolean found = true;
            while (found) {
                System.err.println("Matches at: " + matcher.getMatch().value() + "-" + matcher.getMatch().index());
                ArrayList<String> nodeNames = Generics.newArrayList();
                nodeNames.addAll(matcher.getNodeNames());
                Collections.sort(nodeNames);
                for (String name : nodeNames) {
                    System.err.println("  " + name + ": " + matcher.getNode(name).value() + "-" + matcher.getNode(name).index());
                }
                System.err.println();
                found = matcher.find();
            }
        }
    }
}

