/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.tregex.gui.DisplayMatchesPanel;
import edu.stanford.nlp.trees.tregex.gui.FilePanel;
import edu.stanford.nlp.trees.tregex.gui.FileTreeModel;
import edu.stanford.nlp.trees.tregex.gui.FileTreeNode;
import edu.stanford.nlp.trees.tregex.gui.InputPanel;
import edu.stanford.nlp.trees.tregex.gui.MatchesPanel;
import edu.stanford.nlp.trees.tregex.gui.PreferencesPanel;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class TregexGUI
extends JFrame
implements ActionListener,
MatchesPanel.MatchesPanelListener {
    private static TregexGUI instance;
    private JMenuItem preferences;
    private JMenuItem loadFiles;
    private JMenuItem saveMatches;
    private JMenuItem saveSentences;
    private JMenuItem saveHistory;
    private JMenuItem loadTsurgeon;
    private JMenuItem tDiff;
    private JMenuItem quit;
    private JMenuItem copy;
    private JMenuItem clearFileList;
    private JFileChooser chooser;
    private static File chooserFile;
    final TreeTransformer transformer;
    private JDialog preferenceDialog;
    private JDialog aboutBox;
    private static final String TRANSFORMER = "transformer";
    private boolean doTdiff = false;
    public static final int MAX_TDIFF_TREEBANKS = 2;

    private JMenuBar getMenu() {
        JMenuBar mbar = new JMenuBar();
        JMenu file = new JMenu("File");
        this.loadFiles = new JMenuItem("Load trees...");
        this.loadFiles.addActionListener(this);
        this.saveMatches = new JMenuItem("Save matched trees...");
        this.saveMatches.addActionListener(this);
        this.saveMatches.setEnabled(false);
        this.saveSentences = new JMenuItem("Save matched sentences...");
        this.saveSentences.addActionListener(this);
        this.saveSentences.setEnabled(false);
        this.saveHistory = new JMenuItem("Save statistics...");
        this.saveHistory.addActionListener(this);
        this.saveHistory.setEnabled(false);
        this.loadTsurgeon = new JMenuItem("Load Tsurgeon script...");
        this.loadTsurgeon.addActionListener(this);
        this.clearFileList = new JMenuItem("Clear tree file list");
        this.clearFileList.addActionListener(this);
        this.clearFileList.setEnabled(false);
        this.quit = new JMenuItem("Exit");
        this.quit.addActionListener(this);
        file.add(this.loadFiles);
        file.add(this.loadTsurgeon);
        file.addSeparator();
        file.add(this.clearFileList);
        file.addSeparator();
        file.add(this.saveMatches);
        file.add(this.saveSentences);
        file.add(this.saveHistory);
        if (!TregexGUI.isMacOSX()) {
            file.addSeparator();
            file.addSeparator();
            file.add(this.quit);
        }
        JMenu edit = new JMenu("Edit");
        this.copy = new JMenuItem("Copy");
        this.copy.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        this.copy.addActionListener(new TransferActionListener());
        edit.add(this.copy);
        this.preferences = new JMenuItem("Options...");
        this.preferences.addActionListener(this);
        this.tDiff = new JCheckBoxMenuItem("Tdiff");
        this.tDiff.addActionListener(this);
        JMenu tools = new JMenu("Tools");
        if (!TregexGUI.isMacOSX()) {
            tools.add(this.preferences);
        }
        tools.add(this.tDiff);
        mbar.add(file);
        mbar.add(edit);
        mbar.add(tools);
        this.setShortcutKeys();
        return mbar;
    }

    private void setShortcutKeys() {
        if (TregexGUI.isMacOSX()) {
            this.setMacShortcutKeys();
        } else {
            this.setWindowsShortcutKeys();
        }
    }

    private void setMacShortcutKeys() {
        this.preferences.setAccelerator(KeyStroke.getKeyStroke(44, 4));
        this.loadFiles.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        this.saveMatches.setAccelerator(KeyStroke.getKeyStroke(83, 4));
        this.saveHistory.setAccelerator(KeyStroke.getKeyStroke(83, 5));
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, 4));
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 4));
    }

    private void setWindowsShortcutKeys() {
        this.loadFiles.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveMatches.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveHistory.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
    }

    private void initAboutBox() {
        this.aboutBox = new JDialog((Frame)this, "About Tregex");
        this.aboutBox.getContentPane().setLayout(new BorderLayout());
        this.aboutBox.getContentPane().add((Component)new JLabel("<html><b>Tregex and Tsurgeon</b></html>", 0), "North");
        this.aboutBox.getContentPane().add((Component)new JLabel("<html>Tregex by Galen Andrew and Roger Levy<br>Tsurgeon by Roger Levy<br>Graphical interface by Anna Rafferty<br>Additional features and development by Chris Manning<br></html>", 0), "Center");
        this.aboutBox.getContentPane().add((Component)new JLabel("<html><font size=2>\u00a92007 The Board of Trustees of The Leland Stanford Junior University.<br>Distributed under the GNU General Public License</font></html>", 0), "South");
    }

    public void setSaveEnabled(boolean enabled) {
        if (this.saveMatches.isEnabled() != enabled) {
            this.saveMatches.setEnabled(enabled);
            this.saveSentences.setEnabled(enabled);
        }
    }

    public void setSaveHistoryEnabled(boolean enabled) {
        if (this.saveHistory.isEnabled() != enabled) {
            this.saveHistory.setEnabled(enabled);
        }
    }

    public void setTsurgeonEnabled(boolean enabled) {
        if (this.loadTsurgeon.isEnabled() != enabled) {
            this.loadTsurgeon.setEnabled(enabled);
        }
    }

    private static void setMacProperties() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Tregex");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static TregexGUI getInstance() {
        return instance;
    }

    private static JSplitPane setUpTopPanels() {
        FilePanel filePanel = FilePanel.getInstance();
        InputPanel inputPanel = InputPanel.getInstance();
        MatchesPanel matchesPanel = MatchesPanel.getInstance();
        JSplitPane inputAndMatchesPane = new JSplitPane(1, true, inputPanel, matchesPanel);
        inputAndMatchesPane.setDividerLocation(450);
        inputAndMatchesPane.setResizeWeight(0.5);
        inputAndMatchesPane.setBorder(BorderFactory.createEmptyBorder());
        JSplitPane fullTopPanel = new JSplitPane(1, true, filePanel, inputAndMatchesPane);
        fullTopPanel.setDividerLocation(275);
        fullTopPanel.setBorder(BorderFactory.createEmptyBorder());
        return fullTopPanel;
    }

    private TregexGUI(Properties props, List<String> initialFiles) {
        super("Tregex");
        instance = this;
        TregexGUI.setDefaultLookAndFeelDecorated(true);
        this.setDefaultCloseOperation(3);
        String transformerClass = props.getProperty(TRANSFORMER, null);
        this.transformer = transformerClass == null ? null : (TreeTransformer)ReflectionLoading.loadByReflection(transformerClass, new Object[0]);
        this.initAboutBox();
        Container content = this.getContentPane();
        content.setBackground(Color.lightGray);
        JMenuBar mbar = this.getMenu();
        DisplayMatchesPanel displayMatchesPanel = DisplayMatchesPanel.getInstance();
        JSplitPane inputAndMatchesPanel = TregexGUI.setUpTopPanels();
        MatchesPanel.getInstance().addListener(this);
        this.setFocusTraversalKeysEnabled(true);
        this.macOSXRegistration();
        this.setJMenuBar(mbar);
        content.setLayout(new BorderLayout());
        JSplitPane verticalSplit = new JSplitPane(0, inputAndMatchesPanel, displayMatchesPanel);
        verticalSplit.setResizeWeight(0.2);
        this.add((Component)verticalSplit, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int begX = (int)((double)screenSize.width * 0.05);
        int begY = (int)((double)screenSize.height * 0.05);
        screenSize.width = (int)((double)screenSize.width * 0.9);
        screenSize.height = (int)((double)screenSize.height * 0.9);
        if (screenSize.width > 1200) {
            screenSize.width = 1200;
        }
        if (screenSize.height > 800) {
            screenSize.height = 800;
        }
        this.setPreferredSize(screenSize);
        Dimension displayMatchesSize = new Dimension((int)screenSize.getWidth(), (int)(screenSize.getHeight() * 3.0 / 4.0));
        displayMatchesPanel.setPreferredSize(displayMatchesSize);
        this.setBounds(begX, begY, screenSize.width, screenSize.height);
        this.pack();
        if (initialFiles.size() > 0) {
            File[] files = new File[initialFiles.size()];
            for (int i = 0; i < initialFiles.size(); ++i) {
                files[i] = new File(initialFiles.get(i));
            }
            this.startFileLoadingThread(new EnumMap<FilterType, String>(FilterType.class), files);
        }
        this.setVisible(true);
    }

    private void macOSXRegistration() {
        if (TregexGUI.isMacOSX()) {
            try {
                Class<?> osxAdapter = ClassLoader.getSystemClassLoader().loadClass("edu.stanford.nlp.trees.tregex.gui.OSXAdapter");
                Class[] defArgs = new Class[]{TregexGUI.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                if (prefsEnableMethod != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    private static JFileChooser createFileChooser() {
        final JFileChooser chooser = new JFileChooser();
        try {
            chooserFile = new File(new File(".").getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        chooser.setCurrentDirectory(chooserFile);
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    chooserFile = chooser.getSelectedFile();
                }
            }
        });
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        return chooser;
    }

    private void doLoadFiles() {
        if (this.chooser == null) {
            this.chooser = TregexGUI.createFileChooser();
        }
        String approveText = this.chooser.getApproveButtonText();
        this.chooser.setApproveButtonText("Load with file filters");
        int status = this.chooser.showOpenDialog(this);
        this.chooser.setApproveButtonText(approveText);
        if (status == 0) {
            File[] selectedFiles = this.chooser.getSelectedFiles();
            boolean haveDirectory = false;
            for (File f : selectedFiles) {
                if (!f.isDirectory()) continue;
                haveDirectory = true;
                break;
            }
            if (haveDirectory) {
                this.doFileFilters(selectedFiles);
            } else {
                this.startFileLoadingThread(new EnumMap<FilterType, String>(FilterType.class), selectedFiles);
            }
        }
    }

    private void doFileFilters(File[] files) {
        final File[] cFiles = files;
        final JPanel fileFilterPanel = new JPanel();
        fileFilterPanel.setLayout(new BoxLayout(fileFilterPanel, 3));
        JLabel text = new JLabel("<html>Please indicate any constraints on the files you want to load. All files in specified folders that satisfy all of the given constraints will be loaded. Just press Okay to load all files.</html>");
        text.setAlignmentX(10.0f);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setPreferredSize(new Dimension(100, 50));
        textPanel.add(text);
        fileFilterPanel.add(textPanel);
        fileFilterPanel.add(Box.createVerticalStrut(5));
        Box defaultFilter = TregexGUI.getNewFilter();
        fileFilterPanel.add(defaultFilter);
        JOptionPane fileFilterDialog = new JOptionPane();
        fileFilterDialog.setMessage(fileFilterPanel);
        Object[] options = new JButton[3];
        JButton okay = new JButton("Okay");
        JButton add = new JButton("Add another filter");
        JButton cancel = new JButton("Cancel");
        options[0] = okay;
        options[1] = add;
        options[2] = cancel;
        fileFilterDialog.setOptions(options);
        final JDialog dialog = fileFilterDialog.createDialog(null, "Set file filters...");
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EnumMap filters = TregexGUI.getFilters(fileFilterPanel);
                if (filters.containsKey((Object)FilterType.isInRange)) {
                    try {
                        new NumberRangesFileFilter((String)filters.get((Object)FilterType.isInRange), false);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(dialog, new JLabel("<html>Please check the range you specified for the file number.  Ranges must be numerical, and disjoint <br>ranges should be separated by commas.  For example \"1-200,250-375\" is a valid range.</html>"), "Error in File Number Range", 0);
                        return;
                    }
                }
                dialog.setVisible(false);
                TregexGUI.this.startFileLoadingThread(filters, cFiles);
            }
        });
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileFilterPanel.add(TregexGUI.getNewFilter());
                dialog.pack();
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.getRootPane().setDefaultButton(okay);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void startFileLoadingThread(final EnumMap<FilterType, String> filters, final File[] cFiles) {
        Thread t = new Thread(){

            @Override
            public void run() {
                FilePanel.getInstance().loadFiles(filters, cFiles);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TregexGUI.this.clearFileList.setEnabled(true);
                    }
                });
            }
        };
        t.start();
    }

    private static EnumMap<FilterType, String> getFilters(JPanel panel) {
        Component[] components;
        EnumMap<FilterType, String> filters = new EnumMap<FilterType, String>(FilterType.class);
        for (Component c : components = panel.getComponents()) {
            if (c.getClass() != Box.class) continue;
            JComboBox filterType = (JComboBox)((Container)c).getComponent(0);
            JTextField filterValue = (JTextField)((Container)c).getComponent(2);
            filters.put((FilterType)((Object)filterType.getSelectedItem()), filterValue.getText());
        }
        return filters;
    }

    private static Box getNewFilter() {
        Box filter = Box.createHorizontalBox();
        FilterType[] filterTypeOptions = FilterType.values();
        JComboBox<FilterType> filterTypes = new JComboBox<FilterType>(filterTypeOptions);
        filterTypes.setEditable(false);
        filter.add(filterTypes);
        filter.add(Box.createHorizontalGlue());
        JTextField filterInput = new JTextField();
        filterInput.setEditable(true);
        filter.add(filterInput);
        return filter;
    }

    private void doSaveFile() {
        int status;
        if (this.chooser == null) {
            this.chooser = TregexGUI.createFileChooser();
        }
        if ((status = this.chooser.showSaveDialog(this)) == 0) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedWriter out2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(TregexGUI.this.chooser.getSelectedFile()), FileTreeModel.getCurEncoding()));
                        StringBuffer sb = MatchesPanel.getInstance().getMatches();
                        out2.write(sb.toString());
                        out2.flush();
                        out2.close();
                    }
                    catch (Exception e) {
                        System.err.println("Exception in save");
                        e.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    private void doSaveSentencesFile() {
        int status;
        if (this.chooser == null) {
            this.chooser = TregexGUI.createFileChooser();
        }
        if ((status = this.chooser.showSaveDialog(this)) == 0) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedWriter out2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(TregexGUI.this.chooser.getSelectedFile()), FileTreeModel.getCurEncoding()));
                        StringBuffer sb = MatchesPanel.getInstance().getMatchedSentences();
                        out2.write(sb.toString());
                        out2.flush();
                        out2.close();
                    }
                    catch (Exception e) {
                        System.err.println("Exception in save");
                        e.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    private void doSaveHistory() {
        int status;
        if (this.chooser == null) {
            this.chooser = TregexGUI.createFileChooser();
        }
        if ((status = this.chooser.showSaveDialog(this)) == 0) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedWriter out2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(TregexGUI.this.chooser.getSelectedFile()), FileTreeModel.getCurEncoding()));
                        String hist = InputPanel.getInstance().getHistoryString();
                        out2.write(hist);
                        out2.flush();
                        out2.close();
                    }
                    catch (Exception e) {
                        System.err.println("Exception in save");
                        e.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    private void loadTsurgeonScript() {
        int status;
        if (this.chooser == null) {
            this.chooser = TregexGUI.createFileChooser();
        }
        if ((status = this.chooser.showOpenDialog(this)) == 0) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(TregexGUI.this.chooser.getSelectedFile().toString()));
                        final String tregexPatternString = Tsurgeon.getTregexPatternFromReader(reader);
                        final String tsurgeonOperationsString = Tsurgeon.getTsurgeonTextFromReader(reader);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                InputPanel.getInstance().setScriptAndPattern(tregexPatternString, tsurgeonOperationsString);
                            }
                        });
                    }
                    catch (IOException e) {
                        System.out.println("Error parsing Tsurgeon file");
                    }
                }
            };
            t.start();
        }
    }

    void doPreferences() {
        if (this.preferenceDialog == null) {
            this.preferenceDialog = new PreferencesPanel(this);
        }
        this.preferenceDialog.pack();
        this.preferenceDialog.setLocationRelativeTo(this);
        this.preferenceDialog.setVisible(true);
    }

    private void doTdiff() {
        this.doTdiff = !this.doTdiff;
        ((JCheckBoxMenuItem)this.tDiff).setState(this.doTdiff);
        if (this.doTdiff) {
            List<FileTreeNode> activeTreebanks = FilePanel.getInstance().getActiveTreebanks();
            for (int i = 2; i < activeTreebanks.size(); ++i) {
                activeTreebanks.get(i).setActive(false);
            }
        }
    }

    public boolean isTdiffEnabled() {
        return this.doTdiff;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loadFiles) {
            this.doLoadFiles();
        } else if (source == this.saveMatches) {
            this.doSaveFile();
        } else if (source == this.saveSentences) {
            this.doSaveSentencesFile();
        } else if (source == this.loadTsurgeon) {
            this.loadTsurgeonScript();
        } else if (source == this.preferences) {
            this.doPreferences();
        } else if (source == this.tDiff) {
            this.doTdiff();
        } else if (source == this.quit) {
            TregexGUI.doQuit();
        } else if (source == this.saveHistory) {
            this.doSaveHistory();
        } else if (source == this.clearFileList) {
            this.doClearFileList();
        }
    }

    public void doClearFileList() {
        FilePanel.getInstance().clearAll();
        this.clearFileList.setEnabled(false);
    }

    public static void doQuit() {
        System.exit(0);
    }

    @Override
    public void matchesChanged() {
        this.setSaveEnabled(!MatchesPanel.getInstance().isEmpty());
    }

    public static void main(String[] args) {
        if (TregexGUI.isMacOSX()) {
            TregexGUI.setMacProperties();
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Properties props = new Properties();
        ArrayList<String> filenames = Generics.newArrayList();
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-transformer")) {
                props.setProperty(TRANSFORMER, args[argIndex + 1]);
                argIndex += 2;
                continue;
            }
            filenames.add(args[argIndex++]);
        }
        new TregexGUI(props, filenames);
    }

    public void about() {
        this.aboutBox.setSize(360, 240);
        this.aboutBox.setLocation((int)this.getLocation().getX() + 22, (int)this.getLocation().getY() + 22);
        this.aboutBox.setResizable(false);
        this.aboutBox.setVisible(true);
    }

    public static enum FilterType {
        none("None"),
        hasExtension("Has extension: "),
        hasPrefix("Has prefix: "),
        isInRange("Has number in range: ");

        private final String text;

        private FilterType(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class TransferActionListener
    implements ActionListener,
    PropertyChangeListener {
        private JComponent focusOwner;

        public TransferActionListener() {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object o = e.getNewValue();
            this.focusOwner = o instanceof JComponent ? (JComponent)o : null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.focusOwner == null) {
                return;
            }
            String action = e.getActionCommand();
            Action a = this.focusOwner.getActionMap().get(action);
            if (a != null) {
                a.actionPerformed(new ActionEvent(this.focusOwner, 1001, null));
            }
        }
    }
}

