/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.swing.FontDetector;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.LeftHeadFinder;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.StringLabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicHeadFinder;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeReaderFactory;
import edu.stanford.nlp.trees.international.french.DybroFrenchHeadFinder;
import edu.stanford.nlp.trees.international.french.FrenchTreeReaderFactory;
import edu.stanford.nlp.trees.international.negra.NegraHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.BikelChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.CTBTreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.ChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.NoEmptiesCTBTreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.SunJurafskyChineseHeadFinder;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZHeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.gui.DisplayMatchesPanel;
import edu.stanford.nlp.trees.tregex.gui.FilePanel;
import edu.stanford.nlp.trees.tregex.gui.FileTreeModel;
import edu.stanford.nlp.trees.tregex.gui.InputPanel;
import edu.stanford.nlp.trees.tregex.gui.MatchesPanel;
import edu.stanford.nlp.trees.tregex.gui.TregexGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PreferencesPanel
extends JDialog {
    private static final String FONT_ERROR = "font";
    private static final String HISTORY_ERROR = "history";
    private static final String MAX_MATCH_ERROR = "maxMatch";
    final JButton highlightButton;
    private JTextField setEncoding;

    public PreferencesPanel(TregexGUI gui) {
        super((Frame)gui, "Preferences");
        JButton cancel;
        this.setResizable(false);
        final JPanel prefPanel = new JPanel();
        prefPanel.setLayout(new GridBagLayout());
        Box displayPrefs = Box.createVerticalBox();
        displayPrefs.setBorder(BorderFactory.createTitledBorder("Display"));
        JPanel displayOptions = new JPanel();
        displayOptions.setLayout(new GridLayout(3, 2, 0, 2));
        JLabel historyLabel = new JLabel("Recent matches length: ");
        final JTextField historySizeField = new JTextField();
        displayOptions.add(historyLabel);
        displayOptions.add(historySizeField);
        JLabel maxMatchesLabel = new JLabel("Max displayed trees: ");
        final JTextField maxMatchesSizeField = new JTextField(Integer.toString(MatchesPanel.getInstance().getMaxMatches()));
        displayOptions.add(maxMatchesLabel);
        displayOptions.add(maxMatchesSizeField);
        JLabel highlightLabel = new JLabel("Highlight color:");
        this.highlightButton = PreferencesPanel.makeColorButton("Pick a new highlight color: ", MatchesPanel.getInstance().getHighlightColor(), prefPanel);
        this.highlightButton.putClientProperty("JButton.buttonType", "icon");
        displayOptions.add(highlightLabel);
        displayOptions.add(this.highlightButton);
        displayPrefs.add(displayOptions);
        Box treeDisplayPrefs = Box.createVerticalBox();
        treeDisplayPrefs.setBorder(BorderFactory.createTitledBorder("Tree Display"));
        JPanel treeDisplayOptions = new JPanel();
        treeDisplayOptions.setLayout(new GridLayout(4, 2));
        JLabel fontName = new JLabel("Font: ");
        final JComboBox<String> fontPicker = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        fontPicker.setSelectedItem("Dialog");
        JLabel sizeLabel = new JLabel("Font size: ");
        final JTextField size = new JTextField();
        treeDisplayOptions.add(fontName);
        treeDisplayOptions.add(fontPicker);
        treeDisplayOptions.add(sizeLabel);
        treeDisplayOptions.add(size);
        JLabel defaultColorLabel = new JLabel("Tree color: ");
        final JButton defaultColorButton = PreferencesPanel.makeColorButton("Pick a new tree color: ", DisplayMatchesPanel.getInstance().getDefaultColor(), prefPanel);
        treeDisplayOptions.add(defaultColorLabel);
        treeDisplayOptions.add(defaultColorButton);
        JLabel matchedLabel = new JLabel("Matched node color: ");
        final JButton matchedButton = PreferencesPanel.makeColorButton("Pick a new color for matched nodes: ", DisplayMatchesPanel.getInstance().getMatchedColor(), prefPanel);
        treeDisplayOptions.add(matchedLabel);
        treeDisplayOptions.add(matchedButton);
        treeDisplayPrefs.add(treeDisplayOptions);
        JPanel advOptions = new JPanel();
        advOptions.setBorder(BorderFactory.createTitledBorder("Advanced "));
        advOptions.setLayout(new GridLayout(3, 2, 0, 4));
        JLabel headfinderName = new JLabel("Head finder:");
        final JComboBox<String> headfinderPicker = new JComboBox<String>(new String[]{"ArabicHeadFinder", "BikelChineseHeadFinder", "ChineseHeadFinder", "ChineseSemanticHeadFinder", "CollinsHeadFinder", "FrenchHeadFinder", "LeftHeadFinder", "ModCollinsHeadFinder", "NegraHeadFinder", "SemanticHeadFinder", "SunJurafskyChineseHeadFinder", "TueBaDZHeadFinder"});
        headfinderPicker.setEditable(true);
        headfinderPicker.setSelectedItem("CollinsHeadFinder");
        JLabel treeReaderFactoryName = new JLabel("Tree reader factory:");
        final JComboBox<String> trfPicker = new JComboBox<String>(new String[]{"ArabicTreeReaderFactory", "ArabicTreeReaderFactory.ArabicRawTreeReaderFactory", "CTBTreeReaderFactory", "Basic categories only (LabeledScoredTreeReaderFactory)", "FrenchTreeReaderFactory", "NoEmptiesCTBTreeReaderFactory", "PennTreeReaderFactory", "TregexPattern.TregexTreeReaderFactory"});
        trfPicker.setEditable(true);
        trfPicker.setSelectedItem("TregexPattern.TregexTreeReaderFactory");
        JLabel encodingLabel = new JLabel("Character encoding: ");
        this.setEncoding = new JTextField(FileTreeModel.getCurEncoding());
        this.setEncoding.setPreferredSize(headfinderName.getPreferredSize());
        advOptions.add(headfinderName);
        advOptions.add(headfinderPicker);
        advOptions.add(treeReaderFactoryName);
        advOptions.add(trfPicker);
        advOptions.add(encodingLabel);
        advOptions.add(this.setEncoding);
        final JCheckBox tsurgeonCheck = new JCheckBox("Enable Tsurgeon");
        tsurgeonCheck.setSelected(InputPanel.getInstance().getTsurgeonEnabled());
        final JCheckBox matchPortion = new JCheckBox("Show only matched portions of tree");
        matchPortion.setSelected(MatchesPanel.getInstance().isShowOnlyMatchedPortion());
        GridBagConstraints c = new GridBagConstraints();
        c.ipady = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        prefPanel.add((Component)displayPrefs, c);
        prefPanel.add((Component)treeDisplayPrefs, c);
        prefPanel.add((Component)advOptions, c);
        prefPanel.add((Component)tsurgeonCheck, c);
        c.gridheight = 0;
        prefPanel.add((Component)matchPortion, c);
        Object[] options = new JButton[2];
        JButton okay = new JButton("Okay");
        options[1] = cancel = new JButton("Cancel");
        options[0] = okay;
        JOptionPane prefPane = new JOptionPane();
        prefPane.setMessage(prefPanel);
        prefPane.setOptions(options);
        prefPane.setOpaque(true);
        this.setContentPane(prefPane);
        this.getRootPane().setDefaultButton(okay);
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    HeadFinder hf = PreferencesPanel.this.getHeadfinder(headfinderPicker.getSelectedItem().toString());
                    if (hf == null) {
                        throw new Exception("Headfinder error");
                    }
                    TreeReaderFactory trf = PreferencesPanel.this.getTreeReaderFactory(trfPicker.getSelectedItem().toString());
                    if (trf == null) {
                        throw new Exception("Tree reader factory error");
                    }
                    Integer historySize = PreferencesPanel.checkNumberFormat(historySizeField, PreferencesPanel.HISTORY_ERROR);
                    Integer maxMatchSize = PreferencesPanel.checkNumberFormat(maxMatchesSizeField, PreferencesPanel.MAX_MATCH_ERROR);
                    Integer textSize = PreferencesPanel.checkNumberFormat(size, PreferencesPanel.FONT_ERROR);
                    PreferencesPanel.this.syncFromPrefPanel(fontPicker.getSelectedItem().toString(), textSize, ((ColorIcon)defaultColorButton.getIcon()).getColor(), ((ColorIcon)matchedButton.getIcon()).getColor(), ((ColorIcon)PreferencesPanel.this.highlightButton.getIcon()).getColor(), historySize, maxMatchSize, tsurgeonCheck.isSelected(), matchPortion.isSelected(), hf, trf, PreferencesPanel.this.setEncoding.getText().trim());
                    PreferencesPanel.this.setVisible(false);
                }
                catch (NumberFormatException e) {
                    if (e.getMessage() == PreferencesPanel.FONT_ERROR) {
                        JOptionPane.showMessageDialog(prefPanel, "Please enter an integer greater than 0 for the font size.", "Font size error", 0);
                    } else if (e.getMessage() == PreferencesPanel.HISTORY_ERROR) {
                        JOptionPane.showMessageDialog(prefPanel, "Please enter an integer greater than or equal to 0 for the number of recent matches to remember.", "History size error", 0);
                    } else if (e.getMessage() == PreferencesPanel.HISTORY_ERROR) {
                        JOptionPane.showMessageDialog(prefPanel, "Please enter an integer greater than or equal to 0 for the maximum number of matches to display.", "Max Matches size error", 0);
                    } else {
                        JOptionPane.showMessageDialog(prefPanel, "Please check that the font size, max matches to display, and number of recent matches to remember are all integers greater than 0.", "Size error", 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PreferencesPanel.this.setVisible(false);
            }
        });
    }

    private static Integer checkNumberFormat(JTextField component, String errorType) throws NumberFormatException {
        Integer number = null;
        String txt = component.getText();
        if (txt != null && !"".equals(txt)) {
            try {
                number = Integer.parseInt(txt);
                if (number <= 0) {
                    throw new NumberFormatException(errorType);
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(errorType);
            }
        }
        return number;
    }

    private TreeReaderFactory getTreeReaderFactory(String trfName) {
        if (trfName.equalsIgnoreCase("ArabicTreeReaderFactory")) {
            return new ArabicTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("ArabicTreeReaderFactory.ArabicRawTreeReaderFactory")) {
            return new ArabicTreeReaderFactory.ArabicRawTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("CTBTreeReaderFactory")) {
            return new CTBTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("NoEmptiesCTBTreeReaderFactory")) {
            return new NoEmptiesCTBTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("Basic categories only (LabeledScoredTreeReaderFactory)")) {
            return new LabeledScoredTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("FrenchTreeReaderFactory")) {
            return new FrenchTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("PennTreeReaderFactory")) {
            return new PennTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("StringLabeledScoredTreeReaderFactory")) {
            return new StringLabeledScoredTreeReaderFactory();
        }
        if (trfName.equalsIgnoreCase("TregexPattern.TregexTreeReaderFactory")) {
            return new TregexPattern.TRegexTreeReaderFactory();
        }
        try {
            Class<?> trfClass = Class.forName(trfName);
            TreeReaderFactory trf = (TreeReaderFactory)trfClass.newInstance();
            return trf;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Sorry, there was an error finding or instantiating the tree reader factory. Please choose another tree reader factory.", "Tree Reader Factory Error", 0);
            return null;
        }
    }

    private HeadFinder getHeadfinder(String headfinderName) {
        if (headfinderName.equalsIgnoreCase("ArabicHeadFinder")) {
            return new ArabicHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("BikelChineseHeadFinder")) {
            return new BikelChineseHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("ChineseHeadFinder")) {
            return new ChineseHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("ChineseSemanticHeadFinder")) {
            return new ChineseSemanticHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("CollinsHeadFinder")) {
            return new CollinsHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("FrenchHeadFinder")) {
            return new DybroFrenchHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("LeftHeadFinder")) {
            return new LeftHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("ModCollinsHeadFinder")) {
            return new ModCollinsHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("NegraHeadFinder")) {
            return new NegraHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("SemanticHeadFinder")) {
            return new SemanticHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("SunJurafskyChineseHeadFinder")) {
            return new SunJurafskyChineseHeadFinder();
        }
        if (headfinderName.equalsIgnoreCase("TueBaDZHeadFinder")) {
            return new TueBaDZHeadFinder();
        }
        try {
            Class<?> headfinder = Class.forName(headfinderName);
            HeadFinder hf = (HeadFinder)headfinder.newInstance();
            return hf;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Sorry, there was an error finding or instantiating the head finder. Please choose another head finder.", "Head Finder Error", 0);
            return null;
        }
    }

    public static void alignLeft(JComponent box) {
        for (Component comp : box.getComponents()) {
            ((JComponent)comp).setAlignmentX(0.0f);
        }
    }

    private void syncFromPrefPanel(String font, Integer fontSize, Color treeColor, Color matchedColor, Color highlightColor, Integer historySize, Integer maxMatches, boolean enableTsurgeon, boolean matchPortionOnly, HeadFinder hf, TreeReaderFactory trf, String encoding) {
        InputPanel.getInstance().enableTsurgeon(enableTsurgeon);
        MatchesPanel.getInstance().setShowOnlyMatchedPortion(matchPortionOnly);
        MatchesPanel.getInstance().setHighlightColor(highlightColor);
        if (historySize != null) {
            InputPanel.getInstance().setNumRecentPatterns(historySize);
        }
        if (maxMatches != null) {
            MatchesPanel.getInstance().setMaxMatches(maxMatches);
        }
        DisplayMatchesPanel.getInstance().setMatchedColor(matchedColor);
        DisplayMatchesPanel.getInstance().setDefaultColor(treeColor);
        DisplayMatchesPanel.getInstance().setFontName(font);
        MatchesPanel.getInstance().setFontName(font);
        if (fontSize != null) {
            DisplayMatchesPanel.getInstance().setFontSize(fontSize);
        }
        InputPanel.getInstance().setHeadFinder(hf);
        FilePanel.getInstance().setTreeReaderFactory(trf);
        String hfName = hf.getClass().getSimpleName();
        String trfName = trf.getClass().getSimpleName();
        if (encoding != null && !encoding.equals("")) {
            FileTreeModel.setCurEncoding(encoding);
        }
        if (PreferencesPanel.isChinese(hfName, trfName)) {
            PreferencesPanel.setChineseFont();
        } else if (PreferencesPanel.isArabic(hfName, trfName)) {
            PreferencesPanel.setArabicFont();
        }
        this.checkEncodingAndDisplay(hfName, trfName);
    }

    private void checkEncodingAndDisplay(String headFinder, String trf) {
        boolean prompt = false;
        String defaultEncoding = "";
        String curEncoding = FileTreeModel.getCurEncoding();
        if (PreferencesPanel.isChinese(headFinder, trf)) {
            if (!curEncoding.equals("GB18030")) {
                prompt = true;
                defaultEncoding = "GB18030";
            }
        } else if (PreferencesPanel.isNegra(headFinder, trf)) {
            if (!curEncoding.equals(" ISO-8859-1")) {
                prompt = true;
                defaultEncoding = " ISO-8859-1";
            }
        } else if (!curEncoding.equals("UTF-8")) {
            prompt = true;
            defaultEncoding = "UTF-8";
        }
        if (prompt) {
            this.doEncodingPrompt(defaultEncoding, curEncoding);
        }
    }

    private void doEncodingPrompt(final String encoding, String oldEncoding) {
        JPanel encodingPanel = new JPanel();
        encodingPanel.setLayout(new BoxLayout(encodingPanel, 3));
        JLabel text = new JLabel("<html>A head finder or tree reader was selected that has the default encoding " + encoding + "; this differs from " + oldEncoding + ", which was being used. If the encoding is changed, all newly loaded" + "treebanks will be read using the new encoding. Choosing an encoding that is not the true encoding of your tree " + "files may cause errors and unexpected behavior.</html>");
        text.setAlignmentX(10.0f);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setPreferredSize(new Dimension(100, 100));
        textPanel.add(text);
        encodingPanel.add(textPanel);
        encodingPanel.add(Box.createVerticalStrut(5));
        JOptionPane fileFilterDialog = new JOptionPane();
        fileFilterDialog.setMessage(encodingPanel);
        Object[] options = new JButton[3];
        JButton useNewEncoding = new JButton("Use " + encoding);
        JButton useOldEncoding = new JButton("Use " + oldEncoding);
        JButton useAnotherEncoding = new JButton("Use encoding...");
        options[0] = useNewEncoding;
        options[1] = useOldEncoding;
        options[2] = useAnotherEncoding;
        fileFilterDialog.setOptions(options);
        final JDialog dialog = fileFilterDialog.createDialog(null, "Default encoding changed...");
        useNewEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileTreeModel.setCurEncoding(encoding);
                if (PreferencesPanel.this.setEncoding == null) {
                    System.out.println("encoding null!!");
                }
                PreferencesPanel.this.setEncoding.setText(encoding);
                dialog.setVisible(false);
            }
        });
        useOldEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        useAnotherEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                PreferencesPanel.this.alternateEncodingPrompt(encoding);
            }
        });
        dialog.getRootPane().setDefaultButton(useNewEncoding);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private static void setChineseFont() {
        Thread t = new Thread(){

            @Override
            public void run() {
                List<Font> fonts = FontDetector.supportedFonts(0);
                String fontName = "";
                if (!fonts.isEmpty()) {
                    fontName = fonts.get(0).getName();
                } else if (FontDetector.hasFont("Watanabe Mincho")) {
                    fontName = "Watanabe Mincho";
                }
                if (!fontName.equals("")) {
                    DisplayMatchesPanel.getInstance().setFontName(fontName);
                    MatchesPanel.getInstance().setFontName(fontName);
                }
            }
        };
        t.start();
    }

    private void alternateEncodingPrompt(String newDefaultEncoding) {
        String response = (String)JOptionPane.showInputDialog(this, "Please enter a text encoding: ", "Set Encoding...", 3, null, null, newDefaultEncoding);
        FileTreeModel.setCurEncoding(response.trim());
        this.setEncoding.setText(response.trim());
    }

    private static void setArabicFont() {
        Thread t = new Thread(){

            @Override
            public void run() {
                List<Font> fonts = FontDetector.supportedFonts(1);
                String fontName = "";
                if (fonts.size() > 0) {
                    fontName = fonts.get(0).getName();
                }
                if (!fontName.equals("")) {
                    DisplayMatchesPanel.getInstance().setFontName(fontName);
                    MatchesPanel.getInstance().setFontName(fontName);
                }
            }
        };
        t.start();
    }

    private static boolean isNegra(String headFinder, String trf) {
        return headFinder.startsWith("Negra");
    }

    private static boolean isChinese(String headFinder, String trf) {
        return headFinder.startsWith("Chinese") || headFinder.startsWith("OldChinese") || trf.equalsIgnoreCase("CTBTreeReaderFactory") || trf.equalsIgnoreCase("NoEmptiesCTBTreeReaderFactory");
    }

    private static boolean isArabic(String headFinder, String trf) {
        return headFinder.startsWith("Arabic") || trf.startsWith("Arabic");
    }

    public static JButton makeColorButton(final String promptText, Color iconColor, final JPanel parent) {
        final ColorIcon icon = new ColorIcon(iconColor);
        JButton button = new JButton(icon);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color newColor = JColorChooser.showDialog(parent, promptText, icon.getColor());
                if (newColor != null) {
                    icon.setColor(newColor);
                    parent.repaint();
                }
            }
        });
        return button;
    }

    private static class ColorIcon
    implements Icon {
        private static final int iconHeight = 8;
        private static final int iconWidth = 15;
        private Color color;

        public ColorIcon(Color c) {
            this.color = c;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(oldColor);
        }
    }
}

