/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.util.Filter;
import java.io.IOException;

public class FilteringTreeReader
implements TreeReader {
    private TreeReader tr;
    private Filter<Tree> f;

    public FilteringTreeReader(TreeReader tr, Filter<Tree> f) {
        this.tr = tr;
        this.f = f;
    }

    @Override
    public Tree readTree() throws IOException {
        Tree t;
        while ((t = this.tr.readTree()) != null && !this.f.accept(t)) {
        }
        return t;
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }
}

