/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.gui.HighlightUtils;
import edu.stanford.nlp.trees.tregex.gui.MatchesPanel;
import edu.stanford.nlp.trees.tregex.gui.ScrollableTreeJPanel;
import edu.stanford.nlp.trees.tregex.gui.TreeFromFile;
import edu.stanford.nlp.trees.tregex.gui.TregexGUI;
import edu.stanford.nlp.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;

public class DisplayMatchesPanel
extends JPanel
implements ListSelectionListener {
    private JScrollPane scroller;
    private MouseEvent firstMouseEvent = null;
    private String fontName = "";
    private int fontSize = 12;
    private Color defaultColor = Color.BLACK;
    private Color matchedColor = Color.RED;
    private static DisplayMatchesPanel instance = null;
    private ScrollableTreeJPanel tjp;

    public static synchronized DisplayMatchesPanel getInstance() {
        if (instance == null) {
            instance = new DisplayMatchesPanel();
        }
        return instance;
    }

    private DisplayMatchesPanel() {
        JPanel spaceholder = new JPanel();
        spaceholder.setBackground(Color.white);
        JTextArea message = new JTextArea("For non-English trees, first set up the tree reader and encoding in Preferences. Then load trees from the File menu.");
        message.setEditable(false);
        spaceholder.add(message);
        this.scroller = new JScrollPane(spaceholder);
        this.setFocusable(true);
        this.setTransferHandler(new DisplayTransferHandler());
        MatchesPanel.getInstance().addListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), ""));
        this.add((Component)this.scroller, "Center");
    }

    public void setMatch(TreeFromFile match, List<Tree> matchedParts) {
        this.clearMatches();
        if (match != null) {
            this.addMatch(match, matchedParts);
        }
    }

    public void clearMatches() {
        JPanel spaceholder = new JPanel();
        spaceholder.setBackground(Color.white);
        this.scroller.setViewportView(spaceholder);
        this.scroller.validate();
        this.scroller.repaint();
    }

    private void addMatch(TreeFromFile match, List<Tree> matchedParts) {
        JPanel treeDisplay = new JPanel(new BorderLayout());
        JTextField filename = new JTextField("From file: " + match.getFilename());
        filename.setEditable(false);
        FilenameMouseInputAdapter listener = new FilenameMouseInputAdapter(filename);
        filename.addMouseListener(listener);
        filename.addMouseMotionListener(listener);
        treeDisplay.add((Component)filename, "North");
        if (TregexGUI.getInstance().isTdiffEnabled()) {
            this.tjp = this.getTreeJPanel(match.getDiffDecoratedTree(), matchedParts);
            this.tjp.setDiffConstituents(match.getDiffConstituents());
        } else {
            this.tjp = this.getTreeJPanel(match.getTree(), matchedParts);
        }
        treeDisplay.add((Component)this.tjp, "Center");
        filename.setOpaque(true);
        filename.setBackground(this.tjp.getBackground());
        filename.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.scroller.setViewportView(treeDisplay);
        this.revalidate();
        this.repaint();
    }

    private ScrollableTreeJPanel getTreeJPanel(Tree t, List<Tree> matchedParts) {
        final ScrollableTreeJPanel treeJP = new ScrollableTreeJPanel(0, 1);
        treeJP.setFontName(this.fontName);
        treeJP.setFontSize(this.fontSize);
        treeJP.setDefaultColor(this.defaultColor);
        treeJP.setMatchedColor(this.matchedColor);
        treeJP.setTree(t);
        treeJP.setMatchedParts(matchedParts);
        treeJP.setBackground(Color.WHITE);
        treeJP.setFocusable(true);
        treeJP.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                treeJP.requestFocusInWindow();
            }
        });
        DisplayMouseMotionAdapter d = new DisplayMouseMotionAdapter();
        treeJP.addMouseMotionListener(d);
        treeJP.addMouseListener(d);
        treeJP.setTransferHandler(new DisplayTransferHandler());
        InputMap imap = treeJP.getInputMap();
        imap.put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
        ActionMap map = treeJP.getActionMap();
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        return treeJP;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontSizeRepaint(int fontSize) {
        this.fontSize = fontSize;
        if (this.tjp != null) {
            this.tjp.setFontSize(fontSize);
            this.tjp.revalidate();
            this.scroller.repaint();
        }
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public Color getMatchedColor() {
        return this.matchedColor;
    }

    public void setMatchedColor(Color matchedColor) {
        this.matchedColor = matchedColor;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Pair<TreeFromFile, List<Tree>> newMatch = MatchesPanel.getInstance().getSelectedMatch();
        if (newMatch == null) {
            this.clearMatches();
        } else {
            this.setMatch(newMatch.first(), newMatch.second());
        }
    }

    private static class DisplayMouseMotionAdapter
    extends MouseInputAdapter {
        MouseEvent firstMouseEvent1 = null;

        private DisplayMouseMotionAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MatchesPanel.getInstance().isEmpty()) {
                return;
            }
            this.firstMouseEvent1 = e;
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (MatchesPanel.getInstance().isEmpty()) {
                return;
            }
            if (this.firstMouseEvent1 != null) {
                e.consume();
                int dx = Math.abs(e.getX() - this.firstMouseEvent1.getX());
                int dy = Math.abs(e.getY() - this.firstMouseEvent1.getY());
                if (dx > 5 || dy > 5) {
                    JComponent c = (JComponent)e.getSource();
                    TransferHandler handler = c.getTransferHandler();
                    handler.exportAsDrag(c, this.firstMouseEvent1, 1);
                    this.firstMouseEvent1 = null;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.firstMouseEvent1 = null;
        }
    }

    public class FilenameMouseInputAdapter
    extends MouseInputAdapter {
        JTextField textField;
        private boolean dragNDrop = false;

        public FilenameMouseInputAdapter(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MatchesPanel.getInstance().isEmpty()) {
                return;
            }
            if (DisplayMatchesPanel.this.firstMouseEvent == null) {
                DisplayMatchesPanel.this.firstMouseEvent = e;
            }
            e.consume();
            if ((e.getModifiersEx() & 0x40) == 64) {
                this.addHighlight(this.textField, DisplayMatchesPanel.this.firstMouseEvent, e);
            } else if (!HighlightUtils.isInHighlight(e, this.textField, this.textField.getHighlighter())) {
                this.textField.getHighlighter().removeAllHighlights();
                DisplayMatchesPanel.this.firstMouseEvent = e;
                this.dragNDrop = false;
                this.textField.repaint();
            } else {
                this.dragNDrop = true;
            }
        }

        private boolean addHighlight(JTextField label, MouseEvent mouseEvent1, MouseEvent mouseEvent2) {
            return HighlightUtils.addHighlight(label, mouseEvent1, mouseEvent2);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (MatchesPanel.getInstance().isEmpty()) {
                return;
            }
            if (DisplayMatchesPanel.this.firstMouseEvent != null) {
                e.consume();
                if (this.dragNDrop) {
                    if (this.textField == null) {
                        return;
                    }
                    if (Point2D.distanceSq(e.getX(), e.getY(), DisplayMatchesPanel.this.firstMouseEvent.getX(), DisplayMatchesPanel.this.firstMouseEvent.getY()) > 25.0) {
                        this.textField.getTransferHandler().exportAsDrag((JComponent)e.getSource(), DisplayMatchesPanel.this.firstMouseEvent, 1);
                    }
                } else {
                    this.addHighlight(this.textField, DisplayMatchesPanel.this.firstMouseEvent, e);
                }
            }
        }
    }

    private static class DisplayTransferHandler
    extends TransferHandler {
        protected static String exportString(JComponent c) {
            if (c instanceof ScrollableTreeJPanel) {
                ScrollableTreeJPanel tjp = (ScrollableTreeJPanel)c;
                return tjp.getTree().pennString();
            }
            return "";
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new StringSelection(DisplayTransferHandler.exportString(c));
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }
    }
}

