/* The following code was generated by JFlex 1.4.3 on 3/20/11 12:30 AM */

package edu.stanford.nlp.process;

/** Undoes the more common cases of Penn Treebank quoting to producing
 *  something resembling normal text.  That is, it is an approximate inverse
 *  of PTBTokenizer.
 *
 *  Jan 2008: This was both made better, and some quirky weird stuff was added
 *  so as to better handle the NIST MT08 translation system's output.
 *
 *  @author Joseph Smarr
 *  @author Christopher Manning
 */



class PTB2TextLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int INQUOTE = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\12\0\1\71\2\70\1\72\22\0\1\1\1\75\1\2\1\0\1\106"+
    "\1\105\1\3\1\30\1\101\1\102\2\0\1\75\1\35\1\74\1\100"+
    "\1\67\1\34\10\66\1\75\1\7\3\0\1\76\1\0\1\4\1\63"+
    "\1\57\1\61\1\51\1\43\1\15\1\47\1\37\2\33\1\14\1\5"+
    "\1\41\1\12\1\6\1\10\1\45\1\31\1\13\1\11\1\65\1\55"+
    "\1\33\1\53\1\33\1\0\1\77\3\0\1\73\1\17\1\62\1\56"+
    "\1\60\1\50\1\42\1\27\1\46\1\36\2\16\1\26\1\20\1\40"+
    "\1\24\1\21\1\22\1\44\1\32\1\25\1\23\1\64\1\54\1\16"+
    "\1\52\1\16\1\103\1\0\1\104\7\0\1\70\44\0\1\33\12\0"+
    "\1\33\4\0\1\33\5\0\27\33\1\0\37\33\1\0\u013f\33\31\0"+
    "\162\33\4\0\14\33\16\0\5\33\11\0\1\33\213\0\1\33\13\0"+
    "\1\33\1\0\3\33\1\0\1\33\1\0\24\33\1\0\54\33\1\0"+
    "\46\33\1\0\5\33\4\0\202\33\10\0\105\33\1\0\46\33\2\0"+
    "\2\33\6\0\20\33\41\0\46\33\2\0\1\33\7\0\47\33\110\0"+
    "\33\33\5\0\3\33\56\0\32\33\5\0\13\33\25\0\12\34\4\0"+
    "\2\33\1\0\143\33\1\0\1\33\17\0\2\33\7\0\2\33\12\34"+
    "\3\33\2\0\1\33\20\0\1\33\1\0\36\33\35\0\3\33\60\0"+
    "\46\33\13\0\1\33\u0152\0\66\33\3\0\1\33\22\0\1\33\7\0"+
    "\12\33\4\0\12\34\25\0\10\33\2\0\2\33\2\0\26\33\1\0"+
    "\7\33\1\0\1\33\3\0\4\33\3\0\1\33\36\0\2\33\1\0"+
    "\3\33\4\0\12\34\2\33\23\0\6\33\4\0\2\33\2\0\26\33"+
    "\1\0\7\33\1\0\2\33\1\0\2\33\1\0\2\33\37\0\4\33"+
    "\1\0\1\33\7\0\12\34\2\0\3\33\20\0\11\33\1\0\3\33"+
    "\1\0\26\33\1\0\7\33\1\0\2\33\1\0\5\33\3\0\1\33"+
    "\22\0\1\33\17\0\2\33\4\0\12\34\25\0\10\33\2\0\2\33"+
    "\2\0\26\33\1\0\7\33\1\0\2\33\1\0\5\33\3\0\1\33"+
    "\36\0\2\33\1\0\3\33\4\0\12\34\1\0\1\33\21\0\1\33"+
    "\1\0\6\33\3\0\3\33\1\0\4\33\3\0\2\33\1\0\1\33"+
    "\1\0\2\33\3\0\2\33\3\0\3\33\3\0\10\33\1\0\3\33"+
    "\55\0\11\34\25\0\10\33\1\0\3\33\1\0\27\33\1\0\12\33"+
    "\1\0\5\33\46\0\2\33\4\0\12\34\25\0\10\33\1\0\3\33"+
    "\1\0\27\33\1\0\12\33\1\0\5\33\3\0\1\33\40\0\1\33"+
    "\1\0\2\33\4\0\12\34\25\0\10\33\1\0\3\33\1\0\27\33"+
    "\1\0\20\33\46\0\2\33\4\0\12\34\25\0\22\33\3\0\30\33"+
    "\1\0\11\33\1\0\1\33\2\0\7\33\72\0\60\33\1\0\2\33"+
    "\14\0\7\33\11\0\12\34\47\0\2\33\1\0\1\33\2\0\2\33"+
    "\1\0\1\33\2\0\1\33\6\0\4\33\1\0\7\33\1\0\3\33"+
    "\1\0\1\33\1\0\1\33\2\0\2\33\1\0\4\33\1\0\2\33"+
    "\11\0\1\33\2\0\5\33\1\0\1\33\11\0\12\34\2\0\2\33"+
    "\42\0\1\33\37\0\12\34\26\0\10\33\1\0\42\33\35\0\4\33"+
    "\164\0\42\33\1\0\5\33\1\0\2\33\25\0\12\34\6\0\6\33"+
    "\112\0\46\33\12\0\51\33\7\0\132\33\5\0\104\33\5\0\122\33"+
    "\6\0\7\33\1\0\77\33\1\0\1\33\1\0\4\33\2\0\7\33"+
    "\1\0\1\33\1\0\4\33\2\0\47\33\1\0\1\33\1\0\4\33"+
    "\2\0\37\33\1\0\1\33\1\0\4\33\2\0\7\33\1\0\1\33"+
    "\1\0\4\33\2\0\7\33\1\0\7\33\1\0\27\33\1\0\37\33"+
    "\1\0\1\33\1\0\4\33\2\0\7\33\1\0\47\33\1\0\23\33"+
    "\16\0\11\34\56\0\125\33\14\0\u026c\33\2\0\10\33\12\0\32\33"+
    "\5\0\113\33\25\0\15\33\1\0\4\33\16\0\22\33\16\0\22\33"+
    "\16\0\15\33\1\0\3\33\17\0\64\33\43\0\1\33\4\0\1\33"+
    "\3\0\12\34\46\0\12\34\6\0\130\33\10\0\51\33\127\0\35\33"+
    "\51\0\12\34\36\33\2\0\5\33\u038b\0\154\33\224\0\234\33\4\0"+
    "\132\33\6\0\26\33\2\0\6\33\2\0\46\33\2\0\6\33\2\0"+
    "\10\33\1\0\1\33\1\0\1\33\1\0\1\33\1\0\37\33\2\0"+
    "\65\33\1\0\7\33\1\0\1\33\3\0\3\33\1\0\7\33\3\0"+
    "\4\33\2\0\6\33\4\0\15\33\5\0\3\33\1\0\7\33\53\0"+
    "\2\70\107\0\1\33\15\0\1\33\202\0\1\33\4\0\1\33\2\0"+
    "\12\33\1\0\1\33\3\0\5\33\6\0\1\33\1\0\1\33\1\0"+
    "\1\33\1\0\4\33\1\0\3\33\1\0\7\33\3\0\3\33\5\0"+
    "\5\33\u0ebb\0\2\33\52\0\5\33\5\0\2\33\4\0\126\33\6\0"+
    "\3\33\1\0\132\33\1\0\4\33\5\0\50\33\4\0\136\33\21\0"+
    "\30\33\70\0\20\33\u0200\0\u19b6\33\112\0\u51a6\33\132\0\u048d\33\u0773\0"+
    "\u2ba4\33\u215c\0\u012e\33\2\0\73\33\225\0\7\33\14\0\5\33\5\0"+
    "\1\33\1\0\12\33\1\0\15\33\1\0\5\33\1\0\1\33\1\0"+
    "\2\33\1\0\2\33\1\0\154\33\41\0\u016b\33\22\0\100\33\2\0"+
    "\66\33\50\0\14\33\164\0\5\33\1\0\207\33\23\0\12\34\7\0"+
    "\32\33\6\0\32\33\13\0\131\33\3\0\6\33\2\0\6\33\2\0"+
    "\6\33\2\0\3\33\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\2\1\1\2\1\3\11\1\1\4\1\1\2\5"+
    "\4\1\1\6\1\3\2\0\1\7\3\0\2\7\1\10"+
    "\1\11\1\12\7\0\10\1\1\13\1\1\1\14\1\15"+
    "\1\16\1\17\1\6\4\0\2\20\3\0\1\21\6\0"+
    "\1\22\7\0\13\1\1\23\6\0\1\24\4\0\1\25"+
    "\5\0\1\3\2\0\1\26\1\0\1\27\7\0\2\1"+
    "\1\0\2\1\1\0\5\1\5\0\1\3\5\0\1\30"+
    "\3\0\2\3\1\2\4\0\15\31\1\0\1\1\1\0"+
    "\4\1\4\0\2\3\1\6\10\0\1\2\1\0\1\32"+
    "\2\33\1\0\1\32\5\31\1\0\20\31\1\0\1\1"+
    "\1\0\3\1\3\0\1\6\3\0\1\6\5\0\1\34"+
    "\2\0\12\31\1\0\1\1\1\31\1\0\2\1\1\35"+
    "\1\0\1\6\3\0\5\31\1\36\2\1\4\31\1\1"+
    "\1\0\1\31\1\1\1\0\1\31\1\1\1\0\1\31"+
    "\1\1\1\31\22\1";

  private static int [] zzUnpackAction() {
    int [] result = new int[306];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\107\0\216\0\325\0\u011c\0\u0163\0\u01aa\0\u01f1"+
    "\0\u0238\0\u027f\0\u02c6\0\u030d\0\u0354\0\u039b\0\u03e2\0\u0429"+
    "\0\u0470\0\u04b7\0\u0429\0\u04fe\0\u0545\0\u058c\0\u05d3\0\u0429"+
    "\0\u061a\0\u0661\0\u06a8\0\u0429\0\u06ef\0\u0736\0\u077d\0\u07c4"+
    "\0\u080b\0\u0429\0\u0429\0\u0429\0\u0852\0\u0899\0\u08e0\0\u0927"+
    "\0\u096e\0\u09b5\0\u09fc\0\u0a43\0\u0a8a\0\u0ad1\0\u0b18\0\u0b5f"+
    "\0\u0ba6\0\u0bed\0\u0c34\0\u0429\0\u0c7b\0\u0429\0\u0429\0\u0429"+
    "\0\u0429\0\u0661\0\u0cc2\0\u0d09\0\u0d50\0\u0d97\0\u0429\0\u0dde"+
    "\0\u0e25\0\u0e6c\0\u0eb3\0\u0429\0\u0efa\0\u0f41\0\u0f88\0\u04b7"+
    "\0\u0fcf\0\u1016\0\u0429\0\u105d\0\u10a4\0\u10eb\0\u1132\0\u1179"+
    "\0\u11c0\0\u1207\0\u124e\0\u1295\0\u12dc\0\u1323\0\u136a\0\u13b1"+
    "\0\u13f8\0\u143f\0\u1486\0\u14cd\0\u1514\0\u0429\0\u155b\0\u15a2"+
    "\0\u15e9\0\u1630\0\u1677\0\u16be\0\u0429\0\u1705\0\u174c\0\u1793"+
    "\0\u17da\0\u0429\0\u1821\0\u1868\0\u18af\0\u18f6\0\u193d\0\u1984"+
    "\0\u19cb\0\u1a12\0\u0429\0\u1a59\0\u0429\0\u1aa0\0\u1ae7\0\u1b2e"+
    "\0\u1b75\0\u1bbc\0\u1c03\0\u1c4a\0\u1c91\0\u1cd8\0\u1d1f\0\u1d66"+
    "\0\u1dad\0\u1df4\0\u1e3b\0\u1e82\0\u1ec9\0\u1f10\0\u1f57\0\u1f9e"+
    "\0\u1fe5\0\u202c\0\u2073\0\u20ba\0\u2101\0\u2148\0\u218f\0\u21d6"+
    "\0\u221d\0\u2264\0\u0429\0\u22ab\0\u22f2\0\u2339\0\u2380\0\u23c7"+
    "\0\u240e\0\u2455\0\u249c\0\u24e3\0\u252a\0\u2571\0\u25b8\0\u25ff"+
    "\0\u2646\0\u268d\0\u26d4\0\u271b\0\u2762\0\u27a9\0\u27f0\0\u2837"+
    "\0\u287e\0\u28c5\0\u290c\0\u2953\0\u299a\0\u29e1\0\u2a28\0\u2a6f"+
    "\0\u2ab6\0\u2afd\0\u2b44\0\u2b8b\0\u2bd2\0\u2c19\0\u2c60\0\u2ca7"+
    "\0\u2cee\0\u2d35\0\u2d7c\0\u2dc3\0\u2e0a\0\u2e51\0\u23c7\0\u2e98"+
    "\0\u2edf\0\u2f26\0\u0429\0\u0429\0\u2f6d\0\u2fb4\0\u2ffb\0\u3042"+
    "\0\u3089\0\u30d0\0\u3117\0\u315e\0\u2ffb\0\u31a5\0\u31ec\0\u3233"+
    "\0\u327a\0\u32c1\0\u3308\0\u334f\0\u3396\0\u33dd\0\u3424\0\u346b"+
    "\0\u34b2\0\u34f9\0\u3540\0\u3587\0\u35ce\0\u3615\0\u365c\0\u36a3"+
    "\0\u36ea\0\u3731\0\u3778\0\u37bf\0\u3806\0\u384d\0\u3894\0\u38db"+
    "\0\u2c60\0\u3922\0\u3969\0\u39b0\0\u39f7\0\u3a3e\0\u3a85\0\u3acc"+
    "\0\u0429\0\u3b13\0\u3b5a\0\u3ba1\0\u3be8\0\u3c2f\0\u3c76\0\u3cbd"+
    "\0\u3d04\0\u3d4b\0\u3d92\0\u3dd9\0\u3e20\0\u3e67\0\u3eae\0\u3ef5"+
    "\0\u3f3c\0\u3f83\0\u3fca\0\u0429\0\u4011\0\u4058\0\u409f\0\u40e6"+
    "\0\u412d\0\u4174\0\u41bb\0\u4202\0\u4249\0\u4290\0\u0429\0\u42d7"+
    "\0\u431e\0\u4365\0\u43ac\0\u43f3\0\u443a\0\u4481\0\u44c8\0\u450f"+
    "\0\u4556\0\u459d\0\u45e4\0\u462b\0\u4672\0\u46b9\0\u4700\0\u4672"+
    "\0\u4747\0\u478e\0\u47d5\0\u481c\0\u4863\0\u48aa\0\u48f1\0\u4938"+
    "\0\u497f\0\u49c6\0\u4a0d\0\u4a54\0\u4a9b\0\u4ae2\0\u4b29\0\u4b70"+
    "\0\u4bb7\0\u4bfe";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[306];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\3\7\1\3\6\7\12\10"+
    "\1\3\1\11\1\12\2\7\1\13\1\10\1\7\1\10"+
    "\1\7\1\10\1\7\1\10\1\7\1\14\1\15\1\10"+
    "\1\7\1\10\1\7\1\10\1\7\1\16\1\17\1\10"+
    "\1\7\1\10\1\7\1\10\3\7\1\3\1\20\1\3"+
    "\1\21\3\3\1\22\1\23\1\24\1\3\1\25\2\3"+
    "\1\26\1\3\1\27\1\30\1\31\3\7\1\3\6\7"+
    "\12\10\1\3\1\11\1\12\2\7\1\13\1\10\1\7"+
    "\1\10\1\7\1\10\1\7\1\10\1\7\1\14\1\15"+
    "\1\10\1\7\1\10\1\7\1\10\1\7\1\16\1\17"+
    "\1\10\1\7\1\10\1\7\1\10\3\7\1\3\1\20"+
    "\1\3\1\21\3\3\1\22\1\23\1\24\1\3\1\25"+
    "\2\3\1\26\1\3\3\0\65\3\1\0\5\3\2\0"+
    "\6\3\2\0\1\32\1\33\3\0\1\34\20\0\1\35"+
    "\4\0\1\36\2\0\2\37\32\0\1\40\1\34\1\41"+
    "\3\0\1\42\1\0\1\43\1\44\2\0\1\45\106\0"+
    "\1\46\2\0\1\47\3\0\1\50\3\0\1\51\1\52"+
    "\1\0\1\47\2\0\1\50\3\0\1\51\1\52\57\0"+
    "\1\3\1\53\2\0\3\7\1\3\20\7\1\3\4\7"+
    "\1\3\32\7\1\3\1\0\5\3\2\0\7\3\1\53"+
    "\2\0\3\7\1\3\6\7\12\54\1\3\1\7\1\54"+
    "\2\7\1\3\1\54\1\7\1\54\1\7\1\54\1\7"+
    "\1\54\1\7\1\54\1\7\1\54\1\7\1\54\1\7"+
    "\1\54\1\7\1\54\1\7\1\54\1\7\1\54\1\7"+
    "\1\54\3\7\1\3\1\0\5\3\2\0\7\3\1\53"+
    "\2\0\1\55\2\7\1\3\7\7\1\55\10\7\1\3"+
    "\4\7\1\3\32\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\1\55\2\7\1\3\6\7\1\54\1\56"+
    "\10\54\1\3\1\7\1\54\2\7\1\3\1\54\1\7"+
    "\1\54\1\7\1\54\1\7\1\54\1\7\1\54\1\7"+
    "\1\54\1\7\1\54\1\7\1\54\1\7\1\54\1\7"+
    "\1\54\1\7\1\54\1\7\1\54\3\7\1\3\1\0"+
    "\5\3\2\0\7\3\3\0\10\3\1\57\11\3\1\57"+
    "\42\3\1\0\5\3\2\0\7\3\1\53\2\0\3\7"+
    "\1\3\6\7\12\54\1\3\1\7\1\54\2\7\1\3"+
    "\1\54\1\7\1\54\1\7\1\54\1\7\1\54\1\7"+
    "\1\54\1\7\1\60\1\61\1\54\1\7\1\54\1\7"+
    "\1\54\1\7\1\54\1\7\1\54\1\7\1\54\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\53\2\0\3\7"+
    "\1\3\20\7\1\3\4\7\1\3\12\7\2\61\16\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\53\2\0\1\62"+
    "\2\7\1\3\6\7\1\54\1\63\10\54\1\3\1\7"+
    "\1\54\2\7\1\3\1\54\1\7\1\54\1\7\1\54"+
    "\1\7\1\54\1\7\1\54\1\7\1\54\1\7\1\54"+
    "\1\7\1\54\1\7\1\54\1\7\1\54\1\7\1\54"+
    "\1\7\1\54\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\1\62\2\7\1\3\7\7\1\62\10\7"+
    "\1\3\4\7\1\3\32\7\1\3\1\0\5\3\2\0"+
    "\6\3\107\0\1\3\1\64\2\0\65\3\1\0\1\3"+
    "\1\65\3\3\2\0\6\3\100\0\1\66\6\0\1\3"+
    "\1\67\2\0\65\3\1\0\5\3\2\0\7\3\1\70"+
    "\2\0\65\3\1\0\5\3\2\0\7\3\1\71\2\0"+
    "\65\3\1\0\5\3\2\0\6\3\2\0\1\72\1\73"+
    "\3\0\1\34\20\0\1\35\4\0\1\36\2\0\2\37"+
    "\32\0\1\40\1\34\1\41\3\0\1\42\1\0\1\43"+
    "\1\44\2\0\1\74\2\0\1\75\3\0\1\76\3\0"+
    "\1\51\1\52\1\0\1\75\2\0\1\76\3\0\1\51"+
    "\1\52\147\0\2\77\1\100\15\0\1\101\2\0\1\102"+
    "\3\0\1\103\6\0\1\102\2\0\1\103\64\0\30\34"+
    "\1\104\40\34\1\0\15\34\44\0\2\105\71\0\1\106"+
    "\152\0\1\107\111\0\1\110\11\0\1\111\1\112\3\113"+
    "\1\0\20\113\1\0\3\113\2\0\30\113\25\0\1\114"+
    "\3\0\1\50\6\0\1\114\2\0\1\50\71\0\1\115"+
    "\12\0\1\115\77\0\1\116\11\0\1\116\76\0\1\117"+
    "\11\0\1\117\74\0\1\120\11\0\1\120\111\0\1\121"+
    "\4\0\1\122\51\0\1\3\1\53\2\0\3\7\1\3"+
    "\6\7\12\123\1\3\1\7\1\123\2\7\1\3\1\123"+
    "\1\7\1\123\1\7\1\123\1\7\1\123\1\7\1\123"+
    "\1\7\1\123\1\7\1\123\1\7\1\123\1\7\1\123"+
    "\1\7\1\123\1\7\1\123\1\7\1\123\3\7\1\3"+
    "\1\0\5\3\2\0\7\3\1\53\2\0\3\7\1\3"+
    "\20\7\1\3\4\7\1\3\2\124\12\7\2\125\14\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\53\2\0\3\7"+
    "\1\3\6\7\12\123\1\3\1\7\1\123\2\7\1\3"+
    "\1\126\1\124\1\123\1\7\1\123\1\7\1\123\1\7"+
    "\1\123\1\7\1\123\1\7\1\127\1\125\1\123\1\7"+
    "\1\123\1\7\1\123\1\7\1\123\1\7\1\123\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\3\0\40\3\2\130"+
    "\10\3\2\131\11\3\1\0\5\3\2\0\7\3\1\53"+
    "\2\0\1\132\2\7\1\3\6\7\1\123\1\133\10\123"+
    "\1\3\1\7\1\123\2\7\1\3\1\123\1\7\1\123"+
    "\1\7\1\123\1\7\1\123\1\7\1\123\1\7\1\123"+
    "\1\7\1\123\1\7\1\123\1\7\1\123\1\7\1\123"+
    "\1\7\1\123\1\7\1\123\3\7\1\3\1\0\5\3"+
    "\2\0\7\3\1\53\2\0\1\132\2\7\1\3\7\7"+
    "\1\132\10\7\1\3\4\7\1\3\32\7\1\3\1\0"+
    "\5\3\2\0\7\3\1\53\2\0\3\7\1\3\20\7"+
    "\1\3\4\7\1\3\2\7\2\134\26\7\1\3\1\0"+
    "\5\3\2\0\7\3\1\53\2\0\3\7\1\3\6\7"+
    "\12\123\1\3\1\7\1\123\2\7\1\3\1\123\1\7"+
    "\1\135\1\134\1\123\1\7\1\123\1\7\1\123\1\7"+
    "\1\123\1\7\1\123\1\7\1\123\1\7\1\123\1\7"+
    "\1\123\1\7\1\123\1\7\1\123\3\7\1\3\1\0"+
    "\5\3\2\0\7\3\1\136\2\0\65\3\1\0\5\3"+
    "\2\0\6\3\1\0\1\137\2\0\1\140\3\0\1\141"+
    "\6\0\1\140\2\0\1\141\70\0\1\142\3\0\1\76"+
    "\6\0\1\142\2\0\1\76\71\0\1\143\12\0\1\143"+
    "\77\0\1\144\11\0\1\144\154\0\1\145\21\0\1\102"+
    "\3\0\1\103\6\0\1\102\2\0\1\103\71\0\1\146"+
    "\12\0\1\146\77\0\1\147\11\0\1\147\127\0\2\150"+
    "\10\0\2\151\42\0\1\152\11\0\1\152\155\0\1\34"+
    "\13\0\1\153\106\0\1\154\2\0\1\155\3\0\1\156"+
    "\6\0\1\155\2\0\1\156\71\0\1\157\12\0\1\157"+
    "\74\0\1\160\12\0\1\160\77\0\1\161\11\0\1\161"+
    "\63\0\1\162\5\0\1\163\100\0\1\164\5\0\1\165"+
    "\112\0\1\166\11\0\1\166\12\0\2\167\6\0\2\170"+
    "\4\0\2\171\6\0\1\172\21\0\1\173\105\0\1\3"+
    "\1\174\2\0\3\7\1\3\6\7\12\175\1\3\1\7"+
    "\1\175\2\7\1\3\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\3\7\1\3\20\7\1\3\4\7\1\3"+
    "\22\7\2\176\6\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\177\2\0\3\7\1\3\20\7\1\3\2\176\2\7"+
    "\1\3\2\200\30\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\174\2\0\3\7\1\3\6\7\12\175\1\3\1\7"+
    "\1\175\2\7\1\3\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\201\1\176\1\175"+
    "\1\7\1\175\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\202\2\0\3\7\1\3\6\7\12\175\1\3\1\176"+
    "\1\201\2\7\1\3\1\203\1\200\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\3\0\56\3\2\204\5\3\1\0\5\3\2\0\7\3"+
    "\3\0\56\3\2\205\5\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\3\7\1\3\20\7\1\3\4\7\1\3"+
    "\22\7\2\206\6\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\174\2\0\3\7\1\3\6\7\12\175\1\3\1\7"+
    "\1\175\2\7\1\3\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\207\1\206\1\175"+
    "\1\7\1\175\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\210\2\0\3\7\1\3\20\7\1\3\4\7\1\3"+
    "\32\7\1\3\1\0\5\3\2\0\7\3\1\211\2\0"+
    "\3\7\1\3\6\7\12\175\1\3\1\7\1\175\2\7"+
    "\1\3\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\1\7\1\175\1\7\1\175\1\7\1\175\1\7\1\175"+
    "\3\7\1\3\1\0\5\3\2\0\6\3\4\0\1\140"+
    "\3\0\1\141\6\0\1\140\2\0\1\141\71\0\1\212"+
    "\12\0\1\212\77\0\1\213\11\0\1\213\70\0\1\214"+
    "\12\0\1\214\74\0\1\215\12\0\1\215\77\0\1\216"+
    "\11\0\1\216\70\0\1\217\12\0\1\217\77\0\1\220"+
    "\11\0\1\220\144\0\2\221\105\0\2\222\27\0\3\223"+
    "\1\0\20\223\1\0\3\223\2\0\30\223\25\0\1\155"+
    "\3\0\1\156\6\0\1\155\2\0\1\156\71\0\1\224"+
    "\12\0\1\224\77\0\1\225\11\0\1\225\71\0\1\226"+
    "\12\0\1\226\66\0\1\227\5\0\1\230\112\0\1\231"+
    "\11\0\1\231\70\0\1\163\106\0\1\165\135\0\2\232"+
    "\77\0\1\233\63\0\1\233\12\0\1\233\72\0\1\234"+
    "\12\0\1\234\156\0\1\235\23\0\1\236\2\237\1\0"+
    "\2\237\1\240\1\241\3\237\1\236\4\237\1\240\1\241"+
    "\2\237\1\0\2\242\1\237\2\0\2\243\2\244\2\245"+
    "\2\246\2\247\2\237\2\250\2\251\4\237\2\252\2\237"+
    "\51\0\1\253\4\0\1\122\51\0\1\3\1\174\2\0"+
    "\3\7\1\3\6\7\12\254\1\3\1\7\1\254\2\7"+
    "\1\3\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\3\7\1\3\1\0\5\3\2\0\7\3\1\177\2\0"+
    "\3\7\1\3\20\7\1\3\4\7\1\3\32\7\1\3"+
    "\1\0\5\3\2\0\6\3\30\0\1\121\4\0\1\255"+
    "\51\0\1\3\1\53\2\0\3\7\1\3\20\7\1\3"+
    "\4\7\1\3\2\7\2\256\26\7\1\3\1\0\5\3"+
    "\2\0\7\3\1\202\2\0\3\7\1\3\6\7\12\254"+
    "\1\3\1\7\1\254\2\7\1\3\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\3\7\1\3\1\0\5\3"+
    "\2\0\6\3\30\0\1\253\4\0\1\255\51\0\1\3"+
    "\1\174\2\0\3\7\1\3\6\7\12\254\1\3\1\7"+
    "\1\254\2\7\1\3\1\254\1\7\1\257\1\256\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\3\0\31\3\1\24\33\3\1\0\5\3\2\0\7\3"+
    "\3\0\31\3\1\25\33\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\3\7\1\3\4\7\1\260\11\7\1\260"+
    "\1\7\1\3\4\7\1\3\32\7\1\3\1\0\5\3"+
    "\2\0\7\3\1\174\2\0\3\7\1\3\4\7\1\260"+
    "\1\7\10\254\1\261\1\254\1\3\1\7\1\254\2\7"+
    "\1\3\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\1\7\1\254\1\7\1\254\1\7\1\254\1\7\1\254"+
    "\3\7\1\3\1\0\5\3\2\0\6\3\30\0\1\121"+
    "\4\0\1\122\2\0\2\262\75\0\1\253\4\0\1\122"+
    "\2\0\2\262\53\0\1\263\12\0\1\263\77\0\1\264"+
    "\11\0\1\264\70\0\1\265\12\0\1\265\66\0\1\266"+
    "\5\0\1\267\112\0\1\270\11\0\1\270\62\0\1\271"+
    "\5\0\1\272\112\0\1\273\11\0\1\273\116\0\1\42"+
    "\106\0\1\43\57\0\1\274\12\0\1\274\77\0\1\275"+
    "\11\0\1\275\63\0\1\276\5\0\1\277\106\0\1\230"+
    "\100\0\1\300\6\0\1\50\11\0\1\50\65\0\1\301"+
    "\5\0\1\5\113\0\1\302\11\0\1\302\61\0\1\303"+
    "\66\0\2\304\1\305\25\0\1\306\11\0\1\306\114\0"+
    "\2\233\55\0\1\307\2\0\3\237\1\0\3\237\1\310"+
    "\11\237\1\310\2\237\1\0\2\310\1\237\2\0\2\237"+
    "\2\311\2\312\2\313\10\237\2\314\6\237\2\0\2\304"+
    "\1\305\15\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\3\237\2\0\30\237\22\0\1\315\2\0\3\237\1\0"+
    "\20\237\1\0\3\237\2\0\2\237\2\316\24\237\22\0"+
    "\1\315\2\0\3\237\1\0\2\237\1\310\11\237\1\310"+
    "\3\237\1\0\3\237\2\0\10\237\2\317\16\237\22\0"+
    "\1\315\2\0\3\237\1\0\1\237\1\320\1\321\10\237"+
    "\1\320\1\321\3\237\1\0\3\237\2\0\10\237\2\322"+
    "\16\237\22\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\2\310\1\237\2\0\2\237\2\323\24\237\22\0\1\315"+
    "\2\0\3\237\1\0\20\237\1\0\3\237\2\0\12\237"+
    "\2\324\14\237\22\0\1\315\2\0\3\237\1\0\2\237"+
    "\1\325\11\237\1\325\3\237\1\0\3\237\2\0\30\237"+
    "\22\0\1\315\2\0\3\237\1\0\20\237\1\0\3\237"+
    "\2\0\12\237\2\326\14\237\22\0\1\315\2\0\1\327"+
    "\2\237\1\0\7\237\1\327\10\237\1\0\3\237\2\0"+
    "\12\237\2\330\14\237\22\0\1\315\2\0\3\237\1\0"+
    "\2\237\1\331\11\237\1\331\3\237\1\0\3\237\2\0"+
    "\30\237\22\0\1\315\2\0\1\332\2\237\1\0\2\237"+
    "\1\333\4\237\1\332\4\237\1\333\3\237\1\0\3\237"+
    "\2\0\10\237\2\334\2\330\14\237\22\0\1\315\2\0"+
    "\3\237\1\0\20\237\1\0\3\237\2\0\12\237\2\335"+
    "\14\237\22\0\1\336\11\0\1\166\11\0\1\166\12\0"+
    "\2\167\6\0\2\170\4\0\2\171\6\0\1\172\20\0"+
    "\1\3\1\174\2\0\3\7\1\3\6\7\12\337\1\3"+
    "\1\7\1\337\2\7\1\3\1\337\1\7\1\337\1\7"+
    "\1\337\1\7\1\337\1\7\1\337\1\7\1\337\1\7"+
    "\1\337\1\7\1\337\1\7\1\337\1\7\1\337\1\7"+
    "\1\337\1\7\1\337\3\7\1\3\1\0\5\3\2\0"+
    "\6\3\1\0\1\340\105\0\1\3\1\53\2\0\3\7"+
    "\1\3\5\7\1\176\11\7\1\176\1\3\4\7\1\3"+
    "\32\7\1\3\1\0\5\3\2\0\7\3\1\174\2\0"+
    "\3\7\1\3\5\7\1\176\11\337\1\341\1\3\1\7"+
    "\1\337\2\7\1\3\1\337\1\7\1\337\1\7\1\337"+
    "\1\7\1\337\1\7\1\337\1\7\1\337\1\7\1\337"+
    "\1\7\1\337\1\7\1\337\1\7\1\337\1\7\1\337"+
    "\1\7\1\337\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\3\7\1\3\20\7\1\3\4\7\1\3"+
    "\2\342\30\7\1\3\1\0\5\3\2\0\7\3\1\174"+
    "\2\0\3\7\1\3\6\7\12\337\1\3\1\7\1\337"+
    "\2\7\1\3\1\343\1\342\1\337\1\7\1\337\1\7"+
    "\1\337\1\7\1\337\1\7\1\337\1\7\1\337\1\7"+
    "\1\337\1\7\1\337\1\7\1\337\1\7\1\337\1\7"+
    "\1\337\3\7\1\3\1\0\5\3\2\0\6\3\12\0"+
    "\1\344\11\0\1\344\63\0\1\345\5\0\1\346\112\0"+
    "\1\347\11\0\1\347\62\0\1\350\5\0\1\351\106\0"+
    "\1\267\100\0\1\352\6\0\1\76\11\0\1\76\65\0"+
    "\1\353\5\0\1\30\106\0\1\272\100\0\1\354\6\0"+
    "\1\103\11\0\1\103\65\0\1\355\5\0\1\32\60\0"+
    "\2\77\1\100\15\0\1\356\5\0\1\357\112\0\1\360"+
    "\11\0\1\360\70\0\1\277\107\0\1\50\11\0\1\50"+
    "\65\0\1\45\1\111\1\112\3\113\1\5\20\113\1\0"+
    "\3\113\2\0\30\113\22\0\1\303\12\0\1\233\11\0"+
    "\1\233\41\0\2\304\1\305\105\0\1\361\46\0\2\362"+
    "\111\0\1\363\52\0\1\307\2\0\3\237\1\0\20\237"+
    "\1\0\3\237\2\0\30\237\2\0\2\304\1\305\15\0"+
    "\1\315\2\0\3\237\1\0\20\237\1\0\3\237\2\0"+
    "\22\237\2\310\4\237\22\0\1\315\2\0\2\237\1\310"+
    "\1\0\3\237\1\364\5\237\1\310\3\237\1\364\2\237"+
    "\1\0\3\237\2\0\30\237\22\0\1\315\2\0\3\237"+
    "\1\0\20\237\1\0\3\237\2\0\12\237\2\310\14\237"+
    "\22\0\1\315\2\0\3\237\1\0\20\237\1\0\3\237"+
    "\2\0\20\237\2\365\6\237\22\0\1\307\2\0\3\237"+
    "\1\0\20\237\1\0\3\237\2\0\12\237\2\310\14\237"+
    "\2\0\2\304\1\305\15\0\1\315\2\0\1\366\2\237"+
    "\1\0\1\237\1\332\1\367\4\237\1\366\3\237\1\332"+
    "\1\367\3\237\1\0\3\237\2\0\2\332\10\237\2\370"+
    "\14\237\22\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\3\237\2\0\20\237\2\371\6\237\22\0\1\307\2\0"+
    "\1\237\1\313\1\237\1\0\10\237\1\313\7\237\1\0"+
    "\3\237\2\0\30\237\2\0\2\304\1\305\15\0\1\315"+
    "\2\0\3\237\1\0\2\237\1\333\11\237\1\333\3\237"+
    "\1\0\3\237\2\0\12\237\2\310\14\237\22\0\1\307"+
    "\2\0\3\237\1\0\20\237\1\0\3\237\2\0\20\237"+
    "\2\372\6\237\2\0\2\304\1\305\15\0\1\315\2\0"+
    "\3\237\1\0\20\237\1\0\3\237\2\0\16\237\2\332"+
    "\10\237\22\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\3\237\2\0\6\237\2\310\20\237\22\0\1\315\2\0"+
    "\3\237\1\0\1\237\1\373\11\237\1\373\4\237\1\0"+
    "\3\237\2\0\30\237\22\0\1\315\2\0\3\237\1\0"+
    "\20\237\1\0\2\310\1\237\2\0\26\237\2\313\22\0"+
    "\1\307\2\0\3\237\1\0\20\237\1\0\3\237\2\0"+
    "\6\237\2\313\20\237\2\0\2\304\1\305\15\0\1\315"+
    "\2\0\3\237\1\0\1\237\1\310\11\237\1\310\4\237"+
    "\1\0\3\237\2\0\30\237\22\0\1\315\2\0\3\237"+
    "\1\0\20\237\1\0\2\310\1\237\2\0\30\237\22\0"+
    "\1\315\2\0\3\237\1\0\1\237\1\374\11\237\1\374"+
    "\4\237\1\0\3\237\2\0\30\237\22\0\1\315\2\0"+
    "\3\237\1\0\2\237\1\310\11\237\1\310\3\237\1\0"+
    "\3\237\2\0\2\320\26\237\22\0\1\315\2\0\3\237"+
    "\1\0\20\237\1\0\3\237\2\0\4\237\2\375\22\237"+
    "\52\0\2\376\54\0\1\3\1\174\2\0\3\7\1\3"+
    "\6\7\12\377\1\3\1\7\1\377\2\7\1\3\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\3\7\1\3"+
    "\1\0\5\3\2\0\6\3\4\0\3\u0100\1\0\20\u0100"+
    "\1\0\3\u0100\1\u0101\1\0\30\u0100\2\u0101\17\0\1\3"+
    "\1\202\2\0\3\7\1\3\6\7\12\377\1\3\1\7"+
    "\1\377\2\7\1\3\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\3\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\53\2\0\3\7\1\3\20\7\1\3\4\7\1\3"+
    "\2\7\2\u0102\26\7\1\3\1\0\5\3\2\0\7\3"+
    "\1\174\2\0\3\7\1\3\6\7\12\377\1\3\1\7"+
    "\1\377\2\7\1\3\1\377\1\7\1\u0103\1\u0102\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\1\7\1\377\1\7\1\377\1\7\1\377"+
    "\1\7\1\377\3\7\1\3\1\0\5\3\2\0\6\3"+
    "\13\0\1\u0104\11\0\1\u0104\70\0\1\346\100\0\1\u0105"+
    "\6\0\1\141\11\0\1\141\65\0\1\u0106\5\0\1\72"+
    "\60\0\2\77\1\100\23\0\1\351\107\0\1\76\11\0"+
    "\1\76\73\0\1\30\107\0\1\103\11\0\1\103\73\0"+
    "\1\32\60\0\2\77\1\100\23\0\1\357\100\0\1\u0107"+
    "\6\0\1\156\11\0\1\156\65\0\1\u0108\5\0\1\111"+
    "\147\0\2\233\36\0\1\u0109\106\0\1\315\2\0\3\237"+
    "\1\0\20\237\1\0\3\237\2\0\12\237\2\325\14\237"+
    "\22\0\1\315\2\0\3\237\1\0\2\237\1\u010a\11\237"+
    "\1\u010a\3\237\1\0\3\237\2\0\30\237\22\0\1\315"+
    "\2\0\3\237\1\0\3\237\1\310\11\237\1\310\2\237"+
    "\1\0\3\237\2\0\30\237\22\0\1\315\2\0\3\237"+
    "\1\0\20\237\1\0\2\313\1\237\2\0\30\237\22\0"+
    "\1\307\2\0\3\237\1\0\20\237\1\0\2\313\1\237"+
    "\2\0\6\237\2\u010b\4\237\2\310\12\237\2\0\2\304"+
    "\1\305\15\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\3\237\2\0\10\237\2\310\16\237\22\0\1\315\2\0"+
    "\3\237\1\0\4\237\1\u010c\11\237\1\u010c\1\237\1\0"+
    "\3\237\2\0\30\237\22\0\1\315\2\0\3\237\1\0"+
    "\3\237\1\u010d\11\237\1\u010d\2\237\1\0\3\237\2\0"+
    "\30\237\22\0\1\315\2\0\3\237\1\0\4\237\1\311"+
    "\11\237\1\311\1\237\1\0\3\237\2\0\30\237\22\0"+
    "\1\315\2\0\3\237\1\0\2\237\1\u010e\11\237\1\u010e"+
    "\3\237\1\0\3\237\2\0\30\237\22\0\1\u010f\105\0"+
    "\1\3\1\174\2\0\3\7\1\3\6\7\12\u0110\1\3"+
    "\1\7\1\u0110\2\7\1\3\1\u0110\1\7\1\u0110\1\7"+
    "\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7"+
    "\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7"+
    "\1\u0110\1\7\1\u0110\3\7\1\3\1\0\5\3\2\0"+
    "\6\3\1\0\1\307\2\0\3\u0100\1\0\20\u0100\1\0"+
    "\3\u0100\1\u0101\1\0\30\u0100\2\u0101\2\304\1\305\15\0"+
    "\1\303\2\0\3\u0101\1\0\20\u0101\1\0\4\u0101\1\0"+
    "\32\u0101\2\304\1\305\14\0\1\3\1\53\2\0\3\7"+
    "\1\3\20\7\1\3\4\7\1\3\12\7\2\176\16\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0110\1\3\1\7\1\u0110\2\7\1\3"+
    "\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7"+
    "\1\u0110\1\7\1\u0111\1\176\1\u0110\1\7\1\u0110\1\7"+
    "\1\u0110\1\7\1\u0110\1\7\1\u0110\1\7\1\u0110\3\7"+
    "\1\3\1\0\5\3\2\0\6\3\10\0\1\141\11\0"+
    "\1\141\73\0\1\72\60\0\2\77\1\100\24\0\1\156"+
    "\11\0\1\156\65\0\1\153\2\0\3\223\1\111\20\223"+
    "\1\0\3\223\2\0\30\223\25\0\3\u0112\1\0\20\u0112"+
    "\1\0\3\u0112\2\0\30\u0112\22\0\1\315\2\0\3\237"+
    "\1\0\20\237\1\0\3\237\2\0\6\237\2\u0113\20\237"+
    "\22\0\1\315\2\0\3\237\1\0\20\237\1\0\3\237"+
    "\2\0\12\237\2\u0114\14\237\22\0\1\315\2\0\3\237"+
    "\1\0\1\237\1\u0113\11\237\1\u0113\4\237\1\0\3\237"+
    "\2\0\30\237\22\0\1\315\2\0\3\237\1\0\20\237"+
    "\1\0\3\237\2\0\12\237\2\u0115\14\237\22\0\1\315"+
    "\2\0\3\237\1\0\20\237\1\0\3\237\2\0\6\237"+
    "\2\313\20\237\21\0\1\3\1\174\2\0\3\7\1\3"+
    "\6\7\12\u0116\1\3\1\7\1\u0116\2\7\1\3\1\u0116"+
    "\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116"+
    "\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116"+
    "\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116\3\7\1\3"+
    "\1\0\5\3\2\0\7\3\1\202\2\0\3\7\1\3"+
    "\6\7\12\u0116\1\3\1\7\1\u0116\2\7\1\3\1\u0116"+
    "\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116"+
    "\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116"+
    "\1\7\1\u0116\1\7\1\u0116\1\7\1\u0116\3\7\1\3"+
    "\1\0\5\3\2\0\6\3\1\0\1\u0117\2\0\3\u0112"+
    "\1\0\20\u0112\1\0\3\u0112\2\0\30\u0112\22\0\1\315"+
    "\2\0\3\237\1\0\20\237\1\0\3\237\2\0\22\237"+
    "\2\u0118\4\237\22\0\1\307\2\0\3\237\1\0\20\237"+
    "\1\0\3\237\2\0\4\237\2\375\22\237\2\0\2\304"+
    "\1\305\15\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\3\237\2\0\6\237\2\332\20\237\21\0\1\3\1\174"+
    "\2\0\3\7\1\3\6\7\12\u0119\1\3\1\7\1\u0119"+
    "\2\7\1\3\1\u0119\1\7\1\u0119\1\7\1\u0119\1\7"+
    "\1\u0119\1\7\1\u0119\1\7\1\u0119\1\7\1\u0119\1\7"+
    "\1\u0119\1\7\1\u0119\1\7\1\u0119\1\7\1\u0119\1\7"+
    "\1\u0119\3\7\1\3\1\0\5\3\2\0\6\3\35\0"+
    "\1\u011a\52\0\1\315\2\0\3\237\1\0\20\237\1\0"+
    "\3\237\2\0\2\u011b\26\237\21\0\1\3\1\174\2\0"+
    "\3\7\1\3\6\7\12\u011c\1\3\1\7\1\u011c\2\7"+
    "\1\3\1\u011c\1\7\1\u011c\1\7\1\u011c\1\7\1\u011c"+
    "\1\7\1\u011c\1\7\1\u011c\1\7\1\u011c\1\7\1\u011c"+
    "\1\7\1\u011c\1\7\1\u011c\1\7\1\u011c\1\7\1\u011c"+
    "\3\7\1\3\1\0\5\3\2\0\6\3\1\0\1\u011d"+
    "\106\0\1\315\2\0\3\237\1\0\20\237\1\0\3\237"+
    "\2\0\2\237\2\u011e\24\237\21\0\1\3\1\174\2\0"+
    "\3\7\1\3\6\7\12\u011f\1\3\1\7\1\u011f\2\7"+
    "\1\3\1\u011f\1\7\1\u011f\1\7\1\u011f\1\7\1\u011f"+
    "\1\7\1\u011f\1\7\1\u011f\1\7\1\u011f\1\7\1\u011f"+
    "\1\7\1\u011f\1\7\1\u011f\1\7\1\u011f\1\7\1\u011f"+
    "\3\7\1\3\1\0\5\3\2\0\6\3\4\0\3\u0120"+
    "\1\0\20\u0120\1\0\3\u0120\2\0\30\u0120\22\0\1\315"+
    "\2\0\3\237\1\0\5\237\1\310\11\237\1\310\1\0"+
    "\3\237\2\0\30\237\21\0\1\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0121\1\3\1\7\1\u0121\2\7\1\3"+
    "\1\u0121\1\7\1\u0121\1\7\1\u0121\1\7\1\u0121\1\7"+
    "\1\u0121\1\7\1\u0121\1\7\1\u0121\1\7\1\u0121\1\7"+
    "\1\u0121\1\7\1\u0121\1\7\1\u0121\1\7\1\u0121\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0122\1\3\1\7\1\u0122\2\7\1\3"+
    "\1\u0122\1\7\1\u0122\1\7\1\u0122\1\7\1\u0122\1\7"+
    "\1\u0122\1\7\1\u0122\1\7\1\u0122\1\7\1\u0122\1\7"+
    "\1\u0122\1\7\1\u0122\1\7\1\u0122\1\7\1\u0122\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0123\1\3\1\7\1\u0123\2\7\1\3"+
    "\1\u0123\1\7\1\u0123\1\7\1\u0123\1\7\1\u0123\1\7"+
    "\1\u0123\1\7\1\u0123\1\7\1\u0123\1\7\1\u0123\1\7"+
    "\1\u0123\1\7\1\u0123\1\7\1\u0123\1\7\1\u0123\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0124\1\3\1\7\1\u0124\2\7\1\3"+
    "\1\u0124\1\7\1\u0124\1\7\1\u0124\1\7\1\u0124\1\7"+
    "\1\u0124\1\7\1\u0124\1\7\1\u0124\1\7\1\u0124\1\7"+
    "\1\u0124\1\7\1\u0124\1\7\1\u0124\1\7\1\u0124\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0125\1\3\1\7\1\u0125\2\7\1\3"+
    "\1\u0125\1\7\1\u0125\1\7\1\u0125\1\7\1\u0125\1\7"+
    "\1\u0125\1\7\1\u0125\1\7\1\u0125\1\7\1\u0125\1\7"+
    "\1\u0125\1\7\1\u0125\1\7\1\u0125\1\7\1\u0125\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0126\1\3\1\7\1\u0126\2\7\1\3"+
    "\1\u0126\1\7\1\u0126\1\7\1\u0126\1\7\1\u0126\1\7"+
    "\1\u0126\1\7\1\u0126\1\7\1\u0126\1\7\1\u0126\1\7"+
    "\1\u0126\1\7\1\u0126\1\7\1\u0126\1\7\1\u0126\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0127\1\3\1\7\1\u0127\2\7\1\3"+
    "\1\u0127\1\7\1\u0127\1\7\1\u0127\1\7\1\u0127\1\7"+
    "\1\u0127\1\7\1\u0127\1\7\1\u0127\1\7\1\u0127\1\7"+
    "\1\u0127\1\7\1\u0127\1\7\1\u0127\1\7\1\u0127\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0128\1\3\1\7\1\u0128\2\7\1\3"+
    "\1\u0128\1\7\1\u0128\1\7\1\u0128\1\7\1\u0128\1\7"+
    "\1\u0128\1\7\1\u0128\1\7\1\u0128\1\7\1\u0128\1\7"+
    "\1\u0128\1\7\1\u0128\1\7\1\u0128\1\7\1\u0128\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0129\1\3\1\7\1\u0129\2\7\1\3"+
    "\1\u0129\1\7\1\u0129\1\7\1\u0129\1\7\1\u0129\1\7"+
    "\1\u0129\1\7\1\u0129\1\7\1\u0129\1\7\1\u0129\1\7"+
    "\1\u0129\1\7\1\u0129\1\7\1\u0129\1\7\1\u0129\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u012a\1\3\1\7\1\u012a\2\7\1\3"+
    "\1\u012a\1\7\1\u012a\1\7\1\u012a\1\7\1\u012a\1\7"+
    "\1\u012a\1\7\1\u012a\1\7\1\u012a\1\7\1\u012a\1\7"+
    "\1\u012a\1\7\1\u012a\1\7\1\u012a\1\7\1\u012a\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u012b\1\3\1\7\1\u012b\2\7\1\3"+
    "\1\u012b\1\7\1\u012b\1\7\1\u012b\1\7\1\u012b\1\7"+
    "\1\u012b\1\7\1\u012b\1\7\1\u012b\1\7\1\u012b\1\7"+
    "\1\u012b\1\7\1\u012b\1\7\1\u012b\1\7\1\u012b\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u012c\1\3\1\7\1\u012c\2\7\1\3"+
    "\1\u012c\1\7\1\u012c\1\7\1\u012c\1\7\1\u012c\1\7"+
    "\1\u012c\1\7\1\u012c\1\7\1\u012c\1\7\1\u012c\1\7"+
    "\1\u012c\1\7\1\u012c\1\7\1\u012c\1\7\1\u012c\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u012d\1\3\1\7\1\u012d\2\7\1\3"+
    "\1\u012d\1\7\1\u012d\1\7\1\u012d\1\7\1\u012d\1\7"+
    "\1\u012d\1\7\1\u012d\1\7\1\u012d\1\7\1\u012d\1\7"+
    "\1\u012d\1\7\1\u012d\1\7\1\u012d\1\7\1\u012d\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u012e\1\3\1\7\1\u012e\2\7\1\3"+
    "\1\u012e\1\7\1\u012e\1\7\1\u012e\1\7\1\u012e\1\7"+
    "\1\u012e\1\7\1\u012e\1\7\1\u012e\1\7\1\u012e\1\7"+
    "\1\u012e\1\7\1\u012e\1\7\1\u012e\1\7\1\u012e\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u012f\1\3\1\7\1\u012f\2\7\1\3"+
    "\1\u012f\1\7\1\u012f\1\7\1\u012f\1\7\1\u012f\1\7"+
    "\1\u012f\1\7\1\u012f\1\7\1\u012f\1\7\1\u012f\1\7"+
    "\1\u012f\1\7\1\u012f\1\7\1\u012f\1\7\1\u012f\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0130\1\3\1\7\1\u0130\2\7\1\3"+
    "\1\u0130\1\7\1\u0130\1\7\1\u0130\1\7\1\u0130\1\7"+
    "\1\u0130\1\7\1\u0130\1\7\1\u0130\1\7\1\u0130\1\7"+
    "\1\u0130\1\7\1\u0130\1\7\1\u0130\1\7\1\u0130\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0131\1\3\1\7\1\u0131\2\7\1\3"+
    "\1\u0131\1\7\1\u0131\1\7\1\u0131\1\7\1\u0131\1\7"+
    "\1\u0131\1\7\1\u0131\1\7\1\u0131\1\7\1\u0131\1\7"+
    "\1\u0131\1\7\1\u0131\1\7\1\u0131\1\7\1\u0131\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\6\7\12\u0132\1\3\1\7\1\u0132\2\7\1\3"+
    "\1\u0132\1\7\1\u0132\1\7\1\u0132\1\7\1\u0132\1\7"+
    "\1\u0132\1\7\1\u0132\1\7\1\u0132\1\7\1\u0132\1\7"+
    "\1\u0132\1\7\1\u0132\1\7\1\u0132\1\7\1\u0132\3\7"+
    "\1\3\1\0\5\3\2\0\7\3\1\174\2\0\3\7"+
    "\1\3\20\7\1\3\4\7\1\3\32\7\1\3\1\0"+
    "\5\3\2\0\6\3";

  private static int [] zzUnpackTrans() {
    int [] result = new int[19525];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\15\1\1\11\2\1\1\11\4\1\1\11\1\1"+
    "\2\0\1\11\3\0\2\1\3\11\7\0\10\1\1\11"+
    "\1\1\4\11\1\1\4\0\1\11\1\1\3\0\1\11"+
    "\6\0\1\11\7\0\13\1\1\11\6\0\1\11\4\0"+
    "\1\11\5\0\1\1\2\0\1\11\1\0\1\11\7\0"+
    "\2\1\1\0\2\1\1\0\5\1\5\0\1\1\5\0"+
    "\1\11\3\0\3\1\4\0\15\1\1\0\1\1\1\0"+
    "\4\1\4\0\3\1\10\0\1\1\1\0\2\11\1\1"+
    "\1\0\6\1\1\0\20\1\1\0\1\1\1\0\3\1"+
    "\3\0\1\1\3\0\1\1\5\0\1\11\2\0\12\1"+
    "\1\0\2\1\1\0\2\1\1\11\1\0\1\1\3\0"+
    "\5\1\1\11\7\1\1\0\2\1\1\0\2\1\1\0"+
    "\25\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[306];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */

/*
"'T WAS"
{ return("'TWAS"); }
"'T was"
{ return("'Twas"); }
"'t was"
{ return("'twas"); }
"'T IS"
{ return("'TIS"); }
"'T is"
{ return("'Tis"); }
"'t is"
{ return("'tis"); }
*/

  private static String removeWhite(String in) {
    StringBuilder out = new StringBuilder();
    for (int i = 0, len = in.length(); i < len; i++) {
      char ch = in.charAt(i);
      if (ch != ' ') {
        out.append(ch);
      }
    }
    return out.toString();
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  PTB2TextLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  PTB2TextLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1348) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 21: 
          { return("n't");
          }
        case 31: break;
        case 28: 
          // lookahead expression with fixed lookahead length
          yypushback(2);
          { return yytext();
          }
        case 32: break;
        case 27: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return yytext();
          }
        case 33: break;
        case 26: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return yytext();
          }
        case 34: break;
        case 12: 
          { return "/";
          }
        case 35: break;
        case 5: 
          { return yytext();
          }
        case 36: break;
        case 3: 
          { return "&";
          }
        case 37: break;
        case 6: 
          { yybegin(YYINITIAL); return "\"";
          }
        case 38: break;
        case 13: 
          { return "(";
          }
        case 39: break;
        case 8: 
          { return(")");
          }
        case 40: break;
        case 22: 
          { return "<";
          }
        case 41: break;
        case 23: 
          { return ">";
          }
        case 42: break;
        case 29: 
          { return "cannot";
          }
        case 43: break;
        case 1: 
          { return(yytext());
          }
        case 44: break;
        case 20: 
          // lookahead expression with fixed lookahead length
          yypushback(2);
          { return "\"";
          }
        case 45: break;
        case 16: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return "\"";
          }
        case 46: break;
        case 17: 
          { return "\"";
          }
        case 47: break;
        case 11: 
          { return("`");
          }
        case 48: break;
        case 14: 
          { return("{");
          }
        case 49: break;
        case 19: 
          { return("\"");
          }
        case 50: break;
        case 15: 
          { return("$");
          }
        case 51: break;
        case 7: 
          { return(yytext().substring(1, yytext().length()));
          }
        case 52: break;
        case 24: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { yybegin(INQUOTE); return "\" \"";
          }
        case 53: break;
        case 10: 
          { return("%");
          }
        case 54: break;
        case 4: 
          { yybegin(YYINITIAL); return(yytext());
          }
        case 55: break;
        case 9: 
          { return("}");
          }
        case 56: break;
        case 30: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return removeWhite(yytext());
          }
        case 57: break;
        case 25: 
          { return removeWhite(yytext());
          }
        case 58: break;
        case 18: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { yybegin(INQUOTE); return "\"";
          }
        case 59: break;
        case 2: 
          { yybegin(INQUOTE); return "\"";
          }
        case 60: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return null;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
