/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgrex.Alignment;
import edu.stanford.nlp.semgrex.NodePattern;
import edu.stanford.nlp.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgrex.VariableStrings;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CoordinationPattern
extends SemgrexPattern {
    private static final long serialVersionUID = -3122330899634961002L;
    private boolean isConj;
    private boolean isNodeCoord;
    private List<SemgrexPattern> children;

    public CoordinationPattern(boolean isNodeCoord, List<SemgrexPattern> children, boolean isConj) {
        if (children.size() < 2) {
            throw new RuntimeException("Coordination node must have at least 2 children.");
        }
        this.children = children;
        this.isConj = isConj;
        this.isNodeCoord = isNodeCoord;
    }

    public boolean isNodeCoord() {
        return this.isNodeCoord;
    }

    @Override
    public void setChild(SemgrexPattern child) {
        if (this.isNodeCoord) {
            for (SemgrexPattern c : this.children) {
                if (!(c instanceof NodePattern)) continue;
                ((NodePattern)c).setChild(child);
            }
        }
    }

    public void addRelnToNodeCoord(SemgrexPattern child) {
        if (this.isNodeCoord) {
            for (SemgrexPattern c : this.children) {
                ArrayList<SemgrexPattern> newChildren = new ArrayList<SemgrexPattern>();
                newChildren.addAll(c.getChildren());
                newChildren.add(child);
                c.setChild(new CoordinationPattern(false, newChildren, true));
            }
        }
    }

    @Override
    public List<SemgrexPattern> getChildren() {
        return this.children;
    }

    @Override
    public String localString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegated()) {
            sb.append('!');
        }
        if (this.isOptional()) {
            sb.append('?');
        }
        sb.append(this.isConj ? "and" : "or");
        sb.append(" ");
        sb.append(this.isNodeCoord ? "node coordination" : "reln coordination");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean hasPrecedence) {
        StringBuilder sb = new StringBuilder();
        if (this.isConj) {
            for (SemgrexPattern node : this.children) {
                sb.append(node.toString());
            }
        } else {
            sb.append('[');
            Iterator<SemgrexPattern> iter = this.children.iterator();
            while (iter.hasNext()) {
                SemgrexPattern node = iter.next();
                sb.append(node.toString());
                if (!iter.hasNext()) continue;
                sb.append(" |");
            }
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public SemgrexMatcher matcher(SemanticGraph sg, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings, boolean ignoreCase) {
        return new CoordinationMatcher(this, sg, null, null, true, node, namesToNodes, namesToRelations, variableStrings, ignoreCase);
    }

    @Override
    public SemgrexMatcher matcher(SemanticGraph sg, Alignment alignment, SemanticGraph sg_align, boolean hypToText, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings, boolean ignoreCase) {
        return new CoordinationMatcher(this, sg, alignment, sg_align, hypToText, node, namesToNodes, namesToRelations, variableStrings, ignoreCase);
    }

    private static class CoordinationMatcher
    extends SemgrexMatcher {
        private SemgrexMatcher[] children;
        private final CoordinationPattern myNode;
        private int currChild;
        private final boolean considerAll;
        private IndexedWord nextNodeMatch = null;

        public CoordinationMatcher(CoordinationPattern c, SemanticGraph sg, Alignment alignment, SemanticGraph sg_align, boolean hypToText, IndexedWord n, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings, boolean ignoreCase) {
            super(sg, alignment, sg_align, hypToText, n, namesToNodes, namesToRelations, variableStrings);
            this.myNode = c;
            this.children = new SemgrexMatcher[this.myNode.children.size()];
            for (int i = 0; i < this.children.length; ++i) {
                SemgrexPattern node = (SemgrexPattern)this.myNode.children.get(i);
                this.children[i] = node.matcher(sg, alignment, sg_align, hypToText, n, namesToNodes, namesToRelations, variableStrings, ignoreCase);
            }
            this.currChild = 0;
            this.considerAll = this.myNode.isConj ^ this.myNode.isNegated();
        }

        @Override
        void resetChildIter() {
            this.currChild = 0;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].resetChildIter();
            }
            this.nextNodeMatch = null;
        }

        @Override
        void resetChildIter(IndexedWord node) {
            this.currChild = 0;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].resetChildIter(node);
            }
        }

        @Override
        public boolean matches() {
            if (this.considerAll) {
                if (this.currChild < 0) {
                    return this.myNode.isOptional();
                }
                if (this.currChild == this.children.length) {
                    --this.currChild;
                }
                while (true) {
                    if (this.myNode.isNegated() != this.children[this.currChild].matches()) {
                        ++this.currChild;
                        if (this.currChild != this.children.length) continue;
                        if (this.myNode.isNegated()) {
                            this.currChild = -1;
                        } else if (this.myNode.isNodeCoord) {
                            this.nextNodeMatch = this.children[0].getMatch();
                        }
                        return true;
                    }
                    this.children[this.currChild].resetChildIter();
                    --this.currChild;
                    if (this.currChild < 0) break;
                }
                return this.myNode.isOptional();
            }
            while (this.currChild < this.children.length) {
                if (this.myNode.isNegated() != this.children[this.currChild].matches()) {
                    if (this.myNode.isNegated()) {
                        this.currChild = this.children.length;
                    }
                    if (this.myNode.isNodeCoord) {
                        this.nextNodeMatch = this.children[this.currChild].getMatch();
                    }
                    return true;
                }
                this.children[this.currChild].resetChildIter();
                ++this.currChild;
            }
            if (this.myNode.isNegated()) {
                this.currChild = this.children.length;
            }
            return this.myNode.isOptional();
        }

        @Override
        public IndexedWord getMatch() {
            if (this.myNode.isNodeCoord && !this.myNode.isNegated()) {
                return this.nextNodeMatch;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            String ret = "coordinate matcher for: ";
            for (SemgrexMatcher child : this.children) {
                ret = ret + child.toString() + " ";
            }
            return ret;
        }
    }
}

