/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.gui.FilePanel;
import edu.stanford.nlp.trees.tregex.gui.FileTreeNode;
import edu.stanford.nlp.trees.tregex.gui.TregexGUI;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTreeModel
extends DefaultTreeModel
implements FileTreeNode.FileTreeNodeListener {
    private final List<TreeModelListener> listeners;
    private final FileTreeNode root;
    private final HashMap<FileTreeNode, List<FileTreeNode>> treeStructure;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_CHINESE_ENCODING = "GB18030";
    public static final String DEFAULT_NEGRA_ENCODING = " ISO-8859-1";
    private static String curEncoding = "UTF-8";
    private static TreeReaderFactory trf;

    public FileTreeModel(FileTreeNode root) {
        super(root);
        this.root = root;
        root.addListener(this);
        this.listeners = new ArrayList<TreeModelListener>();
        this.treeStructure = new HashMap();
        this.treeStructure.put(root, new ArrayList());
        trf = new TregexPattern.TRegexTreeReaderFactory();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    protected void fireTreeStructureChanged(TreePath parentPath) {
        TreeModelEvent e = null;
        for (TreeModelListener l : this.listeners) {
            if (e == null) {
                e = new TreeModelEvent((Object)this, parentPath, null, null);
            }
            l.treeStructureChanged(e);
        }
    }

    @Override
    public FileTreeNode getChild(Object parent, int childNum) {
        List<FileTreeNode> children = this.treeStructure.get(parent);
        if (children == null || childNum < 0 || children.size() <= childNum) {
            return null;
        }
        return children.get(childNum);
    }

    @Override
    public int getChildCount(Object parent) {
        List<FileTreeNode> children = this.treeStructure.get(parent);
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        List<FileTreeNode> children = this.treeStructure.get(parent);
        if (children == null) {
            return -1;
        }
        return children.indexOf(child);
    }

    @Override
    public boolean isLeaf(Object node) {
        List<FileTreeNode> children = this.treeStructure.get(node);
        return children == null;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void treeNodeChanged(FileTreeNode n) {
        TreePath t = new TreePath(this.makeTreePathArray(n));
        this.fireTreeStructureChanged(t);
    }

    public boolean isEmpty() {
        return this.getChildCount(this.root) == 0;
    }

    private Object[] makeTreePathArray(FileTreeNode node) {
        ArrayList<FileTreeNode> path = new ArrayList<FileTreeNode>();
        path.add(node);
        for (TreeNode child = node; child != this.getRoot(); child = child.getParent()) {
            path.add(0, (FileTreeNode)child);
        }
        return path.toArray();
    }

    @Override
    public FileTreeNode getRoot() {
        return this.root;
    }

    public void addFileFolder(EnumMap<TregexGUI.FilterType, String> filters, File[] files) {
        ArrayList<FileTreeNode> newFiles = new ArrayList<FileTreeNode>();
        this.findLoadableFiles(filters, files, newFiles, this.getRoot());
        for (FileTreeNode fileNode : newFiles) {
            DiskTreebank treebank = new DiskTreebank(trf, curEncoding);
            treebank.loadPath(fileNode.getFile(), null, true);
            fileNode.setTreebank(treebank);
        }
        this.fireTreeStructureChanged(new TreePath(this.getRoot()));
    }

    private void findLoadableFiles(EnumMap<TregexGUI.FilterType, String> filters, File[] files, List<FileTreeNode> newFiles, FileTreeNode parent) {
        for (File f : files) {
            if (f.isDirectory()) {
                if (FileTreeModel.isLikelyInvisible(f.getName())) continue;
                FileTreeNode newParent = this.createNode(f, parent);
                this.treeStructure.put(newParent, new ArrayList());
                this.findLoadableFiles(filters, f.listFiles(), newFiles, newParent);
                if (this.treeStructure.get(newParent).isEmpty()) continue;
                List<FileTreeNode> value = this.treeStructure.get(parent);
                value.add(newParent);
                continue;
            }
            boolean loadFile = FileTreeModel.checkFile(filters, f);
            if (!loadFile) continue;
            FileTreeNode newFile = this.addToMap(f, parent);
            if (TregexGUI.getInstance().isTdiffEnabled() && FilePanel.getInstance().getActiveTreebanks().size() > 2) {
                newFile.setActive(false);
            }
            newFiles.add(newFile);
        }
    }

    private FileTreeNode createNode(File f, FileTreeNode parent) {
        FileTreeNode newNode = new FileTreeNode(f, parent);
        newNode.addListener(this);
        return newNode;
    }

    private FileTreeNode addToMap(File f, FileTreeNode parent) {
        List<FileTreeNode> value = this.treeStructure.get(parent);
        if (value == null) {
            throw new RuntimeException("Something very very bad has happened; a parent was not in the tree for the given child; parent: " + parent);
        }
        FileTreeNode newNode = this.createNode(f, parent);
        value.add(newNode);
        return newNode;
    }

    private static boolean checkFile(EnumMap<TregexGUI.FilterType, String> filters, File file) {
        NumberRangesFileFilter f;
        String pre;
        String ext;
        String fileName = file.getName();
        if (FileTreeModel.isLikelyInvisible(fileName)) {
            return false;
        }
        if (filters.containsKey((Object)TregexGUI.FilterType.hasExtension) && !fileName.endsWith(ext = filters.get((Object)TregexGUI.FilterType.hasExtension))) {
            return false;
        }
        if (filters.containsKey((Object)TregexGUI.FilterType.hasPrefix) && !fileName.startsWith(pre = filters.get((Object)TregexGUI.FilterType.hasPrefix))) {
            return false;
        }
        return !filters.containsKey((Object)TregexGUI.FilterType.isInRange) || (f = new NumberRangesFileFilter(filters.get((Object)TregexGUI.FilterType.isInRange), false)).accept(fileName);
    }

    private static boolean isLikelyInvisible(String filename) {
        return filename.startsWith(".");
    }

    public static TreeReaderFactory getTRF() {
        return trf;
    }

    public static void setTRF(TreeReaderFactory trf) {
        FileTreeModel.trf = trf;
    }

    public static String getCurEncoding() {
        return curEncoding;
    }

    public static void setCurEncoding(String curEncoding) {
        FileTreeModel.curEncoding = curEncoding;
    }
}

