/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgrex.Alignment;
import edu.stanford.nlp.semgrex.ParseException;
import edu.stanford.nlp.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgrex.SemgrexParseException;
import edu.stanford.nlp.semgrex.SemgrexParser;
import edu.stanford.nlp.semgrex.TokenMgrError;
import edu.stanford.nlp.semgrex.VariableStrings;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SemgrexPattern
implements Serializable {
    private static final long serialVersionUID = 1722052832350596732L;
    private boolean neg = false;
    private boolean opt = false;
    private String patternString;

    SemgrexPattern() {
    }

    abstract List<SemgrexPattern> getChildren();

    abstract String localString();

    abstract void setChild(SemgrexPattern var1);

    void negate() {
        this.neg = true;
        if (this.neg && this.opt) {
            throw new RuntimeException("Node cannot be both negated and optional.");
        }
    }

    void makeOptional() {
        this.opt = true;
        if (this.neg && this.opt) {
            throw new RuntimeException("Node cannot be both negated and optional.");
        }
    }

    boolean isNegated() {
        return this.neg;
    }

    boolean isOptional() {
        return this.opt;
    }

    abstract SemgrexMatcher matcher(SemanticGraph var1, IndexedWord var2, Map<String, IndexedWord> var3, Map<String, String> var4, VariableStrings var5, boolean var6);

    abstract SemgrexMatcher matcher(SemanticGraph var1, Alignment var2, SemanticGraph var3, boolean var4, IndexedWord var5, Map<String, IndexedWord> var6, Map<String, String> var7, VariableStrings var8, boolean var9);

    public SemgrexMatcher matcher(SemanticGraph sg) {
        return this.matcher(sg, sg.getFirstRoot(), new HashMap<String, IndexedWord>(), new HashMap<String, String>(), new VariableStrings(), false);
    }

    public SemgrexMatcher matcher(SemanticGraph sg, Map<String, IndexedWord> variables) {
        return this.matcher(sg, sg.getFirstRoot(), variables, new HashMap<String, String>(), new VariableStrings(), false);
    }

    public SemgrexMatcher matcher(SemanticGraph sg, boolean ignoreCase) {
        return this.matcher(sg, sg.getFirstRoot(), new HashMap<String, IndexedWord>(), new HashMap<String, String>(), new VariableStrings(), ignoreCase);
    }

    public SemgrexMatcher matcher(SemanticGraph hypGraph, Alignment alignment, SemanticGraph txtGraph) {
        return this.matcher(hypGraph, alignment, txtGraph, true, hypGraph.getFirstRoot(), new HashMap<String, IndexedWord>(), new HashMap<String, String>(), new VariableStrings(), false);
    }

    public SemgrexMatcher matcher(SemanticGraph hypGraph, Alignment alignment, SemanticGraph txtGraph, boolean ignoreCase) {
        return this.matcher(hypGraph, alignment, txtGraph, true, hypGraph.getFirstRoot(), new HashMap<String, IndexedWord>(), new HashMap<String, String>(), new VariableStrings(), ignoreCase);
    }

    public static SemgrexPattern compile(String semgrex) {
        try {
            SemgrexParser parser = new SemgrexParser(new StringReader(semgrex + "\n"));
            SemgrexPattern newPattern = parser.Root();
            newPattern.setPatternString(semgrex);
            return newPattern;
        }
        catch (ParseException ex) {
            throw new SemgrexParseException("Error parsing semgrex pattern " + semgrex, ex);
        }
        catch (TokenMgrError er) {
            throw new SemgrexParseException("Error parsing semgrex pattern " + semgrex, er);
        }
    }

    public String pattern() {
        return this.patternString;
    }

    public void setPatternString(String patternString) {
        this.patternString = patternString;
    }

    public abstract String toString();

    public abstract String toString(boolean var1);

    private void prettyPrint(PrintWriter pw, int indent) {
        for (int i = 0; i < indent; ++i) {
            pw.print("   ");
        }
        pw.println(this.localString());
        for (SemgrexPattern child : this.getChildren()) {
            child.prettyPrint(pw, indent + 1);
        }
    }

    public void prettyPrint(PrintWriter pw) {
        this.prettyPrint(pw, 0);
    }

    public void prettyPrint(PrintStream ps) {
        this.prettyPrint(new PrintWriter((Writer)new OutputStreamWriter(ps), true));
    }

    public void prettyPrint() {
        this.prettyPrint(System.out);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SemgrexPattern)) {
            return false;
        }
        return ((SemgrexPattern)o).toString().equals(this.toString());
    }

    public int hashCode() {
        if (this == null) {
            return 0;
        }
        return this.toString().hashCode();
    }
}

