/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgrex.Alignment;
import edu.stanford.nlp.semgrex.VariableStrings;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SemgrexMatcher {
    SemanticGraph sg;
    Map<String, IndexedWord> namesToNodes;
    Map<String, String> namesToRelations;
    VariableStrings variableStrings;
    LinkedList<IndexedWord> nodesToCheck;
    List<IndexedWord> seenNodes;
    IndexedWord node;
    Alignment alignment;
    SemanticGraph sg_aligned;
    boolean hyp;
    Iterator<IndexedWord> findIterator;
    IndexedWord findCurrent;

    SemgrexMatcher(SemanticGraph sg, Alignment alignment, SemanticGraph sg_aligned, boolean hyp, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings) {
        this.sg = sg;
        this.alignment = alignment == null ? null : alignment;
        this.sg_aligned = sg_aligned == null ? null : sg_aligned;
        this.hyp = hyp;
        this.node = node;
        this.namesToNodes = namesToNodes;
        this.namesToRelations = namesToRelations;
        this.variableStrings = variableStrings;
        this.nodesToCheck = new LinkedList();
        this.nodesToCheck.add(sg.getFirstRoot());
        this.seenNodes = new ArrayList<IndexedWord>();
    }

    SemgrexMatcher(SemanticGraph sg, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings) {
        this(sg, null, null, true, node, namesToNodes, namesToRelations, variableStrings);
    }

    public void reset() {
        this.findIterator = null;
        this.namesToNodes.clear();
        this.namesToRelations.clear();
        this.seenNodes.clear();
    }

    void resetChildIter(IndexedWord node) {
        this.node = node;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(IndexedWord node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract IndexedWord getMatch();

    public boolean find() {
        if (this.findIterator == null) {
            try {
                if (this.hyp) {
                    this.findIterator = this.sg.topologicalSort().iterator();
                } else {
                    if (this.sg_aligned == null) {
                        return false;
                    }
                    this.findIterator = this.sg_aligned.topologicalSort().iterator();
                }
            }
            catch (Exception ex) {
                if (this.hyp) {
                    this.findIterator = this.sg.vertexSet().iterator();
                }
                if (this.sg_aligned == null) {
                    return false;
                }
                this.findIterator = this.sg_aligned.vertexSet().iterator();
            }
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findNextMatchingNode() {
        IndexedWord lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    public IndexedWord getNode(String name) {
        return this.namesToNodes.get(name);
    }

    public String getRelnString(String name) {
        return this.namesToRelations.get(name);
    }

    public Set<String> getNodeNames() {
        return this.namesToNodes.keySet();
    }

    public Set<String> getRelationNames() {
        return this.namesToRelations.keySet();
    }

    public abstract String toString();

    public SemanticGraph getGraph() {
        return this.sg;
    }
}

