/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.LogRecordHandler;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VisibilityHandler
extends LogRecordHandler {
    private State defaultState = State.SHOW_ALL;
    private final Set<Object> deltaPool = new HashSet<Object>();

    public VisibilityHandler() {
    }

    public VisibilityHandler(Object[] channels) {
        if (channels.length > 0) {
            this.defaultState = State.HIDE_ALL;
            Collections.addAll(this.deltaPool, channels);
        }
    }

    public void showAll() {
        this.defaultState = State.SHOW_ALL;
        this.deltaPool.clear();
    }

    public void hideAll() {
        this.defaultState = State.HIDE_ALL;
        this.deltaPool.clear();
    }

    public boolean alsoShow(Object filter) {
        switch (this.defaultState) {
            case HIDE_ALL: {
                return this.deltaPool.add(filter);
            }
            case SHOW_ALL: {
                return this.deltaPool.remove(filter);
            }
        }
        throw new IllegalStateException("Unknown default state setting: " + (Object)((Object)this.defaultState));
    }

    public boolean alsoHide(Object filter) {
        switch (this.defaultState) {
            case HIDE_ALL: {
                return this.deltaPool.remove(filter);
            }
            case SHOW_ALL: {
                return this.deltaPool.add(filter);
            }
        }
        throw new IllegalStateException("Unknown default state setting: " + (Object)((Object)this.defaultState));
    }

    @Override
    public List<Redwood.Record> handle(Redwood.Record record) {
        boolean isPrinting = false;
        if (record.force()) {
            isPrinting = true;
        } else {
            block0 : switch (this.defaultState) {
                case HIDE_ALL: {
                    for (Object tag : record.channels()) {
                        if (!this.deltaPool.contains(tag)) continue;
                        isPrinting = true;
                        break block0;
                    }
                    break;
                }
                case SHOW_ALL: {
                    if (!this.deltaPool.isEmpty()) {
                        boolean somethingSeen = false;
                        for (Object tag : record.channels()) {
                            if (!this.deltaPool.contains(tag)) continue;
                            somethingSeen = true;
                            break;
                        }
                        isPrinting = !somethingSeen;
                        break;
                    }
                    isPrinting = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown default state setting: " + (Object)((Object)this.defaultState));
                }
            }
        }
        if (isPrinting) {
            return Collections.singletonList(record);
        }
        return EMPTY;
    }

    @Override
    public List<Redwood.Record> signalStartTrack(Redwood.Record signal) {
        return EMPTY;
    }

    @Override
    public List<Redwood.Record> signalEndTrack(int newDepth, long timeOfEnd) {
        return EMPTY;
    }

    private static enum State {
        SHOW_ALL,
        HIDE_ALL;

    }
}

