/* The following code was generated by JFlex 1.6.1 */

package edu.stanford.nlp.international.arabic.process;

import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;

/**
 * Tokenizer for UTF-8 Arabic. Supports raw text and both sections
 * (vocalized and unvocalized) of the ATB.
 *
 * @author Spence Green
 */


class ArabicLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\42\1\2\1\3\1\4\1\1\22\0\1\42\1\16\1\43"+
    "\1\7\1\46\2\7\1\46\2\43\1\7\1\27\1\15\1\21\1\6"+
    "\1\41\12\47\1\40\1\46\1\43\1\46\1\43\1\16\1\101\1\50"+
    "\1\105\1\57\1\75\1\67\1\50\1\73\1\51\3\50\1\103\1\63"+
    "\1\65\1\61\1\53\1\50\1\71\1\54\1\52\1\77\1\50\1\55"+
    "\3\50\1\22\1\13\1\26\1\46\1\20\1\46\1\14\1\104\1\56"+
    "\1\74\1\66\1\14\1\72\1\33\3\14\1\102\1\62\1\64\1\60"+
    "\1\35\1\14\1\70\1\36\1\34\1\76\1\14\1\45\3\14\1\44"+
    "\1\43\1\44\1\7\6\0\1\3\32\0\1\100\11\7\1\31\2\7"+
    "\1\31\7\7\1\31\4\7\1\31\5\7\27\30\1\0\37\30\1\0"+
    "\207\30\1\37\267\30\31\30\162\30\4\30\14\30\16\30\5\30\7\30"+
    "\1\30\1\30\1\30\201\30\5\30\1\30\2\30\2\30\4\30\1\0"+
    "\1\30\4\0\2\30\1\30\1\0\3\30\1\0\1\30\1\0\24\30"+
    "\1\0\54\30\1\30\46\30\1\30\5\30\4\30\202\30\1\0\5\30"+
    "\2\0\105\30\1\30\46\30\12\30\20\30\26\30\12\30\1\0\46\30"+
    "\2\0\1\30\6\30\1\0\47\30\11\0\55\30\1\0\1\30\1\0"+
    "\2\30\1\0\2\30\1\0\1\30\10\0\33\30\5\0\3\30\15\0"+
    "\14\7\1\11\1\12\15\17\5\7\1\30\43\32\1\25\1\32\1\23"+
    "\4\32\4\17\1\24\17\17\1\0\12\10\1\7\2\12\1\7\2\32"+
    "\1\17\143\32\1\7\1\32\17\17\2\32\7\17\2\32\12\10\3\32"+
    "\2\17\1\32\17\0\1\30\1\30\1\30\36\30\35\30\63\30\46\30"+
    "\13\30\1\30\16\0\12\10\41\30\11\30\2\30\4\0\1\30\5\0"+
    "\26\30\4\0\1\30\11\0\1\30\3\0\1\30\27\0\31\30\107\0"+
    "\23\30\115\0\4\30\66\30\2\0\1\30\1\30\21\30\1\0\1\30"+
    "\5\30\2\0\12\30\2\30\2\0\12\10\1\0\20\30\3\30\1\0"+
    "\10\30\2\0\2\30\2\0\26\30\1\0\7\30\1\0\1\30\3\0"+
    "\4\30\2\0\1\30\1\30\7\30\2\0\2\30\2\0\3\30\1\30"+
    "\10\0\1\30\4\0\2\30\1\0\3\30\2\30\2\0\12\10\2\30"+
    "\17\0\3\30\1\0\6\30\4\0\2\30\2\0\26\30\1\0\7\30"+
    "\1\0\2\30\1\0\2\30\1\0\2\30\2\0\1\30\1\0\22\30"+
    "\11\0\4\30\1\0\1\30\7\0\12\10\2\0\3\30\14\0\3\30"+
    "\1\0\11\30\1\0\3\30\1\0\26\30\1\0\7\30\1\0\2\30"+
    "\1\0\5\30\2\0\1\30\1\30\22\30\1\30\17\0\2\30\4\0"+
    "\12\10\25\0\10\30\2\0\2\30\2\0\26\30\1\0\7\30\1\0"+
    "\2\30\1\0\5\30\3\0\1\30\36\0\2\30\1\0\3\30\4\0"+
    "\12\10\1\0\1\30\20\0\1\30\1\30\1\0\6\30\3\0\3\30"+
    "\1\0\4\30\3\0\2\30\1\0\1\30\1\0\2\30\3\0\2\30"+
    "\3\0\3\30\3\0\14\30\4\0\5\30\3\0\3\30\1\0\4\30"+
    "\2\0\1\30\25\0\12\10\21\0\3\30\1\0\10\30\1\0\3\30"+
    "\1\0\27\30\1\0\20\30\3\0\1\30\31\30\1\0\2\30\6\0"+
    "\2\30\4\0\12\10\25\0\10\30\1\0\3\30\1\0\27\30\1\0"+
    "\12\30\1\0\5\30\3\0\1\30\40\0\1\30\1\0\2\30\4\0"+
    "\12\10\1\0\2\30\22\0\10\30\1\0\3\30\1\0\51\30\2\0"+
    "\1\30\7\30\1\0\3\30\5\0\1\30\21\0\2\30\4\0\12\10"+
    "\12\0\6\30\5\0\22\30\3\0\30\30\1\0\11\30\1\0\1\30"+
    "\2\0\7\30\37\0\12\10\21\0\57\30\1\30\1\30\2\30\7\30"+
    "\5\0\7\30\10\30\1\0\12\10\47\0\2\30\1\0\1\30\2\0"+
    "\2\30\1\0\1\30\2\0\1\30\6\0\4\30\1\0\7\30\1\0"+
    "\3\30\1\0\1\30\1\0\1\30\2\0\2\30\1\0\4\30\1\30"+
    "\2\30\11\30\1\30\2\0\5\30\1\0\1\30\1\0\6\30\2\0"+
    "\12\10\2\0\4\30\40\0\1\30\37\0\12\10\26\0\10\30\1\0"+
    "\44\30\33\0\5\30\163\0\53\30\24\0\1\30\12\10\6\0\6\30"+
    "\4\0\4\30\3\0\1\30\3\0\2\30\7\0\3\30\4\0\15\30"+
    "\14\0\1\30\1\0\12\10\6\0\46\30\1\0\1\30\5\0\1\30"+
    "\2\0\53\30\1\0\u014d\30\1\0\4\30\2\0\7\30\1\0\1\30"+
    "\1\0\4\30\2\0\51\30\1\0\4\30\2\0\41\30\1\0\4\30"+
    "\2\0\7\30\1\0\1\30\1\0\4\30\2\0\17\30\1\0\71\30"+
    "\1\0\4\30\2\0\103\30\45\0\20\30\20\0\125\30\14\0\u026c\30"+
    "\2\0\21\30\1\0\32\30\5\0\113\30\6\0\10\30\7\0\15\30"+
    "\1\0\4\30\16\0\22\30\16\0\22\30\16\0\15\30\1\0\3\30"+
    "\17\0\64\30\43\0\1\30\4\0\1\30\3\0\12\10\46\0\12\10"+
    "\6\0\130\30\10\0\51\30\1\0\1\30\5\0\106\30\12\0\37\30"+
    "\47\0\12\10\36\30\2\0\5\30\13\0\54\30\25\0\7\30\10\0"+
    "\12\10\46\0\27\30\11\0\65\30\53\0\12\10\6\0\12\10\15\0"+
    "\1\30\135\0\57\30\21\0\7\30\4\0\12\10\51\0\36\30\15\0"+
    "\2\30\12\10\54\30\32\0\44\30\34\0\12\10\3\0\3\30\12\10"+
    "\44\30\153\0\4\30\1\0\4\30\3\0\2\30\11\0\300\30\100\0"+
    "\u0116\30\2\0\6\30\2\0\46\30\2\0\6\30\2\0\10\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\0\37\30\2\0\65\30\1\0"+
    "\7\30\1\0\1\30\3\0\3\30\1\0\7\30\3\0\4\30\2\0"+
    "\6\30\4\0\15\30\5\0\3\30\1\0\7\30\3\0\13\5\5\0"+
    "\30\7\1\3\1\3\5\0\1\5\57\7\22\0\1\30\15\0\1\30"+
    "\20\0\15\30\3\0\26\7\114\0\1\30\4\0\1\30\2\0\12\30"+
    "\1\0\1\30\3\0\5\30\6\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\0\4\30\1\0\13\30\2\0\4\30\5\0\5\30\4\0\1\30"+
    "\64\0\2\30\u0a7b\0\57\30\1\0\57\30\1\0\205\30\6\0\4\30"+
    "\3\0\2\30\14\0\46\30\1\0\1\30\5\0\1\30\2\0\70\30"+
    "\7\0\1\30\20\0\27\30\11\0\7\30\1\0\7\30\1\0\7\30"+
    "\1\0\7\30\1\0\7\30\1\0\7\30\1\0\7\30\1\0\7\30"+
    "\117\0\1\7\1\30\u01d0\0\1\5\4\0\2\30\52\0\5\30\5\0"+
    "\2\30\4\0\126\30\6\0\3\30\1\0\132\30\1\0\4\30\5\0"+
    "\51\30\3\0\136\30\21\0\33\30\65\0\20\30\u0200\0\u19b6\30\112\0"+
    "\u51cd\30\63\0\u048d\30\103\0\56\30\2\0\u010d\30\3\0\20\30\12\10"+
    "\2\30\24\0\57\30\20\0\37\30\2\0\106\30\61\0\11\30\2\0"+
    "\147\30\2\0\4\30\1\0\36\30\2\0\2\30\105\0\13\30\1\0"+
    "\3\30\1\0\4\30\1\0\27\30\35\0\64\30\16\0\62\30\34\0"+
    "\12\10\30\0\6\30\3\0\1\30\4\0\12\10\34\30\12\0\27\30"+
    "\31\0\35\30\7\0\57\30\34\0\1\30\12\10\6\0\5\30\1\0"+
    "\12\30\12\10\5\30\1\0\51\30\27\0\3\30\1\0\10\30\4\0"+
    "\12\10\6\0\27\30\3\0\1\30\3\0\62\30\1\0\1\30\3\0"+
    "\2\30\2\0\5\30\2\0\1\30\1\0\1\30\30\0\3\30\2\0"+
    "\13\30\7\0\3\30\14\0\6\30\2\0\6\30\2\0\6\30\11\0"+
    "\7\30\1\0\7\30\1\0\53\30\1\0\4\30\4\0\2\30\132\0"+
    "\43\30\15\0\12\10\6\0\u2ba4\30\14\0\27\30\4\0\61\30\u2104\0"+
    "\u016e\30\2\0\152\30\46\0\7\30\14\0\5\30\5\0\1\30\1\0"+
    "\12\30\1\0\15\30\1\0\5\30\1\0\1\30\1\0\2\30\1\0"+
    "\2\30\1\0\154\30\41\0\u016b\30\22\0\100\30\2\0\66\30\50\0"+
    "\14\30\164\0\5\30\1\0\207\30\23\0\12\10\7\0\32\30\6\0"+
    "\32\30\13\0\131\30\3\0\6\30\2\0\6\30\2\0\6\30\2\0"+
    "\3\30\43\0\14\30\1\0\32\30\1\0\23\30\1\0\2\30\1\0"+
    "\17\30\2\0\16\30\42\0\173\30\u0185\0\35\30\3\0\61\30\57\0"+
    "\40\30\20\0\21\30\1\0\10\30\6\0\46\30\12\0\36\30\2\0"+
    "\44\30\4\0\10\30\60\0\236\30\2\0\12\10\126\0\50\30\10\0"+
    "\64\30\234\0\u0137\30\11\0\26\30\12\0\10\30\230\0\6\30\2\0"+
    "\1\30\1\0\54\30\1\0\2\30\3\0\1\30\2\0\27\30\12\0"+
    "\27\30\11\0\37\30\141\0\26\30\12\0\32\30\106\0\70\30\6\0"+
    "\2\30\100\0\1\30\17\0\4\30\1\0\3\30\1\0\33\30\54\0"+
    "\35\30\3\0\35\30\43\0\10\30\1\0\34\30\33\0\66\30\12\0"+
    "\26\30\12\0\23\30\15\0\22\30\156\0\111\30\u03ba\0\65\30\56\0"+
    "\12\10\23\0\55\30\40\0\31\30\7\0\12\10\11\0\44\30\17\0"+
    "\12\10\20\0\43\30\3\0\1\30\14\0\60\30\16\0\4\30\13\0"+
    "\12\10\1\30\45\0\22\30\1\0\31\30\204\0\57\30\21\0\12\10"+
    "\13\0\10\30\2\0\2\30\2\0\26\30\1\0\7\30\1\0\2\30"+
    "\1\0\5\30\3\0\1\30\37\0\5\30\u011e\0\60\30\24\0\2\30"+
    "\1\0\1\30\10\0\12\10\246\0\57\30\121\0\60\30\24\0\1\30"+
    "\13\0\12\10\46\0\53\30\25\0\12\10\u01d6\0\100\30\12\10\25\0"+
    "\1\30\u01c0\0\71\30\u0507\0\u0399\30\u0c67\0\u042f\30\u33d1\0\u0239\30\7\0"+
    "\37\30\1\0\12\10\146\0\36\30\22\0\60\30\20\0\4\30\14\0"+
    "\12\10\11\0\25\30\5\0\23\30\u0370\0\105\30\13\0\1\30\102\0"+
    "\15\30\u4060\0\2\30\u0bfe\0\153\30\5\0\15\30\3\0\11\30\7\0"+
    "\12\30\u1766\0\125\30\1\0\107\30\1\0\2\30\2\0\1\30\2\0"+
    "\2\30\2\0\4\30\1\0\14\30\1\0\1\30\1\0\7\30\1\0"+
    "\101\30\1\0\4\30\2\0\10\30\1\0\7\30\1\0\34\30\1\0"+
    "\4\30\1\0\5\30\1\0\1\30\3\0\7\30\1\0\u0154\30\2\0"+
    "\31\30\1\0\31\30\1\0\37\30\1\0\31\30\1\0\37\30\1\0"+
    "\31\30\1\0\37\30\1\0\31\30\1\0\37\30\1\0\31\30\1\0"+
    "\10\30\2\0\62\10\u1000\0\305\30\u053b\0\4\30\1\0\33\30\1\0"+
    "\2\30\1\0\1\30\2\0\1\30\1\0\12\30\1\0\4\30\1\0"+
    "\1\30\1\0\1\30\6\0\1\30\4\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\1\0\2\30\1\0\1\30\2\0\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\0\1\30\1\0\2\30\1\0"+
    "\1\30\2\0\4\30\1\0\7\30\1\0\4\30\1\0\4\30\1\0"+
    "\1\30\1\0\12\30\1\0\21\30\5\0\3\30\1\0\5\30\1\0"+
    "\21\30\u1144\0\ua6d7\30\51\0\u1035\30\13\0\336\30\u3fe2\0\u021e\30\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05f0\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\3\2\1\3\10\4\1\5\3\4\2\5"+
    "\2\4\1\3\5\4\6\0\3\4\2\0\1\4\1\0"+
    "\1\5\1\4\1\0\1\4\2\5\3\4\2\0\1\5"+
    "\4\4\1\0\1\5\10\0\1\6\2\4\13\0\5\4"+
    "\23\0\2\4\2\0\4\4\2\0\1\4\1\5\1\0"+
    "\1\4\1\5\10\0\1\4\1\7\11\0\1\4\1\10"+
    "\1\0\1\4\2\0\4\4\1\0\6\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[156];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\106\0\214\0\322\0\106\0\u0118\0\u015e\0\u01a4"+
    "\0\u01ea\0\106\0\u0230\0\u0276\0\322\0\u02bc\0\u0302\0\u0348"+
    "\0\u038e\0\u03d4\0\u041a\0\u0460\0\u04a6\0\u04ec\0\u0532\0\u0578"+
    "\0\u05be\0\u0604\0\u064a\0\u0690\0\106\0\u06d6\0\u071c\0\u0762"+
    "\0\u07a8\0\u07ee\0\u0834\0\u087a\0\u08c0\0\u0906\0\u094c\0\u0992"+
    "\0\u09d8\0\u0a1e\0\u0a64\0\u0aaa\0\u0af0\0\u0b36\0\u0b7c\0\u0bc2"+
    "\0\u0c08\0\u0c4e\0\u0c94\0\u0cda\0\u0d20\0\u0d66\0\u0dac\0\u0df2"+
    "\0\u0e38\0\u0e7e\0\u0ec4\0\u0f0a\0\u0f50\0\u0f96\0\u0fdc\0\u1022"+
    "\0\u1068\0\u10ae\0\u10f4\0\u071c\0\u07a8\0\u07ee\0\u113a\0\u1180"+
    "\0\u11c6\0\u120c\0\u1252\0\u1298\0\u12de\0\u1324\0\u136a\0\u13b0"+
    "\0\u13f6\0\u143c\0\u1482\0\u14c8\0\u150e\0\u0e7e\0\u1554\0\u159a"+
    "\0\u15e0\0\u1626\0\u166c\0\u16b2\0\u16f8\0\u173e\0\u1784\0\u17ca"+
    "\0\u1810\0\u1856\0\u189c\0\u18e2\0\u1928\0\u196e\0\u19b4\0\u19fa"+
    "\0\u1a40\0\u1a86\0\u1acc\0\u1b12\0\u1b58\0\u1b9e\0\u1be4\0\u1c2a"+
    "\0\u1c70\0\u1cb6\0\u1cfc\0\u1d42\0\u1d88\0\u1dce\0\u1e14\0\u1e5a"+
    "\0\u1ea0\0\u1ee6\0\u1f2c\0\u1f72\0\u1fb8\0\u1ffe\0\u2044\0\u208a"+
    "\0\u20d0\0\u2116\0\u1c70\0\u215c\0\u21a2\0\u21e8\0\u222e\0\u2274"+
    "\0\u22ba\0\u2300\0\u2346\0\u238c\0\322\0\u23d2\0\u2418\0\u245e"+
    "\0\u24a4\0\u2346\0\u136a\0\u24ea\0\u2530\0\u2576\0\u25bc\0\u2602"+
    "\0\u2648\0\u268e\0\u26d4\0\u271a";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[156];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\4\1\6\1\7\1\10"+
    "\1\11\1\12\1\10\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\17\1\23\1\13\1\10"+
    "\1\24\1\25\1\23\1\26\3\14\1\24\2\13\1\27"+
    "\2\13\1\30\1\13\1\31\1\32\1\33\3\32\1\34"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\6\1\13\1\14\1\32\1\14\1\32"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\1\0"+
    "\1\35\2\0\1\35\3\0\3\35\1\0\11\35\5\0"+
    "\1\35\10\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\3\0\1\4\211\0\1\35\2\0\1\35\1\0"+
    "\1\6\1\36\4\35\1\0\1\35\2\0\1\35\3\0"+
    "\3\35\1\0\11\35\2\0\1\27\2\0\1\35\10\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\6\1\0\1\35\1\0\1\35\7\0"+
    "\1\37\77\0\1\35\2\0\1\35\1\0\1\35\1\36"+
    "\1\10\2\35\1\10\1\13\1\35\2\0\1\35\3\13"+
    "\3\35\1\13\1\10\1\35\1\10\6\35\2\13\1\0"+
    "\2\13\1\35\1\13\7\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\13"+
    "\1\35\1\0\1\35\1\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\40\1\35\1\11\2\41\1\42\1\43\1\42"+
    "\1\0\1\35\2\42\1\0\3\35\1\0\1\41\3\35"+
    "\4\43\1\35\1\0\1\42\3\0\1\43\1\0\1\44"+
    "\6\45\1\43\1\45\1\43\1\45\1\43\1\45\1\43"+
    "\1\45\1\43\1\45\1\43\1\45\1\43\1\45\1\43"+
    "\1\45\1\43\1\45\1\35\1\0\1\43\1\45\1\43"+
    "\1\45\7\0\1\13\2\0\2\13\4\0\3\13\3\0"+
    "\2\13\1\0\1\13\6\0\2\13\1\0\2\13\1\0"+
    "\1\13\32\0\1\13\4\0\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\1\46\1\50\2\46\1\51\1\14\2\51"+
    "\1\46\3\51\1\52\1\46\1\52\1\51\1\46\3\52"+
    "\4\14\1\52\2\51\2\0\1\51\1\14\1\51\1\53"+
    "\6\32\1\14\1\32\1\14\1\32\1\14\1\32\1\14"+
    "\1\32\1\14\1\32\1\14\1\32\1\14\1\32\1\14"+
    "\1\32\1\14\1\32\1\35\1\54\1\14\1\32\1\14"+
    "\1\32\16\0\1\16\67\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\1\35\1\55\2\35\1\0\1\35\2\0"+
    "\1\17\1\56\1\57\1\0\3\17\1\0\1\17\2\35"+
    "\1\17\5\35\5\0\1\35\1\0\1\60\6\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\10\0\1\13"+
    "\1\60\1\0\2\13\3\0\1\56\1\20\1\61\1\13"+
    "\3\56\1\13\1\20\1\0\1\13\1\56\5\0\2\13"+
    "\1\0\2\13\1\0\1\13\1\60\31\0\1\13\13\0"+
    "\1\13\2\0\2\13\3\0\1\56\1\20\1\62\1\22"+
    "\3\56\2\13\1\0\1\13\1\56\5\0\2\13\1\0"+
    "\2\13\1\0\1\13\21\0\2\63\7\0\1\13\2\63"+
    "\11\0\1\13\2\0\2\13\4\0\3\13\1\64\2\0"+
    "\2\13\1\0\1\13\6\0\2\13\1\0\2\13\1\0"+
    "\1\13\32\0\1\13\4\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\1\35\1\55\2\35\1\0\1\24\2\0"+
    "\1\17\1\56\1\57\1\0\1\23\1\17\1\23\1\0"+
    "\1\17\2\24\1\23\5\24\5\0\1\24\1\0\1\60"+
    "\6\65\1\24\1\65\1\24\1\65\1\24\1\65\1\24"+
    "\1\65\1\24\1\65\1\24\1\65\1\24\1\65\1\24"+
    "\1\65\1\24\1\65\1\35\1\0\1\24\1\65\1\24"+
    "\1\65\1\35\2\0\1\35\1\0\1\35\1\36\4\35"+
    "\1\0\1\24\2\0\1\35\3\0\1\24\1\35\1\24"+
    "\1\0\1\35\10\24\5\0\1\24\2\0\6\65\1\24"+
    "\1\65\1\24\1\65\1\24\1\65\1\24\1\65\1\24"+
    "\1\65\1\24\1\65\1\24\1\65\1\24\1\65\1\24"+
    "\1\65\1\35\1\0\1\24\1\65\1\24\1\65\1\35"+
    "\2\0\1\35\1\0\1\35\1\36\1\10\2\35\1\10"+
    "\1\13\1\24\2\0\1\35\3\13\1\24\1\35\1\24"+
    "\1\13\1\10\1\24\1\25\6\24\2\13\1\0\2\13"+
    "\1\24\1\13\1\0\6\65\1\24\1\65\1\24\1\65"+
    "\1\24\1\65\1\24\1\65\1\24\1\65\1\24\1\65"+
    "\1\24\1\65\1\24\1\65\1\24\1\65\1\35\1\13"+
    "\1\24\1\65\1\24\1\65\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\1\46\1\50\2\46\1\51\1\14\2\51"+
    "\1\46\3\51\1\52\1\46\1\52\1\51\1\46\3\52"+
    "\1\14\1\66\2\14\1\52\2\51\2\0\1\51\1\14"+
    "\1\51\1\53\2\32\1\67\3\32\1\14\1\32\1\14"+
    "\1\32\1\14\1\32\1\14\1\32\1\14\1\32\1\14"+
    "\1\32\1\14\1\32\1\14\1\32\1\14\1\32\1\35"+
    "\1\54\1\14\1\32\1\14\1\32\5\0\1\27\34\0"+
    "\1\27\35\0\1\27\5\0\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\1\46\1\50\2\46\1\51\1\14\2\51"+
    "\1\46\3\51\1\52\1\46\1\52\1\51\1\46\3\52"+
    "\4\14\1\52\2\51\2\0\1\51\1\70\1\51\1\53"+
    "\5\32\1\71\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\35\1\54\1\14\1\32"+
    "\1\14\1\32\1\51\2\0\1\51\1\0\1\51\1\72"+
    "\1\51\1\31\3\72\1\53\1\72\2\51\2\72\5\51"+
    "\1\72\3\51\4\53\2\51\1\72\2\0\1\51\1\53"+
    "\1\51\1\31\30\53\1\0\1\54\4\53\1\51\2\0"+
    "\1\51\1\0\3\51\1\53\3\51\1\32\6\51\1\73"+
    "\1\51\1\73\2\51\3\73\4\32\1\73\2\51\2\0"+
    "\1\51\1\32\1\51\1\53\30\32\1\0\1\54\4\32"+
    "\1\51\2\0\1\51\1\0\3\51\1\53\3\51\1\32"+
    "\6\51\1\73\1\51\1\73\2\51\3\73\1\32\1\67"+
    "\2\32\1\73\2\51\2\0\1\51\1\32\1\51\1\53"+
    "\2\32\1\67\25\32\1\0\1\54\4\32\1\51\2\0"+
    "\1\51\1\0\3\51\1\53\3\51\1\32\6\51\1\73"+
    "\1\51\1\73\2\51\3\73\4\32\1\73\2\51\2\0"+
    "\1\51\1\71\1\51\1\53\5\32\1\71\22\32\1\0"+
    "\1\54\4\32\1\35\2\0\1\35\1\0\1\35\1\0"+
    "\4\35\1\0\1\35\2\0\1\35\3\0\3\35\1\0"+
    "\11\35\5\0\1\35\10\0\1\74\1\75\1\76\1\77"+
    "\1\35\1\0\1\100\1\101\1\102\1\103\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\7\0\1\104\77\0\1\35\2\0"+
    "\1\35\1\0\1\35\1\42\1\35\1\105\2\41\1\42"+
    "\1\35\1\42\1\0\1\35\2\42\1\0\3\35\1\0"+
    "\1\41\10\35\1\0\1\42\3\0\1\35\1\0\1\106"+
    "\6\0\1\74\1\75\1\76\1\77\1\35\1\0\1\100"+
    "\1\101\1\102\1\103\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\2\0\1\35\1\0\1\35\1\40\1\35"+
    "\1\105\2\41\1\42\1\35\1\42\1\0\1\35\2\42"+
    "\1\0\3\35\1\0\1\41\10\35\1\0\1\42\3\0"+
    "\1\35\1\0\1\106\6\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\7\0\1\42\1\0\1\106\3\42"+
    "\1\0\1\42\2\0\2\42\5\0\1\42\11\0\1\42"+
    "\5\0\1\106\36\0\1\35\2\0\1\35\1\0\1\35"+
    "\1\36\1\35\1\43\2\35\1\0\1\43\2\0\1\35"+
    "\3\0\3\35\1\0\4\35\4\43\1\35\5\0\1\43"+
    "\1\0\7\45\1\43\1\45\1\43\1\45\1\43\1\45"+
    "\1\43\1\45\1\43\1\45\1\43\1\45\1\43\1\45"+
    "\1\43\1\45\1\43\1\45\1\35\1\0\1\43\1\45"+
    "\1\43\1\45\6\0\1\42\1\0\1\44\3\42\1\45"+
    "\1\42\2\0\2\42\5\0\1\42\3\0\4\45\2\0"+
    "\1\42\3\0\1\45\1\0\1\44\30\45\2\0\4\45"+
    "\10\0\1\45\3\0\1\45\16\0\4\45\6\0\1\45"+
    "\1\0\31\45\2\0\4\45\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\4\46\1\51\1\46\2\51\1\46\3\51"+
    "\3\46\1\51\11\46\2\51\2\0\1\51\1\46\10\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\35\1\54\1\46\1\51\1\46\1\51"+
    "\1\46\2\0\1\46\1\0\1\46\1\51\4\46\1\51"+
    "\1\46\2\51\1\46\3\51\3\46\1\51\11\46\2\51"+
    "\2\0\1\51\1\46\10\51\1\107\1\110\1\111\1\112"+
    "\1\46\1\51\1\113\1\114\1\115\1\116\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\35\1\54"+
    "\1\46\1\51\1\46\1\51\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\1\46\1\50\2\46\1\51\1\50\2\51"+
    "\1\46\3\51\3\46\1\51\4\46\4\50\1\46\2\51"+
    "\2\0\1\51\1\50\1\51\7\53\1\50\1\53\1\50"+
    "\1\53\1\50\1\53\1\50\1\53\1\50\1\53\1\50"+
    "\1\53\1\50\1\53\1\50\1\53\1\50\1\53\1\35"+
    "\1\54\1\50\1\53\1\50\1\53\1\51\2\0\1\51"+
    "\1\0\35\51\2\0\34\51\1\0\1\54\4\51\1\46"+
    "\2\0\1\46\1\0\1\46\1\47\4\46\1\51\1\52"+
    "\2\51\1\46\3\51\1\52\1\46\1\52\1\51\1\46"+
    "\10\52\2\51\2\0\1\51\1\52\2\51\6\73\1\52"+
    "\1\73\1\52\1\73\1\52\1\73\1\52\1\73\1\52"+
    "\1\73\1\52\1\73\1\52\1\73\1\52\1\73\1\52"+
    "\1\73\1\35\1\54\1\52\1\73\1\52\1\73\1\51"+
    "\2\0\1\51\1\0\3\51\1\53\3\51\1\53\16\51"+
    "\4\53\3\51\2\0\1\51\1\53\1\51\31\53\1\0"+
    "\1\54\4\53\1\117\2\0\1\117\1\0\1\117\1\51"+
    "\33\117\2\0\34\117\1\0\5\117\1\35\2\0\1\35"+
    "\1\0\1\35\1\36\1\35\1\55\2\35\1\0\1\35"+
    "\2\0\1\35\3\0\3\35\1\0\11\35\5\0\1\35"+
    "\1\0\1\60\6\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\11\0\1\60\6\0\2\56\1\57\1\0"+
    "\3\56\1\0\1\56\2\0\1\56\14\0\1\60\46\0"+
    "\1\60\10\0\1\57\25\0\1\60\46\0\1\60\36\0"+
    "\1\60\45\0\1\13\1\60\1\0\2\13\4\0\1\13"+
    "\1\61\1\13\3\0\2\13\1\0\1\13\6\0\2\13"+
    "\1\0\2\13\1\0\1\13\1\60\31\0\1\13\13\0"+
    "\1\13\2\0\2\13\3\0\1\56\1\20\1\62\1\22"+
    "\3\56\2\13\1\0\1\13\1\56\5\0\2\13\1\0"+
    "\2\13\1\0\1\13\32\0\1\13\74\0\2\120\40\0"+
    "\1\121\75\0\1\65\6\0\1\65\1\0\1\65\2\0"+
    "\10\65\5\0\1\65\2\0\30\65\2\0\4\65\1\46"+
    "\2\0\1\46\1\0\1\46\1\47\1\46\1\50\2\46"+
    "\1\51\1\14\2\51\1\46\3\51\1\52\1\46\1\52"+
    "\1\51\1\46\3\52\1\14\1\122\2\14\1\52\2\51"+
    "\2\0\1\51\1\14\1\51\1\53\2\32\1\123\3\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\35\1\54\1\14\1\32\1\14\1\32"+
    "\1\51\2\0\1\51\1\0\3\51\1\53\3\51\1\32"+
    "\6\51\1\73\1\51\1\73\2\51\3\73\1\32\1\123"+
    "\2\32\1\73\2\51\2\0\1\51\1\32\1\51\1\53"+
    "\2\32\1\123\25\32\1\0\1\54\4\32\1\46\2\0"+
    "\1\46\1\0\1\46\1\47\1\46\1\50\2\46\1\51"+
    "\1\14\2\51\1\46\3\51\1\52\1\46\1\52\1\51"+
    "\1\46\3\52\4\14\1\52\2\51\2\0\1\51\1\124"+
    "\1\51\1\53\5\32\1\125\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\35\1\54"+
    "\1\14\1\32\1\14\1\32\1\51\2\0\1\51\1\0"+
    "\3\51\1\53\3\51\1\32\6\51\1\73\1\51\1\73"+
    "\2\51\3\73\4\32\1\73\2\51\2\0\1\51\1\125"+
    "\1\51\1\53\5\32\1\125\22\32\1\0\1\54\4\32"+
    "\1\51\2\0\1\51\1\0\1\51\1\72\1\51\1\126"+
    "\3\72\1\51\1\72\2\51\2\72\5\51\1\72\11\51"+
    "\1\72\2\0\3\51\1\126\30\51\1\0\1\54\5\51"+
    "\2\0\1\51\1\0\7\51\1\73\6\51\1\73\1\51"+
    "\1\73\2\51\10\73\2\51\2\0\1\51\1\73\2\51"+
    "\30\73\1\0\1\54\4\73\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\4\35\1\0\1\35\2\0\1\35\3\0"+
    "\3\35\1\0\11\35\5\0\1\35\10\0\1\35\1\0"+
    "\1\127\1\130\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\61\0\2\130\24\0"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\1\0"+
    "\1\35\2\0\1\35\3\0\3\35\1\0\11\35\5\0"+
    "\1\35\10\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\131\1\132\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\71\0\2\132\14\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\4\35\1\0\1\35\2\0\1\35\3\0"+
    "\3\35\1\0\11\35\5\0\1\35\10\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\133\1\134"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\67\0\2\134\16\0"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\1\0"+
    "\1\35\2\0\1\35\3\0\3\35\1\0\11\35\5\0"+
    "\1\35\10\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\135\1\136\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\75\0\2\136\10\0\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\4\46\1\51\1\46\2\51\1\46\3\51"+
    "\3\46\1\51\11\46\2\51\2\0\1\51\1\46\10\51"+
    "\1\46\1\51\1\137\1\140\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\35\1\54\1\46\1\51\1\46\2\51"+
    "\2\0\1\51\1\0\35\51\2\0\14\51\2\140\16\51"+
    "\1\0\1\54\4\51\1\46\2\0\1\46\1\0\1\46"+
    "\1\47\4\46\1\51\1\46\2\51\1\46\3\51\3\46"+
    "\1\51\11\46\2\51\2\0\1\51\1\46\10\51\1\46"+
    "\1\51\1\46\1\51\1\46\1\51\1\46\1\51\1\46"+
    "\1\51\1\141\1\142\1\46\1\51\1\46\1\51\1\46"+
    "\1\51\1\35\1\54\1\46\1\51\1\46\2\51\2\0"+
    "\1\51\1\0\35\51\2\0\24\51\2\142\6\51\1\0"+
    "\1\54\4\51\1\46\2\0\1\46\1\0\1\46\1\47"+
    "\4\46\1\51\1\46\2\51\1\46\3\51\3\46\1\51"+
    "\11\46\2\51\2\0\1\51\1\46\10\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\143\1\144"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\35\1\54\1\46\1\51\1\46\2\51\2\0\1\51"+
    "\1\0\35\51\2\0\22\51\2\144\10\51\1\0\1\54"+
    "\4\51\1\46\2\0\1\46\1\0\1\46\1\47\4\46"+
    "\1\51\1\46\2\51\1\46\3\51\3\46\1\51\11\46"+
    "\2\51\2\0\1\51\1\46\10\51\1\46\1\51\1\46"+
    "\1\51\1\46\1\51\1\46\1\51\1\46\1\51\1\46"+
    "\1\51\1\46\1\51\1\145\1\146\1\46\1\51\1\35"+
    "\1\54\1\46\1\51\1\46\2\51\2\0\1\51\1\0"+
    "\35\51\2\0\30\51\2\146\2\51\1\0\1\54\4\51"+
    "\1\117\2\0\1\117\1\0\1\117\1\147\33\117\2\0"+
    "\34\117\1\0\5\117\104\0\2\150\25\0\1\151\60\0"+
    "\1\46\2\0\1\46\1\0\1\46\1\47\1\46\1\50"+
    "\2\46\1\51\1\14\2\51\1\46\3\51\1\52\1\46"+
    "\1\52\1\51\1\46\3\52\2\14\1\152\1\14\1\52"+
    "\2\51\2\0\1\51\1\14\1\51\1\53\3\32\1\153"+
    "\2\32\1\14\1\32\1\14\1\32\1\14\1\32\1\14"+
    "\1\32\1\14\1\32\1\14\1\32\1\14\1\32\1\14"+
    "\1\32\1\14\1\32\1\35\1\54\1\14\1\32\1\14"+
    "\1\32\1\51\2\0\1\51\1\0\3\51\1\53\3\51"+
    "\1\32\6\51\1\73\1\51\1\73\2\51\3\73\2\32"+
    "\1\153\1\32\1\73\2\51\2\0\1\51\1\32\1\51"+
    "\1\53\3\32\1\153\24\32\1\0\1\54\4\32\1\46"+
    "\2\0\1\46\1\0\1\46\1\154\1\46\1\50\2\46"+
    "\1\51\1\14\2\51\1\46\3\51\1\52\1\46\1\52"+
    "\1\51\1\46\3\52\4\14\1\52\2\51\2\0\1\51"+
    "\1\14\1\51\1\53\6\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\35\1\54"+
    "\1\14\1\32\1\14\1\32\1\51\2\0\1\51\1\0"+
    "\1\51\1\155\1\51\1\53\3\51\1\32\6\51\1\73"+
    "\1\51\1\73\2\51\3\73\4\32\1\73\2\51\2\0"+
    "\1\51\1\32\1\51\1\53\30\32\1\0\1\54\4\32"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\1\0"+
    "\1\35\2\0\1\35\3\0\3\35\1\0\11\35\5\0"+
    "\1\35\10\0\1\35\1\0\1\35\1\0\1\156\1\157"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\63\0\2\157\22\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\4\35\1\0\1\35\2\0\1\35\3\0"+
    "\3\35\1\0\11\35\5\0\1\35\10\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\156\1\157\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\73\0\2\157\12\0"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\1\0"+
    "\1\35\2\0\1\35\3\0\3\35\1\0\5\35\1\156"+
    "\3\35\5\0\1\35\4\0\1\157\3\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\35\0\1\157\15\0"+
    "\1\157\33\0\1\35\2\0\1\35\1\0\1\35\1\36"+
    "\4\35\1\0\1\35\2\0\1\35\3\0\3\35\1\0"+
    "\11\35\5\0\1\35\10\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\156\1\157\1\35\1\0"+
    "\1\35\1\0\1\35\77\0\2\157\6\0\1\46\2\0"+
    "\1\46\1\0\1\46\1\47\4\46\1\51\1\46\2\51"+
    "\1\46\3\51\3\46\1\51\11\46\2\51\2\0\1\51"+
    "\1\46\10\51\1\46\1\51\1\46\1\51\1\160\1\161"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\35\1\54\1\46\1\51"+
    "\1\46\2\51\2\0\1\51\1\0\35\51\2\0\16\51"+
    "\2\161\14\51\1\0\1\54\4\51\1\46\2\0\1\46"+
    "\1\0\1\46\1\47\4\46\1\51\1\46\2\51\1\46"+
    "\3\51\3\46\1\51\11\46\2\51\2\0\1\51\1\46"+
    "\10\51\1\46\1\51\1\46\1\51\1\46\1\51\1\46"+
    "\1\51\1\46\1\51\1\46\1\51\1\160\1\161\1\46"+
    "\1\51\1\46\1\51\1\35\1\54\1\46\1\51\1\46"+
    "\2\51\2\0\1\51\1\0\35\51\2\0\26\51\2\161"+
    "\4\51\1\0\1\54\4\51\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\4\46\1\51\1\46\2\51\1\46\3\51"+
    "\3\46\1\51\5\46\1\160\3\46\2\51\2\0\1\51"+
    "\1\46\4\51\1\161\3\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\35\1\54"+
    "\1\46\1\51\1\46\2\51\2\0\1\51\1\0\27\51"+
    "\1\161\5\51\2\0\6\51\1\161\25\51\1\0\1\54"+
    "\4\51\1\46\2\0\1\46\1\0\1\46\1\47\4\46"+
    "\1\51\1\46\2\51\1\46\3\51\3\46\1\51\11\46"+
    "\2\51\2\0\1\51\1\46\10\51\1\46\1\51\1\46"+
    "\1\51\1\46\1\51\1\46\1\51\1\46\1\51\1\46"+
    "\1\51\1\46\1\51\1\46\1\51\1\160\1\161\1\35"+
    "\1\54\1\46\1\51\1\46\2\51\2\0\1\51\1\0"+
    "\35\51\2\0\32\51\2\161\1\0\1\54\4\51\1\117"+
    "\2\0\1\117\1\0\1\117\1\51\5\117\1\162\16\117"+
    "\4\162\3\117\2\0\1\117\1\162\2\117\30\162\1\0"+
    "\1\117\4\162\21\0\1\15\111\0\1\163\60\0\1\46"+
    "\2\0\1\46\1\0\1\46\1\47\1\46\1\50\2\46"+
    "\1\51\1\14\2\51\1\46\3\51\1\52\1\46\1\52"+
    "\1\51\1\46\3\52\3\14\1\164\1\165\1\166\1\51"+
    "\2\0\1\51\1\14\1\51\1\53\4\32\1\167\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\35\1\54\1\14\1\32\1\14\1\32"+
    "\1\51\2\0\1\51\1\0\3\51\1\53\3\51\1\32"+
    "\6\51\1\73\1\51\1\73\2\51\3\73\3\32\1\167"+
    "\1\170\1\166\1\51\2\0\1\51\1\32\1\51\1\53"+
    "\4\32\1\167\23\32\1\0\1\54\4\32\1\171\2\0"+
    "\1\171\1\0\1\171\1\51\6\171\2\51\23\171\2\0"+
    "\1\51\11\171\2\172\2\173\2\171\2\174\2\175\10\171"+
    "\1\176\1\177\5\171\2\0\1\171\1\0\1\171\1\51"+
    "\6\171\2\51\23\171\2\0\1\51\33\171\1\176\1\177"+
    "\4\171\1\35\2\0\1\35\1\0\1\35\1\36\4\35"+
    "\1\0\1\35\2\0\1\35\3\0\3\35\1\0\11\35"+
    "\1\0\1\200\3\0\1\35\10\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\42\0\1\200\44\0\1\46"+
    "\2\0\1\46\1\0\1\46\1\47\4\46\1\51\1\46"+
    "\2\51\1\46\3\51\3\46\1\51\11\46\1\51\1\200"+
    "\2\0\1\51\1\46\10\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\46\1\51"+
    "\1\46\1\51\1\46\1\51\1\46\1\51\1\35\1\54"+
    "\1\46\1\51\1\46\2\51\2\0\1\51\1\0\34\51"+
    "\1\200\2\0\34\51\1\0\1\54\4\51\1\117\2\0"+
    "\1\117\1\0\1\117\1\147\5\117\1\201\16\117\4\201"+
    "\3\117\2\0\1\117\1\201\2\117\30\201\1\0\1\117"+
    "\4\201\26\0\1\202\57\0\1\46\2\0\1\46\1\0"+
    "\1\46\1\47\1\46\1\50\2\46\1\51\1\14\2\51"+
    "\1\46\3\51\1\52\1\46\1\52\1\51\1\46\3\52"+
    "\4\14\1\52\1\166\1\51\2\0\1\51\1\14\1\51"+
    "\1\53\6\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\14\1\32\1\14\1\32"+
    "\1\14\1\32\1\14\1\32\1\35\1\54\1\14\1\32"+
    "\1\14\1\32\1\46\2\0\1\46\1\0\1\46\1\47"+
    "\4\46\1\51\1\52\2\51\1\46\3\51\1\52\1\46"+
    "\1\52\1\51\1\46\10\52\1\166\1\51\2\0\1\51"+
    "\1\52\2\51\6\73\1\52\1\73\1\52\1\73\1\52"+
    "\1\73\1\52\1\73\1\52\1\73\1\52\1\73\1\52"+
    "\1\73\1\52\1\73\1\52\1\73\1\35\1\54\1\52"+
    "\1\73\1\52\1\73\1\51\2\0\1\51\1\0\34\51"+
    "\1\203\2\0\34\51\1\0\1\54\5\51\2\0\1\51"+
    "\1\0\3\51\1\53\3\51\1\32\6\51\1\73\1\51"+
    "\1\73\2\51\3\73\4\32\1\73\1\166\1\51\2\0"+
    "\1\51\1\32\1\51\1\53\30\32\1\0\1\54\4\32"+
    "\1\51\2\0\1\51\1\0\7\51\1\73\6\51\1\73"+
    "\1\51\1\73\2\51\10\73\1\166\1\51\2\0\1\51"+
    "\1\73\2\51\30\73\1\0\1\54\4\73\1\171\2\0"+
    "\1\171\1\0\1\171\1\204\6\171\2\51\23\171\2\0"+
    "\1\51\33\171\1\176\1\177\5\171\2\0\1\171\1\0"+
    "\1\171\1\204\6\171\2\51\23\171\2\0\1\51\13\171"+
    "\2\205\16\171\1\176\1\177\5\171\2\0\1\171\1\0"+
    "\1\171\1\204\6\171\2\51\23\171\2\0\1\51\23\171"+
    "\2\206\6\171\1\176\1\177\5\171\2\0\1\171\1\0"+
    "\1\171\1\204\6\171\2\51\23\171\2\0\1\51\21\171"+
    "\2\207\10\171\1\176\1\177\5\171\2\0\1\171\1\0"+
    "\1\171\1\204\6\171\2\51\23\171\2\0\1\51\27\171"+
    "\2\210\2\171\1\176\1\177\4\171\1\176\2\0\1\176"+
    "\1\0\1\176\1\211\6\176\2\0\23\176\3\0\41\176"+
    "\1\212\2\0\1\212\1\0\1\212\1\204\6\212\2\117"+
    "\23\212\2\0\1\117\33\212\1\176\5\212\1\213\2\0"+
    "\1\213\1\0\35\213\2\0\42\213\1\117\2\0\1\117"+
    "\1\0\1\117\1\147\5\117\1\214\16\117\4\214\3\117"+
    "\2\0\1\117\1\214\2\117\30\214\1\0\1\117\4\214"+
    "\21\0\1\215\64\0\1\171\2\0\1\171\1\0\1\171"+
    "\1\51\5\171\1\216\2\51\14\171\4\216\3\171\2\0"+
    "\1\51\1\216\2\171\30\216\1\176\1\177\4\216\1\171"+
    "\2\0\1\171\1\0\1\171\1\204\6\171\2\51\23\171"+
    "\2\0\1\51\15\171\2\217\14\171\1\176\1\177\5\171"+
    "\2\0\1\171\1\0\1\171\1\204\6\171\2\51\23\171"+
    "\2\0\1\51\25\171\2\217\4\171\1\176\1\177\5\171"+
    "\2\0\1\171\1\0\1\171\1\204\6\171\2\51\15\171"+
    "\1\217\5\171\2\0\1\51\5\171\1\217\25\171\1\176"+
    "\1\177\5\171\2\0\1\171\1\0\1\171\1\204\6\171"+
    "\2\51\23\171\2\0\1\51\31\171\2\217\1\176\1\177"+
    "\4\171\1\176\2\0\1\176\1\0\1\176\1\0\5\176"+
    "\1\220\2\0\14\176\4\220\3\176\3\0\1\220\2\176"+
    "\30\220\2\176\4\220\1\212\2\0\1\212\1\0\1\212"+
    "\1\221\6\212\2\117\23\212\2\0\1\117\33\212\1\176"+
    "\5\212\1\222\2\0\1\222\1\0\1\222\1\213\6\222"+
    "\2\213\2\222\1\213\20\222\2\0\1\213\41\222\1\117"+
    "\2\0\1\117\1\0\1\117\1\147\5\117\1\223\16\117"+
    "\4\223\3\117\2\0\1\117\1\223\2\117\30\223\1\0"+
    "\1\117\4\223\1\171\2\0\1\171\1\0\1\171\1\204"+
    "\5\171\1\224\2\51\14\171\4\224\3\171\2\0\1\51"+
    "\1\224\2\171\30\224\1\176\1\177\4\224\1\171\2\0"+
    "\1\171\1\0\1\171\1\204\6\171\2\51\22\171\1\200"+
    "\2\0\1\51\33\171\1\176\1\177\4\171\1\176\2\0"+
    "\1\176\1\0\1\176\1\211\5\176\1\225\2\0\14\176"+
    "\4\225\3\176\3\0\1\225\2\176\30\225\2\176\4\225"+
    "\1\212\2\0\1\212\1\0\1\212\1\51\5\212\1\226"+
    "\2\117\14\212\4\226\3\212\2\0\1\117\1\226\2\212"+
    "\30\226\1\176\1\212\4\226\1\171\2\0\1\171\1\0"+
    "\1\171\1\204\5\171\1\227\2\51\14\171\4\227\2\171"+
    "\1\200\2\0\1\51\1\227\2\171\30\227\1\176\1\177"+
    "\4\227\1\176\2\0\1\176\1\0\1\176\1\211\5\176"+
    "\1\230\2\0\14\176\4\230\2\176\1\200\3\0\1\230"+
    "\2\176\30\230\2\176\4\230\1\212\2\0\1\212\1\0"+
    "\1\212\1\221\5\212\1\231\2\117\14\212\4\231\3\212"+
    "\2\0\1\117\1\231\2\212\30\231\1\176\1\212\4\231"+
    "\1\171\2\0\1\171\1\0\1\171\1\204\5\171\1\217"+
    "\2\51\14\171\4\217\2\171\1\200\2\0\1\51\1\217"+
    "\2\171\30\217\1\176\1\177\4\217\1\176\2\0\1\176"+
    "\1\0\1\176\1\211\5\176\1\232\2\0\14\176\4\232"+
    "\2\176\1\200\3\0\1\232\2\176\30\232\2\176\4\232"+
    "\1\212\2\0\1\212\1\0\1\212\1\221\5\212\1\233"+
    "\2\117\14\212\4\233\2\212\1\200\2\0\1\117\1\233"+
    "\2\212\30\233\1\176\1\212\4\233\1\176\2\0\1\176"+
    "\1\0\1\176\1\211\6\176\2\0\22\176\1\200\3\0"+
    "\41\176\1\212\2\0\1\212\1\0\1\212\1\221\5\212"+
    "\1\234\2\117\14\212\4\234\2\212\1\200\2\0\1\117"+
    "\1\234\2\212\30\234\1\176\1\212\4\234\1\212\2\0"+
    "\1\212\1\0\1\212\1\221\6\212\2\117\22\212\1\200"+
    "\2\0\1\117\33\212\1\176\5\212";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10080];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\1\1\11\10\1\1\11\17\1\6\0\3\1"+
    "\2\0\1\1\1\0\2\1\1\0\6\1\2\0\5\1"+
    "\1\0\1\1\10\0\3\1\13\0\5\1\23\0\2\1"+
    "\2\0\4\1\2\0\2\1\1\0\2\1\10\0\2\1"+
    "\11\0\1\1\1\11\1\0\1\1\2\0\4\1\1\0"+
    "\6\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[156];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
 private LexedTokenFactory<?> tokenFactory;
 private boolean invertible;
 private CoreLabel prevWord;
 private StringBuilder prevWordAfter;
 
 // Convert Arabic digits to ASCII digits
 private boolean normArDigits;
 
 // Convert Arabic punctuation to ASCII equivalents
 private boolean normArPunc;
 
 // Substitute newlines with newlineChar.
 // Otherwise, treat them like whitespace
 private boolean tokenizeNLs;
 public static final String NEWLINE_TOKEN = "*NL*";

 // Use \u2026 for ellipses
 private boolean useUTF8Ellipsis;
 
 // Arabic-specific orthographic normalization rules
 private boolean normAlif;
 private boolean normYa;
 private boolean removeDiacritics;
 private boolean removeTatweel;
 private boolean removeQuranChars;
 
 // Penn ATB vocalized section normalizations
 private boolean removeProMarker;
 private boolean removeSegMarker;
 private boolean removeMorphMarker;
 
 // Lengthening effects (yAAAAAAA): replace three or more of the same character with one
 private boolean removeLengthening;

 private final Pattern segmentationMarker = Pattern.compile("^-+|-+$");
 
 // Escape parens for ATB parsing
 private boolean atbEscaping;

 private Map<String,String> normMap;
 
 public ArabicLexer(Reader r, LexedTokenFactory<?> tf, Properties props) {
   this(r);
   this.tokenFactory = tf;
   
   tokenizeNLs = PropertiesUtils.getBool(props, "tokenizeNLs", false);
   useUTF8Ellipsis = PropertiesUtils.getBool(props, "useUTF8Ellipsis", false);
   invertible = PropertiesUtils.getBool(props, "invertible", false);
   normArDigits = PropertiesUtils.getBool(props, "normArDigits", false);
   normArPunc = PropertiesUtils.getBool(props, "normArPunc", false);
   normAlif = PropertiesUtils.getBool(props, "normAlif", false);
   normYa = PropertiesUtils.getBool(props, "normYa", false);
   removeDiacritics = PropertiesUtils.getBool(props, "removeDiacritics", false);
   removeTatweel = PropertiesUtils.getBool(props, "removeTatweel", false);
   removeQuranChars = PropertiesUtils.getBool(props, "removeQuranChars", false);
   removeProMarker = PropertiesUtils.getBool(props, "removeProMarker", false);
   removeSegMarker = PropertiesUtils.getBool(props, "removeSegMarker", false);
   removeMorphMarker = PropertiesUtils.getBool(props, "removeMorphMarker", false);
   removeLengthening = PropertiesUtils.getBool(props, "removeLengthening", false);
   atbEscaping = PropertiesUtils.getBool(props, "atbEscaping", false);

   setupNormalizationMap();

   if (invertible) {
     if (!(tf instanceof CoreLabelTokenFactory)) {
       throw new IllegalArgumentException("ArabicLexer: the invertible option requires a CoreLabelTokenFactory");
     }
     prevWord = (CoreLabel) tf.makeToken("", 0, 0);
     prevWordAfter = new StringBuilder();
   }
 }

 private void setupNormalizationMap() {
   normMap = Generics.newHashMap(200);

   // Junk characters that we always remove
   normMap.put("\u0600","#");
   normMap.put("\u0601","");
   normMap.put("\u0602","");
   normMap.put("\u0603","");
   normMap.put("\u0606","\u221B");
   normMap.put("\u0607","\u221C");
   normMap.put("\u0608","");
   normMap.put("\u0609","%");
   normMap.put("\u060A","%");
   normMap.put("\u060B","");
   normMap.put("\u060E","");
   normMap.put("\u060F","");
   normMap.put("\u066E","\u0628");
   normMap.put("\u066F","\u0642");
   normMap.put("\u06CC","\u0649");
   normMap.put("\u06D6","");
   normMap.put("\u06D7","");
   normMap.put("\u06D8","");
   normMap.put("\u06D9","");
   normMap.put("\u06DA","");
   normMap.put("\u06DB","");
   normMap.put("\u06DC","");
   normMap.put("\u06DD","");
   normMap.put("\u06DE","");
   normMap.put("\u06DF","");
   normMap.put("\u06E0","");
   normMap.put("\u06E1","");
   normMap.put("\u06E2","");
   normMap.put("\u06E3","");
   normMap.put("\u06E4","");
   normMap.put("\u06E5","");
   normMap.put("\u06E6","");
   normMap.put("\u06E7","");
   normMap.put("\u06E8","");
   normMap.put("\u06E9","");
   normMap.put("\u06EA","");
   normMap.put("\u06EB","");
   normMap.put("\u06EC","");
   normMap.put("\u06ED","");

   if (normArDigits) {
      normMap.put("\u0660","0");
      normMap.put("\u0661","1");
      normMap.put("\u0662","2");
      normMap.put("\u0663","3");
      normMap.put("\u0664","4");
      normMap.put("\u0665","5");
      normMap.put("\u0666","6");
      normMap.put("\u0667","7");
      normMap.put("\u0668","8");
      normMap.put("\u0669","9");
      normMap.put("\u06F0","0");
      normMap.put("\u06F1","1");
      normMap.put("\u06F2","2");
      normMap.put("\u06F3","3");
      normMap.put("\u06F4","4");
      normMap.put("\u06F5","5");
      normMap.put("\u06F6","6");
      normMap.put("\u06F7","7");
      normMap.put("\u06F8","8");
      normMap.put("\u06F9","9");
   }
   if (normArPunc) {
      normMap.put("\u00BB","\"");
      normMap.put("\u00AB","\"");
      normMap.put("\u060C",",");
      normMap.put("\u060D",",");
      normMap.put("\u061B",";");
      normMap.put("\u061E",".");
      normMap.put("\u061F","?");
      normMap.put("\u066A","%");
      normMap.put("\u066B",",");
      normMap.put("\u066C","\u0027");
      normMap.put("\u066F","*");
      normMap.put("\u06DF",".");
   }
   if (normAlif) {
      normMap.put("\u0622","\u0627");
      normMap.put("\u0623","\u0627");
      normMap.put("\u0625","\u0627");
      normMap.put("\u0671","\u0627");
      normMap.put("\u0672","\u0627");
      normMap.put("\u0673","\u0627");
   }
   if (normYa) {
      normMap.put("\u064A","\u0649");
   }
   if (removeDiacritics) {
      normMap.put("\u064B","");
      normMap.put("\u064C","");
      normMap.put("\u064D","");
      normMap.put("\u064E","");
      normMap.put("\u064F","");
      normMap.put("\u0650","");
      normMap.put("\u0651","");
      normMap.put("\u0652","");
      normMap.put("\u0653","");
      normMap.put("\u0654","");
      normMap.put("\u0655","");
      normMap.put("\u0656","");
      normMap.put("\u0657","");
      normMap.put("\u0658","");
      normMap.put("\u0659","");
      normMap.put("\u065A","");
      normMap.put("\u065B","");
      normMap.put("\u065C","");
      normMap.put("\u065D","");
      normMap.put("\u065E","");
      normMap.put("\u0670","");
   }
   if (removeTatweel) {
      normMap.put("\u0640","");
      normMap.put("_","");
   }
   if (removeQuranChars) {
      // Arabic honorifics
      normMap.put("\u0610","");
      normMap.put("\u0611","");
      normMap.put("\u0612","");
      normMap.put("\u0613","");
      normMap.put("\u0614","");
      normMap.put("\u0615","");
      normMap.put("\u0616","");
      normMap.put("\u0617","");
      normMap.put("\u0618","");
      normMap.put("\u0619","");
      normMap.put("\u061A","");
   }
   if (atbEscaping) {
      normMap.put("(","-LRB-");
      normMap.put(")","-RRB-");
   }
 }

 private String normalizeToken(String text, boolean isWord) {
   // Remove segmentation markers from the ATB
   if (isWord && removeSegMarker) {
     text = segmentationMarker.matcher(text).replaceAll("");
   }
   int len = text.length();
   StringBuilder sb = new StringBuilder(len);
   for (int i = 0; i < len; ++i) {
     String thisChar = String.valueOf(text.charAt(i));
     // Remove morpheme markers from the ATB vocalized section
     if (isWord && removeMorphMarker && thisChar.equals("+")) {
       continue;
     }
     if (removeLengthening && isLengthening(text, i)) {
       continue;
     }
     if (normMap.containsKey(thisChar)) {
       thisChar = normMap.get(thisChar);
     }
     if (thisChar.length() > 0) {
       sb.append(thisChar);
     }
   }
   return sb.toString();
 }
 
 private boolean isLengthening(String text, int pos) {
   if (pos == 0) return false;
   String thisChar = String.valueOf(text.charAt(pos));
   if (!thisChar.equals(String.valueOf(text.charAt(pos - 1))))
     return false;
   if (pos < text.length() - 1 && thisChar.equals(String.valueOf(text.charAt(pos + 1))))
     return true;
   if (pos >= 2 && thisChar.equals(String.valueOf(text.charAt(pos - 2))))
     return true;
   return false;
 }
 
   /** Make the next token.
   *
   *  @param txt What the token should be
   *  @param originalText The original String that got transformed into txt
   */
  private Object getNext(String txt, String originalText) {
    if (tokenFactory == null) {
      throw new RuntimeException(this.getClass().getName() + ": Token factory is null.");
    }
    if (invertible) {
      String str = prevWordAfter.toString();
      prevWordAfter.setLength(0);
      CoreLabel word = (CoreLabel) tokenFactory.makeToken(txt, yychar, yylength());
      word.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
      word.set(CoreAnnotations.BeforeAnnotation.class, str);
      prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
      prevWord = word;
      return word;
    } else {
      return tokenFactory.makeToken(txt, yychar, yylength());
    }
  }
  
  private Object getNext(boolean isWord) {
    String text = yytext();
    String normText = normalizeToken(text, isWord);
    return getNext(normText, text);
  }

  private Object getEllipsis() {
    String ellipsisString = useUTF8Ellipsis ? "\u2026" : "...";
    return getNext(ellipsisString, yytext());
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  ArabicLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2708) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Object next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                if (invertible) {
                String str = prevWordAfter.toString();
                prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
                prevWordAfter.setLength(0);
              }
              return null;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { System.err.printf("Untokenizable: %s%n", yytext());
	      return getNext(true);
            }
          case 9: break;
          case 2: 
            { if (tokenizeNLs) {
                return getNext(NEWLINE_TOKEN, yytext());
              } else if (invertible) {
                prevWordAfter.append(yytext());
              }
            }
          case 10: break;
          case 3: 
            { if (invertible) {
                prevWordAfter.append(yytext());
              }
            }
          case 11: break;
          case 4: 
            { return getNext(false);
            }
          case 12: break;
          case 5: 
            { return getNext(true);
            }
          case 13: break;
          case 6: 
            { return getEllipsis();
            }
          case 14: break;
          case 7: 
            { if (! removeProMarker) {
               return getNext(false);
             } else if (invertible) {
               prevWordAfter.append(yytext());
             }
            }
          case 15: break;
          case 8: 
            { if (removeProMarker) {
                if ( ! removeSegMarker) {
                  return getNext("-", yytext());
                } else if (invertible) {
                  prevWordAfter.append(yytext());
                }
              } else {
                return getNext(false);
              }
            }
          case 16: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
