/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.spanish;

import edu.stanford.nlp.international.spanish.process.SpanishTokenizer;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.international.spanish.SpanishHeadFinder;

public class SpanishTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private static final long serialVersionUID = -7059939700276532428L;
    private static final String[] punctTags = new String[]{"faa", "fat", "fc", "fca", "fct", "fd", "fe", "fg", "fh", "fia", "fit", "fla", "flt", "fp", "fpa", "fpt", "fra", "frc", "fs", "ft", "fx", "fz", "f0", "PUNCT"};
    private static final String[] sentenceFinalPunctTags = new String[]{"fat", "fit", "fp", "fs", "PUNCT"};
    private static final String[] punctWords = new String[]{"\u00a1", "!", ",", "[", "]", ":", "\"", "-", "/", "\u00bf", "?", "{", "}", ".", "=LRB=", "=RRB=", "-LRB-", "-RRB-", "(", ")", "\u00ab", "\u00bb", "\u2026", "...", "%", ";", "_", "+", "=", "&", "@"};
    private static final String[] sentenceFinalPunctWords = new String[]{"!", "?", ".", "\u2026", "..."};
    private static final String[] startSymbols = new String[]{"ROOT"};
    private static final char[] annotationIntroducingChars = new char[]{'^', '[', '-'};

    @Override
    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        return SpanishTokenizer.factory(new CoreLabelTokenFactory(), "invertible,ellipses=ptb3,splitAll=false");
    }

    @Override
    public String[] punctuationTags() {
        return punctTags;
    }

    @Override
    public String[] punctuationWords() {
        return punctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return sentenceFinalPunctTags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return sentenceFinalPunctWords;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return startSymbols;
    }

    @Override
    public String treebankFileExtension() {
        return "xml";
    }

    @Override
    public HeadFinder headFinder() {
        return new SpanishHeadFinder(this);
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new SpanishHeadFinder(this);
    }
}

