/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Map;

public class ExciseNode
extends TsurgeonPattern {
    private static Redwood.RedwoodChannels log = Redwood.channels(ExciseNode.class);

    public ExciseNode(TsurgeonPattern top, TsurgeonPattern bottom) {
        super("excise", new TsurgeonPattern[]{top, bottom});
    }

    public ExciseNode(TsurgeonPattern node) {
        super("excise", new TsurgeonPattern[]{node, node});
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(ExciseNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree topNode = this.childMatcher[0].evaluate(tree, tregex);
            Tree bottomNode = this.childMatcher[1].evaluate(tree, tregex);
            if (Tsurgeon.verbose) {
                log.info("Excising...original tree:");
                tree.pennPrint(System.err);
                log.info("top: " + topNode + "\nbottom:" + bottomNode);
            }
            if (topNode == tree) {
                if (bottomNode.children().length == 1) {
                    return bottomNode.children()[0];
                }
                return null;
            }
            Tree parent = topNode.parent(tree);
            if (Tsurgeon.verbose) {
                log.info("Parent: " + parent);
            }
            int i = Trees.objectEqualityIndexOf(parent, topNode);
            parent.removeChild(i);
            for (Tree child : bottomNode.children()) {
                parent.addChild(i, child);
                ++i;
            }
            if (Tsurgeon.verbose) {
                tree.pennPrint(System.err);
            }
            return tree;
        }
    }
}

