/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import java.util.zip.GZIPOutputStream;

public final class FileSystem {
    private static final Redwood.RedwoodChannels log = Redwood.channels(FileSystem.class);

    private FileSystem() {
    }

    public static void copyFile(File sourceFile, File destFile) {
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
        try (FileChannel source = new FileInputStream(sourceFile).getChannel();
             FileChannel destination = new FileOutputStream(destFile).getChannel();){
            destination.transferFrom(source, 0L, source.size());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("FileSystem: Error copying %s to %s%n", sourceFile.getPath(), destFile.getPath()), e);
        }
    }

    public static void gzipFile(File uncompressedFileName, File compressedFileName) throws IOException {
        try (GZIPOutputStream out2 = new GZIPOutputStream(new FileOutputStream(compressedFileName));
             FileInputStream in = new FileInputStream(uncompressedFileName);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out2.write(buf, 0, len);
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children == null) {
                return false;
            }
            for (String aChildren : children) {
                boolean success = FileSystem.deleteDir(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean existsAndNonEmpty(File file) {
        String firstLine;
        if (!file.exists()) {
            return false;
        }
        Iterable<String> lines = IOUtils.readLines(file);
        try {
            firstLine = lines.iterator().next();
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
        return firstLine.length() > 0;
    }

    public static void mkdirOrFail(String dir) {
        FileSystem.mkdirOrFail(new File(dir));
    }

    public static void mkdirOrFail(File dir) {
        if (!dir.mkdirs()) {
            String error = "Could not create " + dir;
            log.info(error);
            throw new RuntimeException(error);
        }
    }

    public static void checkExistsOrFail(File file) {
        if (!file.exists()) {
            String error = "Output path " + file + " does not exist";
            log.info(error);
            throw new RuntimeException(error);
        }
    }

    public static void checkNotExistsOrFail(File file) {
        if (file.exists()) {
            String error = "Output path " + file + " already exists";
            log.info(error);
            throw new RuntimeException(error);
        }
    }

    public static void main(String[] args) {
        String testDirName = "FileSystemTest";
        String testFileName = "Pair.java";
        File testDir = new File(testDirName);
        testDir.mkdir();
        try {
            FileSystem.copyFile(new File(testFileName), new File(testDirName + "/" + testFileName));
        }
        catch (RuntimeIOException e) {
            log.info("Copy failed");
            System.exit(-1);
        }
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(String.format("tar -cf %s.tar %s", testDirName, testDirName));
            int ret_val = p.waitFor();
            if (ret_val != 0) {
                System.err.printf("tar command returned %d%n", ret_val);
                System.exit(-1);
            }
        }
        catch (IOException e) {
            log.info("Tar command failed");
            System.exit(-1);
        }
        catch (InterruptedException e) {
            log.info("Tar command interrupted");
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            FileSystem.gzipFile(new File(testDirName + ".tar"), new File(testDirName + ".tar.gz"));
        }
        catch (IOException e) {
            log.info("gzip command failed");
            System.exit(-1);
        }
        boolean deleteSuccess = FileSystem.deleteDir(new File(testDirName));
        if (!deleteSuccess) {
            log.info("Could not delete directory");
            System.exit(-1);
        }
        System.out.println("Success!");
    }
}

