/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.HoldTreeNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.TreeLocation;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;
import java.util.Map;

class InsertNode
extends TsurgeonPattern {
    TreeLocation location;
    boolean needsCopy = true;

    public InsertNode(TsurgeonPattern child, TreeLocation l) {
        super("insert", new TsurgeonPattern[]{child});
        this.location = l;
    }

    @Override
    protected void setRoot(TsurgeonPatternRoot root) {
        super.setRoot(root);
        this.location.setRoot(root);
    }

    public InsertNode(AuxiliaryTree t, TreeLocation l) {
        this(new HoldTreeNode(t), l);
        this.needsCopy = false;
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    @Override
    public String toString() {
        return this.label + '(' + this.children[0] + ',' + this.location + ')';
    }

    private class Matcher
    extends TsurgeonMatcher {
        TreeLocation.LocationMatcher locationMatcher;

        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(InsertNode.this, newNodeNames, coindexer);
            this.locationMatcher = InsertNode.this.location.matcher(newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree nodeToInsert = this.childMatcher[0].evaluate(tree, tregex);
            Pair<Tree, Integer> position = this.locationMatcher.evaluate(tree, tregex);
            position.first().insertDtr(InsertNode.this.needsCopy ? nodeToInsert.deepCopy() : nodeToInsert, position.second());
            return tree;
        }
    }
}

