/* The following code was generated by JFlex 1.5.1 */

package edu.stanford.nlp.international.arabic.process;

import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;

/**
 * Tokenizer for UTF-8 Arabic. Supports raw text and both sections
 * (vocalized and unvocalized) of the ATB.
 *
 * @author Spence Green
 */


class ArabicLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\35\1\2\1\3\1\4\1\1\22\0\1\35\1\37\1\36"+
    "\1\7\1\44\2\7\1\44\2\36\1\7\1\23\1\40\1\15\1\6"+
    "\1\34\12\45\1\33\1\44\1\36\1\44\1\36\1\37\1\77\1\52"+
    "\1\103\1\55\1\73\1\65\1\52\1\71\1\46\3\52\1\101\1\61"+
    "\1\63\1\57\1\50\1\52\1\67\1\53\1\47\1\75\1\52\1\51"+
    "\3\52\1\16\1\12\1\22\1\44\1\14\1\44\1\42\1\102\1\54"+
    "\1\72\1\64\1\42\1\70\1\27\3\42\1\100\1\60\1\62\1\56"+
    "\1\31\1\42\1\66\1\43\1\30\1\74\1\42\1\41\3\42\1\37"+
    "\1\36\1\37\1\7\6\0\1\3\32\0\1\76\11\7\1\25\2\7"+
    "\1\25\7\7\1\25\4\7\1\25\5\7\27\24\1\0\37\24\1\0"+
    "\207\24\1\32\267\24\31\24\162\24\4\24\14\24\16\24\5\24\7\24"+
    "\1\24\1\24\1\24\201\24\5\24\1\24\2\24\2\24\4\24\6\0"+
    "\2\24\1\24\1\0\3\24\1\0\1\24\1\0\24\24\1\0\54\24"+
    "\1\24\46\24\1\24\5\24\4\24\202\24\1\0\5\24\2\0\105\24"+
    "\1\24\46\24\12\24\20\24\26\24\2\24\11\0\46\24\2\0\1\24"+
    "\6\24\1\0\47\24\11\0\55\24\1\0\1\24\1\0\2\24\1\0"+
    "\2\24\1\0\1\24\10\0\33\24\5\0\3\24\15\0\14\7\2\11"+
    "\15\13\5\7\1\24\43\26\1\21\1\26\1\17\4\26\4\13\1\20"+
    "\17\13\1\0\12\10\1\7\2\11\1\7\2\26\1\13\143\26\1\7"+
    "\1\26\17\13\2\26\7\13\2\26\12\10\3\26\2\13\1\26\17\0"+
    "\1\24\1\24\1\24\36\24\35\24\63\24\46\24\13\24\1\24\16\0"+
    "\12\10\41\24\11\24\2\24\4\0\1\24\5\0\26\24\4\0\1\24"+
    "\11\0\1\24\3\0\1\24\27\0\31\24\107\0\1\24\1\0\13\24"+
    "\123\0\4\24\66\24\2\0\1\24\1\24\21\24\1\0\1\24\5\24"+
    "\2\0\12\24\2\24\2\0\12\10\1\0\7\24\1\0\7\24\1\0"+
    "\3\24\1\0\10\24\2\0\2\24\2\0\26\24\1\0\7\24\1\0"+
    "\1\24\3\0\4\24\2\0\1\24\1\24\7\24\2\0\2\24\2\0"+
    "\3\24\1\24\10\0\1\24\4\0\2\24\1\0\3\24\2\24\2\0"+
    "\12\10\2\24\17\0\3\24\1\0\6\24\4\0\2\24\2\0\26\24"+
    "\1\0\7\24\1\0\2\24\1\0\2\24\1\0\2\24\2\0\1\24"+
    "\1\0\22\24\11\0\4\24\1\0\1\24\7\0\12\10\2\0\3\24"+
    "\14\0\3\24\1\0\11\24\1\0\3\24\1\0\26\24\1\0\7\24"+
    "\1\0\2\24\1\0\5\24\2\0\1\24\1\24\22\24\1\24\17\0"+
    "\2\24\4\0\12\10\25\0\10\24\2\0\2\24\2\0\26\24\1\0"+
    "\7\24\1\0\2\24\1\0\5\24\3\0\1\24\36\0\2\24\1\0"+
    "\3\24\4\0\12\10\1\0\1\24\20\0\1\24\1\24\1\0\6\24"+
    "\3\0\3\24\1\0\4\24\3\0\2\24\1\0\1\24\1\0\2\24"+
    "\3\0\2\24\3\0\3\24\3\0\14\24\4\0\5\24\3\0\3\24"+
    "\1\0\4\24\2\0\1\24\25\0\12\10\21\0\3\24\1\0\10\24"+
    "\1\0\3\24\1\0\27\24\1\0\12\24\1\0\5\24\3\0\1\24"+
    "\31\24\1\0\2\24\6\0\2\24\4\0\12\10\25\0\10\24\1\0"+
    "\3\24\1\0\27\24\1\0\12\24\1\0\5\24\3\0\1\24\40\0"+
    "\1\24\1\0\2\24\4\0\12\10\1\0\2\24\22\0\10\24\1\0"+
    "\3\24\1\0\51\24\2\0\1\24\7\24\1\0\3\24\5\0\1\24"+
    "\21\0\2\24\4\0\12\10\12\0\6\24\5\0\22\24\3\0\30\24"+
    "\1\0\11\24\1\0\1\24\2\0\7\24\72\0\57\24\1\24\1\24"+
    "\2\24\7\24\5\0\7\24\10\24\1\0\12\10\47\0\2\24\1\0"+
    "\1\24\2\0\2\24\1\0\1\24\2\0\1\24\6\0\4\24\1\0"+
    "\7\24\1\0\3\24\1\0\1\24\1\0\1\24\2\0\2\24\1\0"+
    "\4\24\1\24\2\24\11\24\1\24\2\0\5\24\1\0\1\24\1\0"+
    "\6\24\2\0\12\10\2\0\4\24\40\0\1\24\37\0\12\10\26\0"+
    "\10\24\1\0\44\24\33\0\5\24\163\0\53\24\24\0\1\24\12\10"+
    "\6\0\6\24\4\0\4\24\3\0\1\24\3\0\2\24\7\0\3\24"+
    "\4\0\15\24\14\0\1\24\1\0\12\10\6\0\46\24\1\0\1\24"+
    "\5\0\1\24\2\0\53\24\1\0\u014d\24\1\0\4\24\2\0\7\24"+
    "\1\0\1\24\1\0\4\24\2\0\51\24\1\0\4\24\2\0\41\24"+
    "\1\0\4\24\2\0\7\24\1\0\1\24\1\0\4\24\2\0\17\24"+
    "\1\0\71\24\1\0\4\24\2\0\103\24\45\0\20\24\20\0\125\24"+
    "\14\0\u026c\24\2\0\21\24\1\0\32\24\5\0\113\24\25\0\15\24"+
    "\1\0\4\24\16\0\22\24\16\0\22\24\16\0\15\24\1\0\3\24"+
    "\17\0\64\24\43\0\1\24\4\0\1\24\3\0\12\10\46\0\12\10"+
    "\6\0\130\24\10\0\51\24\1\0\1\24\5\0\106\24\12\0\35\24"+
    "\51\0\12\10\36\24\2\0\5\24\13\0\54\24\25\0\7\24\10\0"+
    "\12\10\46\0\27\24\11\0\65\24\53\0\12\10\6\0\12\10\15\0"+
    "\1\24\135\0\57\24\21\0\7\24\4\0\12\10\51\0\36\24\15\0"+
    "\2\24\12\10\54\24\32\0\44\24\34\0\12\10\3\0\3\24\12\10"+
    "\44\24\153\0\4\24\1\0\4\24\3\0\2\24\11\0\300\24\100\0"+
    "\u0116\24\2\0\6\24\2\0\46\24\2\0\6\24\2\0\10\24\1\0"+
    "\1\24\1\0\1\24\1\0\1\24\1\0\37\24\2\0\65\24\1\0"+
    "\7\24\1\0\1\24\3\0\3\24\1\0\7\24\3\0\4\24\2\0"+
    "\6\24\4\0\15\24\5\0\3\24\1\0\7\24\3\0\13\5\5\0"+
    "\30\7\1\3\1\3\5\0\1\5\57\7\22\0\1\24\15\0\1\24"+
    "\20\0\15\24\3\0\26\7\114\0\1\24\4\0\1\24\2\0\12\24"+
    "\1\0\1\24\3\0\5\24\6\0\1\24\1\0\1\24\1\0\1\24"+
    "\1\0\4\24\1\0\13\24\2\0\4\24\5\0\5\24\4\0\1\24"+
    "\64\0\2\24\u0a7b\0\57\24\1\0\57\24\1\0\205\24\6\0\4\24"+
    "\3\0\2\24\14\0\46\24\1\0\1\24\5\0\1\24\2\0\70\24"+
    "\7\0\1\24\20\0\27\24\11\0\7\24\1\0\7\24\1\0\7\24"+
    "\1\0\7\24\1\0\7\24\1\0\7\24\1\0\7\24\1\0\7\24"+
    "\117\0\1\7\1\24\u01d0\0\1\5\4\0\2\24\52\0\5\24\5\0"+
    "\2\24\4\0\126\24\6\0\3\24\1\0\132\24\1\0\4\24\5\0"+
    "\51\24\3\0\136\24\21\0\33\24\65\0\20\24\u0200\0\u19b6\24\112\0"+
    "\u51cd\24\63\0\u048d\24\103\0\56\24\2\0\u010d\24\3\0\20\24\12\10"+
    "\2\24\24\0\57\24\20\0\31\24\10\0\106\24\61\0\11\24\2\0"+
    "\147\24\2\0\4\24\1\0\4\24\14\0\13\24\115\0\12\24\1\0"+
    "\3\24\1\0\4\24\1\0\27\24\35\0\64\24\16\0\62\24\34\0"+
    "\12\10\30\0\6\24\3\0\1\24\4\0\12\10\34\24\12\0\27\24"+
    "\31\0\35\24\7\0\57\24\34\0\1\24\12\10\46\0\51\24\27\0"+
    "\3\24\1\0\10\24\4\0\12\10\6\0\27\24\3\0\1\24\5\0"+
    "\60\24\1\0\1\24\3\0\2\24\2\0\5\24\2\0\1\24\1\0"+
    "\1\24\30\0\3\24\2\0\13\24\7\0\3\24\14\0\6\24\2\0"+
    "\6\24\2\0\6\24\11\0\7\24\1\0\7\24\221\0\43\24\15\0"+
    "\12\10\6\0\u2ba4\24\14\0\27\24\4\0\61\24\u2104\0\u016e\24\2\0"+
    "\152\24\46\0\7\24\14\0\5\24\5\0\1\24\1\0\12\24\1\0"+
    "\15\24\1\0\5\24\1\0\1\24\1\0\2\24\1\0\2\24\1\0"+
    "\154\24\41\0\u016b\24\22\0\100\24\2\0\66\24\50\0\14\24\164\0"+
    "\5\24\1\0\207\24\23\0\12\10\7\0\32\24\6\0\32\24\13\0"+
    "\131\24\3\0\6\24\2\0\6\24\2\0\6\24\2\0\3\24\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\3\2\1\3\4\4\1\5\3\4\2\5"+
    "\1\4\2\5\1\3\1\5\1\4\3\5\2\0\5\4"+
    "\2\5\3\4\2\0\1\5\3\0\2\5\1\0\2\5"+
    "\10\0\1\6\12\0\2\5\1\0\2\5\22\0\2\5"+
    "\3\0\3\4\1\0\2\4\1\5\1\0\1\5\11\0"+
    "\1\7\1\0\1\4\10\0\1\10\1\4\1\0\1\4"+
    "\2\0\4\4\1\0\6\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[141];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\104\0\210\0\314\0\104\0\u0110\0\u0154\0\u0198"+
    "\0\u01dc\0\u0220\0\u0264\0\u02a8\0\u02ec\0\u0330\0\u0374\0\u03b8"+
    "\0\u03fc\0\u0440\0\u0484\0\u04c8\0\u050c\0\u0550\0\u0594\0\u05d8"+
    "\0\u061c\0\104\0\u0660\0\u06a4\0\u06e8\0\u072c\0\u0770\0\u07b4"+
    "\0\u07f8\0\u083c\0\u0880\0\u08c4\0\u0908\0\u094c\0\u0990\0\u09d4"+
    "\0\u0a18\0\u0a5c\0\u0aa0\0\u0ae4\0\u0b28\0\u0b6c\0\u0bb0\0\u0bf4"+
    "\0\u0c38\0\u0c7c\0\u0cc0\0\u0d04\0\u0d48\0\u0d8c\0\u0dd0\0\u0e14"+
    "\0\u06a4\0\u0e58\0\u0e9c\0\u0ee0\0\u0f24\0\u0f68\0\u0fac\0\u0ff0"+
    "\0\u1034\0\u1078\0\u10bc\0\u1100\0\u1144\0\u1188\0\u11cc\0\u1210"+
    "\0\u1254\0\u1298\0\u12dc\0\u1320\0\u1364\0\u13a8\0\u13ec\0\u1430"+
    "\0\u1474\0\u14b8\0\u14fc\0\u1540\0\u1584\0\u15c8\0\u160c\0\u1650"+
    "\0\u1694\0\u16d8\0\u171c\0\u1760\0\u17a4\0\u17e8\0\u182c\0\u1870"+
    "\0\u18b4\0\314\0\u18f8\0\u193c\0\u1980\0\u19c4\0\u1a08\0\u1a4c"+
    "\0\u1a90\0\u1ad4\0\u1b18\0\u1b5c\0\u1ba0\0\u1be4\0\u1c28\0\u1c6c"+
    "\0\u1cb0\0\u1cf4\0\u1980\0\u1d38\0\u1d7c\0\u1dc0\0\u1e04\0\u1e48"+
    "\0\u1e8c\0\u1ed0\0\u1f14\0\u1f58\0\314\0\u1f9c\0\u1fe0\0\u2024"+
    "\0\u2068\0\u20ac\0\u1f58\0\u1188\0\u20f0\0\u2134\0\u2178\0\u21bc"+
    "\0\u2200\0\u2244\0\u2288\0\u22cc\0\u2310";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[141];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\4\1\6\1\7\1\10"+
    "\1\11\1\10\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\13\1\17\1\12\1\10\1\20\1\21\1\17\1\22"+
    "\2\23\1\20\2\12\1\24\3\12\1\25\2\23\1\12"+
    "\1\26\1\27\2\30\1\31\2\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\6"+
    "\1\12\1\23\1\30\1\23\1\30\1\32\2\0\1\32"+
    "\1\0\1\32\1\33\3\32\1\0\1\32\3\0\3\32"+
    "\1\0\10\32\6\0\3\32\10\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\3\0\1\4\205\0\1\32"+
    "\2\0\1\32\1\0\1\6\1\33\3\32\1\0\1\32"+
    "\3\0\3\32\1\0\10\32\2\0\1\24\3\0\3\32"+
    "\10\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\6\1\0\1\32\1\0\1\32"+
    "\7\0\1\34\1\12\1\0\2\12\1\0\3\12\3\0"+
    "\2\12\1\0\1\12\5\0\2\12\1\0\3\12\3\0"+
    "\1\12\32\0\1\12\4\0\1\32\2\0\1\32\1\0"+
    "\1\32\1\35\1\10\1\32\1\10\1\12\1\32\3\12"+
    "\3\32\1\12\1\10\1\32\1\10\5\32\2\12\1\0"+
    "\3\12\3\32\1\12\7\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\12"+
    "\1\32\1\0\1\32\1\0\1\32\2\0\1\32\1\0"+
    "\1\32\1\36\1\32\2\11\1\37\1\32\2\37\1\0"+
    "\3\32\1\0\1\11\7\32\1\0\1\37\3\0\1\37"+
    "\3\32\1\0\1\37\6\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\7\0\2\12\1\0\2\12\1\0"+
    "\3\12\3\0\2\12\1\0\1\12\5\0\2\12\1\0"+
    "\3\12\3\0\1\12\32\0\1\12\4\0\1\32\2\0"+
    "\1\32\1\0\1\32\1\33\1\32\1\40\1\32\1\0"+
    "\1\13\1\41\1\42\1\0\3\13\1\0\1\13\2\32"+
    "\1\13\4\32\6\0\3\32\1\0\1\43\6\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\7\0\2\12"+
    "\1\43\2\12\1\41\1\14\1\44\1\12\3\41\1\12"+
    "\1\14\1\0\1\12\1\41\4\0\2\12\1\0\3\12"+
    "\3\0\1\12\1\43\31\0\1\12\12\0\2\12\1\0"+
    "\2\12\1\41\1\14\1\45\1\16\3\41\2\12\1\0"+
    "\1\12\1\41\4\0\2\12\1\0\3\12\3\0\1\12"+
    "\21\0\2\46\7\0\1\12\2\46\10\0\2\12\1\0"+
    "\2\12\1\0\3\12\1\47\2\0\2\12\1\0\1\12"+
    "\5\0\2\12\1\0\3\12\3\0\1\12\32\0\1\12"+
    "\4\0\1\32\2\0\1\32\1\0\1\32\1\33\1\32"+
    "\1\40\1\32\1\0\1\13\1\41\1\42\1\0\1\17"+
    "\1\13\1\17\1\0\1\13\2\20\1\17\4\20\6\0"+
    "\3\20\1\0\1\43\6\50\1\20\1\50\1\20\1\50"+
    "\1\20\1\50\1\20\1\50\1\20\1\50\1\20\1\50"+
    "\1\20\1\50\1\20\1\50\1\20\1\50\1\32\1\0"+
    "\1\20\1\50\1\20\1\50\1\32\2\0\1\32\1\0"+
    "\1\32\1\33\3\32\1\0\1\32\3\0\1\20\1\32"+
    "\1\20\1\0\1\32\7\20\6\0\3\20\2\0\6\50"+
    "\1\20\1\50\1\20\1\50\1\20\1\50\1\20\1\50"+
    "\1\20\1\50\1\20\1\50\1\20\1\50\1\20\1\50"+
    "\1\20\1\50\1\32\1\0\1\20\1\50\1\20\1\50"+
    "\1\32\2\0\1\32\1\0\1\32\1\35\1\10\1\32"+
    "\1\10\1\12\1\32\3\12\1\20\1\32\1\20\1\12"+
    "\1\10\1\20\1\21\5\20\2\12\1\0\3\12\3\20"+
    "\1\12\1\0\6\50\1\20\1\50\1\20\1\50\1\20"+
    "\1\50\1\20\1\50\1\20\1\50\1\20\1\50\1\20"+
    "\1\50\1\20\1\50\1\20\1\50\1\32\1\12\1\20"+
    "\1\50\1\20\1\50\1\51\2\0\1\51\1\0\1\51"+
    "\1\52\3\51\1\53\1\51\3\53\1\23\1\51\1\23"+
    "\1\53\1\51\4\23\1\54\2\23\2\53\2\0\2\53"+
    "\3\23\2\53\1\30\1\55\4\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\32"+
    "\1\56\1\23\1\30\1\23\1\30\1\51\2\0\1\51"+
    "\1\0\1\51\1\52\3\51\1\53\1\51\3\53\1\23"+
    "\1\51\1\23\1\53\1\51\7\23\2\53\2\0\2\53"+
    "\3\23\2\53\6\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\32\1\56\1\23"+
    "\1\30\1\23\1\30\5\0\1\24\27\0\1\24\40\0"+
    "\1\24\5\0\1\51\2\0\1\51\1\0\1\51\1\52"+
    "\3\51\1\53\1\51\3\53\1\23\1\51\1\23\1\53"+
    "\1\51\7\23\2\53\2\0\2\53\1\57\2\23\2\53"+
    "\3\30\1\60\2\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\32\1\56\1\23"+
    "\1\30\1\23\1\30\1\53\2\0\1\53\1\0\1\53"+
    "\1\26\1\53\3\26\1\53\2\26\5\53\1\26\10\53"+
    "\1\26\2\0\1\53\1\26\4\53\1\26\30\53\1\0"+
    "\1\56\5\53\2\0\1\53\1\0\12\53\1\30\1\53"+
    "\1\30\2\53\4\30\1\55\2\30\2\53\2\0\2\53"+
    "\3\30\2\53\1\30\1\55\26\30\1\0\1\56\4\30"+
    "\1\53\2\0\1\53\1\0\12\53\1\30\1\53\1\30"+
    "\2\53\7\30\2\53\2\0\2\53\3\30\2\53\30\30"+
    "\1\0\1\56\4\30\1\53\2\0\1\53\1\0\12\53"+
    "\1\30\1\53\1\30\2\53\7\30\2\53\2\0\2\53"+
    "\1\60\2\30\2\53\3\30\1\60\24\30\1\0\1\56"+
    "\4\30\1\32\2\0\1\32\1\0\1\32\1\0\3\32"+
    "\1\0\1\32\3\0\3\32\1\0\10\32\6\0\3\32"+
    "\10\0\1\61\1\62\1\63\1\64\1\32\1\0\1\65"+
    "\1\66\1\67\1\70\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\7\0\1\71\1\12\1\0\2\12\1\0\3\12\3\0"+
    "\2\12\1\0\1\12\5\0\2\12\1\0\3\12\3\0"+
    "\1\12\32\0\1\12\4\0\1\32\2\0\1\32\1\0"+
    "\1\32\1\12\1\10\1\32\1\10\1\12\1\32\3\12"+
    "\3\32\1\12\1\10\1\32\1\10\5\32\2\12\1\0"+
    "\3\12\3\32\1\12\7\0\1\61\1\62\1\63\1\64"+
    "\1\32\1\0\1\65\1\66\1\67\1\70\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\12"+
    "\1\32\1\0\1\32\1\0\1\32\2\0\1\32\1\0"+
    "\1\32\1\37\1\32\2\11\1\37\1\32\2\37\1\0"+
    "\3\32\1\0\1\11\7\32\1\0\1\37\3\0\1\37"+
    "\3\32\1\0\1\37\6\0\1\61\1\62\1\63\1\64"+
    "\1\32\1\0\1\65\1\66\1\67\1\70\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\7\0\1\37\1\0\3\37\1\0"+
    "\2\37\5\0\1\37\10\0\1\37\3\0\1\37\4\0"+
    "\1\37\36\0\1\32\2\0\1\32\1\0\1\32\1\33"+
    "\1\32\1\40\1\32\1\0\1\32\3\0\3\32\1\0"+
    "\10\32\6\0\3\32\1\0\1\43\6\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\11\0\1\43\2\0"+
    "\2\41\1\42\1\0\3\41\1\0\1\41\2\0\1\41"+
    "\16\0\1\43\46\0\1\43\4\0\1\42\27\0\1\43"+
    "\46\0\1\43\34\0\1\43\44\0\2\12\1\43\2\12"+
    "\1\0\1\12\1\44\1\12\3\0\2\12\1\0\1\12"+
    "\5\0\2\12\1\0\3\12\3\0\1\12\1\43\31\0"+
    "\1\12\12\0\2\12\1\0\2\12\1\41\1\14\1\45"+
    "\1\16\3\41\2\12\1\0\1\12\1\41\4\0\2\12"+
    "\1\0\3\12\3\0\1\12\32\0\1\12\72\0\2\72"+
    "\34\0\1\73\102\0\1\50\1\0\1\50\2\0\7\50"+
    "\6\0\3\50\2\0\30\50\2\0\4\50\1\51\2\0"+
    "\1\51\1\0\1\51\1\52\3\51\1\53\1\51\3\53"+
    "\3\51\1\53\10\51\2\53\2\0\2\53\3\51\10\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\51\1\53"+
    "\1\51\1\53\1\32\1\56\1\51\1\53\1\51\1\53"+
    "\1\51\2\0\1\51\1\0\1\51\1\53\3\51\1\53"+
    "\1\51\3\53\3\51\1\53\10\51\2\53\2\0\2\53"+
    "\3\51\10\53\1\74\1\75\1\76\1\77\1\51\1\53"+
    "\1\100\1\101\1\102\1\103\1\51\1\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\32\1\56\1\51\1\53"+
    "\1\51\2\53\2\0\1\53\1\0\30\53\2\0\37\53"+
    "\1\0\1\56\4\53\1\51\2\0\1\51\1\0\1\51"+
    "\1\52\3\51\1\53\1\51\3\53\1\23\1\51\1\23"+
    "\1\53\1\51\4\23\1\104\2\23\2\53\2\0\2\53"+
    "\3\23\2\53\1\30\1\105\4\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\23"+
    "\1\30\1\23\1\30\1\23\1\30\1\23\1\30\1\32"+
    "\1\56\1\23\1\30\1\23\1\30\1\53\2\0\1\53"+
    "\1\0\12\53\1\30\1\53\1\30\2\53\4\30\1\105"+
    "\2\30\2\53\2\0\2\53\3\30\2\53\1\30\1\105"+
    "\26\30\1\0\1\56\4\30\1\106\2\0\1\106\1\0"+
    "\1\106\1\53\26\106\2\0\37\106\1\0\5\106\1\51"+
    "\2\0\1\51\1\0\1\51\1\52\3\51\1\53\1\51"+
    "\3\53\1\23\1\51\1\23\1\53\1\51\7\23\2\53"+
    "\2\0\2\53\1\107\2\23\2\53\3\30\1\110\2\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\32\1\56\1\23\1\30\1\23\1\30"+
    "\1\53\2\0\1\53\1\0\12\53\1\30\1\53\1\30"+
    "\2\53\7\30\2\53\2\0\2\53\1\110\2\30\2\53"+
    "\3\30\1\110\24\30\1\0\1\56\4\30\1\32\2\0"+
    "\1\32\1\0\1\32\1\33\3\32\1\0\1\32\3\0"+
    "\3\32\1\0\10\32\6\0\3\32\10\0\1\32\1\0"+
    "\1\111\1\112\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\57\0\2\112\24\0"+
    "\1\32\2\0\1\32\1\0\1\32\1\33\3\32\1\0"+
    "\1\32\3\0\3\32\1\0\10\32\6\0\3\32\10\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\113\1\114\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\67\0"+
    "\2\114\14\0\1\32\2\0\1\32\1\0\1\32\1\33"+
    "\3\32\1\0\1\32\3\0\3\32\1\0\10\32\6\0"+
    "\3\32\10\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\115\1\116\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\65\0\2\116\16\0\1\32\2\0\1\32\1\0"+
    "\1\32\1\33\3\32\1\0\1\32\3\0\3\32\1\0"+
    "\10\32\6\0\3\32\10\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\117\1\120\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\73\0\2\120\112\0\2\121\21\0"+
    "\1\122\62\0\1\51\2\0\1\51\1\0\1\51\1\52"+
    "\3\51\1\53\1\51\3\53\3\51\1\53\10\51\2\53"+
    "\2\0\2\53\3\51\10\53\1\51\1\53\1\123\1\124"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\32\1\56"+
    "\1\51\1\53\1\51\2\53\2\0\1\53\1\0\30\53"+
    "\2\0\17\53\2\124\16\53\1\0\1\56\4\53\1\51"+
    "\2\0\1\51\1\0\1\51\1\52\3\51\1\53\1\51"+
    "\3\53\3\51\1\53\10\51\2\53\2\0\2\53\3\51"+
    "\10\53\1\51\1\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\125\1\126\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\32\1\56\1\51\1\53\1\51"+
    "\2\53\2\0\1\53\1\0\30\53\2\0\27\53\2\126"+
    "\6\53\1\0\1\56\4\53\1\51\2\0\1\51\1\0"+
    "\1\51\1\52\3\51\1\53\1\51\3\53\3\51\1\53"+
    "\10\51\2\53\2\0\2\53\3\51\10\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\127\1\130"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\51\1\53"+
    "\1\32\1\56\1\51\1\53\1\51\2\53\2\0\1\53"+
    "\1\0\30\53\2\0\25\53\2\130\10\53\1\0\1\56"+
    "\4\53\1\51\2\0\1\51\1\0\1\51\1\52\3\51"+
    "\1\53\1\51\3\53\3\51\1\53\10\51\2\53\2\0"+
    "\2\53\3\51\10\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\131\1\132\1\51\1\53\1\32\1\56\1\51"+
    "\1\53\1\51\2\53\2\0\1\53\1\0\30\53\2\0"+
    "\33\53\2\132\2\53\1\0\1\56\4\53\1\51\2\0"+
    "\1\51\1\0\1\51\1\52\3\51\1\53\1\51\3\53"+
    "\1\23\1\51\1\23\1\53\1\51\5\23\1\133\1\23"+
    "\2\53\2\0\2\53\3\23\2\53\2\30\1\134\3\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\32\1\56\1\23\1\30\1\23\1\30"+
    "\1\53\2\0\1\53\1\0\12\53\1\30\1\53\1\30"+
    "\2\53\5\30\1\134\1\30\2\53\2\0\2\53\3\30"+
    "\2\53\2\30\1\134\25\30\1\0\1\56\4\30\1\106"+
    "\2\0\1\106\1\0\1\106\1\135\26\106\2\0\37\106"+
    "\1\0\5\106\1\51\2\0\1\51\1\0\1\51\1\136"+
    "\3\51\1\53\1\51\3\53\1\23\1\51\1\23\1\53"+
    "\1\51\7\23\2\53\2\0\2\53\3\23\2\53\6\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\32\1\56\1\23\1\30\1\23\1\30"+
    "\1\53\2\0\1\53\1\0\1\53\1\137\10\53\1\30"+
    "\1\53\1\30\2\53\7\30\2\53\2\0\2\53\3\30"+
    "\2\53\30\30\1\0\1\56\4\30\1\32\2\0\1\32"+
    "\1\0\1\32\1\33\3\32\1\0\1\32\3\0\3\32"+
    "\1\0\10\32\6\0\3\32\10\0\1\32\1\0\1\32"+
    "\1\0\1\140\1\141\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\61\0\2\141\22\0\1\32"+
    "\2\0\1\32\1\0\1\32\1\33\3\32\1\0\1\32"+
    "\3\0\3\32\1\0\10\32\6\0\3\32\10\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\140\1\141\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\71\0\2\141"+
    "\12\0\1\32\2\0\1\32\1\0\1\32\1\33\3\32"+
    "\1\0\1\32\3\0\3\32\1\0\5\32\1\140\2\32"+
    "\6\0\3\32\3\0\1\141\4\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\31\0\1\141\16\0\1\141"+
    "\34\0\1\32\2\0\1\32\1\0\1\32\1\33\3\32"+
    "\1\0\1\32\3\0\3\32\1\0\10\32\6\0\3\32"+
    "\10\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\1\140\1\141\1\32\1\0\1\32\1\0\1\32"+
    "\75\0\2\141\23\0\1\142\107\0\1\143\62\0\1\51"+
    "\2\0\1\51\1\0\1\51\1\52\3\51\1\53\1\51"+
    "\3\53\3\51\1\53\10\51\2\53\2\0\2\53\3\51"+
    "\10\53\1\51\1\53\1\51\1\53\1\144\1\145\1\51"+
    "\1\53\1\51\1\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\32\1\56\1\51\1\53\1\51"+
    "\2\53\2\0\1\53\1\0\30\53\2\0\21\53\2\145"+
    "\14\53\1\0\1\56\4\53\1\51\2\0\1\51\1\0"+
    "\1\51\1\52\3\51\1\53\1\51\3\53\3\51\1\53"+
    "\10\51\2\53\2\0\2\53\3\51\10\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\51\1\53"+
    "\1\51\1\53\1\144\1\145\1\51\1\53\1\51\1\53"+
    "\1\32\1\56\1\51\1\53\1\51\2\53\2\0\1\53"+
    "\1\0\30\53\2\0\31\53\2\145\4\53\1\0\1\56"+
    "\4\53\1\51\2\0\1\51\1\0\1\51\1\52\3\51"+
    "\1\53\1\51\3\53\3\51\1\53\5\51\1\144\2\51"+
    "\2\53\2\0\2\53\3\51\3\53\1\145\4\53\1\51"+
    "\1\53\1\51\1\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\32\1\56\1\51\1\53\1\51\2\53\2\0"+
    "\1\53\1\0\23\53\1\145\4\53\2\0\10\53\1\145"+
    "\26\53\1\0\1\56\4\53\1\51\2\0\1\51\1\0"+
    "\1\51\1\52\3\51\1\53\1\51\3\53\3\51\1\53"+
    "\10\51\2\53\2\0\2\53\3\51\10\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\51\1\53"+
    "\1\51\1\53\1\51\1\53\1\51\1\53\1\144\1\145"+
    "\1\32\1\56\1\51\1\53\1\51\2\53\2\0\1\53"+
    "\1\0\30\53\2\0\35\53\2\145\1\0\1\56\4\53"+
    "\1\51\2\0\1\51\1\0\1\51\1\52\3\51\1\53"+
    "\1\51\3\53\1\23\1\51\1\23\1\53\1\51\6\23"+
    "\1\146\1\147\1\53\2\0\2\53\2\23\1\146\2\53"+
    "\5\30\1\150\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\32\1\56\1\23\1\30"+
    "\1\23\1\30\1\53\2\0\1\53\1\0\12\53\1\30"+
    "\1\53\1\30\2\53\6\30\1\150\1\147\1\53\2\0"+
    "\2\53\2\30\1\150\2\53\5\30\1\150\22\30\1\0"+
    "\1\56\4\30\1\106\2\0\1\106\1\0\1\106\1\53"+
    "\20\106\3\151\3\106\2\0\2\106\3\151\2\106\30\151"+
    "\1\0\1\106\4\151\1\152\2\0\1\152\1\0\1\152"+
    "\1\53\26\152\2\0\2\53\13\152\2\153\2\154\2\152"+
    "\2\155\2\156\10\152\1\157\1\160\5\152\2\0\1\152"+
    "\1\0\1\152\1\53\26\152\2\0\2\53\35\152\1\157"+
    "\1\160\4\152\1\32\2\0\1\32\1\0\1\32\1\33"+
    "\3\32\1\0\1\32\3\0\3\32\1\0\10\32\1\0"+
    "\1\161\4\0\3\32\10\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\1\0\1\32\1\0\1\32\1\0"+
    "\1\32\1\0\1\32\35\0\1\161\71\0\1\162\61\0"+
    "\1\51\2\0\1\51\1\0\1\51\1\52\3\51\1\53"+
    "\1\51\3\53\3\51\1\53\10\51\1\53\1\161\2\0"+
    "\2\53\3\51\10\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\51\1\53\1\51\1\53\1\51"+
    "\1\53\1\51\1\53\1\51\1\53\1\32\1\56\1\51"+
    "\1\53\1\51\2\53\2\0\1\53\1\0\27\53\1\161"+
    "\2\0\37\53\1\0\1\56\4\53\1\51\2\0\1\51"+
    "\1\0\1\51\1\52\3\51\1\53\1\51\3\53\1\23"+
    "\1\51\1\23\1\53\1\51\7\23\1\147\1\53\2\0"+
    "\2\53\3\23\2\53\6\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\23\1\30"+
    "\1\23\1\30\1\23\1\30\1\23\1\30\1\32\1\56"+
    "\1\23\1\30\1\23\1\30\1\53\2\0\1\53\1\0"+
    "\27\53\1\163\2\0\37\53\1\0\1\56\5\53\2\0"+
    "\1\53\1\0\12\53\1\30\1\53\1\30\2\53\7\30"+
    "\1\147\1\53\2\0\2\53\3\30\2\53\30\30\1\0"+
    "\1\56\4\30\1\106\2\0\1\106\1\0\1\106\1\135"+
    "\20\106\3\164\3\106\2\0\2\106\3\164\2\106\30\164"+
    "\1\0\1\106\4\164\1\152\2\0\1\152\1\0\1\152"+
    "\1\165\26\152\2\0\2\53\35\152\1\157\1\160\5\152"+
    "\2\0\1\152\1\0\1\152\1\165\26\152\2\0\2\53"+
    "\15\152\2\166\16\152\1\157\1\160\5\152\2\0\1\152"+
    "\1\0\1\152\1\165\26\152\2\0\2\53\25\152\2\167"+
    "\6\152\1\157\1\160\5\152\2\0\1\152\1\0\1\152"+
    "\1\165\26\152\2\0\2\53\23\152\2\170\10\152\1\157"+
    "\1\160\5\152\2\0\1\152\1\0\1\152\1\165\26\152"+
    "\2\0\2\53\31\152\2\171\2\152\1\157\1\160\4\152"+
    "\1\157\2\0\1\157\1\0\1\157\1\172\26\157\4\0"+
    "\43\157\1\173\2\0\1\173\1\0\1\173\1\165\26\173"+
    "\2\0\2\106\35\173\1\157\5\173\1\174\2\0\1\174"+
    "\1\0\30\174\2\0\45\174\15\0\1\175\66\0\1\106"+
    "\2\0\1\106\1\0\1\106\1\135\20\106\3\176\3\106"+
    "\2\0\2\106\3\176\2\106\30\176\1\0\1\106\4\176"+
    "\1\152\2\0\1\152\1\0\1\152\1\53\20\152\3\177"+
    "\3\152\2\0\2\53\3\177\2\152\30\177\1\157\1\160"+
    "\4\177\1\152\2\0\1\152\1\0\1\152\1\165\26\152"+
    "\2\0\2\53\17\152\2\200\14\152\1\157\1\160\5\152"+
    "\2\0\1\152\1\0\1\152\1\165\26\152\2\0\2\53"+
    "\27\152\2\200\4\152\1\157\1\160\5\152\2\0\1\152"+
    "\1\0\1\152\1\165\21\152\1\200\4\152\2\0\2\53"+
    "\6\152\1\200\26\152\1\157\1\160\5\152\2\0\1\152"+
    "\1\0\1\152\1\165\26\152\2\0\2\53\33\152\2\200"+
    "\1\157\1\160\4\152\1\157\2\0\1\157\1\0\1\157"+
    "\1\0\20\157\3\201\3\157\4\0\3\201\2\157\30\201"+
    "\2\157\4\201\1\173\2\0\1\173\1\0\1\173\1\202"+
    "\26\173\2\0\2\106\35\173\1\157\5\173\1\203\2\0"+
    "\1\203\1\0\1\203\1\174\6\203\1\174\17\203\2\0"+
    "\2\174\43\203\1\106\2\0\1\106\1\0\1\106\1\135"+
    "\20\106\3\204\3\106\2\0\2\106\3\204\2\106\30\204"+
    "\1\0\1\106\4\204\1\152\2\0\1\152\1\0\1\152"+
    "\1\165\20\152\3\205\3\152\2\0\2\53\3\205\2\152"+
    "\30\205\1\157\1\160\4\205\1\152\2\0\1\152\1\0"+
    "\1\152\1\165\25\152\1\161\2\0\2\53\35\152\1\157"+
    "\1\160\4\152\1\157\2\0\1\157\1\0\1\157\1\172"+
    "\20\157\3\206\3\157\4\0\3\206\2\157\30\206\2\157"+
    "\4\206\1\173\2\0\1\173\1\0\1\173\1\53\20\173"+
    "\3\207\3\173\2\0\2\106\3\207\2\173\30\207\1\157"+
    "\1\173\4\207\1\152\2\0\1\152\1\0\1\152\1\165"+
    "\20\152\3\210\2\152\1\161\2\0\2\53\3\210\2\152"+
    "\30\210\1\157\1\160\4\210\1\157\2\0\1\157\1\0"+
    "\1\157\1\172\20\157\3\211\2\157\1\161\4\0\3\211"+
    "\2\157\30\211\2\157\4\211\1\173\2\0\1\173\1\0"+
    "\1\173\1\202\20\173\3\212\3\173\2\0\2\106\3\212"+
    "\2\173\30\212\1\157\1\173\4\212\1\152\2\0\1\152"+
    "\1\0\1\152\1\165\20\152\3\200\2\152\1\161\2\0"+
    "\2\53\3\200\2\152\30\200\1\157\1\160\4\200\1\157"+
    "\2\0\1\157\1\0\1\157\1\172\20\157\3\213\2\157"+
    "\1\161\4\0\3\213\2\157\30\213\2\157\4\213\1\173"+
    "\2\0\1\173\1\0\1\173\1\202\20\173\3\214\2\173"+
    "\1\161\2\0\2\106\3\214\2\173\30\214\1\157\1\173"+
    "\4\214\1\157\2\0\1\157\1\0\1\157\1\172\25\157"+
    "\1\161\4\0\43\157\1\173\2\0\1\173\1\0\1\173"+
    "\1\202\20\173\3\215\2\173\1\161\2\0\2\106\3\215"+
    "\2\173\30\215\1\157\1\173\4\215\1\173\2\0\1\173"+
    "\1\0\1\173\1\202\25\173\1\161\2\0\2\106\35\173"+
    "\1\157\5\173";

  private static int [] zzUnpackTrans() {
    int [] result = new int[9044];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\1\1\11\25\1\2\0\12\1\2\0\1\1"+
    "\3\0\2\1\1\0\2\1\10\0\1\1\12\0\2\1"+
    "\1\0\2\1\22\0\2\1\3\0\2\1\1\11\1\0"+
    "\3\1\1\0\1\1\11\0\1\1\1\0\1\1\10\0"+
    "\1\11\1\1\1\0\1\1\2\0\4\1\1\0\6\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[141];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
 private LexedTokenFactory<?> tokenFactory;
 private boolean invertible;
 
 // Convert Arabic digits to ASCII digits
 private boolean normArDigits;
 
 // Convert Arabic punctuation to ASCII equivalents
 private boolean normArPunc;
 
 // Substitute newlines with newlineChar.
 // Otherwise, treat them like whitespace
 private boolean tokenizeNLs;
 public static final String NEWLINE_TOKEN = "*NL*";

 // Use \u2026 for ellipses
 private boolean useUTF8Ellipsis;
 
 // Arabic-specific orthographic normalization rules
 private boolean normAlif;
 private boolean normYa;
 private boolean removeDiacritics;
 private boolean removeTatweel;
 private boolean removeQuranChars;
 
 // Penn ATB vocalized section normalizations
 private boolean removeProMarker;
 private boolean removeSegMarker;
 private boolean removeMorphMarker;
 
 // Lengthening effects (yAAAAAAA): replace three or more of the same character with one
 private boolean removeLengthening;

 private final Pattern segmentationMarker = Pattern.compile("^-+|-+$");
 
 // Escape parens for ATB parsing
 private boolean atbEscaping;

 private Map<String,String> normMap;
 
 public ArabicLexer(Reader r, LexedTokenFactory<?> tf, Properties props) {
   this(r);
   this.tokenFactory = tf;
   
   tokenizeNLs = PropertiesUtils.getBool(props, "tokenizeNLs", false);
   useUTF8Ellipsis = PropertiesUtils.getBool(props, "useUTF8Ellipsis", false);
   invertible = PropertiesUtils.getBool(props, "invertible", false);
   normArDigits = PropertiesUtils.getBool(props, "normArDigits", false);
   normArPunc = PropertiesUtils.getBool(props, "normArPunc", false);
   normAlif = PropertiesUtils.getBool(props, "normAlif", false);
   normYa = PropertiesUtils.getBool(props, "normYa", false);
   removeDiacritics = PropertiesUtils.getBool(props, "removeDiacritics", false);
   removeTatweel = PropertiesUtils.getBool(props, "removeTatweel", false);
   removeQuranChars = PropertiesUtils.getBool(props, "removeQuranChars", false);
   removeProMarker = PropertiesUtils.getBool(props, "removeProMarker", false);
   removeSegMarker = PropertiesUtils.getBool(props, "removeSegMarker", false);
   removeMorphMarker = PropertiesUtils.getBool(props, "removeMorphMarker", false);
   removeLengthening = PropertiesUtils.getBool(props, "removeLengthening", false);
   atbEscaping = PropertiesUtils.getBool(props, "atbEscaping", false);

   setupNormalizationMap();
 }

 private void setupNormalizationMap() {
   normMap = Generics.newHashMap(200);

   // Junk characters that we always remove
   normMap.put("\u0600","#");
   normMap.put("\u0601","");
   normMap.put("\u0602","");
   normMap.put("\u0603","");
   normMap.put("\u0606","\u221B");
   normMap.put("\u0607","\u221C");
   normMap.put("\u0608","");
   normMap.put("\u0609","%");
   normMap.put("\u060A","%");
   normMap.put("\u060B","");
   normMap.put("\u060E","");
   normMap.put("\u060F","");
   normMap.put("\u066E","\u0628");
   normMap.put("\u066F","\u0642");
   normMap.put("\u06CC","\u0649");
   normMap.put("\u06D6","");
   normMap.put("\u06D7","");
   normMap.put("\u06D8","");
   normMap.put("\u06D9","");
   normMap.put("\u06DA","");
   normMap.put("\u06DB","");
   normMap.put("\u06DC","");
   normMap.put("\u06DD","");
   normMap.put("\u06DE","");
   normMap.put("\u06DF","");
   normMap.put("\u06E0","");
   normMap.put("\u06E1","");
   normMap.put("\u06E2","");
   normMap.put("\u06E3","");
   normMap.put("\u06E4","");
   normMap.put("\u06E5","");
   normMap.put("\u06E6","");
   normMap.put("\u06E7","");
   normMap.put("\u06E8","");
   normMap.put("\u06E9","");
   normMap.put("\u06EA","");
   normMap.put("\u06EB","");
   normMap.put("\u06EC","");
   normMap.put("\u06ED","");

   if (normArDigits) {
      normMap.put("\u0660","0");
      normMap.put("\u0661","1");
      normMap.put("\u0662","2");
      normMap.put("\u0663","3");
      normMap.put("\u0664","4");
      normMap.put("\u0665","5");
      normMap.put("\u0666","6");
      normMap.put("\u0667","7");
      normMap.put("\u0668","8");
      normMap.put("\u0669","9");
      normMap.put("\u06F0","0");
      normMap.put("\u06F1","1");
      normMap.put("\u06F2","2");
      normMap.put("\u06F3","3");
      normMap.put("\u06F4","4");
      normMap.put("\u06F5","5");
      normMap.put("\u06F6","6");
      normMap.put("\u06F7","7");
      normMap.put("\u06F8","8");
      normMap.put("\u06F9","9");
   }
   if (normArPunc) {
      normMap.put("\u00BB","\"");
      normMap.put("\u00AB","\"");
      normMap.put("\u060C",",");
      normMap.put("\u060D",",");
      normMap.put("\u061B",";");
      normMap.put("\u061E",".");
      normMap.put("\u061F","?");
      normMap.put("\u066A","%");
      normMap.put("\u066B",",");
      normMap.put("\u066C","\u0027");
      normMap.put("\u066F","*");
      normMap.put("\u06DF",".");
   }
   if (normAlif) {
      normMap.put("\u0622","\u0627");
      normMap.put("\u0623","\u0627");
      normMap.put("\u0625","\u0627");
      normMap.put("\u0671","\u0627");
      normMap.put("\u0672","\u0627");
      normMap.put("\u0673","\u0627");
   }
   if (normYa) {
      normMap.put("\u064A","\u0649");
   }
   if (removeDiacritics) {
      normMap.put("\u064B","");
      normMap.put("\u064C","");
      normMap.put("\u064D","");
      normMap.put("\u064E","");
      normMap.put("\u064F","");
      normMap.put("\u0650","");
      normMap.put("\u0651","");
      normMap.put("\u0652","");
      normMap.put("\u0653","");
      normMap.put("\u0654","");
      normMap.put("\u0655","");
      normMap.put("\u0656","");
      normMap.put("\u0657","");
      normMap.put("\u0658","");
      normMap.put("\u0659","");
      normMap.put("\u065A","");
      normMap.put("\u065B","");
      normMap.put("\u065C","");
      normMap.put("\u065D","");
      normMap.put("\u065E","");
      normMap.put("\u0670","");
   }
   if (removeTatweel) {
      normMap.put("\u0640","");
      normMap.put("_","");
   }
   if (removeQuranChars) {
      // Arabic honorifics
      normMap.put("\u0610","");
      normMap.put("\u0611","");
      normMap.put("\u0612","");
      normMap.put("\u0613","");
      normMap.put("\u0614","");
      normMap.put("\u0615","");
      normMap.put("\u0616","");
      normMap.put("\u0617","");
      normMap.put("\u0618","");
      normMap.put("\u0619","");
      normMap.put("\u061A","");
   }
   if (atbEscaping) {
      normMap.put("(","-LRB-");
      normMap.put(")","-RRB-");
   }
 }

 private String normalizeToken(String text, boolean isWord) {
   // Remove segmentation markers from the ATB
   if (isWord && removeSegMarker) {
     text = segmentationMarker.matcher(text).replaceAll("");
   }
   int len = text.length();
   StringBuilder sb = new StringBuilder(len);
   for (int i = 0; i < len; ++i) {
     String thisChar = String.valueOf(text.charAt(i));
     // Remove morpheme markers from the ATB vocalized section
     if (isWord && removeMorphMarker && thisChar.equals("+")) {
       continue;
     }
     if (removeLengthening && isLengthening(text, i)) {
       continue;
     }
     if (normMap.containsKey(thisChar)) {
       thisChar = normMap.get(thisChar);
     }
     if (thisChar.length() > 0) {
       sb.append(thisChar);
     }
   }
   return sb.toString();
 }
 
 private boolean isLengthening(String text, int pos) {
   if (pos == 0) return false;
   String thisChar = String.valueOf(text.charAt(pos));
   if (!thisChar.equals(String.valueOf(text.charAt(pos - 1))))
     return false;
   if (pos < text.length() - 1 && thisChar.equals(String.valueOf(text.charAt(pos + 1))))
     return true;
   if (pos >= 2 && thisChar.equals(String.valueOf(text.charAt(pos - 2))))
     return true;
   return false;
 }
 
   /** Make the next token.
   *
   *  @param txt What the token should be
   *  @param originalText The original String that got transformed into txt
   */
  private Object getNext(String txt, String originalText) {
    if (tokenFactory == null) {
      throw new RuntimeException(this.getClass().getName() + ": Token factory is null.");
    }
    if (invertible) {
      //String str = prevWordAfter.toString();
      //prevWordAfter.setLength(0);
      CoreLabel word = (CoreLabel) tokenFactory.makeToken(txt, yychar, yylength());
      word.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
      //word.set(CoreAnnotations.BeforeAnnotation.class, str);
      //prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
      //prevWord = word;
      return word;
    } else {
      return tokenFactory.makeToken(txt, yychar, yylength());
    }
  }
  
  private Object getNext(boolean isWord) {
    String text = yytext();
    String normText = normalizeToken(text, isWord);
    return getNext(normText, text);
  }

  private Object getEllipsis() {
    String ellipsisString = useUTF8Ellipsis ? "\u2026" : "...";
    return getNext(ellipsisString, yytext());
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  ArabicLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  ArabicLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader
             (in, java.nio.charset.Charset.forName("UTF-8")));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1960) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

    // numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Object next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { System.err.printf("Untokenizable: %s%n", yytext());
	      return getNext(true);
          }
        case 9: break;
        case 2: 
          { if (tokenizeNLs) {
                return getNext(NEWLINE_TOKEN, yytext());
              }
          }
        case 10: break;
        case 3: 
          { 
          }
        case 11: break;
        case 4: 
          { return getNext(false);
          }
        case 12: break;
        case 5: 
          { return getNext(true);
          }
        case 13: break;
        case 6: 
          { return getEllipsis();
          }
        case 14: break;
        case 7: 
          { if (! removeProMarker) return getNext(false);
          }
        case 15: break;
        case 8: 
          { if (removeProMarker) {
                if ( ! removeSegMarker) {
                  return getNext("-", yytext());
                }
              } else {
                return getNext(false);
              }
          }
        case 16: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return null;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
