/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.treebank;

import edu.stanford.nlp.io.FileSystem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DistributionPackage {
    private final List<String> distFiles = new ArrayList<String>();
    private String lastCreatedDistribution = "UNKNOWN";

    public void addFiles(List<String> fileList) {
        this.distFiles.addAll(fileList);
    }

    public boolean make(String distribName) {
        boolean createdDir = new File(distribName).mkdir();
        if (createdDir) {
            String currentFile = "";
            try {
                Iterator<String> iterator = this.distFiles.iterator();
                while (iterator.hasNext()) {
                    String filename;
                    currentFile = filename = iterator.next();
                    File destFile = new File(filename);
                    String relativePath = distribName + "/" + destFile.getName();
                    destFile = new File(relativePath);
                    FileSystem.copyFile(new File(filename), destFile);
                }
                String tarFileName = String.format("%s.tar", distribName);
                Runtime r = Runtime.getRuntime();
                Process p = r.exec(String.format("tar -cf %s %s/", tarFileName, distribName));
                if (p.waitFor() == 0) {
                    File tarFile = new File(tarFileName);
                    FileSystem.gzipFile(tarFile, new File(tarFileName + ".gz"));
                    tarFile.delete();
                    FileSystem.deleteDir(new File(distribName));
                    this.lastCreatedDistribution = distribName;
                    return true;
                }
                System.err.printf("%s: Unable to create tar file %s\n", this.getClass().getName(), tarFileName);
            }
            catch (IOException e) {
                System.err.printf("%s: Unable to add file %s to distribution %s\n", this.getClass().getName(), currentFile, distribName);
            }
            catch (InterruptedException e) {
                System.err.printf("%s: tar did not return from building %s.tar\n", this.getClass().getName(), distribName);
            }
        } else {
            System.err.printf("%s: Unable to create temp directory %s\n", this.getClass().getName(), distribName);
        }
        return false;
    }

    public String toString() {
        String header = String.format("Distributable package %s (%d files)\n", this.lastCreatedDistribution, this.distFiles.size());
        StringBuilder sb = new StringBuilder(header);
        sb.append("--------------------------------------------------------------------\n");
        for (String filename : this.distFiles) {
            sb.append(String.format("  %s\n", filename));
        }
        return sb.toString();
    }
}

