/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.tregex.tsurgeon.AdjoinNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.AdjoinToFootNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.AdjoinToHeadNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexNodes;
import edu.stanford.nlp.trees.tregex.tsurgeon.CreateSubtreeNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.DeleteNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.ExciseNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.FetchNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.IfExistsNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.InsertNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.JJTTsurgeonParserState;
import edu.stanford.nlp.trees.tregex.tsurgeon.MoveNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.Node;
import edu.stanford.nlp.trees.tregex.tsurgeon.ParseException;
import edu.stanford.nlp.trees.tregex.tsurgeon.PruneNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.RelabelNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.ReplaceNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.SimpleCharStream;
import edu.stanford.nlp.trees.tregex.tsurgeon.SimpleNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.Token;
import edu.stanford.nlp.trees.tregex.tsurgeon.TreeLocation;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParserConstants;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParserTokenManager;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParserTreeConstants;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Generics;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class TsurgeonParser
implements TsurgeonParserTreeConstants,
TsurgeonParserConstants {
    protected JJTTsurgeonParserState jjtree = new JJTTsurgeonParserState();
    private TreeFactory treeFactory = new LabeledScoredTreeFactory();
    public TsurgeonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[10];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) {
        System.out.println("Reading from standard input...");
        TsurgeonParser t = new TsurgeonParser(System.in);
        try {
            TsurgeonPatternRoot n = t.Root();
            System.out.println(n.toString());
            System.out.println("Thank you.");
        }
        catch (Exception e) {
            System.out.println("Oops.");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public final TsurgeonPatternRoot Root() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(0);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<TsurgeonPattern> results = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    TsurgeonPattern result = this.Operation();
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    if ("" != null) {
                        TsurgeonPatternRoot tsurgeonPatternRoot = new TsurgeonPatternRoot(result);
                        return tsurgeonPatternRoot;
                    }
                    break;
                }
                case 6: {
                    this.jj_consume_token(6);
                    this.jj_consume_token(7);
                    Token name = this.jj_consume_token(20);
                    TsurgeonPatternRoot result = this.Root();
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    if ("" != null) {
                        TsurgeonPatternRoot tsurgeonPatternRoot = new TsurgeonPatternRoot(new IfExistsNode(name.image, result.children));
                        return tsurgeonPatternRoot;
                    }
                    break;
                }
                case 5: {
                    block16: while (true) {
                        this.jj_consume_token(5);
                        TsurgeonPatternRoot result = this.Root();
                        this.jj_consume_token(21);
                        if (results == null) {
                            results = Generics.newArrayList();
                        }
                        for (TsurgeonPattern child : result.children) {
                            results.add(child);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                continue block16;
                            }
                        }
                        break;
                    }
                    this.jj_la1[0] = this.jj_gen;
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    TsurgeonPattern[] array = new TsurgeonPattern[results.size()];
                    if ("" != null) {
                        TsurgeonPatternRoot tsurgeonPatternRoot = new TsurgeonPatternRoot(results.toArray(array));
                        return tsurgeonPatternRoot;
                    }
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final TsurgeonPattern Operation() throws ParseException {
        block75: {
            SimpleNode jjtn000 = new SimpleNode(1);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            TsurgeonPattern child2 = null;
            Token newLabel = null;
            TreeLocation loc = null;
            AuxiliaryTree tree = null;
            List<AuxiliaryTree> treeList = null;
            List<TsurgeonPattern> nodeSelections = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        Token operator = this.jj_consume_token(8);
                        nodeSelections = this.NodeSelectionList(new ArrayList<TsurgeonPattern>());
                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                        jjtc000 = false;
                        if ("" != null) {
                            DeleteNode deleteNode = new DeleteNode(nodeSelections);
                            return deleteNode;
                        }
                        break;
                    }
                    case 9: {
                        Token operator = this.jj_consume_token(9);
                        nodeSelections = this.NodeSelectionList(new ArrayList<TsurgeonPattern>());
                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                        jjtc000 = false;
                        if ("" != null) {
                            PruneNode pruneNode = new PruneNode(nodeSelections);
                            return pruneNode;
                        }
                        break;
                    }
                    case 11: {
                        Token operator = this.jj_consume_token(11);
                        TsurgeonPattern child1 = this.NodeSelection();
                        child2 = this.NodeSelection();
                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                        jjtc000 = false;
                        if ("" != null) {
                            ExciseNode exciseNode = new ExciseNode(child1, child2);
                            return exciseNode;
                        }
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        if (this.jj_2_1(3)) {
                            Token operator = this.jj_consume_token(10);
                            TsurgeonPattern child1 = this.NodeSelection();
                            newLabel = this.jj_consume_token(24);
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            if ("" != null) {
                                RelabelNode relabelNode = new RelabelNode(child1, newLabel.image);
                                return relabelNode;
                            }
                            break;
                        }
                        if (this.jj_2_2(3)) {
                            Token operator = this.jj_consume_token(10);
                            TsurgeonPattern child1 = this.NodeSelection();
                            newLabel = this.jj_consume_token(27);
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            if ("" != null) {
                                RelabelNode relabelNode = new RelabelNode(child1, newLabel.image);
                                return relabelNode;
                            }
                            break;
                        }
                        if (this.jj_2_3(3)) {
                            Token operator = this.jj_consume_token(10);
                            TsurgeonPattern child1 = this.NodeSelection();
                            Token regex = this.jj_consume_token(26);
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            if ("" != null) {
                                RelabelNode relabelNode = new RelabelNode(child1, regex.image);
                                return relabelNode;
                            }
                            break;
                        }
                        if (this.jj_2_4(3)) {
                            Token operator = this.jj_consume_token(10);
                            TsurgeonPattern child1 = this.NodeSelection();
                            newLabel = this.jj_consume_token(23);
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            if ("" != null) {
                                RelabelNode relabelNode = new RelabelNode(child1, newLabel.image);
                                return relabelNode;
                            }
                            break;
                        }
                        if (this.jj_2_5(3)) {
                            Token operator = this.jj_consume_token(14);
                            TsurgeonPattern child1 = this.NodeSelection();
                            child2 = this.NodeSelection();
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            if ("" != null) {
                                ReplaceNode replaceNode = new ReplaceNode(child1, child2);
                                return replaceNode;
                            }
                            break;
                        }
                        if (this.jj_2_6(3)) {
                            Token operator = this.jj_consume_token(14);
                            TsurgeonPattern child1 = this.NodeSelection();
                            treeList = this.TreeList(false);
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            if ("" != null) {
                                ReplaceNode replaceNode = new ReplaceNode(child1, treeList);
                                return replaceNode;
                            }
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 13: {
                                Token operator = this.jj_consume_token(13);
                                TsurgeonPattern child1 = this.NodeSelection();
                                loc = this.Location();
                                this.jjtree.closeNodeScope((Node)jjtn000, true);
                                jjtc000 = false;
                                if ("" != null) {
                                    MoveNode moveNode = new MoveNode(child1, loc);
                                    return moveNode;
                                }
                                break block75;
                            }
                            default: {
                                this.jj_la1[4] = this.jj_gen;
                                if (this.jj_2_7(3)) {
                                    Token operator = this.jj_consume_token(12);
                                    TsurgeonPattern child1 = this.NodeSelection();
                                    loc = this.Location();
                                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                                    jjtc000 = false;
                                    if ("" != null) {
                                        InsertNode insertNode = new InsertNode(child1, loc);
                                        return insertNode;
                                    }
                                    break block75;
                                }
                                if (this.jj_2_8(3)) {
                                    Token operator = this.jj_consume_token(12);
                                    tree = this.TreeRoot(false);
                                    loc = this.Location();
                                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                                    jjtc000 = false;
                                    if ("" != null) {
                                        InsertNode insertNode = new InsertNode(tree, loc);
                                        return insertNode;
                                    }
                                    break block75;
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 15: {
                                        Token operator = this.jj_consume_token(15);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 24: {
                                                newLabel = this.jj_consume_token(24);
                                                break;
                                            }
                                            case 29: {
                                                newLabel = this.jj_consume_token(29);
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[2] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        nodeSelections = this.NodeSelectionList(new ArrayList<TsurgeonPattern>());
                                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                                        jjtc000 = false;
                                        if (nodeSelections.size() == 1) {
                                            if ("" != null) {
                                                CreateSubtreeNode createSubtreeNode = new CreateSubtreeNode(nodeSelections.get(0), newLabel.image);
                                                return createSubtreeNode;
                                            }
                                            break block75;
                                        }
                                        if (nodeSelections.size() == 2) {
                                            if ("" != null) {
                                                CreateSubtreeNode createSubtreeNode = new CreateSubtreeNode(nodeSelections.get(0), nodeSelections.get(1), newLabel.image);
                                                return createSubtreeNode;
                                            }
                                            break block75;
                                        }
                                        throw new ParseException("Illegal number of nodes given to createSubtree (" + nodeSelections.size() + ")");
                                    }
                                    case 16: {
                                        Token operator = this.jj_consume_token(16);
                                        tree = this.TreeRoot(true);
                                        TsurgeonPattern child1 = this.NodeSelection();
                                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                                        jjtc000 = false;
                                        if ("" != null) {
                                            AdjoinNode adjoinNode = new AdjoinNode(tree, child1);
                                            return adjoinNode;
                                        }
                                        break block75;
                                    }
                                    case 17: {
                                        Token operator = this.jj_consume_token(17);
                                        tree = this.TreeRoot(true);
                                        TsurgeonPattern child1 = this.NodeSelection();
                                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                                        jjtc000 = false;
                                        if ("" != null) {
                                            AdjoinToHeadNode adjoinToHeadNode = new AdjoinToHeadNode(tree, child1);
                                            return adjoinToHeadNode;
                                        }
                                        break block75;
                                    }
                                    case 18: {
                                        Token operator = this.jj_consume_token(18);
                                        tree = this.TreeRoot(true);
                                        TsurgeonPattern child1 = this.NodeSelection();
                                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                                        jjtc000 = false;
                                        if ("" != null) {
                                            AdjoinToFootNode adjoinToFootNode = new AdjoinToFootNode(tree, child1);
                                            return adjoinToFootNode;
                                        }
                                        break block75;
                                    }
                                    case 19: {
                                        Token operator = this.jj_consume_token(19);
                                        nodeSelections = this.NodeSelectionList(new ArrayList<TsurgeonPattern>());
                                        this.jjtree.closeNodeScope((Node)jjtn000, true);
                                        jjtc000 = false;
                                        if ("" != null) {
                                            CoindexNodes coindexNodes = new CoindexNodes(nodeSelections.toArray(new TsurgeonPattern[0]));
                                            return coindexNodes;
                                        }
                                        break block75;
                                    }
                                    default: {
                                        this.jj_la1[5] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                }
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final TreeLocation Location() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token rel = this.jj_consume_token(25);
            TsurgeonPattern child = this.NodeSelection();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if ("" != null) {
                TreeLocation treeLocation = new TreeLocation(rel.image, child);
                return treeLocation;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final List<TsurgeonPattern> NodeSelectionList(List<TsurgeonPattern> l) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(3);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            TsurgeonPattern result = this.NodeSelection();
            l.add(result);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block8;
                    }
                }
                result = this.NodeSelection();
                l.add(result);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if ("" != null) {
                List<TsurgeonPattern> list = l;
                return list;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final TsurgeonPattern NodeSelection() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(4);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            TsurgeonPattern result = this.NodeName();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if ("" != null) {
                TsurgeonPattern tsurgeonPattern = result;
                return tsurgeonPattern;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TsurgeonPattern NodeName() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t = this.jj_consume_token(24);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if ("" != null) {
                FetchNode fetchNode = new FetchNode(t.image);
                return fetchNode;
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final List<AuxiliaryTree> TreeList(boolean requiresFoot) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(6);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<AuxiliaryTree> trees = Generics.newArrayList();
        try {
            AuxiliaryTree tree = this.TreeRoot(requiresFoot);
            trees.add(tree);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: 
                    case 29: 
                    case 30: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block8;
                    }
                }
                tree = this.TreeRoot(requiresFoot);
                trees.add(tree);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if ("" != null) {
                ArrayList<AuxiliaryTree> arrayList = trees;
                return arrayList;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final AuxiliaryTree TreeRoot(boolean requiresFoot) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(7);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Tree t = this.TreeNode();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if ("" != null) {
                AuxiliaryTree auxiliaryTree = new AuxiliaryTree(t, requiresFoot);
                return auxiliaryTree;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Tree TreeNode() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(8);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        List<Tree> dtrs = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 30: {
                    Token label = this.jj_consume_token(30);
                    dtrs = this.TreeDtrs(new ArrayList<Tree>());
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    if ("" != null) {
                        Tree tree = this.treeFactory.newTreeNode(label.image.substring(1), dtrs);
                        return tree;
                    }
                    break;
                }
                case 29: {
                    Token label = this.jj_consume_token(29);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    if ("" != null) {
                        Tree tree = this.treeFactory.newTreeNode(label.image, new ArrayList<Tree>());
                        return tree;
                    }
                    break;
                }
                case 24: {
                    Token label = this.jj_consume_token(24);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    if ("" != null) {
                        Tree tree = this.treeFactory.newTreeNode(label.image, new ArrayList<Tree>());
                        return tree;
                    }
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Tree> TreeDtrs(List<Tree> dtrs) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(9);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: 
                case 29: 
                case 30: {
                    Tree tree = this.TreeNode();
                    this.TreeDtrs(dtrs);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    dtrs.add(0, tree);
                    if ("" != null) {
                        List<Tree> list = dtrs;
                        return list;
                    }
                    break;
                }
                case 31: {
                    this.jj_consume_token(31);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    if ("" != null) {
                        List<Tree> list = dtrs;
                        return list;
                    }
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3R_5() {
        return this.jj_3R_7();
    }

    private boolean jj_3R_15() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_14() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_15()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_4() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_3R_6();
    }

    private boolean jj_3R_11() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_3R_6();
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_11()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_12()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_10() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_3R_4();
    }

    private boolean jj_3R_7() {
        return this.jj_3R_9();
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_6() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 1048416, 0x21000000, 2816, 8192, 1015808, 0x1000000, 0x61000000, 0x61000000, -520093696};
    }

    public TsurgeonParser(InputStream stream) {
        this(stream, null);
    }

    public TsurgeonParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TsurgeonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TsurgeonParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TsurgeonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TsurgeonParser(TsurgeonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(TsurgeonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 10; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 32; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        TsurgeonParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

