/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;

public class NoisyLabelLinearCliquePotentialFunction
implements CliquePotentialFunction {
    double[][] weights;
    int[] docLabels;
    double[][] errorMatrix;

    public NoisyLabelLinearCliquePotentialFunction(double[][] weights, int[] docLabels, double[][] errorMatrix) {
        this.weights = weights;
        this.docLabels = docLabels;
        this.errorMatrix = errorMatrix;
    }

    private double g(int labelIndex, int posInSent) {
        if (this.errorMatrix == null) {
            return 0.0;
        }
        int observed = this.docLabels[posInSent];
        int truth = labelIndex;
        return this.errorMatrix[truth][observed];
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures, double[] featureVal, int posInSent) {
        double output = 0.0;
        double dotProd = 0.0;
        for (int m = 0; m < cliqueFeatures.length; ++m) {
            dotProd = this.weights[cliqueFeatures[m]][labelIndex];
            output += dotProd;
        }
        if (cliqueSize == 1) {
            output += this.g(labelIndex, posInSent);
        }
        return output;
    }
}

