/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.EntityBIO;
import edu.stanford.nlp.ie.EntityCachingAbstractSequencePriorBIO;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import java.util.List;

public class EmpiricalNERPriorBIO<IN extends CoreMap>
extends EntityCachingAbstractSequencePriorBIO<IN> {
    private double[][] entityMatrix;
    private double[][] subEntityMatrix;
    private SeqClassifierFlags flags;
    protected double p1 = Math.log(0.01);
    protected double p2 = Math.log(2.0);
    protected int ORGIndex;
    protected int LOCIndex;
    public static boolean DEBUG = false;

    public EmpiricalNERPriorBIO(String backgroundSymbol, Index<String> classIndex, Index<String> tagIndex, List<IN> doc, Pair<double[][], double[][]> matrices, SeqClassifierFlags flags) {
        super(backgroundSymbol, classIndex, tagIndex, doc);
        this.entityMatrix = matrices.first();
        this.subEntityMatrix = matrices.second();
        this.flags = flags;
        this.ORGIndex = tagIndex.indexOf("ORG");
        this.LOCIndex = tagIndex.indexOf("LOC");
    }

    @Override
    public double scoreOf(int[] sequence) {
        double p = 0.0;
        for (int i = 0; i < this.entities.length; ++i) {
            EntityBIO entity = this.entities[i];
            if (i != 0 && this.entities[i - 1] == entity || entity == null) continue;
            int length = entity.words.size();
            int tag1 = entity.type;
            int[] other = this.entities[i].otherOccurrences;
            for (int j = 0; j < other.length; ++j) {
                EntityBIO otherEntity = null;
                for (int k = other[j]; k < other[j] + length && k < this.entities.length && (otherEntity = this.entities[k]) == null; ++k) {
                }
                if (otherEntity == null) continue;
                int oLength = otherEntity.words.size();
                int tag2 = otherEntity.type;
                boolean exact = false;
                int[] oOther = otherEntity.otherOccurrences;
                for (int k = 0; k < oOther.length; ++k) {
                    if (oOther[k] < i || oOther[k] > i + length - 1) continue;
                    exact = true;
                    break;
                }
                double factor = 0.0;
                if (exact) {
                    if (DEBUG) {
                        System.err.print("Exact match of tag1=" + (String)this.tagIndex.get(tag1) + ", tag2=" + (String)this.tagIndex.get(tag2));
                    }
                    if (length != oLength) {
                        if (tag1 == tag2) {
                            p += (double)Math.abs(oLength - length) * this.p1;
                        } else if (!(tag1 == this.ORGIndex && tag2 == this.LOCIndex || tag1 == this.LOCIndex && tag2 == this.ORGIndex)) {
                            p += (double)(oLength + length) * this.p1;
                        }
                    }
                    factor = this.entityMatrix[tag1][tag2];
                } else {
                    if (DEBUG) {
                        System.err.print("Sub  match of tag1=" + (String)this.tagIndex.get(tag1) + ", tag2=" + (String)this.tagIndex.get(tag2));
                    }
                    factor = this.subEntityMatrix[tag1][tag2];
                }
                if (tag1 == tag2) {
                    factor = this.flags.matchNERIncentive ? this.p2 : 0.0;
                }
                if (DEBUG) {
                    System.err.println(" of factor=" + factor + ", p += " + (double)length * factor);
                }
                p += (double)length * factor;
            }
        }
        return p;
    }
}

