/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.trees.international.pennchinese.RadicalMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.wordseg.CorpusDictionary;
import edu.stanford.nlp.wordseg.NonDict2;
import edu.stanford.nlp.wordseg.TagAffixDetector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChineseSegmenterFeatureFactory<IN extends CoreLabel>
extends FeatureFactory<IN>
implements Serializable {
    private static final long serialVersionUID = 3387166382968763350L;
    private static TagAffixDetector taDetector = null;
    private static Pattern patE = Pattern.compile("[a-z]");
    private static Pattern patEC = Pattern.compile("[A-Z]");
    private static Pattern patP = Pattern.compile("[\u00b7\\-\\.]");
    private static CorpusDictionary outDict = null;

    @Override
    public void init(SeqClassifierFlags flags) {
        super.init(flags);
    }

    @Override
    public Collection<String> getCliqueFeatures(PaddedList<IN> cInfo, int loc, Clique clique) {
        Set<String> features = Generics.newHashSet();
        if (clique == cliqueC) {
            this.addAllInterningAndSuffixing(features, this.featuresC(cInfo, loc), "C");
        } else if (clique == cliqueCpC) {
            this.addAllInterningAndSuffixing(features, this.featuresCpC(cInfo, loc), "CpC");
            this.addAllInterningAndSuffixing(features, this.featuresCnC(cInfo, loc - 1), "CnC");
        }
        return features;
    }

    private static String isEnglish(String Ep, String Ec) {
        String chp = Ep;
        String chc = Ec;
        Matcher mp = patE.matcher(chp);
        Matcher mc = patE.matcher(chc);
        Matcher mpC = patEC.matcher(chp);
        Matcher mcC = patEC.matcher(chc);
        if (mp.matches() && mcC.matches()) {
            return "BND";
        }
        if (mp.matches() && mc.matches()) {
            return "ENG";
        }
        if (mpC.matches() && mcC.matches()) {
            return "BCC";
        }
        if (mp.matches() && !mc.matches() && !mcC.matches()) {
            return "e1";
        }
        if (mc.matches() && !mp.matches() && !mpC.matches()) {
            return "e2";
        }
        if (mpC.matches() && !mc.matches() && !mcC.matches()) {
            return "e3";
        }
        if (mcC.matches() && !mp.matches() && !mpC.matches()) {
            return "e4";
        }
        return "";
    }

    private static String isEngPU(String Ep) {
        Matcher mp = patP.matcher(Ep);
        if (mp.matches()) {
            return "1:EngPU";
        }
        return "";
    }

    protected Collection<String> featuresC(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel c1 = (CoreLabel)cInfo.get(loc + 1);
        CoreLabel c2 = (CoreLabel)cInfo.get(loc + 2);
        CoreLabel c3 = (CoreLabel)cInfo.get(loc + 3);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charc1 = (String)c1.get(CoreAnnotations.CharAnnotation.class);
        String charc2 = (String)c2.get(CoreAnnotations.CharAnnotation.class);
        String charc3 = (String)c3.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        String charp2 = (String)p2.get(CoreAnnotations.CharAnnotation.class);
        String charp3 = (String)p3.get(CoreAnnotations.CharAnnotation.class);
        if (this.flags.useWord1) {
            features.add(charc + "c");
            features.add(charc1 + "c1");
            features.add(charp + "p");
            features.add(charp + charc + "pc");
            if (this.flags.useAs || this.flags.useMsr || this.flags.usePk || this.flags.useHk) {
                features.add(charc + charc1 + "cc1");
                features.add(charp + charc1 + "pc1");
            }
            features.add("|word1");
        }
        return features;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection<String> featuresCpC(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel c1 = (CoreLabel)cInfo.get(loc + 1);
        CoreLabel c2 = (CoreLabel)cInfo.get(loc + 2);
        CoreLabel c3 = (CoreLabel)cInfo.get(loc + 3);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charc1 = (String)c1.get(CoreAnnotations.CharAnnotation.class);
        String charc2 = (String)c2.get(CoreAnnotations.CharAnnotation.class);
        String charc3 = (String)c3.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        String charp2 = (String)p2.get(CoreAnnotations.CharAnnotation.class);
        String charp3 = (String)p3.get(CoreAnnotations.CharAnnotation.class);
        if (this.flags.useWord2) {
            features.add(charc + "c");
            features.add(charc1 + "c1");
            features.add(charp + "p");
            features.add(charp + charc + "pc");
            if (this.flags.useMsr) {
                features.add(charc + charc1 + "cc1");
                features.add(charp + charc1 + "pc1");
            }
            features.add("|word2");
        }
        char rcharc = charc.length() == 0 ? (char)'n' : (char)RadicalMap.getRadical(charc.charAt(0));
        char rcharc1 = charc1.length() == 0 ? (char)'n' : (char)RadicalMap.getRadical(charc1.charAt(0));
        int rcharc2 = charc2.length() == 0 ? 110 : (int)RadicalMap.getRadical(charc2.charAt(0));
        int rcharc3 = charc3.length() == 0 ? 110 : (int)RadicalMap.getRadical(charc3.charAt(0));
        char rcharp = charp.length() == 0 ? (char)'n' : (char)RadicalMap.getRadical(charp.charAt(0));
        int rcharp2 = charp2.length() == 0 ? 110 : (int)RadicalMap.getRadical(charp2.charAt(0));
        int rcharp3 = charp3.length() == 0 ? 110 : (int)RadicalMap.getRadical(charp3.charAt(0));
        if (this.flags.useRad2) {
            features.add(rcharc + "rc");
            features.add(rcharc1 + "rc1");
            features.add(rcharp + "rp");
            features.add(rcharp + rcharc + "rpc");
            features.add(rcharc + rcharc1 + "rcc1");
            features.add(rcharp + rcharc + rcharc1 + "rpcc1");
            features.add("|rad2");
        }
        if (this.flags.useDict2) {
            NonDict2 nd = new NonDict2(this.flags);
            features.add(nd.checkDic(charp + charc, this.flags) + "nondict");
            features.add("|useDict2");
        }
        if (this.flags.useOutDict2) {
            if (outDict == null) {
                System.err.println("reading " + this.flags.outDict2 + " as a seen lexicon");
                outDict = new CorpusDictionary(this.flags.outDict2);
            }
            features.add(outDict.getW(charp + charc) + "outdict");
            features.add(outDict.getW(charc + charc1) + "outdict");
            features.add(outDict.getW(charp2 + charp) + "outdict");
            features.add(outDict.getW(charp2 + charp + charc) + "outdict");
            features.add(outDict.getW(charp3 + charp2 + charp) + "outdict");
            features.add(outDict.getW(charp + charc + charc1) + "outdict");
            features.add(outDict.getW(charc + charc1 + charc2) + "outdict");
            features.add(outDict.getW(charp + charc + charc1 + charc2) + "outdict");
        }
        if (this.flags.useCTBChar2 || this.flags.useASBCChar2 || this.flags.useHKChar2 || this.flags.usePKChar2 || this.flags.useMSRChar2) {
            String[] tagsets;
            if (this.flags.useChPos) {
                if (this.flags.useCTBChar2) {
                    tagsets = new String[]{"AD", "AS", "BA", "CC", "CD", "CS", "DE", "DT", "ETC", "IJ", "JJ", "LB", "LC", "M", "NN", "NR", "NT", "OD", "P", "PN", "PU", "SB", "SP", "VA", "VC", "VE", "VV"};
                } else {
                    if (!this.flags.usePKChar2) throw new RuntimeException("only support settings for CTB and PK now.");
                    tagsets = new String[]{"2", "3", "4"};
                }
            } else {
                tagsets = new String[]{"2", "3", "4"};
            }
            if (taDetector == null) {
                taDetector = new TagAffixDetector(this.flags);
            }
            for (int k = 0; k < tagsets.length; ++k) {
                features.add(taDetector.checkDic(tagsets[k] + "p", charp) + taDetector.checkDic(tagsets[k] + "i", charp) + taDetector.checkDic(tagsets[k] + "s", charc) + taDetector.checkInDic(charp) + taDetector.checkInDic(charc) + tagsets[k] + "prep-sufc");
            }
        }
        if (this.flags.useRule2) {
            if (charp.equals(charc)) {
                features.add("11");
            }
            if (charp.equals(charc1)) {
                features.add("22");
            }
            if (!this.flags.usePk && !this.flags.useHk && charc.equals(charc2)) {
                features.add("33");
            }
            int cur1 = 32;
            int cur2 = 32;
            int cur = 32;
            int pre = 32;
            if (charc1.length() > 0) {
                cur1 = charc1.charAt(0);
            }
            if (charc2.length() > 0) {
                cur2 = charc2.charAt(0);
            }
            if (charc.length() > 0) {
                cur = charc.charAt(0);
            }
            if (charp.length() > 0) {
                pre = charp.charAt(0);
            }
            String prer = String.valueOf(rcharp);
            Pattern E = Pattern.compile("[a-zA-Z]");
            Pattern N = Pattern.compile("[0-9]");
            Matcher m = E.matcher(charp);
            Matcher ce = E.matcher(charc);
            Matcher pe = E.matcher(charp2);
            Matcher cn = N.matcher(charc);
            Matcher pn = N.matcher(charp2);
            if (cur >= 48 && cur <= 57 && pre >= 48 && pre <= 57) {
                if (cur == 57 && pre == 49 && cur1 == 57 && cur2 >= 48 && cur2 <= 57) {
                    features.add("YR");
                } else {
                    features.add("2N");
                }
            } else if (pre >= 48 && pre <= 57) {
                features.add("1N");
            } else if (m.matches()) {
                features.add("E");
            } else if (prer.equals(".") && charp.length() == 1) {
                if (!this.flags.useHk && !this.flags.usePk) {
                    if (ce.matches()) {
                        features.add("PU+E");
                    }
                    if (pe.matches()) {
                        features.add("E+PU");
                    }
                    if (cn.matches()) {
                        features.add("PU+N");
                    }
                    if (pn.matches()) {
                        features.add("N+PU");
                    }
                }
                features.add("PU");
            }
            String engType = ChineseSegmenterFeatureFactory.isEnglish(charp, charc);
            String engPU = ChineseSegmenterFeatureFactory.isEngPU(charp);
            if (!engType.equals("")) {
                features.add(engType);
            }
            if (!engPU.equals("") && !engType.equals("")) {
                features.add(engPU + engType);
            }
        }
        String origS = (String)c.get(CoreAnnotations.OriginalCharAnnotation.class);
        char origC = ' ';
        if (origS.length() > 0) {
            origC = origS.charAt(0);
        }
        int type = Character.getType(origC);
        switch (type) {
            case 1: 
            case 2: {
                features.add("CHARTYPE-LETTER");
                return features;
            }
            case 9: {
                features.add("CHARTYPE-DECIMAL_DIGIT_NUMBER");
                return features;
            }
            case 5: {
                features.add("CHARTYPE-OTHER_LETTER");
                return features;
            }
            default: {
                features.add("CHARTYPE-MISC");
            }
        }
        return features;
    }

    protected Collection<String> featuresCnC(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel c1 = (CoreLabel)cInfo.get(loc + 1);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charc1 = (String)c1.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        if (this.flags.useWordn) {
            features.add(charc + "c");
            features.add(charc1 + "c1");
            features.add(charp + "p");
            features.add(charp + charc + "pc");
            if (this.flags.useAs || this.flags.useMsr || this.flags.usePk || this.flags.useHk) {
                features.add(charc + charc1 + "cc1");
                features.add(charp + charc1 + "pc1");
            }
            features.add("|wordn");
        }
        return features;
    }
}

