/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.ie.crf.HasCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.NonLinearCliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;
import edu.stanford.nlp.optimization.HasL1ParamRange;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Triple;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class CRFNonLinearLogConditionalObjectiveFunction
extends AbstractCachingDiffFunction
implements HasCliquePotentialFunction,
HasL1ParamRange {
    public static final int NO_PRIOR = 0;
    public static final int QUADRATIC_PRIOR = 1;
    public static final int HUBER_PRIOR = 2;
    public static final int QUARTIC_PRIOR = 3;
    public static final int L1_PRIOR = 4;
    public static final int L1_NODE_L2_EDGE_PRIOR = 5;
    public static final int L1_SPARSENODE_L2_EDGE_PRIOR = 6;
    boolean useOutputLayer;
    boolean useHiddenLayer;
    boolean useSigmoid;
    SeqClassifierFlags flags;
    int count = 0;
    protected int prior;
    protected double sigma;
    protected double priorL1Lambda;
    protected double epsilon;
    Random random = new Random(Integer.MAX_VALUE);
    List<Index<CRFLabel>> labelIndices;
    Index<String> classIndex;
    double[][] Ehat;
    double[][] Uhat;
    double[][] What;
    int window;
    int numClasses;
    int numHiddenUnits;
    int[] map;
    int[][][][] data;
    double[][][][] featureVal;
    int[][] docWindowLabels;
    int[][] labels;
    int domainDimension = -1;
    int inputLayerSize = -1;
    int outputLayerSize = -1;
    int edgeParamCount = -1;
    int numNodeFeatures = -1;
    int numEdgeFeatures = -1;
    int beforeOutputWeights = -1;
    int originalFeatureCount = -1;
    int[][] weightIndices;
    String backgroundSymbol;
    public static boolean VERBOSE = false;

    public static int getPriorType(String priorTypeStr) {
        if (priorTypeStr == null) {
            return 1;
        }
        if ("QUADRATIC".equalsIgnoreCase(priorTypeStr)) {
            return 1;
        }
        if ("L1".equalsIgnoreCase(priorTypeStr)) {
            return 4;
        }
        if ("L1_NODE_L2_EDGE".equalsIgnoreCase(priorTypeStr)) {
            return 5;
        }
        if ("L1_SPARSENODE_L2_EDGE".equalsIgnoreCase(priorTypeStr)) {
            return 6;
        }
        if ("HUBER".equalsIgnoreCase(priorTypeStr)) {
            return 2;
        }
        if ("QUARTIC".equalsIgnoreCase(priorTypeStr)) {
            return 3;
        }
        if ("NONE".equalsIgnoreCase(priorTypeStr)) {
            return 0;
        }
        throw new IllegalArgumentException("Unknown prior type: " + priorTypeStr);
    }

    CRFNonLinearLogConditionalObjectiveFunction(int[][][][] data, int[][] labels, int window, Index<String> classIndex, List<Index<CRFLabel>> labelIndices, int[] map, SeqClassifierFlags flags, int numNodeFeatures, int numEdgeFeatures, double[][][][] featureVal) {
        this.window = window;
        this.classIndex = classIndex;
        this.numClasses = classIndex.size();
        this.labelIndices = labelIndices;
        this.data = data;
        this.featureVal = featureVal;
        this.flags = flags;
        this.map = map;
        this.labels = labels;
        this.prior = CRFNonLinearLogConditionalObjectiveFunction.getPriorType(flags.priorType);
        this.backgroundSymbol = flags.backgroundSymbol;
        this.sigma = flags.sigma;
        this.priorL1Lambda = flags.priorL1Lambda;
        this.outputLayerSize = this.numClasses;
        this.numHiddenUnits = flags.numHiddenUnits;
        this.inputLayerSize = flags.arbitraryInputLayerSize != -1 ? flags.arbitraryInputLayerSize : this.numHiddenUnits * this.numClasses;
        this.numNodeFeatures = numNodeFeatures;
        this.numEdgeFeatures = numEdgeFeatures;
        System.err.println("numOfEdgeFeatures: " + numEdgeFeatures);
        this.useOutputLayer = flags.useOutputLayer;
        this.useHiddenLayer = flags.useHiddenLayer;
        this.useSigmoid = flags.useSigmoid;
        this.docWindowLabels = new int[data.length][];
        if (!this.useOutputLayer) {
            System.err.println("Output layer not activated, inputLayerSize must be equal to numClasses, setting it to " + this.numClasses);
            this.inputLayerSize = this.numClasses;
        } else if (flags.softmaxOutputLayer && !flags.sparseOutputLayer && !flags.tieOutputLayer) {
            throw new RuntimeException("flags.softmaxOutputLayer == true, but neither flags.sparseOutputLayer or flags.tieOutputLayer is true");
        }
        this.empiricalCounts();
    }

    @Override
    public int domainDimension() {
        if (this.domainDimension < 0) {
            this.domainDimension = 0;
            this.edgeParamCount = this.numEdgeFeatures * this.labelIndices.get(1).size();
            this.originalFeatureCount = 0;
            for (int i = 0; i < this.map.length; ++i) {
                int s = this.labelIndices.get(this.map[i]).size();
                this.originalFeatureCount += s;
            }
            this.domainDimension += this.edgeParamCount;
            this.domainDimension += this.inputLayerSize * this.numNodeFeatures;
            this.beforeOutputWeights = this.domainDimension;
            if (this.useOutputLayer) {
                this.domainDimension = this.flags.sparseOutputLayer ? (this.domainDimension += this.outputLayerSize * this.numHiddenUnits) : (this.flags.tieOutputLayer ? (this.domainDimension += 1 * this.numHiddenUnits) : (this.domainDimension += this.outputLayerSize * this.inputLayerSize));
            }
            System.err.println("edgeParamCount: " + this.edgeParamCount);
            System.err.println("originalFeatureCount: " + this.originalFeatureCount);
            System.err.println("beforeOutputWeights: " + this.beforeOutputWeights);
            System.err.println("domainDimension: " + this.domainDimension);
        }
        return this.domainDimension;
    }

    @Override
    public double[] initial() {
        double[] initial = new double[this.domainDimension()];
        if (this.useHiddenLayer || this.useOutputLayer) {
            double twoFanIn;
            double fanIn;
            double epsilon = 0.1;
            double twoEpsilon = epsilon * 2.0;
            int count = 0;
            double val = 0.0;
            for (int i = 0; i < this.edgeParamCount; ++i) {
                val = this.random.nextDouble() * twoEpsilon - epsilon;
                initial[count++] = val;
            }
            if (this.flags.blockInitialize) {
                fanIn = 1.0 / Math.sqrt((double)this.numNodeFeatures + 0.0);
                twoFanIn = 2.0 * fanIn;
                int interval = this.numNodeFeatures / this.numHiddenUnits;
                for (int i = 0; i < this.numHiddenUnits; ++i) {
                    int lower = i * interval;
                    int upper = (i + 1) * interval;
                    if (i == this.numHiddenUnits - 1) {
                        upper = this.numNodeFeatures;
                    }
                    for (int j = 0; j < this.outputLayerSize; ++j) {
                        for (int k = 0; k < this.numNodeFeatures; ++k) {
                            val = 0.0;
                            if (k >= lower && k < upper) {
                                val = this.random.nextDouble() * twoFanIn - fanIn;
                            }
                            initial[count++] = val;
                        }
                    }
                }
                if (count != this.beforeOutputWeights) {
                    throw new RuntimeException("after blockInitialize, param Index (" + count + ") not equal to beforeOutputWeights (" + this.beforeOutputWeights + ")");
                }
            } else {
                fanIn = 1.0 / Math.sqrt((double)this.numNodeFeatures + 0.0);
                twoFanIn = 2.0 * fanIn;
                for (int i = this.edgeParamCount; i < this.beforeOutputWeights; ++i) {
                    val = this.random.nextDouble() * twoFanIn - fanIn;
                    initial[count++] = val;
                }
            }
            if (this.flags.sparseOutputLayer) {
                for (int i = 0; i < this.outputLayerSize; ++i) {
                    double total = 1.0;
                    for (int j = 0; j < this.numHiddenUnits - 1; ++j) {
                        val = this.random.nextDouble() * total;
                        initial[count++] = val;
                        total -= val;
                    }
                    initial[count++] = total;
                }
            } else if (this.flags.tieOutputLayer) {
                double total = 1.0;
                double sum = 0.0;
                for (int j = 0; j < this.numHiddenUnits - 1; ++j) {
                    if (this.flags.hardcodeSoftmaxOutputWeights) {
                        val = 1.0 / (double)this.numHiddenUnits;
                    } else {
                        val = this.random.nextDouble() * total;
                        total -= val;
                    }
                    initial[count++] = val;
                }
                initial[count++] = this.flags.hardcodeSoftmaxOutputWeights ? 1.0 / (double)this.numHiddenUnits : total;
            } else {
                for (int i = this.beforeOutputWeights; i < this.domainDimension(); ++i) {
                    val = this.random.nextDouble() * twoEpsilon - epsilon;
                    initial[count++] = val;
                }
            }
            if (count != this.domainDimension()) {
                throw new RuntimeException("after param initialization, param Index (" + count + ") not equal to domainDimension (" + this.domainDimension() + ")");
            }
        }
        return initial;
    }

    private void empiricalCounts() {
        this.Ehat = this.empty2D();
        for (int m = 0; m < this.data.length; ++m) {
            int[][][] docData = this.data[m];
            int[] docLabels = this.labels[m];
            int[] windowLabels = new int[this.window];
            Arrays.fill(windowLabels, this.classIndex.indexOf(this.backgroundSymbol));
            if (docLabels.length > docData.length) {
                System.arraycopy(docLabels, 0, windowLabels, 0, windowLabels.length);
                int[] newDocLabels = new int[docData.length];
                System.arraycopy(docLabels, docLabels.length - newDocLabels.length, newDocLabels, 0, newDocLabels.length);
                docLabels = newDocLabels;
            }
            for (int i = 0; i < docData.length; ++i) {
                System.arraycopy(windowLabels, 1, windowLabels, 0, this.window - 1);
                windowLabels[this.window - 1] = docLabels[i];
                int j = 1;
                int[] cliqueLabel = new int[j + 1];
                System.arraycopy(windowLabels, this.window - 1 - j, cliqueLabel, 0, j + 1);
                CRFLabel crfLabel = new CRFLabel(cliqueLabel);
                int labelIndex = this.labelIndices.get(j).indexOf(crfLabel);
                int[] cliqueFeatures = docData[i][j];
                for (int n = 0; n < cliqueFeatures.length; ++n) {
                    double[] dArray = this.Ehat[cliqueFeatures[n]];
                    int n2 = labelIndex;
                    dArray[n2] = dArray[n2] + 1.0;
                }
            }
        }
    }

    private double[][] emptyU() {
        int innerSize = this.inputLayerSize;
        if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
            innerSize = this.numHiddenUnits;
        }
        int outerSize = this.outputLayerSize;
        if (this.flags.tieOutputLayer) {
            outerSize = 1;
        }
        double[][] temp = new double[outerSize][innerSize];
        for (int i = 0; i < outerSize; ++i) {
            temp[i] = new double[innerSize];
        }
        return temp;
    }

    private double[][] emptyW() {
        double[][] temp = new double[this.inputLayerSize][this.numNodeFeatures];
        for (int i = 0; i < this.inputLayerSize; ++i) {
            temp[i] = new double[this.numNodeFeatures];
        }
        return temp;
    }

    public Triple<double[][], double[][], double[][]> separateWeights(double[] x) {
        double[] linearWeights = new double[this.edgeParamCount];
        System.arraycopy(x, 0, linearWeights, 0, this.edgeParamCount);
        double[][] linearWeights2D = this.to2D(linearWeights);
        int index = this.edgeParamCount;
        double[][] inputLayerWeights = this.emptyW();
        for (int i = 0; i < inputLayerWeights.length; ++i) {
            for (int j = 0; j < inputLayerWeights[i].length; ++j) {
                inputLayerWeights[i][j] = x[index++];
            }
        }
        double[][] outputLayerWeights = this.emptyU();
        for (int i = 0; i < outputLayerWeights.length; ++i) {
            for (int j = 0; j < outputLayerWeights[i].length; ++j) {
                if (this.useOutputLayer) {
                    if (this.flags.hardcodeSoftmaxOutputWeights) {
                        outputLayerWeights[i][j] = 1.0 / (double)this.numHiddenUnits;
                        continue;
                    }
                    outputLayerWeights[i][j] = x[index++];
                    continue;
                }
                outputLayerWeights[i][j] = 1.0;
            }
        }
        assert (index == x.length);
        return new Triple<double[][], double[][], double[][]>(linearWeights2D, inputLayerWeights, outputLayerWeights);
    }

    @Override
    public CliquePotentialFunction getCliquePotentialFunction(double[] x) {
        Triple<double[][], double[][], double[][]> allParams = this.separateWeights(x);
        double[][] linearWeights = allParams.first();
        double[][] W = allParams.second();
        double[][] U = allParams.third();
        return new NonLinearCliquePotentialFunction(linearWeights, W, U, this.flags);
    }

    @Override
    public void calculate(double[] x) {
        int i;
        double prob = 0.0;
        Triple<double[][], double[][], double[][]> allParams = this.separateWeights(x);
        double[][] linearWeights = allParams.first();
        double[][] W = allParams.second();
        double[][] U = allParams.third();
        Object Y = null;
        if (this.flags.softmaxOutputLayer) {
            Y = new double[U.length][];
            for (int i2 = 0; i2 < U.length; ++i2) {
                Y[i2] = ArrayMath.softmax(U[i2]);
            }
        }
        double[][] What = this.emptyW();
        double[][] Uhat = this.emptyU();
        double[][] E = this.empty2D();
        double[][] eW = this.emptyW();
        double[][] eU = this.emptyU();
        for (int m = 0; m < this.data.length; ++m) {
            int i3;
            int[][][] docData = this.data[m];
            int[] docLabels = this.labels[m];
            double[][][] featureVal3DArr = null;
            if (this.featureVal != null) {
                featureVal3DArr = this.featureVal[m];
            }
            CRFCliqueTree<String> cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(docData, this.labelIndices, this.numClasses, this.classIndex, this.backgroundSymbol, new NonLinearCliquePotentialFunction(linearWeights, W, U, this.flags), featureVal3DArr);
            int[] given = new int[this.window - 1];
            Arrays.fill(given, this.classIndex.indexOf(this.backgroundSymbol));
            int[] windowLabels = new int[this.window];
            Arrays.fill(windowLabels, this.classIndex.indexOf(this.backgroundSymbol));
            if (docLabels.length > docData.length) {
                System.arraycopy(docLabels, 0, given, 0, given.length);
                System.arraycopy(docLabels, 0, windowLabels, 0, windowLabels.length);
                int[] newDocLabels = new int[docData.length];
                System.arraycopy(docLabels, docLabels.length - newDocLabels.length, newDocLabels, 0, newDocLabels.length);
                docLabels = newDocLabels;
            }
            for (i3 = 0; i3 < docData.length; ++i3) {
                int label = docLabels[i3];
                double p = cliqueTree.condLogProbGivenPrevious(i3, label, given);
                if (VERBOSE) {
                    System.err.println("P(" + label + "|" + ArrayMath.toString(given) + ")=" + p);
                }
                prob += p;
                System.arraycopy(given, 1, given, 0, given.length - 1);
                given[given.length - 1] = label;
            }
            for (i3 = 0; i3 < docData.length; ++i3) {
                System.arraycopy(windowLabels, 1, windowLabels, 0, this.window - 1);
                windowLabels[this.window - 1] = docLabels[i3];
                for (int j = 0; j < docData[i3].length; ++j) {
                    double[] Yk;
                    Index<CRFLabel> labelIndex = this.labelIndices.get(j);
                    int[] cliqueFeatures = docData[i3][j];
                    double[] As = null;
                    double[] fDeriv = null;
                    double[][] yTimesA = null;
                    double[] sumOfYTimesA = null;
                    if (j == 0) {
                        double[] featureValArr = null;
                        if (featureVal3DArr != null) {
                            featureValArr = featureVal3DArr[i3][j];
                        }
                        As = NonLinearCliquePotentialFunction.hiddenLayerOutput(W, cliqueFeatures, this.flags, featureValArr);
                        fDeriv = new double[this.inputLayerSize];
                        double fD = 0.0;
                        for (int q = 0; q < this.inputLayerSize; ++q) {
                            fD = this.useSigmoid ? As[q] * (1.0 - As[q]) : 1.0 - As[q] * As[q];
                            fDeriv[q] = fD;
                        }
                        if (this.flags.softmaxOutputLayer) {
                            double val = 0.0;
                            yTimesA = new double[this.outputLayerSize][this.numHiddenUnits];
                            for (int ii = 0; ii < this.outputLayerSize; ++ii) {
                                yTimesA[ii] = new double[this.numHiddenUnits];
                            }
                            sumOfYTimesA = new double[this.outputLayerSize];
                            for (int k = 0; k < this.outputLayerSize; ++k) {
                                Yk = null;
                                Yk = this.flags.tieOutputLayer ? Y[0] : Y[k];
                                double sum = 0.0;
                                for (int q = 0; q < this.inputLayerSize; ++q) {
                                    if (q % this.outputLayerSize != k) continue;
                                    int hiddenUnitNo = q / this.outputLayerSize;
                                    yTimesA[k][hiddenUnitNo] = val = As[q] * Yk[hiddenUnitNo];
                                    sum += val;
                                }
                                sumOfYTimesA[k] = sum;
                            }
                        }
                        int[] cliqueLabel = new int[j + 1];
                        System.arraycopy(windowLabels, this.window - 1 - j, cliqueLabel, 0, j + 1);
                        CRFLabel crfLabel = new CRFLabel(cliqueLabel);
                        int givenLabelIndex = labelIndex.indexOf(crfLabel);
                        double[] Uk = null;
                        double[] UhatK = null;
                        double[] Yk2 = null;
                        double[] yTimesAK = null;
                        double sumOfYTimesAK = 0.0;
                        if (this.flags.tieOutputLayer) {
                            Uk = U[0];
                            UhatK = Uhat[0];
                            if (this.flags.softmaxOutputLayer) {
                                Yk2 = Y[0];
                            }
                        } else {
                            Uk = U[givenLabelIndex];
                            UhatK = Uhat[givenLabelIndex];
                            if (this.flags.softmaxOutputLayer) {
                                Yk2 = Y[givenLabelIndex];
                            }
                        }
                        if (this.flags.softmaxOutputLayer) {
                            yTimesAK = yTimesA[givenLabelIndex];
                            sumOfYTimesAK = sumOfYTimesA[givenLabelIndex];
                        }
                        for (int k = 0; k < this.inputLayerSize; ++k) {
                            int n;
                            double deltaK = 1.0;
                            if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                if (k % this.outputLayerSize == givenLabelIndex) {
                                    int hiddenUnitNo = k / this.outputLayerSize;
                                    if (this.flags.softmaxOutputLayer) {
                                        int n2 = hiddenUnitNo;
                                        UhatK[n2] = UhatK[n2] + (yTimesAK[hiddenUnitNo] - Yk2[hiddenUnitNo] * sumOfYTimesAK);
                                        deltaK *= Yk2[hiddenUnitNo];
                                    } else {
                                        int n3 = hiddenUnitNo;
                                        UhatK[n3] = UhatK[n3] + As[k];
                                        deltaK *= Uk[hiddenUnitNo];
                                    }
                                }
                            } else {
                                int n4 = k;
                                UhatK[n4] = UhatK[n4] + As[k];
                                if (this.useOutputLayer) {
                                    deltaK *= Uk[k];
                                }
                            }
                            if (this.useHiddenLayer) {
                                deltaK *= fDeriv[k];
                            }
                            if (this.useOutputLayer) {
                                if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                    if (k % this.outputLayerSize != givenLabelIndex) continue;
                                    double[] WhatK = What[k];
                                    for (int n5 = 0; n5 < cliqueFeatures.length; ++n5) {
                                        double fVal = 1.0;
                                        if (featureVal3DArr != null) {
                                            fVal = featureVal3DArr[i3][j][n5];
                                        }
                                        int n6 = cliqueFeatures[n5];
                                        WhatK[n6] = WhatK[n6] + deltaK * fVal;
                                    }
                                    continue;
                                }
                                double[] WhatK = What[k];
                                double fVal = 1.0;
                                for (n = 0; n < cliqueFeatures.length; ++n) {
                                    fVal = 1.0;
                                    if (featureVal3DArr != null) {
                                        fVal = featureVal3DArr[i3][j][n];
                                    }
                                    int n7 = cliqueFeatures[n];
                                    WhatK[n7] = WhatK[n7] + deltaK * fVal;
                                }
                                continue;
                            }
                            if (k != givenLabelIndex) continue;
                            double[] WhatK = What[k];
                            double fVal = 1.0;
                            for (n = 0; n < cliqueFeatures.length; ++n) {
                                fVal = 1.0;
                                if (featureVal3DArr != null) {
                                    fVal = featureVal3DArr[i3][j][n];
                                }
                                int n8 = cliqueFeatures[n];
                                WhatK[n8] = WhatK[n8] + deltaK * fVal;
                            }
                        }
                    }
                    for (int k = 0; k < labelIndex.size(); ++k) {
                        int[] label = labelIndex.get(k).getLabel();
                        double p = cliqueTree.prob(i3, label);
                        if (j == 0) {
                            double[] Uk = null;
                            double[] eUK = null;
                            Yk = null;
                            if (this.flags.tieOutputLayer) {
                                Uk = U[0];
                                eUK = eU[0];
                                if (this.flags.softmaxOutputLayer) {
                                    Yk = Y[0];
                                }
                            } else {
                                Uk = U[k];
                                eUK = eU[k];
                                if (this.flags.softmaxOutputLayer) {
                                    Yk = Y[k];
                                }
                            }
                            if (this.useOutputLayer) {
                                for (int q = 0; q < this.inputLayerSize; ++q) {
                                    int n;
                                    double fVal;
                                    double deltaQ = 1.0;
                                    if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                        if (q % this.outputLayerSize == k) {
                                            int hiddenUnitNo = q / this.outputLayerSize;
                                            if (this.flags.softmaxOutputLayer) {
                                                int n9 = hiddenUnitNo;
                                                eUK[n9] = eUK[n9] + (yTimesA[k][hiddenUnitNo] - Yk[hiddenUnitNo] * sumOfYTimesA[k]) * p;
                                                deltaQ = Yk[hiddenUnitNo];
                                            } else {
                                                int n10 = hiddenUnitNo;
                                                eUK[n10] = eUK[n10] + As[q] * p;
                                                deltaQ = Uk[hiddenUnitNo];
                                            }
                                        }
                                    } else {
                                        int n11 = q;
                                        eUK[n11] = eUK[n11] + As[q] * p;
                                        deltaQ = Uk[q];
                                    }
                                    if (this.useHiddenLayer) {
                                        deltaQ *= fDeriv[q];
                                    }
                                    if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                        if (q % this.outputLayerSize != k) continue;
                                        double[] eWq = eW[q];
                                        fVal = 1.0;
                                        for (n = 0; n < cliqueFeatures.length; ++n) {
                                            fVal = 1.0;
                                            if (featureVal3DArr != null) {
                                                fVal = featureVal3DArr[i3][j][n];
                                            }
                                            int n12 = cliqueFeatures[n];
                                            eWq[n12] = eWq[n12] + deltaQ * p * fVal;
                                        }
                                        continue;
                                    }
                                    double[] eWq = eW[q];
                                    fVal = 1.0;
                                    for (n = 0; n < cliqueFeatures.length; ++n) {
                                        fVal = 1.0;
                                        if (featureVal3DArr != null) {
                                            fVal = featureVal3DArr[i3][j][n];
                                        }
                                        int n13 = cliqueFeatures[n];
                                        eWq[n13] = eWq[n13] + deltaQ * p * fVal;
                                    }
                                }
                                continue;
                            }
                            double deltaK = 1.0;
                            if (this.useHiddenLayer) {
                                deltaK *= fDeriv[k];
                            }
                            double[] eWK = eW[k];
                            double fVal = 1.0;
                            for (int n = 0; n < cliqueFeatures.length; ++n) {
                                fVal = 1.0;
                                if (featureVal3DArr != null) {
                                    fVal = featureVal3DArr[i3][j][n];
                                }
                                int n14 = cliqueFeatures[n];
                                eWK[n14] = eWK[n14] + deltaK * p * fVal;
                            }
                            continue;
                        }
                        for (int n = 0; n < cliqueFeatures.length; ++n) {
                            double[] dArray = E[cliqueFeatures[n]];
                            int n15 = k;
                            dArray[n15] = dArray[n15] + p;
                        }
                    }
                }
            }
        }
        if (Double.isNaN(prob)) {
            throw new RuntimeException("Got NaN for prob in CRFNonLinearLogConditionalObjectiveFunction.calculate()");
        }
        this.value = -prob;
        if (VERBOSE) {
            System.err.println("value is " + this.value);
        }
        int index = 0;
        for (i = 0; i < E.length; ++i) {
            for (int j = 0; j < E[i].length; ++j) {
                this.derivative[index++] = E[i][j] - this.Ehat[i][j];
                if (!VERBOSE) continue;
                System.err.println("linearWeights deriv(" + i + "," + j + ") = " + E[i][j] + " - " + this.Ehat[i][j] + " = " + this.derivative[index - 1]);
            }
        }
        if (index != this.edgeParamCount) {
            throw new RuntimeException("after edge derivative, index(" + index + ") != edgeParamCount(" + this.edgeParamCount + ")");
        }
        for (i = 0; i < eW.length; ++i) {
            for (int j = 0; j < eW[i].length; ++j) {
                this.derivative[index++] = eW[i][j] - What[i][j];
                if (!VERBOSE) continue;
                System.err.println("inputLayerWeights deriv(" + i + "," + j + ") = " + eW[i][j] + " - " + What[i][j] + " = " + this.derivative[index - 1]);
            }
        }
        if (index != this.beforeOutputWeights) {
            throw new RuntimeException("after W derivative, index(" + index + ") != beforeOutputWeights(" + this.beforeOutputWeights + ")");
        }
        if (this.useOutputLayer) {
            for (i = 0; i < eU.length; ++i) {
                for (int j = 0; j < eU[i].length; ++j) {
                    this.derivative[index++] = this.flags.hardcodeSoftmaxOutputWeights ? 0.0 : eU[i][j] - Uhat[i][j];
                    if (!VERBOSE) continue;
                    System.err.println("outputLayerWeights deriv(" + i + "," + j + ") = " + eU[i][j] + " - " + Uhat[i][j] + " = " + this.derivative[index - 1]);
                }
            }
        }
        if (index != x.length) {
            throw new RuntimeException("after W derivative, index(" + index + ") != x.length(" + x.length + ")");
        }
        int regSize = x.length;
        if (this.flags.skipOutputRegularization || this.flags.softmaxOutputLayer || this.flags.hardcodeSoftmaxOutputWeights) {
            regSize = this.beforeOutputWeights;
        }
        if (this.prior == 1) {
            double sigmaSq = this.sigma * this.sigma;
            double twoSigmaSq = 2.0 * sigmaSq;
            double w = 0.0;
            double valueSum = 0.0;
            int i4 = 0;
            while (i4 < regSize) {
                w = x[i4];
                valueSum += w * w;
                int n = i4++;
                this.derivative[n] = this.derivative[n] + w / sigmaSq;
            }
            this.value += valueSum / twoSigmaSq;
        } else if (this.prior != 4) {
            if (this.prior == 5) {
                int paramIndex = 0;
                double sigmaSq = this.sigma * this.sigma;
                double lambda = 0.5 / sigmaSq;
                double w = 0.0;
                double valueSum = 0.0;
                while (paramIndex < this.edgeParamCount) {
                    w = x[paramIndex];
                    valueSum += w * w;
                    int n = paramIndex++;
                    this.derivative[n] = this.derivative[n] + w / sigmaSq;
                }
                this.value += valueSum * lambda;
            } else if (this.prior == 6) {
                double sigmaSq = this.sigma * this.sigma;
                double lambda = 0.5 / sigmaSq;
                double w = 0.0;
                double valueSum = 0.0;
                int paramIndex = 0;
                while (paramIndex < this.edgeParamCount) {
                    w = x[paramIndex];
                    valueSum += w * w;
                    int n = paramIndex++;
                    this.derivative[n] = this.derivative[n] + w / sigmaSq;
                }
                this.value += valueSum * lambda;
                for (int nodeFeatureIndex = 0; nodeFeatureIndex < this.numNodeFeatures; ++nodeFeatureIndex) {
                    for (int outputClassIndex = 0; outputClassIndex < this.numClasses; ++outputClassIndex) {
                        int firstLayerIndex;
                        int hiddenUnitIndex;
                        double maxParamAbsVal = 0.0;
                        int maxHiddenUnitIndex = 0;
                        for (hiddenUnitIndex = 0; hiddenUnitIndex < this.numHiddenUnits; ++hiddenUnitIndex) {
                            firstLayerIndex = hiddenUnitIndex * this.numClasses + outputClassIndex;
                            double absWeight = Math.abs(W[firstLayerIndex][nodeFeatureIndex]);
                            if (!(absWeight > maxParamAbsVal)) continue;
                            maxParamAbsVal = absWeight;
                            maxHiddenUnitIndex = hiddenUnitIndex;
                        }
                        for (hiddenUnitIndex = 0; hiddenUnitIndex < this.numHiddenUnits; ++hiddenUnitIndex) {
                            if (hiddenUnitIndex != maxHiddenUnitIndex) continue;
                            firstLayerIndex = hiddenUnitIndex * this.numClasses + outputClassIndex;
                            int oneDIndex = firstLayerIndex * this.numNodeFeatures + nodeFeatureIndex + this.edgeParamCount;
                            w = x[oneDIndex];
                            this.value += w * w * lambda;
                            int n = oneDIndex;
                            this.derivative[n] = this.derivative[n] + w / sigmaSq;
                        }
                    }
                }
            } else if (this.prior == 2) {
                double sigmaSq = this.sigma * this.sigma;
                for (int i5 = 0; i5 < regSize; ++i5) {
                    double w = x[i5];
                    double wabs = Math.abs(w);
                    if (wabs < this.epsilon) {
                        this.value += w * w / 2.0 / this.epsilon / sigmaSq;
                        int n = i5;
                        this.derivative[n] = this.derivative[n] + w / this.epsilon / sigmaSq;
                        continue;
                    }
                    this.value += (wabs - this.epsilon / 2.0) / sigmaSq;
                    int n = i5;
                    this.derivative[n] = this.derivative[n] + (w < 0.0 ? -1.0 : 1.0) / sigmaSq;
                }
            } else if (this.prior == 3) {
                double sigmaQu = this.sigma * this.sigma * this.sigma * this.sigma;
                int i6 = 0;
                while (i6 < regSize) {
                    double k = 1.0;
                    double w = x[i6];
                    this.value += k * w * w * w * w / 2.0 / sigmaQu;
                    int n = i6++;
                    this.derivative[n] = this.derivative[n] + k * w / sigmaQu;
                }
            }
        }
        if (this.flags.regularizeSoftmaxTieParam && this.flags.softmaxOutputLayer && !this.flags.hardcodeSoftmaxOutputWeights) {
            double softmaxLambda = this.flags.softmaxTieLambda;
            double oneDividedByTwoSigmaSq = softmaxLambda * 2.0;
            double y = 0.0;
            double mean = 1.0 / (double)this.numHiddenUnits;
            int count = 0;
            for (int i7 = 0; i7 < U.length; ++i7) {
                for (int j = 0; j < U[i7].length; ++j) {
                    y = U[i7][j];
                    this.value += (y - mean) * (y - mean) * softmaxLambda;
                    double grad = (y - mean) * oneDividedByTwoSigmaSq;
                    int n = this.beforeOutputWeights + count;
                    this.derivative[n] = this.derivative[n] + grad;
                    ++count;
                }
            }
        }
    }

    @Override
    public Set<Integer> getL1ParamRange(double[] x) {
        if (this.prior == 4) {
            Set<Integer> paramRange = Generics.newHashSet(x.length);
            for (int i = 0; i < x.length; ++i) {
                paramRange.add(i);
            }
            return paramRange;
        }
        if (this.prior == 5) {
            Set<Integer> paramRange = Generics.newHashSet(this.beforeOutputWeights - this.edgeParamCount);
            for (int i = this.edgeParamCount; i < this.beforeOutputWeights; ++i) {
                paramRange.add(i);
            }
            return paramRange;
        }
        if (this.prior == 6) {
            double[][] W = this.separateWeights(x).second();
            Set<Integer> paramRange = Generics.newHashSet();
            for (int nodeFeatureIndex = 0; nodeFeatureIndex < this.numNodeFeatures; ++nodeFeatureIndex) {
                for (int outputClassIndex = 0; outputClassIndex < this.numClasses; ++outputClassIndex) {
                    int firstLayerIndex;
                    int hiddenUnitIndex;
                    double maxParamAbsVal = 0.0;
                    int maxHiddenUnitIndex = 0;
                    for (hiddenUnitIndex = 0; hiddenUnitIndex < this.numHiddenUnits; ++hiddenUnitIndex) {
                        firstLayerIndex = hiddenUnitIndex * this.numClasses + outputClassIndex;
                        double absWeight = Math.abs(W[firstLayerIndex][nodeFeatureIndex]);
                        if (!(absWeight > maxParamAbsVal)) continue;
                        maxParamAbsVal = absWeight;
                        maxHiddenUnitIndex = hiddenUnitIndex;
                    }
                    for (hiddenUnitIndex = 0; hiddenUnitIndex < this.numHiddenUnits; ++hiddenUnitIndex) {
                        if (hiddenUnitIndex == maxHiddenUnitIndex) continue;
                        firstLayerIndex = hiddenUnitIndex * this.numClasses + outputClassIndex;
                        int oneDIndex = firstLayerIndex * this.numNodeFeatures + nodeFeatureIndex + this.edgeParamCount;
                        paramRange.add(oneDIndex);
                    }
                }
            }
            return paramRange;
        }
        return Generics.newHashSet();
    }

    public double[][] to2D(double[] linearWeights) {
        double[][] newWeights = new double[this.numEdgeFeatures][];
        int index = 0;
        int labelIndicesSize = this.labelIndices.get(1).size();
        for (int i = 0; i < this.numEdgeFeatures; ++i) {
            newWeights[i] = new double[labelIndicesSize];
            System.arraycopy(linearWeights, index, newWeights[i], 0, labelIndicesSize);
            index += labelIndicesSize;
        }
        return newWeights;
    }

    public double[][] empty2D() {
        double[][] d = new double[this.numEdgeFeatures][];
        int labelIndicesSize = this.labelIndices.get(1).size();
        for (int i = 0; i < this.numEdgeFeatures; ++i) {
            d[i] = new double[labelIndicesSize];
        }
        return d;
    }

    public double[][] emptyFull2D() {
        double[][] d = new double[this.map.length][];
        for (int i = 0; i < this.map.length; ++i) {
            d[i] = new double[this.labelIndices.get(this.map[i]).size()];
        }
        return d;
    }
}

