/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.trees.international.pennchinese.ChineseUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class CorpusDictionary {
    private Set<String> oneWord;

    public CorpusDictionary(String filename) {
        this(filename, false);
    }

    public CorpusDictionary(String filename, boolean normalize) {
        if (this.oneWord == null) {
            this.oneWord = CorpusDictionary.readDict(filename, normalize);
        }
    }

    public Set<String> getTable() {
        return this.oneWord;
    }

    private static Set<String> readDict(String filename, boolean normalize) {
        HashSet<String> word = new HashSet<String>();
        System.err.println("Loading " + (normalize ? "normalized" : "unnormalized") + " dictionary from " + filename);
        try {
            String wordDetectorLine;
            InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filename);
            BufferedReader wordDetectorReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            int i = 0;
            while ((wordDetectorLine = wordDetectorReader.readLine()) != null) {
                ++i;
                int origLeng = wordDetectorLine.length();
                int newLeng = (wordDetectorLine = wordDetectorLine.trim()).length();
                if (newLeng != origLeng) {
                    EncodingPrintWriter.err.println("Line " + i + " of " + filename + " has leading/trailing whitespace: |" + wordDetectorLine + "|", "UTF-8");
                }
                if (newLeng == 0) {
                    EncodingPrintWriter.err.println("Line " + i + " of " + filename + " is empty", "UTF-8");
                    continue;
                }
                if (normalize) {
                    wordDetectorLine = ChineseUtils.normalize(wordDetectorLine, 1, 1, 1);
                }
                word.add(wordDetectorLine);
            }
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return word;
    }

    public boolean contains(String word) {
        return this.getTable().contains(word);
    }

    public String getW(String a1) {
        if (this.contains(a1)) {
            return "1";
        }
        return "0";
    }
}

