/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CorpusChar {
    private HashMap<String, Set<String>> charMap;
    private HashMap<String, Set<String>> char_dict;

    public CorpusChar(String charlistFilename) {
        this.charMap = this.readDict(charlistFilename);
    }

    HashMap<String, Set<String>> getCharMap() {
        return this.charMap;
    }

    private HashMap<String, Set<String>> readDict(String filename) {
        System.err.println("Loading character dictionary file from " + filename);
        try {
            String DetectorLine;
            InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filename);
            BufferedReader DetectorReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            this.char_dict = new HashMap();
            while ((DetectorLine = DetectorReader.readLine()) != null) {
                String[] fields = DetectorLine.split("\t");
                String tag = fields[0];
                Set<String> chars = this.char_dict.get(tag);
                if (chars == null) {
                    chars = new HashSet<String>();
                    this.char_dict.put(tag, chars);
                }
                chars.add(fields[1]);
            }
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return this.char_dict;
    }

    public String getTag(String a1, String a2) {
        HashMap<String, Set<String>> h1 = this.getCharMap();
        Set<String> h2 = h1.get(a1);
        if (h2 == null) {
            return "0";
        }
        if (h2.contains(a2)) {
            return "1";
        }
        return "0";
    }
}

