/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseUtils;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class ChineseDocumentToSentenceProcessor
implements Serializable {
    private static final long serialVersionUID = 4054964767812217460L;
    private static Set<Character> fullStopsSet = new HashSet<Character>(Arrays.asList(Character.valueOf('\u3002'), Character.valueOf('\uff01'), Character.valueOf('\uff1f'), Character.valueOf('!'), Character.valueOf('?')));
    private static Set<Character> rightMarkSet = new HashSet<Character>(Arrays.asList(Character.valueOf('\u201d'), Character.valueOf('\u2019'), Character.valueOf('\u300b'), Character.valueOf('\u300f'), Character.valueOf('\u3009'), Character.valueOf('\u300d'), Character.valueOf('\uff1e'), Character.valueOf('\uff07'), Character.valueOf('\uff09'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('>')));
    private static String normalizationTableFile = null;
    private String encoding = "UTF-8";
    private List<Pair<String, String>> normalizationTable = null;

    private void initNormalizationTable() {
        if (this.normalizationTable == null && normalizationTableFile != null) {
            this.normalizationTable = new ArrayList<Pair<String, String>>();
            for (String line : ObjectBank.getLineIterator(new File(normalizationTableFile), this.encoding)) {
                Pattern pairPattern = Pattern.compile("([^\\s]+)\\s+([^\\s]+)");
                Matcher pairMatcher = pairPattern.matcher(line);
                if (pairMatcher.find()) {
                    this.normalizationTable.add(new Pair<String, String>(pairMatcher.group(1), pairMatcher.group(2)));
                    continue;
                }
                System.err.println("Didn't match: " + line);
            }
        }
    }

    public ChineseDocumentToSentenceProcessor() {
    }

    public ChineseDocumentToSentenceProcessor(String normalizationTableFile) {
        ChineseDocumentToSentenceProcessor.normalizationTableFile = normalizationTableFile;
        this.initNormalizationTable();
    }

    public String normalization(String in) {
        String norm = ChineseUtils.normalize(in);
        String out2 = this.normalize(norm);
        return out2;
    }

    private String normalize(String inputString) {
        if (this.normalizationTable == null) {
            return inputString;
        }
        Pattern replacePattern = Pattern.compile("[\\s\\p{Zs}]+");
        Matcher replaceMatcher = replacePattern.matcher(inputString);
        inputString = replaceMatcher.replaceAll(" ");
        for (Pair<String, String> p : this.normalizationTable) {
            replacePattern = Pattern.compile(p.first(), 16);
            replaceMatcher = replacePattern.matcher(inputString);
            String escape = p.second();
            if (escape.equals("$")) {
                escape = "\\$";
            }
            inputString = replaceMatcher.replaceAll(escape);
        }
        return inputString;
    }

    public static void main(String[] args) throws IOException {
        Properties props = StringUtils.argsToProperties(args);
        boolean alwaysAddS = props.containsKey("alwaysAddS");
        if (!props.containsKey("file")) {
            System.err.println("usage: java ChineseDocumentToSentenceProcessor [-segmentIBM] -file filename [-encoding encoding]");
            return;
        }
        ChineseDocumentToSentenceProcessor cp = new ChineseDocumentToSentenceProcessor(normalizationTableFile);
        if (props.containsKey("encoding")) {
            System.err.println("WARNING: for now the default encoding is " + cp.encoding + ". It's not changeable for now");
        }
        String input = IOUtils.slurpFileNoExceptions(props.getProperty("file"), cp.encoding);
        if (props.containsKey("segmentIBM")) {
            Pattern p4;
            Pattern p3;
            Pattern p2;
            Pattern p1;
            WhitespaceTokenizer<Word> tok = WhitespaceTokenizer.newWordWhitespaceTokenizer(new StringReader(input), true);
            String parseInside = props.getProperty("parseInside");
            if (parseInside == null) {
                parseInside = "";
            }
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, cp.encoding), true);
            StringBuilder buff = new StringBuilder();
            StringBuilder sgmlbuff = new StringBuilder();
            String lastSgml = "";
            try {
                p1 = Pattern.compile("<.*>");
                p2 = Pattern.compile("\ufeff?<[\\p{Alpha}]+");
                p3 = Pattern.compile("[A-Za-z0-9=\"]+>");
                p4 = Pattern.compile("<(?:" + parseInside + ")[ >]");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            boolean inSGML = false;
            int splitItems = 0;
            int numAdded = 0;
            while (tok.hasNext()) {
                String s = ((Word)tok.next()).word();
                if (p2.matcher(s).matches()) {
                    inSGML = true;
                    sgmlbuff.append(s).append(" ");
                    continue;
                }
                if (p1.matcher(s).matches() || inSGML && p3.matcher(s).matches() || "\n".equals(s)) {
                    inSGML = false;
                    if (buff.toString().trim().length() > 0) {
                        boolean processIt = false;
                        if (parseInside.equals("")) {
                            processIt = true;
                        } else if (p4.matcher(lastSgml).find()) {
                            processIt = true;
                        }
                        if (processIt) {
                            List<String> sents = ChineseDocumentToSentenceProcessor.fromPlainText(buff.toString(), true);
                            if (alwaysAddS || sents.size() > 1) {
                                int i = 1;
                                for (String str : sents) {
                                    pw.print("<s id=\"" + i + "\">");
                                    pw.print(str);
                                    pw.println("</s>");
                                    ++i;
                                }
                                if (sents.size() > 1) {
                                    ++splitItems;
                                    numAdded += sents.size() - 1;
                                }
                            } else if (sents.size() == 1) {
                                pw.print(sents.get(0));
                            }
                        } else {
                            pw.print(buff);
                        }
                        buff = new StringBuilder();
                    }
                    sgmlbuff.append(s);
                    pw.print(sgmlbuff);
                    lastSgml = sgmlbuff.toString();
                    sgmlbuff = new StringBuilder();
                    continue;
                }
                if (inSGML) {
                    sgmlbuff.append(s).append(" ");
                    continue;
                }
                buff.append(s).append(" ");
            }
            pw.flush();
            pw.close();
            System.err.println("Split " + splitItems + " segments, adding " + numAdded + " sentences.");
        } else {
            List<String> sent = cp.fromHTML(input);
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, cp.encoding), true);
            for (String a : sent) {
                pw.println(a);
            }
        }
    }

    public List<String> fromHTML(String inputString) throws IOException {
        ArrayList<String> ans = new ArrayList<String>();
        MyHTMLParser parser = new MyHTMLParser();
        List<String> sents = parser.parse(inputString);
        for (String s : sents) {
            ans.addAll(ChineseDocumentToSentenceProcessor.fromPlainText(s));
        }
        return ans;
    }

    public static List<String> fromPlainText(String contentString) throws IOException {
        return ChineseDocumentToSentenceProcessor.fromPlainText(contentString, false);
    }

    public static List<String> fromPlainText(String contentString, boolean segmented) throws IOException {
        contentString = segmented ? ChineseUtils.normalize(contentString, 0, 1) : ChineseUtils.normalize(contentString, 2, 1);
        String sentenceString = "";
        char[] content = contentString.toCharArray();
        boolean sentenceEnd = false;
        ArrayList<String> sentenceList = new ArrayList<String>();
        int lastCh = -1;
        char[] arr$ = content;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            String newChar = c.toString();
            if (!sentenceEnd) {
                if (segmented && fullStopsSet.contains(c) && (lastCh == -1 || Character.isSpaceChar(lastCh))) {
                    sentenceString = sentenceString + newChar;
                    sentenceEnd = true;
                } else if (!segmented && fullStopsSet.contains(c)) {
                    sentenceString = sentenceString + newChar;
                    sentenceEnd = true;
                } else {
                    sentenceString = sentenceString + newChar;
                }
            } else if (rightMarkSet.contains(c)) {
                sentenceString = sentenceString + newChar;
            } else if (newChar.matches("\\s")) {
                sentenceString = sentenceString + newChar;
            } else if (fullStopsSet.contains(c)) {
                sentenceString = sentenceString + newChar;
            } else {
                if (sentenceString.length() > 0) {
                    sentenceEnd = false;
                }
                if ((sentenceString = ChineseDocumentToSentenceProcessor.removeWhitespace(sentenceString, segmented)).length() > 0) {
                    sentenceList.add(sentenceString);
                }
                sentenceString = "";
                sentenceString = sentenceString + newChar;
            }
            lastCh = c.charValue();
        }
        if ((sentenceString = ChineseDocumentToSentenceProcessor.removeWhitespace(sentenceString, segmented)).length() > 0) {
            sentenceList.add(sentenceString);
        }
        return sentenceList;
    }

    private static String removeWhitespace(String str, boolean segmented) {
        if (str.length() > 0) {
            Pattern replacePattern = Pattern.compile("^[\\s\\p{Zs}]+");
            Matcher replaceMatcher = replacePattern.matcher(str);
            str = replaceMatcher.replaceAll("");
            replacePattern = Pattern.compile("[\\s\\p{Zs}]+$");
            replaceMatcher = replacePattern.matcher(str);
            str = replaceMatcher.replaceAll("");
            if (!segmented) {
                replacePattern = Pattern.compile("[\\s\\p{Zs}]+");
                replaceMatcher = replacePattern.matcher(str);
                str = replaceMatcher.replaceAll("");
            }
        }
        return str;
    }

    static class MyHTMLParser
    extends HTMLEditorKit.ParserCallback {
        protected StringBuffer textBuffer;
        protected List<String> sentences;
        protected String title = "";
        protected boolean isTitle = false;
        protected boolean isBody = false;
        protected boolean isScript = false;
        protected boolean isBreak = false;

        @Override
        public void handleText(char[] data, int pos) {
            if (data.length == 0) {
                return;
            }
            if (this.isTitle) {
                this.title = new String(data);
            } else if (!this.isBody || !this.isScript) {
                // empty if block
            }
            this.textBuffer.append(data);
            String text = this.textBuffer.toString();
            text = text.replaceAll("\u00a0", "");
            text = text.trim();
            if (text.length() == 0) {
                return;
            }
            this.sentences.add(text);
            this.textBuffer = new StringBuffer(500);
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
            if (tag == HTML.Tag.TITLE) {
                this.isTitle = true;
            } else if (tag == HTML.Tag.BODY) {
                this.isBody = true;
            } else if (tag == HTML.Tag.SCRIPT) {
                this.isScript = true;
            }
            this.isBreak = tag.breaksFlow();
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int pos) {
            if (tag == HTML.Tag.TITLE) {
                this.isTitle = false;
            } else if (tag == HTML.Tag.BODY) {
                this.isBody = false;
            } else if (tag == HTML.Tag.SCRIPT) {
                this.isScript = false;
            }
        }

        public List<String> parse(URL url) throws IOException {
            return this.parse(IOUtils.slurpURL(url));
        }

        public List<String> parse(Reader r) throws IOException {
            return this.parse(IOUtils.slurpReader(r));
        }

        public List<String> parse(String text) throws IOException {
            text = text.replaceAll("/>", ">");
            text = text.replaceAll("<\\?", "<");
            StringReader r = new StringReader(text);
            this.textBuffer = new StringBuffer(200);
            this.sentences = new ArrayList<String>();
            new ParserDelegator().parse(r, this, true);
            return this.sentences;
        }

        public String title() {
            return this.title;
        }
    }
}

