/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.CTBTreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructureFactory;
import edu.stanford.nlp.trees.international.pennchinese.ChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.util.Filters;
import java.util.function.Predicate;

public class ChineseTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private static final long serialVersionUID = 5757403475523638802L;
    private TokenizerFactory<? extends HasWord> tf;
    public static final String ENCODING = "utf-8";
    private static final char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~'};
    private static final String[] startSymbols = new String[]{"ROOT"};
    private static final String[] tags = new String[]{"PU"};
    private static final String[] comma = new String[]{",", "\uff0c", "\u3000"};
    private static final String[] endSentence = new String[]{"\u3002", "\uff0e", "\uff01", "\uff1f", "?", "!", "."};
    private static final String[] douHao = new String[]{"\u3001"};
    private static final String[] quoteMark = new String[]{"\u201c", "\u201d", "\u2018", "\u2019", "\u300a", "\u300b", "\u300e", "\u300f", "\u3008", "\u3009", "\u300c", "\u300d", "\uff02", "\uff1c", "\uff1e", "'", "`", "\uff07", "\uff40", "\uff62", "\uff63"};
    private static final String[] parenthesis = new String[]{"\uff08", "\uff09", "\uff3b", "\uff3d", "\uff5b", "\uff5d", "-LRB-", "-RRB-", "\u3010", "\u3011", "\u3014", "\u3016", "\u3018", "\u301a", "\uff5f", "\u3015", "\u3017", "\u3019", "\u301b", "\uff60"};
    private static final String[] colon = new String[]{"\uff1a", "\uff1b", "\u2236", ":"};
    private static final String[] dash = new String[]{"\u2026", "\u2015", "\u2014\u2014", "\u2014\u2014\u2014", "\u2014\u2014\u2014\u2014", "\u2014", "\u2014\u2014", "\u2014\u2014\u2014", "\uff0d", "--", "---", "\uff0d\uff0d", "\uff0d\uff0d\uff0d", "\uff0d\uff0d\uff0d\uff0d", "\uff0d\uff0d\uff0d\uff0d\uff0d", "\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d", "\u2500\u2500", "\u2501", "\u2501\u2501", "\u2014\uff0d", "-", "----", "~", "~~", "~~~", "~~~~", "~~~~~", "\u2026\u2026", "\uff5e", "\uff0e\uff0e\uff0e"};
    private static final String[] other = new String[]{"\u00b7", "\uff0f", "\uff0f", "\uff0a", "\uff06", "/", "//", "*", "\u203b", "\u25a0", "\u25cf", "\uff5c"};
    private static final String[] leftQuoteMark = new String[]{"\u201c", "\u2018", "\u300a", "\u300e", "\u3008", "\u300c", "\uff1c", "`", "\uff40", "\uff62"};
    private static final String[] rightQuoteMark = new String[]{"\u201d", "\u2019", "\u300b", "\u300f", "\u3009", "\u300d", "\uff1e", "\uff07", "\uff63"};
    private static final String[] leftParenthesis = new String[]{"\uff08", "-LRB-", "\uff3b", "\uff5b", "\u3010", "\u3014", "\u3016", "\u3018", "\u301a", "\uff5f"};
    private static final String[] rightParenthesis = new String[]{"\uff09", "-RRB-", "\uff3d", "\uff5d", "\u3011", "\u3015", "\u3017", "\u3019", "\u301b", "\uff60"};
    private static final String[] punctWords;

    public void setTokenizerFactory(TokenizerFactory<? extends HasWord> tf) {
        this.tf = tf;
    }

    @Override
    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        if (this.tf != null) {
            return this.tf;
        }
        return super.getTokenizerFactory();
    }

    @Override
    public String getEncoding() {
        return ENCODING;
    }

    @Override
    public boolean isPunctuationTag(String str) {
        return str.equals("PU");
    }

    @Override
    public boolean isPunctuationWord(String str) {
        return ChineseTreebankLanguagePack.chineseCommaAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseQuoteMarkAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseParenthesisAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseColonAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseDashAcceptFilter().test(str) || ChineseTreebankLanguagePack.chineseOtherAcceptFilter().test(str);
    }

    @Override
    public boolean isSentenceFinalPunctuationTag(String str) {
        return ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().test(str);
    }

    @Override
    public String[] punctuationTags() {
        return tags;
    }

    @Override
    public String[] punctuationWords() {
        return punctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return tags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return endSentence;
    }

    @Override
    public boolean isEvalBIgnoredPunctuationTag(String str) {
        return Filters.collectionAcceptFilter(tags).test(str);
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return startSymbols;
    }

    public static Predicate<String> chineseCommaAcceptFilter() {
        return Filters.collectionAcceptFilter(comma);
    }

    public static Predicate<String> chineseEndSentenceAcceptFilter() {
        return Filters.collectionAcceptFilter(endSentence);
    }

    public static Predicate<String> chineseDouHaoAcceptFilter() {
        return Filters.collectionAcceptFilter(douHao);
    }

    public static Predicate<String> chineseQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(quoteMark);
    }

    public static Predicate<String> chineseParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(parenthesis);
    }

    public static Predicate<String> chineseColonAcceptFilter() {
        return Filters.collectionAcceptFilter(colon);
    }

    public static Predicate<String> chineseDashAcceptFilter() {
        return Filters.collectionAcceptFilter(dash);
    }

    public static Predicate<String> chineseOtherAcceptFilter() {
        return Filters.collectionAcceptFilter(other);
    }

    public static Predicate<String> chineseLeftParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(leftParenthesis);
    }

    public static Predicate<String> chineseRightParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(rightParenthesis);
    }

    public static Predicate<String> chineseLeftQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(leftQuoteMark);
    }

    public static Predicate<String> chineseRightQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(rightQuoteMark);
    }

    @Override
    public String treebankFileExtension() {
        return "fid";
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        return new ChineseGrammaticalStructureFactory();
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Predicate<String> puncFilt) {
        return new ChineseGrammaticalStructureFactory(puncFilt);
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Predicate<String> puncFilt, HeadFinder hf) {
        return new ChineseGrammaticalStructureFactory(puncFilt, hf);
    }

    @Override
    public boolean supportsGrammaticalStructures() {
        return true;
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        BobChrisTreeNormalizer tn = new BobChrisTreeNormalizer();
        return new CTBTreeReaderFactory(tn);
    }

    @Override
    public HeadFinder headFinder() {
        return new ChineseHeadFinder(this);
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new ChineseSemanticHeadFinder(this);
    }

    static {
        int n = comma.length + endSentence.length + douHao.length + quoteMark.length + parenthesis.length + colon.length + dash.length + other.length + leftQuoteMark.length + rightQuoteMark.length + leftParenthesis.length + rightParenthesis.length;
        punctWords = new String[n];
        int m = 0;
        System.arraycopy(comma, 0, punctWords, m, comma.length);
        System.arraycopy(endSentence, 0, punctWords, m += comma.length, endSentence.length);
        System.arraycopy(douHao, 0, punctWords, m += endSentence.length, douHao.length);
        System.arraycopy(quoteMark, 0, punctWords, m += douHao.length, quoteMark.length);
        System.arraycopy(parenthesis, 0, punctWords, m += quoteMark.length, parenthesis.length);
        System.arraycopy(colon, 0, punctWords, m += parenthesis.length, colon.length);
        System.arraycopy(dash, 0, punctWords, m += colon.length, dash.length);
        System.arraycopy(other, 0, punctWords, m += dash.length, other.length);
        int n2 = m + other.length;
    }
}

