/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.AbstractCoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.Set;

public class IndexedWord
implements AbstractCoreLabel,
Comparable<IndexedWord> {
    private static final long serialVersionUID = 3739633991145239829L;
    public static final IndexedWord NO_WORD = new IndexedWord(null, -1, -1);
    private final CoreLabel label;

    public IndexedWord() {
        this.label = new CoreLabel();
    }

    public IndexedWord(Label w) {
        if (w instanceof CoreLabel) {
            this.label = (CoreLabel)w;
        } else {
            this.label = new CoreLabel(w);
            if (this.label.word() == null) {
                this.label.setWord(this.label.value());
            }
        }
    }

    public IndexedWord(CoreLabel w) {
        this.label = w;
    }

    public IndexedWord(String docID, int sentenceIndex, int index) {
        this.label = new CoreLabel();
        this.label.set(CoreAnnotations.DocIDAnnotation.class, docID);
        this.label.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
        this.label.set(CoreAnnotations.IndexAnnotation.class, index);
    }

    public IndexedWord makeCopy(int count) {
        CoreLabel labelCopy = new CoreLabel(this.label);
        IndexedWord copy = new IndexedWord(labelCopy);
        copy.setCopyCount(count);
        return copy;
    }

    public CoreLabel backingLabel() {
        return this.label;
    }

    @Override
    public <VALUE> VALUE get(Class<? extends TypesafeMap.Key<VALUE>> key) {
        return this.label.get(key);
    }

    @Override
    public <VALUE> boolean has(Class<? extends TypesafeMap.Key<VALUE>> key) {
        return this.label.has(key);
    }

    @Override
    public <VALUE> boolean containsKey(Class<? extends TypesafeMap.Key<VALUE>> key) {
        return this.label.containsKey(key);
    }

    @Override
    public <VALUE> VALUE set(Class<? extends TypesafeMap.Key<VALUE>> key, VALUE value) {
        return this.label.set(key, value);
    }

    @Override
    public <KEY extends TypesafeMap.Key<String>> String getString(Class<KEY> key) {
        return this.label.getString(key);
    }

    @Override
    public <VALUE> VALUE remove(Class<? extends TypesafeMap.Key<VALUE>> key) {
        return this.label.remove(key);
    }

    @Override
    public Set<Class<?>> keySet() {
        return this.label.keySet();
    }

    @Override
    public int size() {
        return this.label.size();
    }

    @Override
    public String value() {
        return this.label.value();
    }

    @Override
    public void setValue(String value) {
        this.label.setValue(value);
    }

    @Override
    public String tag() {
        return this.label.tag();
    }

    @Override
    public void setTag(String tag) {
        this.label.setTag(tag);
    }

    @Override
    public String word() {
        return this.label.word();
    }

    @Override
    public void setWord(String word) {
        this.label.setWord(word);
    }

    @Override
    public String lemma() {
        return this.label.lemma();
    }

    @Override
    public void setLemma(String lemma) {
        this.label.setLemma(lemma);
    }

    @Override
    public String ner() {
        return this.label.ner();
    }

    @Override
    public void setNER(String ner) {
        this.label.setNER(ner);
    }

    @Override
    public String docID() {
        return this.label.docID();
    }

    @Override
    public void setDocID(String docID) {
        this.label.setDocID(docID);
    }

    @Override
    public int index() {
        return this.label.index();
    }

    @Override
    public void setIndex(int index) {
        this.label.setIndex(index);
    }

    @Override
    public int sentIndex() {
        return this.label.sentIndex();
    }

    @Override
    public void setSentIndex(int sentIndex) {
        this.label.setSentIndex(sentIndex);
    }

    @Override
    public String originalText() {
        return this.label.originalText();
    }

    @Override
    public void setOriginalText(String originalText) {
        this.label.setOriginalText(originalText);
    }

    @Override
    public int beginPosition() {
        return this.label.beginPosition();
    }

    @Override
    public int endPosition() {
        return this.label.endPosition();
    }

    @Override
    public void setBeginPosition(int beginPos) {
        this.label.setBeginPosition(beginPos);
    }

    @Override
    public void setEndPosition(int endPos) {
        this.label.setEndPosition(endPos);
    }

    public int copyCount() {
        return this.label.copyCount();
    }

    public void setCopyCount(int count) {
        this.label.setCopyCount(count);
    }

    public String toPrimes() {
        int copy = this.label.copyCount();
        return StringUtils.repeat('\'', copy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedWord)) {
            return false;
        }
        IndexedWord otherWord = (IndexedWord)o;
        Integer myInd = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
        Integer otherInd = (Integer)otherWord.get(CoreAnnotations.IndexAnnotation.class);
        if (myInd == null ? otherInd != null : !myInd.equals(otherInd)) {
            return false;
        }
        Integer mySentInd = (Integer)this.get(CoreAnnotations.SentenceIndexAnnotation.class);
        Integer otherSentInd = (Integer)otherWord.get(CoreAnnotations.SentenceIndexAnnotation.class);
        if (mySentInd == null ? otherSentInd != null : !mySentInd.equals(otherSentInd)) {
            return false;
        }
        String myDocID = this.getString(CoreAnnotations.DocIDAnnotation.class);
        String otherDocID = otherWord.getString(CoreAnnotations.DocIDAnnotation.class);
        if (myDocID == null ? otherDocID != null : !myDocID.equals(otherDocID)) {
            return false;
        }
        return this.copyCount() == otherWord.copyCount();
    }

    public int hashCode() {
        boolean sensible = false;
        int result = 0;
        if (this.get(CoreAnnotations.DocIDAnnotation.class) != null) {
            result = ((String)this.get(CoreAnnotations.DocIDAnnotation.class)).hashCode();
            sensible = true;
        }
        if (this.has(CoreAnnotations.SentenceIndexAnnotation.class)) {
            result = 29 * result + ((Integer)this.get(CoreAnnotations.SentenceIndexAnnotation.class)).hashCode();
            sensible = true;
        }
        if (this.has(CoreAnnotations.IndexAnnotation.class)) {
            result = 29 * result + ((Integer)this.get(CoreAnnotations.IndexAnnotation.class)).hashCode();
            sensible = true;
        }
        if (!sensible) {
            System.err.println("WARNING!!!  You have hashed an IndexedWord with no docID, sentIndex or wordIndex. You will almost certainly lose");
        }
        return result;
    }

    @Override
    public int compareTo(IndexedWord w) {
        if (this.equals(NO_WORD)) {
            if (w.equals(NO_WORD)) {
                return 0;
            }
            return -1;
        }
        if (w.equals(NO_WORD)) {
            return 1;
        }
        String docID = this.getString(CoreAnnotations.DocIDAnnotation.class);
        int docComp = docID.compareTo(w.getString(CoreAnnotations.DocIDAnnotation.class));
        if (docComp != 0) {
            return docComp;
        }
        int sentComp = this.sentIndex() - w.sentIndex();
        if (sentComp != 0) {
            return sentComp;
        }
        int indexComp = this.index() - w.index();
        if (indexComp != 0) {
            return indexComp;
        }
        return this.copyCount() - w.copyCount();
    }

    @Override
    public String toString() {
        return this.label.toString(CoreLabel.OutputFormat.VALUE_TAG);
    }

    public String toString(CoreLabel.OutputFormat format) {
        return this.label.toString(format);
    }

    @Override
    public void setFromString(String labelStr) {
        throw new UnsupportedOperationException("Cannot set from string");
    }

    public static LabelFactory factory() {
        return new LabelFactory(){

            @Override
            public Label newLabel(String labelStr) {
                CoreLabel label = new CoreLabel();
                label.setValue(labelStr);
                return new IndexedWord(label);
            }

            @Override
            public Label newLabel(String labelStr, int options) {
                return this.newLabel(labelStr);
            }

            @Override
            public Label newLabel(Label oldLabel) {
                return new IndexedWord(oldLabel);
            }

            @Override
            public Label newLabelFromString(String encodedLabelStr) {
                throw new UnsupportedOperationException("This code branch left blank because we do not understand what this method should do.");
            }
        };
    }

    @Override
    public LabelFactory labelFactory() {
        return IndexedWord.factory();
    }
}

