/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MulticoreWrapper<I, O> {
    private long maxSubmitBlockTime = -1L;
    private final int nThreads;
    private int submittedItemCounter = 0;
    private int returnedItemCounter = -1;
    private final boolean orderResults;
    private final Map<Integer, O> outputQueue;
    private final ThreadPoolExecutor threadPool;
    private final BlockingQueue<Integer> idleProcessors;
    private final List<ThreadsafeProcessor<I, O>> processorList;
    private final JobCallback<O> callback;

    public MulticoreWrapper(int nThreads, ThreadsafeProcessor<I, O> processor) {
        this(nThreads, processor, true);
    }

    public MulticoreWrapper(int numThreads, ThreadsafeProcessor<I, O> processor, boolean orderResults) {
        this.nThreads = numThreads <= 0 ? Runtime.getRuntime().availableProcessors() : numThreads;
        this.orderResults = orderResults;
        this.outputQueue = new ConcurrentHashMap<Integer, O>(2 * this.nThreads);
        this.threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.nThreads);
        this.idleProcessors = new ArrayBlockingQueue<Integer>(this.nThreads, false);
        this.callback = new JobCallback<O>(){

            @Override
            public void call(QueueItem<O> result, int processorId) {
                MulticoreWrapper.this.outputQueue.put(result.id, result.item);
                MulticoreWrapper.this.idleProcessors.add(processorId);
            }
        };
        this.threadPool.allowCoreThreadTimeOut(false);
        this.threadPool.prestartAllCoreThreads();
        ArrayList<ThreadsafeProcessor<I, O>> procList = new ArrayList<ThreadsafeProcessor<I, O>>(this.nThreads);
        procList.add(processor);
        this.idleProcessors.add(0);
        for (int i = 1; i < this.nThreads; ++i) {
            procList.add(processor.newInstance());
            this.idleProcessors.add(i);
        }
        this.processorList = Collections.unmodifiableList(procList);
    }

    public void setMaxBlockTime(long t) {
        this.maxSubmitBlockTime = t;
    }

    public String toString() {
        return String.format("active: %d/%d  submitted: %d  completed: %d  input_q: %d  output_q: %d  idle_q: %d", this.threadPool.getActiveCount(), this.threadPool.getPoolSize(), this.threadPool.getTaskCount(), this.threadPool.getCompletedTaskCount(), this.threadPool.getQueue().size(), this.outputQueue.size(), this.idleProcessors.size());
    }

    public synchronized void put(I item) throws RejectedExecutionException {
        Integer procId;
        try {
            Integer n = procId = this.maxSubmitBlockTime < 0L ? this.idleProcessors.take() : this.idleProcessors.poll(this.maxSubmitBlockTime, TimeUnit.MILLISECONDS);
            if (procId == null) {
                throw new RejectedExecutionException("Couldn't submit item to threadpool: " + item.toString());
            }
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException("Exception in threadpool: " + e.toString());
        }
        int itemId = this.submittedItemCounter++;
        CallableJob<I, O> job = new CallableJob<I, O>(item, itemId, this.processorList.get(procId), procId, this.callback);
        this.threadPool.submit(job);
    }

    public void join() {
        this.join(true);
    }

    public void join(boolean destroyThreadpool) {
        if (!this.threadPool.isShutdown()) {
            try {
                int i;
                for (i = this.nThreads; i > 0; --i) {
                    this.idleProcessors.take();
                }
                if (destroyThreadpool) {
                    this.threadPool.shutdown();
                    this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
                } else {
                    for (i = 0; i < this.nThreads; ++i) {
                        this.idleProcessors.put(i);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean peek() {
        if (this.outputQueue.isEmpty()) {
            return false;
        }
        return this.orderResults ? this.outputQueue.containsKey(this.returnedItemCounter + 1) : true;
    }

    public O poll() {
        if (!this.peek()) {
            return null;
        }
        ++this.returnedItemCounter;
        int itemIndex = this.orderResults ? this.returnedItemCounter : this.outputQueue.keySet().iterator().next();
        return this.outputQueue.remove(itemIndex);
    }

    private static class QueueItem<O>
    implements Comparable<QueueItem<O>> {
        public final int id;
        public final O item;

        public QueueItem(O item, int id) {
            this.item = item;
            this.id = id;
        }

        @Override
        public int compareTo(QueueItem<O> other) {
            return this.id - other.id;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof QueueItem)) {
                return false;
            }
            QueueItem otherQueue = (QueueItem)other;
            return this.id == otherQueue.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class CallableJob<I, O>
    implements Callable<Integer> {
        private final I item;
        private final int itemId;
        private final ThreadsafeProcessor<I, O> processor;
        private final int processorId;
        private final JobCallback<O> callback;

        public CallableJob(I item, int itemId, ThreadsafeProcessor<I, O> processor, int processorId, JobCallback<O> callback) {
            this.item = item;
            this.itemId = itemId;
            this.processor = processor;
            this.processorId = processorId;
            this.callback = callback;
        }

        @Override
        public Integer call() {
            try {
                O result = this.processor.process(this.item);
                QueueItem<O> output = new QueueItem<O>(result, this.itemId);
                this.callback.call(output, this.processorId);
                return this.itemId;
            }
            catch (Exception e) {
                e.printStackTrace();
                QueueItem<Object> output = new QueueItem<Object>(null, this.itemId);
                this.callback.call(output, this.processorId);
                return this.itemId;
            }
        }
    }

    private static interface JobCallback<O> {
        public void call(QueueItem<O> var1, int var2);
    }
}

