/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.Pair;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Extractors
implements Serializable {
    private final Extractor[] v;
    private static final boolean DEBUG = false;
    transient List<Pair<Integer, Extractor>> local;
    transient List<Pair<Integer, Extractor>> localContext;
    transient List<Pair<Integer, Extractor>> dynamic;
    private static final long serialVersionUID = -4777107742414749890L;

    public Extractors(Extractor[] extrs) {
        this.v = new Extractor[extrs.length];
        System.arraycopy(extrs, 0, this.v, 0, extrs.length);
        this.initTypes();
    }

    void initTypes() {
        this.local = new ArrayList<Pair<Integer, Extractor>>();
        this.localContext = new ArrayList<Pair<Integer, Extractor>>();
        this.dynamic = new ArrayList<Pair<Integer, Extractor>>();
        for (int i = 0; i < this.v.length; ++i) {
            Extractor e = this.v[i];
            if (e.isLocal() && e.isDynamic()) {
                throw new RuntimeException("Extractors can't both be local and dynamic!");
            }
            if (e.isLocal()) {
                this.local.add(Pair.makePair(i, e));
                continue;
            }
            if (e.isDynamic()) {
                this.dynamic.add(Pair.makePair(i, e));
                continue;
            }
            this.localContext.add(Pair.makePair(i, e));
        }
    }

    String extract(int i, History h) {
        return this.v[i].extract(h);
    }

    boolean equals(History h, History h1) {
        for (Extractor extractor : this.v) {
            if (extractor.extract(h).equals(extractor.extract(h1))) continue;
            return false;
        }
        return true;
    }

    int leftContext() {
        int max = 0;
        for (Extractor extractor : this.v) {
            int lf = extractor.leftContext();
            if (lf <= max) continue;
            max = lf;
        }
        return max;
    }

    int rightContext() {
        int max = 0;
        for (Extractor extractor : this.v) {
            int lf = extractor.rightContext();
            if (lf <= max) continue;
            max = lf;
        }
        return max;
    }

    public int getSize() {
        return this.v.length;
    }

    protected void setGlobalHolder(MaxentTagger tagger) {
        for (Extractor extractor : this.v) {
            extractor.setGlobalHolder(tagger);
        }
    }

    Extractor get(int index) {
        return this.v[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Extractors[");
        for (int i = 0; i < this.v.length; ++i) {
            sb.append(this.v[i].toString());
            if (i >= this.v.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(args[0]));
            Extractors extrs = (Extractors)in.readObject();
            Extractors extrsRare = (Extractors)in.readObject();
            in.close();
            System.out.println("All words:  " + extrs);
            System.out.println("Rare words: " + extrsRare);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

