/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;

public class ExactBestSequenceFinder
implements BestSequenceFinder {
    private static final boolean useOld = false;
    private static final boolean DEBUG = false;

    public static void main(String[] args) {
        ExactBestSequenceFinder ti = new ExactBestSequenceFinder();
        TestSequenceModel ts = new TestSequenceModel();
        int[] bestTags = ti.bestSequence(ts);
        System.out.println("The best sequence is ... " + Arrays.toString(bestTags));
    }

    @Override
    public int[] bestSequence(SequenceModel ts) {
        return ExactBestSequenceFinder.bestSequenceNew(ts);
    }

    public static Pair<int[], Double> bestSequenceWithLinearConstraints(SequenceModel ts, double[][] linearConstraints) {
        return ExactBestSequenceFinder.bestSequenceNew(ts, linearConstraints);
    }

    private static int[] bestSequenceNew(SequenceModel ts) {
        return ExactBestSequenceFinder.bestSequenceNew(ts, null).first();
    }

    private static Pair<int[], Double> bestSequenceNew(SequenceModel ts, double[][] linearConstraints) {
        int pos;
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        int padLength = length + leftWindow + rightWindow;
        if (linearConstraints != null && linearConstraints.length != padLength) {
            throw new RuntimeException("linearConstraints.length (" + linearConstraints.length + ") does not match padLength (" + padLength + ") of SequenceModel" + ", length==" + length + ", leftW=" + leftWindow + ", rightW=" + rightWindow);
        }
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos2 = 0; pos2 < padLength; ++pos2) {
            tags[pos2] = ts.getPossibleValues(pos2);
            tagNum[pos2] = tags[pos2].length;
        }
        int[] tempTags = new int[padLength];
        int[] productSizes = new int[padLength];
        int curProduct = 1;
        for (int i = 0; i < leftWindow + rightWindow; ++i) {
            curProduct *= tagNum[i];
        }
        for (int pos3 = leftWindow + rightWindow; pos3 < padLength; ++pos3) {
            if (pos3 > leftWindow + rightWindow) {
                curProduct /= tagNum[pos3 - leftWindow - rightWindow - 1];
            }
            productSizes[pos3 - rightWindow] = curProduct *= tagNum[pos3];
        }
        double[][] windowScore = new double[padLength][];
        for (int pos4 = leftWindow; pos4 < leftWindow + length; ++pos4) {
            windowScore[pos4] = new double[productSizes[pos4]];
            Arrays.fill(tempTags, tags[0][0]);
            for (int product = 0; product < productSizes[pos4]; ++product) {
                int p = product;
                int shift = 1;
                for (int curPos = pos4 + rightWindow; curPos >= pos4 - leftWindow; --curPos) {
                    tempTags[curPos] = tags[curPos][p % tagNum[curPos]];
                    p /= tagNum[curPos];
                    if (curPos <= pos4) continue;
                    shift *= tagNum[curPos];
                }
                if (tempTags[pos4] != tags[pos4][0]) continue;
                double[] scores = ts.scoresOf(tempTags, pos4);
                for (int t = 0; t < tagNum[pos4]; ++t) {
                    windowScore[pos4][product + t * shift] = scores[t];
                }
            }
        }
        double[][] score = new double[padLength][];
        int[][] trace = new int[padLength][];
        for (pos = 0; pos < padLength; ++pos) {
            score[pos] = new double[productSizes[pos]];
            trace[pos] = new int[productSizes[pos]];
        }
        for (pos = leftWindow; pos < length + leftWindow; ++pos) {
            for (int product = 0; product < productSizes[pos]; ++product) {
                if (pos == leftWindow) {
                    score[pos][product] = windowScore[pos][product];
                    if (linearConstraints != null) {
                        double[] dArray = score[pos];
                        int n = product;
                        dArray[n] = dArray[n] + linearConstraints[pos][product % tagNum[pos]];
                    }
                    trace[pos][product] = -1;
                    continue;
                }
                score[pos][product] = Double.NEGATIVE_INFINITY;
                trace[pos][product] = -1;
                int sharedProduct = product / tagNum[pos + rightWindow];
                int factor = productSizes[pos] / tagNum[pos + rightWindow];
                for (int newTagNum = 0; newTagNum < tagNum[pos - leftWindow - 1]; ++newTagNum) {
                    int predProduct = newTagNum * factor + sharedProduct;
                    double predScore = score[pos - 1][predProduct] + windowScore[pos][product];
                    if (linearConstraints != null) {
                        predScore += linearConstraints[pos][product % tagNum[pos]];
                    }
                    if (!(predScore > score[pos][product])) continue;
                    score[pos][product] = predScore;
                    trace[pos][product] = predProduct;
                }
            }
        }
        double bestFinalScore = Double.NEGATIVE_INFINITY;
        int bestCurrentProduct = -1;
        for (int product = 0; product < productSizes[leftWindow + length - 1]; ++product) {
            if (!(score[leftWindow + length - 1][product] > bestFinalScore)) continue;
            bestCurrentProduct = product;
            bestFinalScore = score[leftWindow + length - 1][product];
        }
        int lastProduct = bestCurrentProduct;
        for (int last = padLength - 1; last >= length - 1 && last >= 0; --last) {
            tempTags[last] = tags[last][lastProduct % tagNum[last]];
            lastProduct /= tagNum[last];
        }
        for (int pos5 = leftWindow + length - 2; pos5 >= leftWindow; --pos5) {
            int bestNextProduct = bestCurrentProduct;
            bestCurrentProduct = trace[pos5 + 1][bestNextProduct];
            tempTags[pos5 - leftWindow] = tags[pos5 - leftWindow][bestCurrentProduct / (productSizes[pos5] / tagNum[pos5 - leftWindow])];
        }
        return new Pair<int[], Double>(tempTags, bestFinalScore);
    }

    private static int[] bestSequenceOld(SequenceModel ts) {
        int pos;
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        int padLength = length + leftWindow + rightWindow;
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos2 = 0; pos2 < padLength; ++pos2) {
            tags[pos2] = ts.getPossibleValues(pos2);
            tagNum[pos2] = tags[pos2].length;
        }
        int[] tempTags = new int[padLength];
        int[] productSizes = new int[padLength];
        int curProduct = 1;
        for (int i = 0; i < leftWindow + rightWindow; ++i) {
            curProduct *= tagNum[i];
        }
        for (int pos3 = leftWindow + rightWindow; pos3 < padLength; ++pos3) {
            if (pos3 > leftWindow + rightWindow) {
                curProduct /= tagNum[pos3 - leftWindow - rightWindow - 1];
            }
            productSizes[pos3 - rightWindow] = curProduct *= tagNum[pos3];
        }
        double[][] windowScore = new double[padLength][];
        for (int pos4 = leftWindow; pos4 < leftWindow + length; ++pos4) {
            windowScore[pos4] = new double[productSizes[pos4]];
            Arrays.fill(tempTags, tags[0][0]);
            for (int product = 0; product < productSizes[pos4]; ++product) {
                int p = product;
                for (int curPos = pos4 + rightWindow; curPos >= pos4 - leftWindow; --curPos) {
                    tempTags[curPos] = tags[curPos][p % tagNum[curPos]];
                    p /= tagNum[curPos];
                }
                windowScore[pos4][product] = ts.scoreOf(tempTags, pos4);
            }
        }
        double[][] score = new double[padLength][];
        int[][] trace = new int[padLength][];
        for (pos = 0; pos < padLength; ++pos) {
            score[pos] = new double[productSizes[pos]];
            trace[pos] = new int[productSizes[pos]];
        }
        for (pos = leftWindow; pos < length + leftWindow; ++pos) {
            for (int product = 0; product < productSizes[pos]; ++product) {
                if (pos == leftWindow) {
                    score[pos][product] = windowScore[pos][product];
                    trace[pos][product] = -1;
                    continue;
                }
                score[pos][product] = Double.NEGATIVE_INFINITY;
                trace[pos][product] = -1;
                int sharedProduct = product / tagNum[pos + rightWindow];
                int factor = productSizes[pos] / tagNum[pos + rightWindow];
                for (int newTagNum = 0; newTagNum < tagNum[pos - leftWindow - 1]; ++newTagNum) {
                    int predProduct = newTagNum * factor + sharedProduct;
                    double predScore = score[pos - 1][predProduct] + windowScore[pos][product];
                    if (!(predScore > score[pos][product])) continue;
                    score[pos][product] = predScore;
                    trace[pos][product] = predProduct;
                }
            }
        }
        double bestFinalScore = Double.NEGATIVE_INFINITY;
        int bestCurrentProduct = -1;
        for (int product = 0; product < productSizes[leftWindow + length - 1]; ++product) {
            if (!(score[leftWindow + length - 1][product] > bestFinalScore)) continue;
            bestCurrentProduct = product;
            bestFinalScore = score[leftWindow + length - 1][product];
        }
        int lastProduct = bestCurrentProduct;
        for (int last = padLength - 1; last >= length - 1; --last) {
            tempTags[last] = tags[last][lastProduct % tagNum[last]];
            lastProduct /= tagNum[last];
        }
        for (int pos5 = leftWindow + length - 2; pos5 >= leftWindow; --pos5) {
            int bestNextProduct = bestCurrentProduct;
            bestCurrentProduct = trace[pos5 + 1][bestNextProduct];
            tempTags[pos5 - leftWindow] = tags[pos5 - leftWindow][bestCurrentProduct / (productSizes[pos5] / tagNum[pos5 - leftWindow])];
        }
        return tempTags;
    }

    private static class TestSequenceModel
    implements SequenceModel {
        private int[] correctTags = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 6, 5, 4, 3, 2, 1, 0, 0};
        private int[] allTags = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        private int[] midTags = new int[]{0, 1, 2, 3};
        private int[] nullTags = new int[]{0};

        private TestSequenceModel() {
        }

        @Override
        public int length() {
            return this.correctTags.length - this.leftWindow() - this.rightWindow();
        }

        @Override
        public int leftWindow() {
            return 2;
        }

        @Override
        public int rightWindow() {
            return 2;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.leftWindow() || pos >= this.leftWindow() + this.length()) {
                return this.nullTags;
            }
            if (this.correctTags[pos] < 4) {
                return this.midTags;
            }
            return this.allTags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            boolean match = true;
            for (int loc = pos - this.leftWindow(); loc <= pos + this.rightWindow(); ++loc) {
                if (tags[loc] == this.correctTags[loc]) continue;
                match = false;
            }
            if (match) {
                return pos;
            }
            return 0.0;
        }

        @Override
        public double scoreOf(int[] sequence) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int[] tagsAtPos = this.getPossibleValues(pos);
            double[] scores = new double[tagsAtPos.length];
            for (int t = 0; t < tagsAtPos.length; ++t) {
                tags[pos] = tagsAtPos[t];
                scores[t] = this.scoreOf(tags, pos);
            }
            return scores;
        }
    }
}

