/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class TTags {
    private Index<String> index = new HashIndex<String>();
    private final Set<String> closed = Generics.newHashSet();
    private Set<String> openTags = null;
    private final boolean isEnglish;
    private static final boolean doDeterministicTagExpansion = true;
    private boolean openFixed = false;
    private final int closedTagThreshold = Integer.valueOf("40");
    private boolean learnClosedTags = false;

    public TTags() {
        this.isEnglish = false;
    }

    TTags(String language) {
        if (language.equalsIgnoreCase("english")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("EX");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("#");
            this.closed.add("MD");
            this.closed.add("CC");
            this.closed.add("DT");
            this.closed.add("LS");
            this.closed.add("PDT");
            this.closed.add("POS");
            this.closed.add("PRP");
            this.closed.add("PRP$");
            this.closed.add("RP");
            this.closed.add("TO");
            this.closed.add(".$$.");
            this.closed.add("UH");
            this.closed.add("WDT");
            this.closed.add("WP");
            this.closed.add("WP$");
            this.closed.add("WRB");
            this.closed.add("-LRB-");
            this.closed.add("-RRB-");
            this.isEnglish = true;
        } else if (language.equalsIgnoreCase("polish")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("#");
            this.closed.add("POS");
            this.closed.add(".$$.");
            this.closed.add("ppron12");
            this.closed.add("ppron3");
            this.closed.add("siebie");
            this.closed.add("qub");
            this.closed.add("conj");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("chinese")) {
            this.closed.add("AS");
            this.closed.add("BA");
            this.closed.add("CC");
            this.closed.add("CS");
            this.closed.add("DEC");
            this.closed.add("DEG");
            this.closed.add("DER");
            this.closed.add("DEV");
            this.closed.add("DT");
            this.closed.add("ETC");
            this.closed.add("IJ");
            this.closed.add("LB");
            this.closed.add("LC");
            this.closed.add("P");
            this.closed.add("PN");
            this.closed.add("PU");
            this.closed.add("SB");
            this.closed.add("SP");
            this.closed.add("VC");
            this.closed.add("VE");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("arabic")) {
            this.closed.add("PUNC");
            this.closed.add("CC");
            this.closed.add("CPRP$");
            this.closed.add(".$$.");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("german")) {
            this.closed.add("$,");
            this.closed.add("$.");
            this.closed.add("$(");
            this.closed.add("--");
            this.closed.add(".$$.");
            this.closed.add("KOKOM");
            this.closed.add("PPOSS");
            this.closed.add("PTKA");
            this.closed.add("PTKNEG");
            this.closed.add("PWAT");
            this.closed.add("VAINF");
            this.closed.add("VAPP");
            this.closed.add("VMINF");
            this.closed.add("VMPP");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("french")) {
            this.closed.add("!");
            this.closed.add("\"");
            this.closed.add("*");
            this.closed.add(",");
            this.closed.add("-");
            this.closed.add("-LRB-");
            this.closed.add("-RRB-");
            this.closed.add(".");
            this.closed.add("...");
            this.closed.add("/");
            this.closed.add(":");
            this.closed.add(";");
            this.closed.add("=");
            this.closed.add("?");
            this.closed.add("[");
            this.closed.add("]");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("medpost")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("EX");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("VM");
            this.closed.add("CC");
            this.closed.add("DD");
            this.closed.add("DB");
            this.closed.add("GE");
            this.closed.add("PND");
            this.closed.add("PNG");
            this.closed.add("TO");
            this.closed.add(".$$.");
            this.closed.add("-LRB-");
            this.closed.add("-RRB-");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("testing")) {
            this.closed.add(".");
            this.closed.add(".$$.");
            this.isEnglish = false;
        } else if (language.equalsIgnoreCase("")) {
            this.isEnglish = false;
        } else {
            throw new RuntimeException("unknown language: " + language);
        }
    }

    public Set<String> getOpenTags() {
        if (this.openTags == null) {
            Set<String> open = Generics.newHashSet();
            for (String tag : this.index) {
                if (this.closed.contains(tag)) continue;
                open.add(tag);
            }
            this.openTags = open;
        }
        return this.openTags;
    }

    protected int add(String tag) {
        this.index.add(tag);
        return this.index.indexOf(tag);
    }

    public String getTag(int i) {
        return this.index.get(i);
    }

    protected void save(String filename, Map<String, Set<String>> tagTokens) {
        try {
            OutDataStreamFile out2 = new OutDataStreamFile(filename);
            this.save(out2, tagTokens);
            out2.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected void save(DataOutputStream file, Map<String, Set<String>> tagTokens) {
        try {
            file.writeInt(this.index.size());
            for (String item : this.index) {
                file.writeUTF(item);
                if (this.learnClosedTags && tagTokens.get(item).size() < this.closedTagThreshold) {
                    this.markClosed(item);
                }
                file.writeBoolean(this.isClosed(item));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected void read(String filename) {
        try {
            InDataStreamFile in = new InDataStreamFile(filename);
            this.read(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream file) {
        try {
            int size = file.readInt();
            this.index = new HashIndex<String>();
            for (int i = 0; i < size; ++i) {
                String tag = file.readUTF();
                boolean inClosed = file.readBoolean();
                this.index.add(tag);
                if (!inClosed) continue;
                this.closed.add(tag);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean isClosed(String tag) {
        if (this.openFixed) {
            return !this.openTags.contains(tag);
        }
        return this.closed.contains(tag);
    }

    void markClosed(String tag) {
        this.add(tag);
        this.closed.add(tag);
    }

    public void setLearnClosedTags(boolean learn) {
        this.learnClosedTags = learn;
    }

    public void setOpenClassTags(String[] openClassTags) {
        this.openTags = Generics.newHashSet();
        this.openTags.addAll(Arrays.asList(openClassTags));
        for (String tag : openClassTags) {
            this.add(tag);
        }
        this.openFixed = true;
    }

    public void setClosedClassTags(String[] closedClassTags) {
        for (String tag : closedClassTags) {
            this.markClosed(tag);
        }
    }

    int getIndex(String tag) {
        return this.index.indexOf(tag);
    }

    public int getSize() {
        return this.index.size();
    }

    String[] deterministicallyExpandTags(String[] tags) {
        if (this.isEnglish) {
            boolean seenVBN = false;
            boolean seenVBD = false;
            boolean seenVB = false;
            boolean seenVBP = false;
            for (String tag : tags) {
                char ch = tag.charAt(0);
                if (ch != 'V') continue;
                if ("VBD".equals(tag)) {
                    seenVBD = true;
                    continue;
                }
                if ("VBN".equals(tag)) {
                    seenVBN = true;
                    continue;
                }
                if ("VB".equals(tag)) {
                    seenVB = true;
                    continue;
                }
                if (!"VBP".equals(tag)) continue;
                seenVBP = true;
            }
            int toAdd = 0;
            if (seenVBN ^ seenVBD) {
                ++toAdd;
            }
            if (seenVB ^ seenVBP) {
                ++toAdd;
            }
            if (toAdd > 0) {
                int ind = tags.length;
                String[] newTags = new String[ind + toAdd];
                System.arraycopy(tags, 0, newTags, 0, tags.length);
                if (seenVBN && !seenVBD) {
                    newTags[ind++] = "VBD";
                } else if (seenVBD && !seenVBN) {
                    newTags[ind++] = "VBN";
                }
                if (seenVB && !seenVBP) {
                    newTags[ind] = "VBP";
                } else if (seenVBP && !seenVB) {
                    newTags[ind] = "VB";
                }
                return newTags;
            }
            return tags;
        }
        return tags;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.index.toString());
        s.append(' ');
        if (this.openFixed) {
            s.append(" OPEN:").append(this.getOpenTags());
        } else {
            s.append(" open:").append(this.getOpenTags()).append(" CLOSED:").append(this.closed);
        }
        return s.toString();
    }
}

