/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TestOptions;
import edu.stanford.nlp.parser.lexparser.TrainOptions;
import edu.stanford.nlp.parser.lexparser.UnknownWordModel;
import edu.stanford.nlp.parser.lexparser.UnknownWordModelTrainer;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseLexicon
implements Lexicon {
    protected UnknownWordModel uwModel;
    protected final String uwModelTrainerClass;
    protected transient UnknownWordModelTrainer uwModelTrainer;
    protected static final boolean DEBUG_LEXICON = false;
    protected static final boolean DEBUG_LEXICON_SCORE = false;
    protected static final int nullWord = -1;
    protected static final short nullTag = -1;
    protected static final IntTaggedWord NULL_ITW = new IntTaggedWord(-1, -1);
    protected final TrainOptions trainOptions;
    protected final TestOptions testOptions;
    protected final Options op;
    protected int smoothInUnknownsThreshold;
    protected boolean smartMutation;
    protected final Index<String> wordIndex;
    protected final Index<String> tagIndex;
    public transient List<IntTaggedWord>[] rulesWithWord;
    protected transient Set<IntTaggedWord> tags = new HashSet<IntTaggedWord>();
    protected transient Set<IntTaggedWord> words = new HashSet<IntTaggedWord>();
    public ClassicCounter<IntTaggedWord> seenCounter = new ClassicCounter();
    double[] smooth = new double[]{1.0, 1.0};
    transient double[][] m_TT;
    transient double[] m_T;
    protected boolean flexiTag;
    protected boolean useSignatureForKnownSmoothing;
    private Map<String, Counter<String>> baseTagCounts = new HashMap<String, Counter<String>>();
    private transient int debugLastWord = -1;
    private transient int debugLoc = -1;
    private transient StringBuilder debugProbs;
    private transient StringBuilder debugNoProbs;
    private transient String debugPrefix;
    private static final int STATS_BINS = 15;
    int[] tagsToBaseTags = null;
    private static final long serialVersionUID = 40L;

    public BaseLexicon(Index<String> wordIndex, Index<String> tagIndex) {
        this(new Options(), wordIndex, tagIndex);
    }

    public BaseLexicon(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.flexiTag = op.lexOptions.flexiTag;
        this.useSignatureForKnownSmoothing = op.lexOptions.useSignatureForKnownSmoothing;
        this.smoothInUnknownsThreshold = op.lexOptions.smoothInUnknownsThreshold;
        this.smartMutation = op.lexOptions.smartMutation;
        this.trainOptions = op.trainOptions;
        this.testOptions = op.testOptions;
        this.op = op;
        this.uwModelTrainerClass = op.lexOptions.uwModelTrainer == null ? "edu.stanford.nlp.parser.lexparser.BaseUnknownWordModelTrainer" : op.lexOptions.uwModelTrainer;
    }

    @Override
    public boolean isKnown(int word) {
        return word < this.rulesWithWord.length && word >= 0 && !this.rulesWithWord[word].isEmpty();
    }

    @Override
    public boolean isKnown(String word) {
        if (!this.wordIndex.contains(word)) {
            return false;
        }
        IntTaggedWord iW = new IntTaggedWord(this.wordIndex.indexOf(word), -1);
        return this.seenCounter.getCount(iW) > 0.0;
    }

    public Iterator<IntTaggedWord> ruleIteratorByWord(String word, int loc) {
        return this.ruleIteratorByWord(this.wordIndex.indexOf(word, true), loc, null);
    }

    @Override
    public Iterator<IntTaggedWord> ruleIteratorByWord(int word, int loc, String featureSpec) {
        List<Object> wordTaggings;
        if (this.isKnown(word)) {
            if (!this.flexiTag) {
                wordTaggings = this.rulesWithWord[word];
            } else {
                IntTaggedWord iW = new IntTaggedWord(word, -1);
                if (this.seenCounter.getCount(iW) > (double)this.smoothInUnknownsThreshold) {
                    return this.rulesWithWord[word].iterator();
                }
                wordTaggings = new ArrayList(40);
                for (IntTaggedWord iTW2 : this.tags) {
                    IntTaggedWord iTW = new IntTaggedWord(word, iTW2.tag);
                    if (!(this.score(iTW, loc, this.wordIndex.get(word), null) > Float.NEGATIVE_INFINITY)) continue;
                    wordTaggings.add(iTW);
                }
            }
        } else {
            wordTaggings = new ArrayList(40);
            for (IntTaggedWord iTW : this.rulesWithWord[this.wordIndex.indexOf("UNK")]) {
                wordTaggings.add(new IntTaggedWord(word, iTW.tag));
            }
        }
        return wordTaggings.iterator();
    }

    @Override
    public Iterator<IntTaggedWord> ruleIteratorByWord(String word, int loc, String featureSpec) {
        return this.ruleIteratorByWord(this.wordIndex.indexOf(word, true), loc, featureSpec);
    }

    protected void initRulesWithWord() {
        if (this.testOptions.verbose) {
            System.err.print("\nInitializing lexicon scores ... ");
        }
        int unkWord = this.wordIndex.indexOf("UNK", true);
        int numWords = this.wordIndex.size();
        this.rulesWithWord = new List[numWords];
        for (int w = 0; w < numWords; ++w) {
            this.rulesWithWord[w] = new ArrayList<IntTaggedWord>(1);
        }
        this.tags = new HashSet<IntTaggedWord>();
        for (IntTaggedWord iTW : this.seenCounter.keySet()) {
            if (iTW.word() != -1 || iTW.tag() == -1) continue;
            this.tags.add(iTW);
        }
        for (IntTaggedWord iT : this.tags) {
            double types = this.uwModel.unSeenCounter().getCount(iT);
            if (!(types > (double)this.trainOptions.openClassTypesThreshold)) continue;
            IntTaggedWord iTW = new IntTaggedWord(unkWord, iT.tag);
            this.rulesWithWord[iTW.word].add(iTW);
        }
        if (this.testOptions.verbose) {
            System.err.print("The " + this.rulesWithWord[unkWord].size() + " open class tags are: [");
            for (IntTaggedWord item : this.rulesWithWord[unkWord]) {
                System.err.print(" " + this.tagIndex.get(item.tag()));
            }
            System.err.println(" ] ");
        }
        for (IntTaggedWord iTW : this.seenCounter.keySet()) {
            if (iTW.tag() == -1 || iTW.word() == -1) continue;
            this.rulesWithWord[iTW.word].add(iTW);
        }
    }

    protected List<IntTaggedWord> treeToEvents(Tree tree) {
        ArrayList<TaggedWord> taggedWords = tree.taggedYield();
        return this.listToEvents(taggedWords);
    }

    protected List<IntTaggedWord> listToEvents(List<TaggedWord> taggedWords) {
        ArrayList<IntTaggedWord> itwList = new ArrayList<IntTaggedWord>();
        for (TaggedWord tw : taggedWords) {
            IntTaggedWord iTW = new IntTaggedWord(tw.word(), tw.tag(), this.wordIndex, this.tagIndex);
            itwList.add(iTW);
        }
        return itwList;
    }

    public void addAll(List<TaggedWord> tagWords) {
        this.addAll(tagWords, 1.0);
    }

    public void addAll(List<TaggedWord> taggedWords, double weight) {
        List<IntTaggedWord> tagWords = this.listToEvents(taggedWords);
    }

    public void trainWithExpansion(Collection<TaggedWord> taggedWords) {
    }

    @Override
    public void initializeTraining(double numTrees) {
        this.uwModelTrainer = (UnknownWordModelTrainer)ReflectionLoading.loadByReflection(this.uwModelTrainerClass, new Object[0]);
        this.uwModelTrainer.initializeTraining(this.op, this, this.wordIndex, this.tagIndex, numTrees);
    }

    @Override
    public void train(Collection<Tree> trees) {
        this.train(trees, 1.0);
    }

    @Override
    public void train(Collection<Tree> trees, double weight) {
        for (Tree tree : trees) {
            this.train(tree, weight);
        }
    }

    @Override
    public void train(Tree tree, double weight) {
        this.train((List<TaggedWord>)tree.taggedYield(), weight);
    }

    @Override
    public final void train(List<TaggedWord> sentence, double weight) {
        this.uwModelTrainer.incrementTreesRead(weight);
        int loc = 0;
        for (TaggedWord tw : sentence) {
            this.train(tw, loc, weight);
            ++loc;
        }
    }

    @Override
    public final void incrementTreesRead(double weight) {
        this.uwModelTrainer.incrementTreesRead(weight);
    }

    @Override
    public final void trainUnannotated(List<TaggedWord> sentence, double weight) {
        this.uwModelTrainer.incrementTreesRead(weight);
        int loc = 0;
        for (TaggedWord tw : sentence) {
            String baseTag = this.op.langpack().basicCategory(tw.tag());
            Counter<String> counts = this.baseTagCounts.get(baseTag);
            if (counts == null) {
                ++loc;
                continue;
            }
            double totalCount = counts.totalCount();
            if (totalCount == 0.0) {
                ++loc;
                continue;
            }
            for (String tag : counts.keySet()) {
                TaggedWord newTW = new TaggedWord(tw.word(), tag);
                this.train(newTW, loc, weight * counts.getCount(tag) / totalCount);
            }
            ++loc;
        }
    }

    @Override
    public void train(TaggedWord tw, int loc, double weight) {
        this.uwModelTrainer.train(tw, loc, weight);
        IntTaggedWord iTW = new IntTaggedWord(tw.word(), tw.tag(), this.wordIndex, this.tagIndex);
        this.seenCounter.incrementCount(iTW, weight);
        IntTaggedWord iT = new IntTaggedWord(-1, iTW.tag);
        this.seenCounter.incrementCount(iT, weight);
        IntTaggedWord iW = new IntTaggedWord(iTW.word, -1);
        this.seenCounter.incrementCount(iW, weight);
        IntTaggedWord i = new IntTaggedWord(-1, -1);
        this.seenCounter.incrementCount(i, weight);
        this.tags.add(iT);
        this.words.add(iW);
        String tag = tw.tag();
        String baseTag = this.op.langpack().basicCategory(tag);
        Counter<String> counts = this.baseTagCounts.get(baseTag);
        if (counts == null) {
            counts = new ClassicCounter<String>();
            this.baseTagCounts.put(baseTag, counts);
        }
        counts.incrementCount(tag, weight);
    }

    @Override
    public void finishTraining() {
        this.uwModel = this.uwModelTrainer.finishTraining();
        this.tune();
        this.initRulesWithWord();
    }

    protected void addTagging(boolean seen, IntTaggedWord itw, double count) {
        if (seen) {
            this.seenCounter.incrementCount(itw, count);
            if (itw.tag() == -1) {
                this.words.add(itw);
            } else if (itw.word() == -1) {
                this.tags.add(itw);
            }
        } else {
            this.uwModel.addTagging(seen, itw, count);
        }
    }

    void buildPT_T() {
        int numTags = this.tagIndex.size();
        this.m_TT = new double[numTags][numTags];
        this.m_T = new double[numTags];
        double[] tmp = new double[numTags];
        for (IntTaggedWord word : this.words) {
            int t;
            double tot = 0.0;
            for (t = 0; t < numTags; ++t) {
                IntTaggedWord iTW = new IntTaggedWord(word.word, t);
                tmp[t] = this.seenCounter.getCount(iTW);
                tot += tmp[t];
            }
            if (tot < 10.0) continue;
            for (t = 0; t < numTags; ++t) {
                for (int t2 = 0; t2 < numTags; ++t2) {
                    if (!(tmp[t2] > 0.0)) continue;
                    double c = tmp[t] / tot;
                    int n = t;
                    this.m_T[n] = this.m_T[n] + c;
                    double[] dArray = this.m_TT[t2];
                    int n2 = t;
                    dArray[n2] = dArray[n2] + c;
                }
            }
        }
    }

    @Override
    public float score(IntTaggedWord iTW, int loc, String word, String featureSpec) {
        double pb_W_T;
        boolean seen;
        double c_TW = this.seenCounter.getCount(iTW);
        IntTaggedWord temp = new IntTaggedWord(iTW.word, -1);
        double c_W = this.seenCounter.getCount(temp);
        double total = this.seenCounter.getCount(NULL_ITW);
        double totalUnseen = this.uwModel.unSeenCounter().getCount(NULL_ITW);
        temp = new IntTaggedWord(-1, iTW.tag);
        double c_T = this.seenCounter.getCount(temp);
        double c_Tunseen = this.uwModel.unSeenCounter().getCount(temp);
        boolean bl = seen = c_W > 0.0;
        if (seen) {
            double pb_T_W;
            double p_T_U = this.useSignatureForKnownSmoothing ? this.getUnknownWordModel().scoreProbTagGivenWordSignature(iTW, loc, this.smooth[0], word) : c_Tunseen / totalUnseen;
            if (c_W > (double)this.smoothInUnknownsThreshold && c_TW > 0.0 && c_W > 0.0) {
                pb_T_W = c_TW / c_W;
            } else {
                if (this.smartMutation) {
                    int numTags = this.tagIndex.size();
                    if (this.m_TT == null || numTags != this.m_T.length) {
                        this.buildPT_T();
                    }
                    p_T_U *= 0.1;
                    for (int t = 0; t < numTags; ++t) {
                        IntTaggedWord iTW2 = new IntTaggedWord(iTW.word, t);
                        double p_T_W2 = this.seenCounter.getCount(iTW2) / c_W;
                        if (!(p_T_W2 > 0.0)) continue;
                        p_T_U += p_T_W2 * this.m_TT[iTW.tag][t] / this.m_T[t] * 0.9;
                    }
                }
                pb_T_W = (c_TW + this.smooth[1] * p_T_U) / (c_W + this.smooth[1]);
            }
            double p_T = c_T / total;
            double p_W = c_W / total;
            pb_W_T = Math.log(pb_T_W * p_W / p_T);
        } else if (loc >= 0) {
            pb_W_T = this.getUnknownWordModel().score(iTW, loc, c_T, total, this.smooth[0], word);
        } else {
            double pb_W0_T = this.getUnknownWordModel().score(iTW, 0, c_T, total, this.smooth[0], word);
            double pb_W1_T = this.getUnknownWordModel().score(iTW, 1, c_T, total, this.smooth[0], word);
            pb_W_T = Math.log((Math.exp(pb_W0_T) + 2.0 * Math.exp(pb_W1_T)) / 3.0);
        }
        String tag = this.tagIndex.get(iTW.tag());
        if (pb_W_T > -100.0) {
            return (float)pb_W_T;
        }
        return Float.NEGATIVE_INFINITY;
    }

    public final void tune() {
        double bestScore = Double.NEGATIVE_INFINITY;
        double[] bestSmooth = new double[]{0.0, 0.0};
        this.smooth[0] = 1.0;
        while (this.smooth[0] <= 1.0) {
            this.smooth[1] = 0.2;
            while (this.smooth[1] <= 0.2) {
                double score = 0.0;
                if (this.testOptions.verbose) {
                    System.err.println("Tuning lexicon: s0 " + this.smooth[0] + " s1 " + this.smooth[1] + " is " + score);
                }
                if (score > bestScore) {
                    System.arraycopy(this.smooth, 0, bestSmooth, 0, this.smooth.length);
                    bestScore = score;
                }
                this.smooth[1] = this.smooth[1] * 2.0;
            }
            this.smooth[0] = this.smooth[0] * 2.0;
        }
        System.arraycopy(bestSmooth, 0, this.smooth, 0, bestSmooth.length);
        if (this.smartMutation) {
            this.smooth[0] = 8.0;
            this.smooth[1] = 0.1;
        }
        if (this.testOptions.unseenSmooth > 0.0) {
            this.smooth[0] = this.testOptions.unseenSmooth;
        }
        if (this.testOptions.verbose) {
            System.err.println("Tuning selected smoothUnseen " + this.smooth[0] + " smoothSeen " + this.smooth[1] + " at " + bestScore);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initRulesWithWord();
    }

    @Override
    public void readData(BufferedReader in) throws IOException {
        String SEEN = "SEEN";
        int lineNum = 1;
        String line = in.readLine();
        Pattern p = Pattern.compile("^smooth\\[([0-9])\\] = (.*)$");
        while (line != null && line.length() > 0) {
            try {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    int i = Integer.parseInt(m.group(1));
                    this.smooth[i] = Double.parseDouble(m.group(2));
                } else {
                    String[] fields = StringUtils.splitOnCharWithQuoting(line, ' ', '\"', '\\');
                    boolean seen = fields[3].equals("SEEN");
                    this.addTagging(seen, new IntTaggedWord(fields[2], fields[0], this.wordIndex, this.tagIndex), Double.parseDouble(fields[4]));
                }
            }
            catch (RuntimeException e) {
                throw new IOException("Error on line " + lineNum + ": " + line, e);
            }
            ++lineNum;
            line = in.readLine();
        }
        this.initRulesWithWord();
    }

    @Override
    public void writeData(Writer w) throws IOException {
        PrintWriter out2 = new PrintWriter(w);
        for (IntTaggedWord itw : this.seenCounter.keySet()) {
            out2.println(itw.toLexicalEntry(this.wordIndex, this.tagIndex) + " SEEN " + this.seenCounter.getCount(itw));
        }
        for (IntTaggedWord itw : this.getUnknownWordModel().unSeenCounter().keySet()) {
            out2.println(itw.toLexicalEntry(this.wordIndex, this.tagIndex) + " UNSEEN " + this.getUnknownWordModel().unSeenCounter().getCount(itw));
        }
        for (int i = 0; i < this.smooth.length; ++i) {
            out2.println("smooth[" + i + "] = " + this.smooth[i]);
        }
        out2.flush();
    }

    @Override
    public int numRules() {
        int accumulated = 0;
        for (List<IntTaggedWord> lis : this.rulesWithWord) {
            accumulated += lis.size();
        }
        return accumulated;
    }

    protected void examineIntersection(Set<String> s1, Set<String> s2) {
        HashSet<String> knownTypes = new HashSet<String>(s1);
        knownTypes.retainAll(s2);
        if (knownTypes.size() != 0) {
            System.err.printf("|intersect|: %d%n", knownTypes.size());
            for (String word : knownTypes) {
                System.err.print(word + " ");
            }
            System.err.println();
        }
    }

    public void printLexStats() {
        int j;
        System.out.println("BaseLexicon statistics");
        System.out.println("unknownLevel is " + this.getUnknownWordModel().getUnknownLevel());
        System.out.println("Sum of rulesWithWord: " + this.numRules());
        System.out.println("Tags size: " + this.tags.size());
        int wsize = this.words.size();
        System.out.println("Words size: " + wsize);
        System.out.println("rulesWithWord length: " + this.rulesWithWord.length + " [should be sum of words + unknown sigs]");
        int[] lengths = new int[15];
        ArrayList[] wArr = new ArrayList[15];
        for (j = 0; j < 15; ++j) {
            wArr[j] = new ArrayList();
        }
        for (int i = 0; i < this.rulesWithWord.length; ++i) {
            int num = this.rulesWithWord[i].size();
            if (num > 14) {
                num = 14;
            }
            int n = num;
            lengths[n] = lengths[n] + 1;
            if (wsize > 20 && num < 7) continue;
            wArr[num].add(this.wordIndex.get(i));
        }
        System.out.println("Stats on how many taggings for how many words");
        for (j = 0; j < 15; ++j) {
            System.out.print(j + " taggings: " + lengths[j] + " words ");
            if (wsize <= 20 || j >= 7) {
                System.out.print(wArr[j]);
            }
            System.out.println();
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(0);
        System.out.println("Unseen counter: " + Counters.toString(this.uwModel.unSeenCounter(), nf));
        if (wsize < 50 && this.tags.size() < 10) {
            nf.setMaximumFractionDigits(3);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Tagging probabilities log P(word|tag)");
            for (int t = 0; t < this.tags.size(); ++t) {
                pw.print('\t');
                pw.print(this.tagIndex.get(t));
            }
            pw.println();
            for (int w = 0; w < wsize; ++w) {
                pw.print(this.wordIndex.get(w));
                pw.print('\t');
                for (int t = 0; t < this.tags.size(); ++t) {
                    IntTaggedWord iTW = new IntTaggedWord(w, t);
                    pw.print(nf.format(this.score(iTW, 1, this.wordIndex.get(w), null)));
                    if (t == this.tags.size() - 1) {
                        pw.println();
                        continue;
                    }
                    pw.print('\t');
                }
            }
            pw.close();
            System.out.println(sw.toString());
        }
    }

    public double evaluateCoverage(Collection<Tree> trees, Set<String> missingWords, Set<String> missingTags, Set<IntTaggedWord> missingTW) {
        ArrayList<IntTaggedWord> iTW1 = new ArrayList<IntTaggedWord>();
        for (Tree t : trees) {
            iTW1.addAll(this.treeToEvents(t));
        }
        int total = 0;
        int unseen = 0;
        for (IntTaggedWord itw : iTW1) {
            ++total;
            if (!this.words.contains(new IntTaggedWord(itw.word(), -1))) {
                missingWords.add(this.wordIndex.get(itw.word()));
            }
            if (!this.tags.contains(new IntTaggedWord(-1, itw.tag()))) {
                missingTags.add(this.tagIndex.get(itw.tag()));
            }
            if (this.seenCounter.getCount(itw) != 0.0) continue;
            ++unseen;
            missingTW.add(itw);
        }
        return (double)unseen / (double)total;
    }

    public int getBaseTag(int tag, TreebankLanguagePack tlp) {
        if (this.tagsToBaseTags == null) {
            this.populateTagsToBaseTags(tlp);
        }
        return this.tagsToBaseTags[tag];
    }

    private void populateTagsToBaseTags(TreebankLanguagePack tlp) {
        int total = this.tagIndex.size();
        this.tagsToBaseTags = new int[total];
        for (int i = 0; i < total; ++i) {
            int j;
            String tag = this.tagIndex.get(i);
            String baseTag = tlp.basicCategory(tag);
            this.tagsToBaseTags[i] = j = this.tagIndex.indexOf(baseTag, true);
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("java BaseLexicon treebankPath fileRange unknownWordModel words*");
            return;
        }
        System.out.print("Training BaseLexicon from " + args[0] + ' ' + args[1] + " ... ");
        DiskTreebank tb = new DiskTreebank();
        tb.loadPath(args[0], (FileFilter)new NumberRangesFileFilter(args[1], true));
        HashIndex<String> wordIndex = new HashIndex<String>();
        HashIndex<String> tagIndex = new HashIndex<String>();
        Options op = new Options();
        op.lexOptions.useUnknownWordSignatures = Integer.parseInt(args[2]);
        BaseLexicon lex = new BaseLexicon(op, wordIndex, tagIndex);
        lex.initializeTraining(tb.size());
        lex.train(tb);
        lex.finishTraining();
        System.out.println("done.");
        System.out.println();
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        ArrayList<String> impos = new ArrayList<String>();
        for (int i = 3; i < args.length; ++i) {
            if (lex.isKnown(args[i])) {
                System.out.println(args[i] + " is a known word.  Log probabilities [log P(w|t)] for its taggings are:");
                Iterator<IntTaggedWord> it = lex.ruleIteratorByWord(wordIndex.indexOf(args[i], true), i - 3, null);
                while (it.hasNext()) {
                    IntTaggedWord iTW = it.next();
                    System.out.println(StringUtils.pad(iTW, 24) + nf.format(lex.score(iTW, i - 3, (String)wordIndex.get(iTW.word), null)));
                }
            } else {
                String sig = lex.getUnknownWordModel().getSignature(args[i], i - 3);
                System.out.println(args[i] + " is an unknown word.  Signature with uwm " + lex.getUnknownWordModel().getUnknownLevel() + (i == 3 ? " init" : "non-init") + " is: " + sig);
                impos.clear();
                ArrayList lis = new ArrayList(tagIndex.objectsList());
                Collections.sort(lis);
                for (String tStr : lis) {
                    IntTaggedWord iTW = new IntTaggedWord(args[i], tStr, wordIndex, tagIndex);
                    double score = lex.score(iTW, 1, args[i], null);
                    if (score == Double.NEGATIVE_INFINITY) {
                        impos.add(tStr);
                        continue;
                    }
                    System.out.println(StringUtils.pad(iTW, 24) + nf.format(score));
                }
                if (impos.size() > 0) {
                    System.out.println(args[i] + " impossible tags: " + impos);
                }
            }
            System.out.println();
        }
    }

    @Override
    public UnknownWordModel getUnknownWordModel() {
        return this.uwModel;
    }

    @Override
    public final void setUnknownWordModel(UnknownWordModel uwm) {
        this.uwModel = uwm;
    }

    @Override
    public void train(Collection<Tree> trees, Collection<Tree> rawTrees) {
        this.train(trees);
    }
}

