/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.Redwood;

public interface LogFilter {
    public boolean matches(Redwood.Record var1);

    public static class MatchesMessage
    implements LogFilter {
        private Object message;

        public MatchesMessage(Object message) {
            this.message = message;
        }

        @Override
        public boolean matches(Redwood.Record record) {
            return record.content.equals(this.message);
        }
    }

    public static class ContainsMessage
    implements LogFilter {
        private String substring;

        public ContainsMessage(String message) {
            this.substring = message;
        }

        @Override
        public boolean matches(Redwood.Record record) {
            String content = record.content.toString();
            return content.contains(this.substring);
        }
    }

    public static class HasChannel
    implements LogFilter {
        private Object matchingChannel;

        public HasChannel(Object message) {
            this.matchingChannel = message;
        }

        @Override
        public boolean matches(Redwood.Record record) {
            for (Object tag : record.channels()) {
                if (!tag.equals(this.matchingChannel)) continue;
                return true;
            }
            return false;
        }
    }
}

