/**
 * <p>A collection of useful general-purpose utility classes. Below is a selection
 * of some of the most useful utility classes. Consult the class comments for
 * more details on any of these classes.</p>
 * <ul>
 *   <li>{@link edu.stanford.nlp.util.Filters}: Defines general useful {@link java.util.function.Predicate}
 *   and utility functions for dealing with predicates.</li>
 *   <li>{@link edu.stanford.nlp.util.Index}: List that also maintains a constant-time reverse-lookup of indices for its
 *   Objects.</li>
 *   <li>{@link edu.stanford.nlp.util.StringUtils}: Static class with lots of useful String manipulation and formatting
 *   methods.</li>
 *   <li>{@link edu.stanford.nlp.util.Timing}: Static class for measuring how long something takes to execute.</li>
 * </ul>
 *
 * <p><b>Other packages with some useful utilies</b></p>
 * <dl>
 * <dt>{@link edu.stanford.nlp.io}</dt>
 * <dd>Contains some useful classes for traversing file systems to get lists of
 * files, writing encoded output, and so on.</dd>
 * <dt>{@link edu.stanford.nlp.process}</dt>
 * <dd>Contains many useful text-filtering classes (they work on Documents from
 * the dbm package).</dd>
 * <dt>{@link edu.stanford.nlp.stats}</dt>
 * <dd>Contains some useful classes for tracking statistics (counts) and
 * performing various calculations (e.g. precision/recall)</dd>
 * <dt>{@link edu.stanford.nlp.swing}</dt>
 * <dd>Contains utilities for working with Swing GUIs, e.g. adding icons to your
 * buttons, representing a GUI for properties, adding undo/redo support, adding
 * smart text selection, etc.</dd>
 * <dt>{@link edu.stanford.nlp.web}</dt>
 * <dd>Contains some classes for doing programmatic web searches and parsing web
 * pages.</dd>
 * </dl>
 */
package edu.stanford.nlp.util;