/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.BooleanLogRecordHandler;
import edu.stanford.nlp.util.logging.LogFilter;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.List;

public class FilterHandler
extends BooleanLogRecordHandler {
    private List<LogFilter> filters;
    private boolean disjunctiveMode;

    public FilterHandler(List<LogFilter> filters, boolean disjunctiveMode) {
        this.filters = filters;
        this.disjunctiveMode = disjunctiveMode;
    }

    @Override
    public boolean propagateRecord(Redwood.Record record) {
        for (LogFilter filter : this.filters) {
            boolean match = filter.matches(record);
            if (match && this.disjunctiveMode) {
                return true;
            }
            if (match || this.disjunctiveMode) continue;
            return false;
        }
        return !this.disjunctiveMode;
    }
}

