/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.CopulaHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.Map;

public abstract class AbstractCollinsHeadFinder
implements HeadFinder,
CopulaHeadFinder {
    private static final boolean DEBUG = false;
    protected final TreebankLanguagePack tlp;
    protected Map<String, String[][]> nonTerminalInfo;
    protected String[] defaultRule;
    protected String[] defaultLeftRule;
    protected String[] defaultRightRule;
    private static final long serialVersionUID = -6540278059442931087L;

    protected AbstractCollinsHeadFinder(TreebankLanguagePack tlp, String ... categoriesToAvoid) {
        this.tlp = tlp;
        this.defaultLeftRule = new String[categoriesToAvoid.length + 1];
        this.defaultRightRule = new String[categoriesToAvoid.length + 1];
        if (categoriesToAvoid.length > 0) {
            this.defaultLeftRule[0] = "leftexcept";
            this.defaultRightRule[0] = "rightexcept";
            System.arraycopy(categoriesToAvoid, 0, this.defaultLeftRule, 1, categoriesToAvoid.length);
            System.arraycopy(categoriesToAvoid, 0, this.defaultRightRule, 1, categoriesToAvoid.length);
        } else {
            this.defaultLeftRule[0] = "left";
            this.defaultRightRule[0] = "right";
        }
    }

    @Override
    public boolean makesCopulaHead() {
        return false;
    }

    protected Tree findMarkedHead(Tree t) {
        return null;
    }

    @Override
    public Tree determineHead(Tree t) {
        return this.determineHead(t, null);
    }

    @Override
    public Tree determineHead(Tree t, Tree parent) {
        if (this.nonTerminalInfo == null) {
            throw new IllegalStateException("Classes derived from AbstractCollinsHeadFinder must create and fill HashMap nonTerminalInfo.");
        }
        if (t == null || t.isLeaf()) {
            throw new IllegalArgumentException("Can't return head of null or leaf Tree.");
        }
        Tree[] kids = t.children();
        Tree theHead = this.findMarkedHead(t);
        if (theHead != null) {
            return theHead;
        }
        if (kids.length == 1) {
            return kids[0];
        }
        return this.determineNonTrivialHead(t, parent);
    }

    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        boolean lastResort;
        Tree theHead = null;
        String motherCat = this.tlp.basicCategory(t.label().value());
        String[][] how = this.nonTerminalInfo.get(motherCat);
        Tree[] kids = t.children();
        if (how == null) {
            if (this.defaultRule != null) {
                return this.traverseLocate(kids, this.defaultRule, true);
            }
            throw new IllegalArgumentException("No head rule defined for " + motherCat + " using " + this.getClass() + " in " + t);
        }
        for (int i = 0; i < how.length && (theHead = this.traverseLocate(kids, how[i], lastResort = i == how.length - 1)) == null; ++i) {
        }
        return theHead;
    }

    protected Tree traverseLocate(Tree[] daughterTrees, String[] how, boolean lastResort) {
        int headIdx;
        if (how[0].equals("left")) {
            headIdx = this.findLeftHead(daughterTrees, how);
        } else if (how[0].equals("leftdis")) {
            headIdx = this.findLeftDisHead(daughterTrees, how);
        } else if (how[0].equals("leftexcept")) {
            headIdx = this.findLeftExceptHead(daughterTrees, how);
        } else if (how[0].equals("right")) {
            headIdx = this.findRightHead(daughterTrees, how);
        } else if (how[0].equals("rightdis")) {
            headIdx = this.findRightDisHead(daughterTrees, how);
        } else if (how[0].equals("rightexcept")) {
            headIdx = this.findRightExceptHead(daughterTrees, how);
        } else {
            throw new IllegalStateException("ERROR: invalid direction type " + how[0] + " to nonTerminalInfo map in AbstractCollinsHeadFinder.");
        }
        if (headIdx < 0) {
            if (lastResort) {
                String[] rule;
                if (how[0].startsWith("left")) {
                    headIdx = 0;
                    rule = this.defaultLeftRule;
                } else {
                    headIdx = daughterTrees.length - 1;
                    rule = this.defaultRightRule;
                }
                Tree child = this.traverseLocate(daughterTrees, rule, false);
                if (child != null) {
                    return child;
                }
                return daughterTrees[headIdx];
            }
            return null;
        }
        headIdx = this.postOperationFix(headIdx, daughterTrees);
        return daughterTrees[headIdx];
    }

    private int findLeftHead(Tree[] daughterTrees, String[] how) {
        for (int i = 1; i < how.length; ++i) {
            for (int headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findLeftDisHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findLeftExceptHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            boolean found = true;
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                found = false;
            }
            if (!found) continue;
            return headIdx;
        }
        return -1;
    }

    private int findRightHead(Tree[] daughterTrees, String[] how) {
        for (int i = 1; i < how.length; ++i) {
            for (int headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findRightDisHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findRightExceptHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            boolean found = true;
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                found = false;
            }
            if (!found) continue;
            return headIdx;
        }
        return -1;
    }

    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        return headIdx;
    }
}

