/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexParseException;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GrammaticalRelation
implements Comparable<GrammaticalRelation>,
Serializable {
    private static final long serialVersionUID = 892618003417550128L;
    private static final boolean DEBUG = false;
    private static final Map<Class<? extends GrammaticalRelationAnnotation>, GrammaticalRelation> annotationsToRelations = Generics.newHashMap();
    private static final Map<GrammaticalRelation, Class<? extends GrammaticalRelationAnnotation>> relationsToAnnotations = Generics.newHashMap();
    private static final EnumMap<Language, Map<String, GrammaticalRelation>> stringsToRelations = new EnumMap(Language.class);
    public static final GrammaticalRelation GOVERNOR = new GrammaticalRelation(Language.Any, "gov", "governor", GovernorGRAnnotation.class, null);
    public static final GrammaticalRelation DEPENDENT = new GrammaticalRelation(Language.Any, "dep", "dependent", DependentGRAnnotation.class, null);
    public static final GrammaticalRelation ROOT = new GrammaticalRelation(Language.Any, "root", "root", RootGRAnnotation.class, null);
    public static final GrammaticalRelation KILL = new GrammaticalRelation(Language.Any, "KILL", "dummy relation kill", KillGRAnnotation.class, null);
    private final Language language;
    private final String shortName;
    private final String longName;
    private final GrammaticalRelation parent;
    private final List<GrammaticalRelation> children = new ArrayList<GrammaticalRelation>();
    private final Pattern sourcePattern;
    private final List<TregexPattern> targetPatterns = new ArrayList<TregexPattern>();
    private final String specific;

    public static Class<? extends GrammaticalRelationAnnotation> getAnnotationClass(GrammaticalRelation relation) {
        return relationsToAnnotations.get(relation);
    }

    public static GrammaticalRelation getRelation(Class<? extends GrammaticalRelationAnnotation> annotation) {
        return annotationsToRelations.get(annotation);
    }

    public static GrammaticalRelation valueOf(String s, Collection<GrammaticalRelation> values) {
        for (GrammaticalRelation reln : values) {
            if (!reln.toString().equals(s)) continue;
            return reln;
        }
        return null;
    }

    public static GrammaticalRelation valueOf(Language language, String s) {
        GrammaticalRelation reln;
        GrammaticalRelation grammaticalRelation = reln = stringsToRelations.get((Object)language) != null ? GrammaticalRelation.valueOf(s, stringsToRelations.get((Object)language).values()) : null;
        if (reln == null) {
            reln = EnglishGrammaticalRelations.valueOf(s);
        }
        if (reln == null) {
            String specific;
            String name;
            int underscorePosition = s.indexOf(95);
            if (underscorePosition > 0) {
                name = s.substring(0, underscorePosition);
                specific = s.substring(underscorePosition + 1);
            } else {
                name = s;
                specific = null;
            }
            reln = new GrammaticalRelation(language, name, null, null, null, specific);
        }
        return reln;
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(Language.English, s);
    }

    public boolean isFromString() {
        return this.longName == null;
    }

    private GrammaticalRelation(Language language, String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent, String sourcePattern, TregexPatternCompiler tregexCompiler, String[] targetPatterns, String specificString) {
        GrammaticalRelation previous;
        this.language = language;
        this.shortName = shortName;
        this.longName = longName;
        this.parent = parent;
        this.specific = specificString;
        if (parent != null) {
            parent.addChild(this);
        }
        if (annotation != null) {
            if (annotationsToRelations.put(annotation, this) != null) {
                throw new IllegalArgumentException("Annotation cannot be associated with more than one relation!");
            }
            if (relationsToAnnotations.put(this, annotation) != null) {
                throw new IllegalArgumentException("There should only ever be one instance of each relation!");
            }
        }
        if (sourcePattern != null) {
            try {
                this.sourcePattern = Pattern.compile(sourcePattern);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Bad pattern: " + sourcePattern);
            }
        } else {
            this.sourcePattern = null;
        }
        for (String pattern : targetPatterns) {
            try {
                TregexPattern p = tregexCompiler.compile(pattern);
                this.targetPatterns.add(p);
            }
            catch (TregexParseException pe) {
                throw new RuntimeException("Bad pattern: " + pattern, pe);
            }
        }
        Map<String, GrammaticalRelation> sToR = stringsToRelations.get((Object)language);
        if (sToR == null) {
            sToR = Generics.newHashMap();
            stringsToRelations.put(language, sToR);
        }
        if ((previous = sToR.put(this.toString(), this)) != null && !previous.isFromString() && !this.isFromString()) {
            throw new IllegalArgumentException("There is already a relation named " + this.toString() + '!');
        }
    }

    public GrammaticalRelation(Language language, String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent, String sourcePattern, TregexPatternCompiler tregexCompiler, String[] targetPatterns) {
        this(language, shortName, longName, annotation, parent, sourcePattern, tregexCompiler, targetPatterns, null);
    }

    public GrammaticalRelation(Language language, String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent) {
        this(language, shortName, longName, annotation, parent, null, null, StringUtils.EMPTY_STRING_ARRAY, null);
    }

    public GrammaticalRelation(Language language, String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent, String specificString) {
        this(language, shortName, longName, annotation, parent, null, null, StringUtils.EMPTY_STRING_ARRAY, specificString);
    }

    private void addChild(GrammaticalRelation child) {
        this.children.add(child);
    }

    public Collection<Tree> getRelatedNodes(Tree t, Tree root) {
        ArraySet<Tree> nodeList = new ArraySet<Tree>();
        for (TregexPattern p : this.targetPatterns) {
            TregexMatcher m = p.matcher(root);
            while (m.findAt(t)) {
                nodeList.add(m.getNode("target"));
            }
        }
        return nodeList;
    }

    public boolean isApplicable(Tree t) {
        return this.sourcePattern != null && t.value() != null && this.sourcePattern.matcher(t.value()).matches();
    }

    public boolean isAncestor(GrammaticalRelation gr) {
        while (gr != null) {
            if (this.equals(gr)) {
                return true;
            }
            gr = gr.parent;
        }
        return false;
    }

    public final String toString() {
        if (this.specific == null) {
            return this.shortName;
        }
        return this.shortName + '_' + this.specific;
    }

    public String toPrettyString() {
        StringBuilder buf = new StringBuilder("\n");
        this.toPrettyString(0, buf);
        return buf.toString();
    }

    private void toPrettyString(int indentLevel, StringBuilder buf) {
        for (int i = 0; i < indentLevel; ++i) {
            buf.append("  ");
        }
        buf.append(this.shortName).append(": ").append(this.targetPatterns);
        for (GrammaticalRelation child : this.children) {
            buf.append('\n');
            child.toPrettyString(indentLevel + 1, buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            new Throwable("Warning: comparing GrammaticalRelation to String").printStackTrace();
            return this.toString().equals(o);
        }
        if (!(o instanceof GrammaticalRelation)) {
            return false;
        }
        GrammaticalRelation gr = (GrammaticalRelation)o;
        return this.language == gr.language && this.shortName.equals(gr.shortName) && (this.specific == gr.specific || this.specific != null && this.specific.equals(gr.specific));
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + (this.language != null ? this.language.toString().hashCode() : 0);
        result = 29 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
        result = 29 * result + (this.specific != null ? this.specific.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(GrammaticalRelation o) {
        String thisN = this.toString();
        String oN = o.toString();
        return thisN.compareTo(oN);
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getSpecific() {
        return this.specific;
    }

    public GrammaticalRelation getParent() {
        return this.parent;
    }

    public static void main(String[] args) {
        String[] names;
        for (String name : names = new String[]{"dep", "pred", "prep_to", "rcmod"}) {
            GrammaticalRelation reln = GrammaticalRelation.valueOf(Language.English, name);
            System.out.println("Data for GrammaticalRelation loaded as valueOf(\"" + name + "\"):");
            System.out.println("\tShort name:    " + reln.getShortName());
            System.out.println("\tLong name:     " + reln.getLongName());
            System.out.println("\tSpecific name: " + reln.getSpecific());
        }
    }

    public static enum Language {
        Any,
        English,
        Chinese;

    }

    public static class KillGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    public static class RootGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    public static class DependentGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    public static class GovernorGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    public static abstract class GrammaticalRelationAnnotation
    implements CoreAnnotation<Set<TreeGraphNode>> {
        @Override
        public Class<Set<TreeGraphNode>> getType() {
            return Set.class;
        }
    }
}

