/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class SemanticHeadFinder
extends ModCollinsHeadFinder {
    private static final boolean DEBUG = false;
    private static final String[] auxiliaries = new String[]{"will", "wo", "shall", "sha", "may", "might", "should", "would", "can", "could", "ca", "must", "has", "have", "had", "having", "get", "gets", "getting", "got", "gotten", "do", "does", "did", "to", "'ve", "ve", "v", "'d", "d", "'ll", "ll", "na", "of", "hav", "hvae", "as"};
    private static final String[] beGetVerbs = new String[]{"be", "being", "been", "am", "are", "r", "is", "ai", "was", "were", "'m", "m", "'re", "'s", "s", "art", "ar", "get", "getting", "gets", "got"};
    private static final String[] copulaVerbs = new String[]{"be", "being", "been", "am", "are", "r", "is", "ai", "was", "were", "'m", "m", "'re", "'s", "s", "wase", "seem", "seems", "seemed", "appear", "appears", "appeared", "stay", "stays", "stayed", "remain", "remains", "remained", "resemble", "resembles", "resembled", "become", "becomes", "became"};
    private static final String[] verbTags = new String[]{"TO", "MD", "VB", "VBD", "VBP", "VBZ", "VBG", "VBN", "AUX", "AUXG"};
    private static final String[] unambiguousAuxTags = new String[]{"TO", "MD", "AUX", "AUXG"};
    private final Set<String> verbalAuxiliaries;
    private final Set<String> copulars;
    private final Set<String> passiveAuxiliaries;
    private final Set<String> verbalTags;
    private final Set<String> unambiguousAuxiliaryTags;
    private static final long serialVersionUID = 5721799188009249808L;

    public SemanticHeadFinder() {
        this((TreebankLanguagePack)new PennTreebankLanguagePack(), true);
    }

    public SemanticHeadFinder(boolean cop) {
        this((TreebankLanguagePack)new PennTreebankLanguagePack(), cop);
    }

    public SemanticHeadFinder(TreebankLanguagePack tlp, boolean cop) {
        super(tlp);
        this.ruleChanges();
        this.verbalAuxiliaries = Generics.newHashSet(Arrays.asList(auxiliaries));
        this.passiveAuxiliaries = Generics.newHashSet(Arrays.asList(beGetVerbs));
        this.copulars = Generics.newHashSet();
        if (cop) {
            this.copulars.addAll(Arrays.asList(copulaVerbs));
        }
        this.verbalTags = Generics.newHashSet(Arrays.asList(verbTags));
        this.unambiguousAuxiliaryTags = Generics.newHashSet(Arrays.asList(unambiguousAuxTags));
    }

    private void ruleChanges() {
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "NML", "JJR", "WP"}, {"left", "NP", "PRP"}, {"rightdis", "$", "ADJP", "FW"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "QP", "DT", "WDT", "NML", "PRN", "RB", "RBR", "ADVP"}, {"left", "POS"}});
        this.nonTerminalInfo.put("WHNP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "NML", "JJR", "WP"}, {"left", "WHNP", "NP"}, {"rightdis", "$", "ADJP", "PRN", "FW"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}, {"left", "WHPP", "WHADJP", "WP$", "WDT"}});
        this.nonTerminalInfo.put("WHADJP", new String[][]{{"left", "ADJP", "JJ", "JJR", "WP"}, {"right", "RB"}, {"right"}});
        this.nonTerminalInfo.put("WHADVP", new String[][]{{"rightdis", "WRB", "WHADVP", "RB", "JJ"}});
        this.nonTerminalInfo.put("QP", new String[][]{{"right", "$", "NNS", "NN", "CD", "JJ", "PDT", "DT", "IN", "RB", "NCD", "QP", "JJR", "JJS"}});
        this.nonTerminalInfo.put("S", new String[][]{{"left", "VP", "S", "FRAG", "SBAR", "ADJP", "UCP", "TO"}, {"right", "NP"}});
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "S", "SQ", "SINV", "SBAR", "FRAG", "VP", "WHNP", "WHPP", "WHADVP", "WHADJP", "IN", "DT"}});
        this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VP", "SQ", "ADJP", "VB", "VBZ", "VBD", "VBP", "MD", "AUX", "AUXG"}});
        this.nonTerminalInfo.put("UCP", new String[][]{{"left"}});
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "VB", "JJ", "RB", "IN", "CC"}});
        this.nonTerminalInfo.put("FRAG", new String[][]{{"left", "IN"}, {"right", "RB"}, {"left", "NP"}, {"left", "ADJP", "ADVP", "FRAG", "S", "SBAR", "VP"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left", "VP", "SQ", "S", "SINV", "SBAR", "NP", "ADJP", "PP", "ADVP", "INTJ", "WHNP", "NAC", "VBP", "JJ", "NN", "NNP"}});
        this.nonTerminalInfo.put("XS", new String[][]{{"right", "IN"}});
        this.nonTerminalInfo.put("EMBED", new String[][]{{"right", "INTJ"}});
    }

    private boolean shouldSkip(Tree t, boolean origWasInterjection) {
        return t.isPreTerminal() && (this.tlp.isPunctuationTag(t.value()) || !origWasInterjection && "UH".equals(t.value())) || "INTJ".equals(t.value()) && !origWasInterjection;
    }

    private int findPreviousHead(int headIdx, Tree[] daughterTrees, boolean origWasInterjection) {
        boolean seenSeparator = false;
        int newHeadIdx = headIdx;
        while (newHeadIdx >= 0) {
            if (--newHeadIdx < 0) {
                return newHeadIdx;
            }
            String label = this.tlp.basicCategory(daughterTrees[newHeadIdx].value());
            if (",".equals(label) || ":".equals(label)) {
                seenSeparator = true;
                continue;
            }
            if (daughterTrees[newHeadIdx].isPreTerminal() && (this.tlp.isPunctuationTag(label) || !origWasInterjection && "UH".equals(label)) || "INTJ".equals(label) && !origWasInterjection) continue;
            if (seenSeparator) break;
            newHeadIdx = -1;
            break;
        }
        return newHeadIdx;
    }

    @Override
    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && ((prevLab = this.tlp.basicCategory(daughterTrees[headIdx - 1].value())).equals("CC") || prevLab.equals("CONJP"))) {
            int nextHead;
            int newHeadIdx;
            boolean origWasInterjection = "UH".equals(this.tlp.basicCategory(daughterTrees[headIdx].value()));
            for (newHeadIdx = headIdx - 2; newHeadIdx >= 0 && this.shouldSkip(daughterTrees[newHeadIdx], origWasInterjection); --newHeadIdx) {
            }
            while (newHeadIdx >= 2 && (nextHead = this.findPreviousHead(newHeadIdx, daughterTrees, origWasInterjection)) >= 0) {
                newHeadIdx = nextHead;
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }

    @Override
    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        String motherCat = this.tlp.basicCategory(t.label().value());
        if (motherCat.equals("VP") || motherCat.equals("SQ") || motherCat.equals("SINV")) {
            String[] how;
            Tree pti;
            Tree[] kids = t.children();
            if ((this.hasVerbalAuxiliary(kids, this.verbalAuxiliaries, true) || this.hasPassiveProgressiveAuxiliary(kids)) && (pti = this.traverseLocate(kids, how = new String[]{"left", "VP", "ADJP"}, false)) != null) {
                return pti;
            }
            if (this.hasVerbalAuxiliary(kids, this.copulars, false) && !this.isExistential(t, parent) && !SemanticHeadFinder.isWHQ(t, parent)) {
                how = motherCat.equals("SQ") ? new String[]{"right", "VP", "ADJP", "NP", "WHADJP", "WHNP"} : new String[]{"left", "VP", "ADJP", "NP", "WHADJP", "WHNP"};
                pti = this.traverseLocate(kids, how, false);
                if (pti != null && pti.label() != null && pti.label().value().contains("-TMP")) {
                    pti = null;
                }
                if (motherCat.equals("SQ") && pti != null && pti.label() != null && pti.label().value().startsWith("NP")) {
                    boolean foundAnotherNp = false;
                    for (Tree kid : kids) {
                        if (kid == pti) break;
                        if (kid.label() == null || !kid.label().value().startsWith("NP")) continue;
                        foundAnotherNp = true;
                        break;
                    }
                    if (!foundAnotherNp) {
                        pti = null;
                    }
                }
                if (pti != null) {
                    return pti;
                }
            }
        }
        Tree hd = super.determineNonTrivialHead(t, parent);
        return hd;
    }

    private boolean isExistential(Tree t, Tree parent) {
        boolean toReturn;
        block5: {
            Tree[] kids;
            String motherCat;
            block4: {
                Tree[] kids2;
                toReturn = false;
                motherCat = this.tlp.basicCategory(t.label().value());
                if (!motherCat.equals("VP") || parent == null) break block4;
                for (Tree kid : kids2 = parent.children()) {
                    if (kid.value().equals("VP")) break;
                    List<Label> tags = kid.preTerminalYield();
                    for (Label tag : tags) {
                        if (!tag.value().equals("EX")) continue;
                        toReturn = true;
                    }
                }
                break block5;
            }
            if (!motherCat.startsWith("SQ") || parent == null) break block5;
            for (Tree kid : kids = parent.children()) {
                if (kid.value().startsWith("VB")) continue;
                List<Label> tags = kid.preTerminalYield();
                for (Label tag : tags) {
                    if (!tag.value().equals("EX")) continue;
                    toReturn = true;
                }
            }
        }
        return toReturn;
    }

    private static boolean isWHQ(Tree t, Tree parent) {
        if (t == null) {
            return false;
        }
        boolean toReturn = false;
        if (t.value().startsWith("SQ") && parent != null && parent.value().equals("SBARQ")) {
            Tree[] kids;
            for (Tree kid : kids = parent.children()) {
                if (!kid.value().startsWith("WH")) continue;
                toReturn = true;
            }
        }
        return toReturn;
    }

    private boolean isVerbalAuxiliary(Tree preterminal, Set<String> verbalSet, boolean allowJustTagMatch) {
        if (preterminal.isPreTerminal()) {
            Label kidLabel = preterminal.label();
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = preterminal.value();
            }
            Label wordLabel = preterminal.firstChild().label();
            String word = null;
            if (wordLabel instanceof HasWord) {
                word = ((HasWord)((Object)wordLabel)).word();
            }
            if (word == null) {
                word = wordLabel.value();
            }
            String lcWord = word.toLowerCase();
            if (allowJustTagMatch && this.unambiguousAuxiliaryTags.contains(tag) || this.verbalTags.contains(tag) && verbalSet.contains(lcWord)) {
                return true;
            }
        }
        return false;
    }

    public boolean isVerbalAuxiliary(Tree t) {
        return this.isVerbalAuxiliary(t, this.verbalAuxiliaries, true);
    }

    private boolean hasPassiveProgressiveAuxiliary(Tree[] kids) {
        boolean foundPassiveVP = false;
        boolean foundPassiveAux = false;
        for (Tree kid : kids) {
            if (this.isVerbalAuxiliary(kid, this.passiveAuxiliaries, false)) {
                foundPassiveAux = true;
            } else if (kid.isPhrasal()) {
                Label kidLabel = kid.label();
                String cat = null;
                if (kidLabel instanceof HasCategory) {
                    cat = ((HasCategory)((Object)kidLabel)).category();
                }
                if (cat == null) {
                    cat = kid.value();
                }
                if (!cat.startsWith("VP")) continue;
                Tree[] kidkids = kid.children();
                boolean foundParticipleInVp = false;
                for (Tree kidkid : kidkids) {
                    if (kidkid.isPreTerminal()) {
                        Label kidkidLabel = kidkid.label();
                        String tag = null;
                        if (kidkidLabel instanceof HasTag) {
                            tag = ((HasTag)((Object)kidkidLabel)).tag();
                        }
                        if (tag == null) {
                            tag = kidkid.value();
                        }
                        if ("VBN".equals(tag) || "VBG".equals(tag) || "VBD".equals(tag)) {
                            foundPassiveVP = true;
                            break;
                        }
                        if (!"CC".equals(tag) || !foundParticipleInVp) continue;
                        foundPassiveVP = true;
                        break;
                    }
                    if (!kidkid.isPhrasal()) continue;
                    String catcat = null;
                    if (kidLabel instanceof HasCategory) {
                        catcat = ((HasCategory)((Object)kidLabel)).category();
                    }
                    if (catcat == null) {
                        catcat = kid.value();
                    }
                    if ("VP".equals(catcat)) {
                        foundParticipleInVp = SemanticHeadFinder.vpContainsParticiple(kidkid);
                        continue;
                    }
                    if (!"CONJP".equals(catcat) && !"PRN".equals(catcat) || !foundParticipleInVp) continue;
                    foundPassiveVP = true;
                    break;
                }
            }
            if (foundPassiveAux && foundPassiveVP) break;
        }
        return foundPassiveAux && foundPassiveVP;
    }

    private static boolean vpContainsParticiple(Tree t) {
        for (Tree kid : t.children()) {
            if (!kid.isPreTerminal()) continue;
            Label kidLabel = kid.label();
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = kid.value();
            }
            if (!"VBN".equals(tag) && !"VBG".equals(tag) && !"VBD".equals(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean hasVerbalAuxiliary(Tree[] kids, Set<String> verbalSet, boolean allowTagOnlyMatch) {
        for (Tree kid : kids) {
            if (!this.isVerbalAuxiliary(kid, verbalSet, allowTagOnlyMatch)) continue;
            return true;
        }
        return false;
    }
}

