/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.Generics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;

class TagCount {
    private Map<String, Integer> map = Generics.newHashMap();
    private int ambClassId = -1;
    private String[] getTagsCache;
    int sumCache;
    private static final String NULL_SYMBOL = "<<NULL>>";

    TagCount() {
    }

    TagCount(IntCounter<String> tagCounts) {
        for (String tag : tagCounts.keySet()) {
            this.map.put(tag, tagCounts.getIntCount(tag));
        }
        this.getTagsCache = this.map.keySet().toArray(new String[this.map.keySet().size()]);
        this.sumCache = this.calculateSumCache();
    }

    protected void save(DataOutputStream rf) {
        try {
            rf.writeInt(this.map.size());
            for (String tag : this.map.keySet()) {
                if (tag == null) {
                    rf.writeUTF(NULL_SYMBOL);
                } else {
                    rf.writeUTF(tag);
                }
                rf.writeInt(this.map.get(tag));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAmbClassId(int ambClassId) {
        this.ambClassId = ambClassId;
    }

    public int getAmbClassId() {
        return this.ambClassId;
    }

    protected void read(DataInputStream rf) {
        try {
            int numTags = rf.readInt();
            this.map = Generics.newHashMap(numTags);
            for (int i = 0; i < numTags; ++i) {
                String tag = rf.readUTF();
                int count = rf.readInt();
                if (tag.equals(NULL_SYMBOL)) {
                    tag = null;
                }
                this.map.put(tag, count);
            }
            this.getTagsCache = this.map.keySet().toArray(new String[this.map.keySet().size()]);
            this.sumCache = this.calculateSumCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int sum() {
        return this.sumCache;
    }

    protected int get(String tag) {
        Integer count = this.map.get(tag);
        if (count == null) {
            return 0;
        }
        return count;
    }

    private int calculateSumCache() {
        int s = 0;
        for (Integer i : this.map.values()) {
            s += i.intValue();
        }
        return s;
    }

    public String[] getTags() {
        return this.getTagsCache;
    }

    protected int numTags() {
        return this.map.size();
    }

    public String getFirstTag() {
        String maxTag = null;
        int max = 0;
        for (String tag : this.map.keySet()) {
            int count = this.map.get(tag);
            if (count <= max) continue;
            maxTag = tag;
            max = count;
        }
        return maxTag;
    }

    public String toString() {
        return this.map.toString();
    }
}

