/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.DeltaCollectionValuedMap;
import edu.stanford.nlp.util.DeltaMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.MapFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CollectionValuedMap<K, V>
implements Map<K, Collection<V>>,
Serializable {
    private static final long serialVersionUID = -9064664153962599076L;
    private Map<K, Collection<V>> map;
    protected CollectionFactory<V> cf;
    private boolean treatCollectionsAsImmutable;
    protected MapFactory<K, Collection<V>> mf;
    private final Collection<V> emptyValue;

    @Override
    public Collection<V> put(K key, Collection<V> collection) {
        return this.map.put(key, collection);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> get(Object key) {
        Collection<V> c = this.map.get(key);
        if (c == null) {
            c = this.emptyValue;
        }
        return c;
    }

    public void add(K key, V value) {
        if (this.treatCollectionsAsImmutable) {
            Collection<V> newC = this.cf.newCollection();
            Collection<V> c = this.map.get(key);
            if (c != null) {
                newC.addAll(c);
            }
            newC.add(value);
            this.map.put(key, newC);
        } else {
            Collection<V> c = this.map.get(key);
            if (c == null) {
                c = this.cf.newCollection();
                this.map.put(key, c);
            }
            c.add(value);
        }
    }

    public void addKey(K key) {
        Collection<V> c = this.map.get(key);
        if (c == null) {
            c = this.cf.newCollection();
            this.map.put(key, c);
        }
    }

    public void addAll(Map<K, V> m) {
        if (m instanceof CollectionValuedMap) {
            throw new UnsupportedOperationException();
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.add(e.getKey(), e.getValue());
        }
    }

    public void addAll(CollectionValuedMap<K, V> cvm) {
        for (Map.Entry<K, Collection<V>> entry : cvm.entrySet()) {
            K key = entry.getKey();
            Collection<V> currentCollection = this.get(key);
            Collection<V> newValues = entry.getValue();
            if (this.treatCollectionsAsImmutable) {
                Collection<V> newCollection = this.cf.newCollection();
                if (currentCollection != null) {
                    newCollection.addAll(currentCollection);
                }
                newCollection.addAll(newValues);
                this.map.put(key, newCollection);
                continue;
            }
            boolean needToAdd = false;
            if (currentCollection == this.emptyValue) {
                currentCollection = this.cf.newCollection();
                needToAdd = true;
            }
            currentCollection.addAll(newValues);
            if (!needToAdd) continue;
            this.map.put(key, currentCollection);
        }
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.map.remove(key);
    }

    public void removeAll(Collection<K> keys) {
        for (K k : keys) {
            this.remove(k);
        }
    }

    public void removeMapping(K key, V value) {
        if (this.treatCollectionsAsImmutable) {
            Collection<V> c = this.map.get(key);
            if (c != null) {
                Collection<V> newC = this.cf.newCollection();
                newC.addAll(c);
                newC.remove(value);
                this.map.put(key, newC);
            }
        } else {
            Object c = this.get(key);
            c.remove(value);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Collection<V>> values() {
        return this.map.values();
    }

    public Collection<V> allValues() {
        Collection<V> c = this.cf.newCollection();
        for (Collection<V> c1 : this.map.values()) {
            c.addAll(c1);
        }
        return c;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectionValuedMap)) {
            return false;
        }
        CollectionValuedMap other = (CollectionValuedMap)ErasureUtils.uncheckedCast(o);
        if (other.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, Collection<V>> e : this.entrySet()) {
                K key = e.getKey();
                Collection<V> value = e.getValue();
                if (!(value == null ? other.get(key) != null || !other.containsKey(key) : !((Object)value).equals(other.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public CollectionValuedMap<K, V> deltaClone() {
        CollectionValuedMap<K, V> result = new CollectionValuedMap<K, V>(null, this.cf, true);
        result.map = new DeltaMap<K, Collection<Collection<V>>>(this.map);
        return result;
    }

    public CollectionValuedMap<K, V> clone() {
        CollectionValuedMap<K, V> result = new CollectionValuedMap<K, V>(this);
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        Iterator<Map.Entry<K, Collection<V>>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, Collection<V>> e = i.next();
            K key = e.getKey();
            Collection<V> value = e.getValue();
            buf.append((Object)(key == this ? "(this Map)" : key)).append('=').append(value == this ? "(this Map)" : value);
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    public CollectionValuedMap(MapFactory<K, Collection<V>> mf, CollectionFactory<V> cf, boolean treatCollectionsAsImmutable) {
        this.mf = mf;
        this.cf = cf;
        this.treatCollectionsAsImmutable = treatCollectionsAsImmutable;
        this.emptyValue = cf.newEmptyCollection();
        if (mf != null) {
            this.map = Collections.synchronizedMap(mf.newMap());
        }
    }

    public CollectionValuedMap(CollectionValuedMap<K, V> cvm) {
        this.mf = cvm.mf;
        this.cf = cvm.cf;
        this.treatCollectionsAsImmutable = cvm.treatCollectionsAsImmutable;
        this.emptyValue = cvm.emptyValue;
        this.map = Collections.synchronizedMap(this.mf.newMap());
        for (Map.Entry<K, Collection<V>> entry : cvm.map.entrySet()) {
            K key = entry.getKey();
            Collection<V> c = entry.getValue();
            for (V value : c) {
                this.add(key, value);
            }
        }
    }

    public CollectionValuedMap() {
        this(MapFactory.hashMapFactory(), CollectionFactory.hashSetFactory(), false);
    }

    public CollectionValuedMap(CollectionFactory<V> cf) {
        this(MapFactory.hashMapFactory(), cf, false);
    }

    public static void main(String[] args) {
        Integer rInt2;
        Integer rInt1;
        int i;
        CollectionValuedMap<Integer, Integer> originalMap = new CollectionValuedMap<Integer, Integer>();
        Random r = new Random();
        for (int i2 = 0; i2 < 800; ++i2) {
            Integer rInt12 = r.nextInt(400);
            Integer rInt22 = r.nextInt(400);
            originalMap.add(rInt12, rInt22);
            System.out.println("Adding " + rInt12 + ' ' + rInt22);
        }
        CollectionValuedMap originalCopyMap = new CollectionValuedMap(originalMap);
        CollectionValuedMap<Integer, Integer> deltaCopyMap = new CollectionValuedMap<Integer, Integer>(originalMap);
        DeltaCollectionValuedMap<Integer, Integer> deltaMap = new DeltaCollectionValuedMap<Integer, Integer>(originalMap);
        for (i = 0; i < 400; ++i) {
            rInt1 = r.nextInt(400);
            rInt2 = r.nextInt(400) + 1000;
            ((CollectionValuedMap)deltaMap).add(rInt1, rInt2);
            deltaCopyMap.add(rInt1, rInt2);
            System.out.println("Adding " + rInt1 + ' ' + rInt2);
        }
        for (i = 0; i < 400; ++i) {
            rInt1 = r.nextInt(1400);
            rInt2 = r.nextInt(1400);
            ((CollectionValuedMap)deltaMap).removeMapping(rInt1, rInt2);
            deltaCopyMap.removeMapping(rInt1, rInt2);
            System.out.println("Removing " + rInt1 + ' ' + rInt2);
        }
        System.out.println("original: " + originalMap);
        System.out.println("copy: " + deltaCopyMap);
        System.out.println("delta: " + deltaMap);
        System.out.println("Original preserved? " + originalCopyMap.equals(originalMap));
        System.out.println("Delta accurate? " + deltaMap.equals(deltaCopyMap));
    }
}

