/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import java.util.regex.Pattern;

public class LexerUtils {
    private static final Pattern CENTS_PATTERN = Pattern.compile("\u00a2");
    private static final Pattern POUND_PATTERN = Pattern.compile("\u00a3");
    private static final Pattern GENERIC_CURRENCY_PATTERN = Pattern.compile("[\u0080\u00a4\u20a0\u20ac\u20b9]");
    private static final Pattern CP1252_EURO_PATTERN = Pattern.compile("\u0080");
    private static final Pattern AMP_PATTERN = Pattern.compile("(?i:&amp;)");

    private LexerUtils() {
    }

    public static String normalizeCurrency(String in) {
        String s1 = in;
        s1 = CENTS_PATTERN.matcher(s1).replaceAll("cents");
        s1 = POUND_PATTERN.matcher(s1).replaceAll("#");
        s1 = GENERIC_CURRENCY_PATTERN.matcher(s1).replaceAll("\\$");
        return s1;
    }

    public static String minimallyNormalizeCurrency(String in) {
        String s1 = in;
        s1 = CP1252_EURO_PATTERN.matcher(s1).replaceAll("\u20ac");
        return s1;
    }

    public static String removeSoftHyphens(String in) {
        if (in.indexOf(173) < 0) {
            return in;
        }
        int length = in.length();
        StringBuilder out2 = new StringBuilder(length - 1);
        for (int i = 0; i < length; ++i) {
            char ch = in.charAt(i);
            if (ch == '\u00ad') continue;
            out2.append(ch);
        }
        if (out2.length() == 0) {
            out2.append('-');
        }
        return out2.toString();
    }

    public static String processCp1252misc(String arg) {
        switch (arg) {
            case "\u0086": {
                return "\u2020";
            }
            case "\u0087": {
                return "\u2021";
            }
            case "\u0089": {
                return "\u2030";
            }
            case "\u0095": {
                return "\u2022";
            }
            case "\u0098": {
                return "\u02dc";
            }
            case "\u0099": {
                return "\u2122";
            }
        }
        throw new IllegalArgumentException("Bad process cp1252");
    }

    public static String normalizeAmp(String in) {
        return AMP_PATTERN.matcher(in).replaceAll("&");
    }
}

