/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;

public class ParserAnnotatorUtils {
    private static Redwood.RedwoodChannels log = Redwood.channels(ParserAnnotatorUtils.class);

    private ParserAnnotatorUtils() {
    }

    public static void fillInParseAnnotations(boolean verbose, boolean buildGraphs, GrammaticalStructureFactory gsf, CoreMap sentence, List<Tree> trees, GrammaticalStructure.Extras extras) {
        boolean first = true;
        for (Tree tree : trees) {
            Trees.convertToCoreLabels(tree);
            tree.indexSpans(0);
            if (!first) continue;
            sentence.set(TreeCoreAnnotations.TreeAnnotation.class, tree);
            if (verbose) {
                log.info("Tree is:");
                tree.pennPrint(System.err);
            }
            ParserAnnotatorUtils.setMissingTags(sentence, tree);
            if (buildGraphs) {
                SemanticGraph deps = SemanticGraphFactory.generateCollapsedDependencies(gsf.newGrammaticalStructure(tree), extras);
                SemanticGraph uncollapsedDeps = SemanticGraphFactory.generateUncollapsedDependencies(gsf.newGrammaticalStructure(tree), extras);
                SemanticGraph ccDeps = SemanticGraphFactory.generateCCProcessedDependencies(gsf.newGrammaticalStructure(tree), extras);
                SemanticGraph enhancedDeps = SemanticGraphFactory.generateEnhancedDependencies(gsf.newGrammaticalStructure(tree));
                SemanticGraph enhancedPlusPlusDeps = SemanticGraphFactory.generateEnhancedPlusPlusDependencies(gsf.newGrammaticalStructure(tree));
                if (verbose) {
                    log.info("SDs:");
                    log.info(deps.toString(SemanticGraph.OutputFormat.LIST));
                }
                sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, deps);
                sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
                sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
                sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, enhancedDeps);
                sentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, enhancedPlusPlusDeps);
            }
            first = false;
        }
        if (trees.size() > 1) {
            sentence.set(TreeCoreAnnotations.KBestTreesAnnotation.class, trees);
        }
    }

    public static void setMissingTags(CoreMap sentence, Tree tree) {
        ArrayList<TaggedWord> taggedWords = null;
        ArrayList<Label> leaves = null;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            CoreLabel token = (CoreLabel)tokens.get(i);
            if (token.tag() != null) continue;
            if (taggedWords == null) {
                taggedWords = tree.taggedYield();
            }
            if (leaves == null) {
                leaves = tree.yield();
            }
            token.setTag(((TaggedWord)taggedWords.get(i)).tag());
            Label leaf = (Label)leaves.get(i);
            if (!(leaf instanceof HasTag)) continue;
            ((HasTag)((Object)leaf)).setTag(((TaggedWord)taggedWords.get(i)).tag());
        }
    }
}

