/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OpenPageDialog
extends JDialog {
    private static final long serialVersionUID = -7987625449997527926L;
    public static final int CANCEL_OPTION = 0;
    public static final int APPROVE_OPTION = 1;
    private JFileChooser jfc;
    private int status;
    private JTextField urlTextField;
    private JButton openButton;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JButton cancelButton;
    private JButton browseButton;
    private JPanel jPanel1;

    public OpenPageDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jfc = new JFileChooser();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                OpenPageDialog.this.status = 0;
            }
        });
    }

    public void setFileChooser(JFileChooser jfc) {
        this.jfc = jfc;
    }

    public String getPage() {
        return this.urlTextField.getText();
    }

    public int getStatus() {
        return this.status;
    }

    private void browseFiles() {
        this.jfc.setDialogTitle("Open file");
        int status = this.jfc.showOpenDialog(this);
        if (status == 0) {
            this.urlTextField.setText(this.jfc.getSelectedFile().getPath());
            this.openButton.setEnabled(true);
        }
    }

    private void approve() {
        this.status = 1;
        this.closeDialog(null);
    }

    private void enableOpenButton() {
        this.openButton.setEnabled(this.urlTextField.getText().length() > 0);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.urlTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.openButton = new JButton();
        this.cancelButton = new JButton();
        this.browseButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OpenPageDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jLabel2.setText("Type in the internet address of a document or web page.");
        this.jPanel1.add(this.jLabel2);
        this.jLabel1.setText("Open");
        this.jPanel3.add(this.jLabel1);
        this.urlTextField.setMinimumSize(new Dimension(100, 20));
        this.urlTextField.setPreferredSize(new Dimension(300, 20));
        this.urlTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenPageDialog.this.enableOpenButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenPageDialog.this.enableOpenButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenPageDialog.this.enableOpenButton();
            }
        });
        this.urlTextField.addActionListener(evt -> this.urlTextFieldActionPerformed(evt));
        this.jPanel3.add(this.urlTextField);
        this.jPanel1.add(this.jPanel3);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.openButton.setText("Open");
        this.openButton.setEnabled(false);
        this.openButton.addActionListener(evt -> this.openButtonActionPerformed(evt));
        this.jPanel2.add(this.openButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(evt -> this.cancelButtonActionPerformed(evt));
        this.jPanel2.add(this.cancelButton);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(evt -> this.browseButtonActionPerformed(evt));
        this.jPanel2.add(this.browseButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void urlTextFieldActionPerformed(ActionEvent evt) {
        if (this.urlTextField.getText().length() > 0) {
            this.approve();
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.browseFiles();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.status = 0;
        this.closeDialog(null);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.approve();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OpenPageDialog((Frame)new JFrame(), true).setVisible(true);
    }
}

