/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolver;

public class LinearSolverSafe<T extends Matrix64F>
implements LinearSolver<T> {
    private LinearSolver<T> alg;
    private T A;
    private T B;

    public LinearSolverSafe(LinearSolver<T> linearSolver) {
        this.alg = linearSolver;
    }

    @Override
    public boolean setA(T t) {
        if (this.alg.modifiesA()) {
            if (this.A == null) {
                this.A = ((Matrix64F)t).copy();
            } else {
                if (((Matrix64F)this.A).numRows != ((Matrix64F)t).numRows || ((Matrix64F)this.A).numCols != ((Matrix64F)t).numCols) {
                    ((Matrix64F)this.A).reshape(((Matrix64F)t).numRows, ((Matrix64F)t).numCols, false);
                }
                ((Matrix64F)this.A).set((Matrix64F)t);
            }
            return this.alg.setA(this.A);
        }
        return this.alg.setA(t);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(T t, T t2) {
        if (this.alg.modifiesB()) {
            if (this.B == null) {
                this.B = ((Matrix64F)t).copy();
            } else {
                if (((Matrix64F)this.B).numRows != ((Matrix64F)t).numRows || ((Matrix64F)this.B).numCols != ((Matrix64F)t).numCols) {
                    ((Matrix64F)this.B).reshape(((Matrix64F)this.A).numRows, ((Matrix64F)t).numCols, false);
                }
                ((Matrix64F)this.B).set((Matrix64F)t);
            }
            t = this.B;
        }
        this.alg.solve(t, t2);
    }

    @Override
    public void invert(T t) {
        this.alg.invert(t);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

