/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep.demo;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.trees.GrammaticalStructure;
import java.io.StringReader;
import java.util.List;

public class DependencyParserDemo {
    public static void main(String[] args) {
        String modelPath = "edu/stanford/nlp/models/parser/nndep/english_SD.gz";
        String taggerPath = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";
        int argIndex = 0;
        block8: while (argIndex < args.length) {
            switch (args[argIndex]) {
                case "-tagger": {
                    taggerPath = args[argIndex + 1];
                    argIndex += 2;
                    continue block8;
                }
                case "-model": {
                    modelPath = args[argIndex + 1];
                    argIndex += 2;
                    continue block8;
                }
            }
            throw new RuntimeException("Unknown argument " + args[argIndex]);
        }
        String text = "I can almost always tell when movies use fake dinosaurs.";
        MaxentTagger tagger = new MaxentTagger(taggerPath);
        DependencyParser parser = DependencyParser.loadFromModelFile(modelPath);
        DocumentPreprocessor tokenizer = new DocumentPreprocessor(new StringReader(text));
        for (List<HasWord> sentence : tokenizer) {
            List<TaggedWord> tagged = tagger.tagSentence(sentence);
            GrammaticalStructure gs = parser.predict(tagged);
            System.err.println(gs);
        }
    }
}

