/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchRules;
import edu.stanford.nlp.ling.tokensregex.parser.ParseException;
import edu.stanford.nlp.ling.tokensregex.parser.TokenSequenceParser;
import edu.stanford.nlp.ling.tokensregex.types.Expression;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoreMapExpressionExtractor<T extends MatchedExpression> {
    private Logger logger = Logger.getLogger(CoreMapExpressionExtractor.class.getName());
    private final Env env;
    private boolean keepTags = false;
    private final Class tokensAnnotationKey;
    private final Map<Integer, Stage<T>> stages = new HashMap<Integer, Stage<T>>();

    public CoreMapExpressionExtractor() {
        this(null);
    }

    public CoreMapExpressionExtractor(Env env) {
        this.env = env;
        this.tokensAnnotationKey = EnvLookup.getDefaultTokensAnnotationKey(env);
    }

    public CoreMapExpressionExtractor(Env env, List<SequenceMatchRules.Rule> rules) {
        this(env);
        this.appendRules(rules);
    }

    public void appendRules(List<SequenceMatchRules.Rule> rules) {
        for (SequenceMatchRules.Rule r : rules) {
            if (r instanceof SequenceMatchRules.AssignmentRule) {
                ((SequenceMatchRules.AssignmentRule)r).evaluate(this.env);
                continue;
            }
            if (!(r instanceof SequenceMatchRules.AnnotationExtractRule)) continue;
            SequenceMatchRules.AnnotationExtractRule aer = (SequenceMatchRules.AnnotationExtractRule)r;
            Stage<T> stage = this.stages.get(aer.stage);
            if (stage == null) {
                Integer limitIters;
                stage = new Stage();
                this.stages.put(aer.stage, stage);
                stage.stageId = aer.stage;
                Boolean clearMatched = (Boolean)this.env.getDefaults().get("stage.clearMatched");
                if (clearMatched != null) {
                    stage.clearMatched = clearMatched;
                }
                if ((limitIters = (Integer)this.env.getDefaults().get("stage.limitIters")) != null) {
                    stage.limitIters = limitIters;
                }
            }
            if (aer.active) {
                if ("filter".equals(aer.ruleType)) {
                    ((Stage)stage).addFilterRule(aer);
                    continue;
                }
                if (aer.isComposite) {
                    ((Stage)stage).addCompositeRule(aer);
                    continue;
                }
                ((Stage)stage).addBasicRule(aer);
                continue;
            }
            this.logger.log(Level.INFO, "Ignoring inactive rule: " + aer.name);
        }
    }

    public Env getEnv() {
        return this.env;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setExtractRules(SequenceMatchRules.ExtractRule<CoreMap, T> basicExtractRule, SequenceMatchRules.ExtractRule<List<? extends CoreMap>, T> compositeExtractRule, Predicate<T> filterRule) {
        Stage stage = new Stage();
        stage.basicExtractRule = basicExtractRule;
        stage.compositeExtractRule = compositeExtractRule;
        stage.filterRule = filterRule;
        this.stages.clear();
        this.stages.put(1, stage);
    }

    public static CoreMapExpressionExtractor createExtractorFromFiles(Env env, String ... filenames) throws RuntimeException {
        return CoreMapExpressionExtractor.createExtractorFromFiles(env, Arrays.asList(filenames));
    }

    public static CoreMapExpressionExtractor createExtractorFromFiles(Env env, List<String> filenames) throws RuntimeException {
        CoreMapExpressionExtractor extractor = new CoreMapExpressionExtractor(env);
        for (String filename : filenames) {
            try {
                System.err.println("Reading TokensRegex rules from " + filename);
                BufferedReader br = IOUtils.getBufferedReaderFromClasspathOrFileSystem(filename);
                TokenSequenceParser parser = new TokenSequenceParser();
                parser.updateExpressionExtractor(extractor, br);
                IOUtils.closeIgnoringExceptions(br);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error parsing file: " + filename, ex);
            }
        }
        return extractor;
    }

    public static CoreMapExpressionExtractor createExtractorFromFile(Env env, String filename) throws RuntimeException {
        try {
            System.err.println("Reading TokensRegex rules from " + filename);
            BufferedReader br = IOUtils.getBufferedReaderFromClasspathOrFileSystem(filename);
            TokenSequenceParser parser = new TokenSequenceParser();
            CoreMapExpressionExtractor extractor = parser.getExpressionExtractor(env, br);
            IOUtils.closeIgnoringExceptions(br);
            return extractor;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing file: " + filename, ex);
        }
    }

    public static CoreMapExpressionExtractor createExtractorFromString(Env env, String str) throws IOException, ParseException {
        TokenSequenceParser parser = new TokenSequenceParser();
        CoreMapExpressionExtractor extractor = parser.getExpressionExtractor(env, new StringReader(str));
        return extractor;
    }

    public Value getValue(String varname) {
        Expression expr = (Expression)this.env.get(varname);
        if (expr != null) {
            return expr.evaluate(this.env, new Object[0]);
        }
        throw new RuntimeException("Unable get expression for variable " + varname);
    }

    public List<CoreMap> extractCoreMapsToList(List<CoreMap> res, CoreMap annotation) {
        List<T> exprs = this.extractExpressions(annotation);
        for (MatchedExpression expr : exprs) {
            res.add(expr.getAnnotation());
        }
        return res;
    }

    public List<CoreMap> extractCoreMaps(CoreMap annotation) {
        ArrayList<CoreMap> res = new ArrayList<CoreMap>();
        return this.extractCoreMapsToList(res, annotation);
    }

    public List<CoreMap> extractCoreMapsMergedWithTokens(CoreMap annotation) {
        List<CoreMap> res = this.extractCoreMaps(annotation);
        Integer startTokenOffset = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (startTokenOffset == null) {
            startTokenOffset = 0;
        }
        Integer startTokenOffsetFinal = startTokenOffset;
        List<CoreMap> merged = CollectionUtils.mergeListWithSortedMatchedPreAggregated((List)annotation.get(this.tokensAnnotationKey), res, in -> Interval.toInterval((Integer)in.get(CoreAnnotations.TokenBeginAnnotation.class) - startTokenOffsetFinal, (Integer)in.get(CoreAnnotations.TokenEndAnnotation.class) - startTokenOffsetFinal));
        return merged;
    }

    public List<CoreMap> flatten(List<CoreMap> cms) {
        return CoreMapExpressionExtractor.flatten(cms, this.tokensAnnotationKey);
    }

    static List<CoreMap> flatten(List<CoreMap> cms, Class key) {
        ArrayList<CoreMap> res = new ArrayList<CoreMap>();
        for (CoreMap cm : cms) {
            if (cm.get(key) != null) {
                res.addAll((List)cm.get(key));
                continue;
            }
            res.add(cm);
        }
        return res;
    }

    private void cleanupTags(Collection objs, Map<Object, Boolean> cleaned) {
        for (Object obj : objs) {
            if (cleaned.containsKey(obj)) continue;
            cleaned.put(obj, false);
            if (obj instanceof CoreMap) {
                this.cleanupTags((CoreMap)obj, cleaned);
            } else if (obj instanceof Collection) {
                this.cleanupTags((Collection)obj, cleaned);
            }
            cleaned.put(obj, true);
        }
    }

    private void cleanupTags(CoreMap cm) {
        this.cleanupTags(cm, new IdentityHashMap<Object, Boolean>());
    }

    private void cleanupTags(CoreMap cm, Map<Object, Boolean> cleaned) {
        cm.remove(Tags.TagsAnnotation.class);
        for (Class<?> key : cm.keySet()) {
            Object obj = cm.get(key);
            if (cleaned.containsKey(obj)) continue;
            cleaned.put(obj, false);
            if (obj instanceof CoreMap) {
                this.cleanupTags((CoreMap)obj, cleaned);
            } else if (obj instanceof Collection) {
                this.cleanupTags((Collection)obj, cleaned);
            }
            cleaned.put(obj, true);
        }
    }

    public Pair<List<? extends CoreMap>, List<T>> applyCompositeRule(SequenceMatchRules.ExtractRule<List<? extends CoreMap>, T> compositeExtractRule, List<? extends CoreMap> merged, List<T> matchedExpressions, int limit) {
        boolean done = false;
        int maxIters = limit;
        int iters = 0;
        while (!done) {
            List<T> newExprs = new ArrayList();
            boolean extracted = compositeExtractRule.extract(merged, newExprs);
            if (extracted) {
                this.annotateExpressions(merged, newExprs);
                newExprs = MatchedExpression.removeNullValues(newExprs);
                if (newExprs.size() > 0) {
                    newExprs = MatchedExpression.removeNested(newExprs);
                    newExprs = MatchedExpression.removeOverlapping(newExprs);
                    merged = MatchedExpression.replaceMerged(merged, newExprs);
                    newExprs.addAll(matchedExpressions);
                    matchedExpressions = MatchedExpression.removeNested(newExprs);
                    matchedExpressions = MatchedExpression.removeOverlapping(matchedExpressions);
                } else {
                    extracted = false;
                }
            }
            done = !extracted;
            if (maxIters <= 0 || ++iters < maxIters) continue;
            this.logger.warning("Aborting application of composite rules: Maximum iteration " + maxIters + " reached");
            break;
        }
        return new Pair<List<? extends CoreMap>, List<T>>(merged, matchedExpressions);
    }

    public List<T> extractExpressions(CoreMap annotation) {
        List<Object> matchedExpressions = new ArrayList();
        ArrayList<Integer> stageIds = new ArrayList<Integer>(this.stages.keySet());
        Collections.sort(stageIds);
        Iterator iterator = stageIds.iterator();
        while (iterator.hasNext()) {
            int stageId = (Integer)iterator.next();
            Stage<T> stage = this.stages.get(stageId);
            SequenceMatchRules.ExtractRule basicExtractRule = stage.basicExtractRule;
            if (stage.clearMatched) {
                matchedExpressions.clear();
            }
            if (basicExtractRule != null) {
                basicExtractRule.extract(annotation, matchedExpressions);
                this.annotateExpressions(annotation, matchedExpressions);
                matchedExpressions = MatchedExpression.removeNullValues(matchedExpressions);
                matchedExpressions = MatchedExpression.removeNested(matchedExpressions);
                matchedExpressions = MatchedExpression.removeOverlapping(matchedExpressions);
            }
            List<? extends CoreMap> merged = MatchedExpression.replaceMergedUsingTokenOffsets((List)annotation.get(this.tokensAnnotationKey), matchedExpressions);
            SequenceMatchRules.ExtractRule compositeExtractRule = stage.compositeExtractRule;
            if (compositeExtractRule != null) {
                Pair p = this.applyCompositeRule(compositeExtractRule, merged, matchedExpressions, stage.limitIters);
                merged = p.first();
                matchedExpressions = p.second();
            }
            matchedExpressions = this.filterInvalidExpressions(stage.filterRule, matchedExpressions);
        }
        Collections.sort(matchedExpressions, MatchedExpression.EXPR_TOKEN_OFFSETS_NESTED_FIRST_COMPARATOR);
        if (!this.keepTags) {
            this.cleanupTags(annotation);
        }
        return matchedExpressions;
    }

    private void annotateExpressions(CoreMap annotation, List<T> expressions) {
        ArrayList<MatchedExpression> toDiscard = new ArrayList<MatchedExpression>();
        for (MatchedExpression te : expressions) {
            if (te.annotation != null) continue;
            try {
                boolean extrackOkay = te.extractAnnotation(this.env, annotation);
                if (extrackOkay) continue;
                toDiscard.add(te);
                this.logger.log(Level.WARNING, "Error extracting annotation from " + te);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error extracting annotation from " + te, ex);
            }
        }
        expressions.removeAll(toDiscard);
    }

    private void annotateExpressions(List<? extends CoreMap> chunks, List<T> expressions) {
        ArrayList<MatchedExpression> toDiscard = new ArrayList<MatchedExpression>();
        for (MatchedExpression te : expressions) {
            try {
                boolean extractOkay = te.extractAnnotation(this.env, chunks);
                if (extractOkay) continue;
                toDiscard.add(te);
                this.logger.log(Level.WARNING, "Error extracting annotation from " + te);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error extracting annotation from " + te, ex);
            }
        }
        expressions.removeAll(toDiscard);
    }

    private List<T> filterInvalidExpressions(Predicate<T> filterRule, List<T> expressions) {
        if (filterRule == null) {
            return expressions;
        }
        if (expressions.size() == 0) {
            return expressions;
        }
        int nfiltered = 0;
        ArrayList<MatchedExpression> kept = new ArrayList<MatchedExpression>(expressions.size());
        for (MatchedExpression expr : expressions) {
            if (!filterRule.test(expr)) {
                kept.add(expr);
                continue;
            }
            ++nfiltered;
        }
        if (nfiltered > 0) {
            this.logger.finest("Filtered " + nfiltered);
        }
        return kept;
    }

    private static class CompositeMatchState<T> {
        List<? extends CoreMap> merged;
        List<T> matched;
        int iters;

        private CompositeMatchState(List<? extends CoreMap> merged, List<T> matched, int iters) {
            this.merged = merged;
            this.matched = matched;
            this.iters = iters;
        }
    }

    public static class Stage<T> {
        boolean clearMatched = false;
        int limitIters = 50;
        int stageId;
        SequenceMatchRules.ExtractRule<CoreMap, T> basicExtractRule;
        SequenceMatchRules.ExtractRule<List<? extends CoreMap>, T> compositeExtractRule;
        Predicate<T> filterRule;

        private static <I, O> SequenceMatchRules.ExtractRule<I, O> addRule(SequenceMatchRules.ExtractRule<I, O> origRule, SequenceMatchRules.ExtractRule<I, O> rule) {
            SequenceMatchRules.ListExtractRule r;
            if (origRule instanceof SequenceMatchRules.ListExtractRule) {
                r = (SequenceMatchRules.ListExtractRule)origRule;
            } else {
                r = new SequenceMatchRules.ListExtractRule(new SequenceMatchRules.ExtractRule[0]);
                if (origRule != null) {
                    r.addRules(origRule);
                }
            }
            r.addRules(rule);
            return r;
        }

        private void addCompositeRule(SequenceMatchRules.ExtractRule<List<? extends CoreMap>, T> rule) {
            this.compositeExtractRule = Stage.addRule(this.compositeExtractRule, rule);
        }

        private void addBasicRule(SequenceMatchRules.ExtractRule<CoreMap, T> rule) {
            this.basicExtractRule = Stage.addRule(this.basicExtractRule, rule);
        }

        private void addFilterRule(Predicate<T> rule) {
            if (this.filterRule instanceof Filters.DisjFilter) {
                Filters.DisjFilter r = (Filters.DisjFilter)this.filterRule;
                r.addFilter(rule);
            } else {
                Filters.DisjFilter r = this.filterRule == null ? new Filters.DisjFilter(rule) : new Filters.DisjFilter(this.filterRule, rule);
                this.filterRule = r;
            }
        }
    }
}

