/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.nndep.Configuration;
import edu.stanford.nlp.parser.nndep.DependencyTree;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ParsingSystem {
    private final TreebankLanguagePack tlp;
    protected final String rootLabel;
    protected List<String> labels;
    protected List<String> transitions;

    protected abstract void makeTransitions();

    public abstract boolean canApply(Configuration var1, String var2);

    public abstract void apply(Configuration var1, String var2);

    public abstract String getOracle(Configuration var1, DependencyTree var2);

    abstract boolean isOracle(Configuration var1, String var2, DependencyTree var3);

    public abstract Configuration initialConfiguration(CoreMap var1);

    abstract boolean isTerminal(Configuration var1);

    public ParsingSystem(TreebankLanguagePack tlp, List<String> labels, boolean verbose) {
        this.tlp = tlp;
        this.labels = new ArrayList<String>(labels);
        this.rootLabel = labels.get(0);
        this.makeTransitions();
        if (verbose) {
            System.err.println("###################");
            System.err.println("#Transitions: " + this.transitions.size());
            System.err.println("#Labels: " + labels.size());
            System.err.println("ROOTLABEL: " + this.rootLabel);
        }
    }

    public int getTransitionID(String s) {
        for (int k = 0; k < this.transitions.size(); ++k) {
            if (!this.transitions.get(k).equals(s)) continue;
            return k;
        }
        return -1;
    }

    private Set<String> getPunctuationTags() {
        if (this.tlp instanceof PennTreebankLanguagePack) {
            return new HashSet<String>(Arrays.asList("``", "''", ".", ",", ":"));
        }
        return CollectionUtils.asSet(this.tlp.punctuationTags());
    }

    public Map<String, Double> evaluate(List<CoreMap> sentences, List<DependencyTree> trees, List<DependencyTree> goldTrees) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        Set<String> punctuationTags = this.getPunctuationTags();
        if (trees.size() != goldTrees.size()) {
            System.err.println("[Error] Incorrect number of trees.");
            return null;
        }
        int correctArcs = 0;
        int correctArcsWoPunc = 0;
        int correctHeads = 0;
        int correctHeadsWoPunc = 0;
        int correctTrees = 0;
        int correctTreesWoPunc = 0;
        int correctRoot = 0;
        int sumArcs = 0;
        int sumArcsWoPunc = 0;
        for (int i = 0; i < trees.size(); ++i) {
            List tokens = (List)sentences.get(i).get(CoreAnnotations.TokensAnnotation.class);
            if (trees.get((int)i).n != goldTrees.get((int)i).n) {
                System.err.println("[Error] Tree " + (i + 1) + ": incorrect number of nodes.");
                return null;
            }
            if (!trees.get(i).isTree()) {
                System.err.println("[Error] Tree " + (i + 1) + ": illegal.");
                return null;
            }
            int nCorrectHead = 0;
            int nCorrectHeadwoPunc = 0;
            int nonPunc = 0;
            for (int j = 1; j <= trees.get((int)i).n; ++j) {
                if (trees.get(i).getHead(j) == goldTrees.get(i).getHead(j)) {
                    ++correctHeads;
                    ++nCorrectHead;
                    if (trees.get(i).getLabel(j).equals(goldTrees.get(i).getLabel(j))) {
                        ++correctArcs;
                    }
                }
                ++sumArcs;
                String tag = ((CoreLabel)tokens.get(j - 1)).tag();
                if (punctuationTags.contains(tag)) continue;
                ++sumArcsWoPunc;
                ++nonPunc;
                if (trees.get(i).getHead(j) != goldTrees.get(i).getHead(j)) continue;
                ++correctHeadsWoPunc;
                ++nCorrectHeadwoPunc;
                if (!trees.get(i).getLabel(j).equals(goldTrees.get(i).getLabel(j))) continue;
                ++correctArcsWoPunc;
            }
            if (nCorrectHead == trees.get((int)i).n) {
                ++correctTrees;
            }
            if (nCorrectHeadwoPunc == nonPunc) {
                ++correctTreesWoPunc;
            }
            if (trees.get(i).getRoot() != goldTrees.get(i).getRoot()) continue;
            ++correctRoot;
        }
        result.put("UAS", (double)correctHeads * 100.0 / (double)sumArcs);
        result.put("UASwoPunc", (double)correctHeadsWoPunc * 100.0 / (double)sumArcsWoPunc);
        result.put("LAS", (double)correctArcs * 100.0 / (double)sumArcs);
        result.put("LASwoPunc", (double)correctArcsWoPunc * 100.0 / (double)sumArcsWoPunc);
        result.put("UEM", (double)correctTrees * 100.0 / (double)trees.size());
        result.put("UEMwoPunc", (double)correctTreesWoPunc * 100.0 / (double)trees.size());
        result.put("ROOT", (double)correctRoot * 100.0 / (double)trees.size());
        return result;
    }

    public double getUASScore(List<CoreMap> sentences, List<DependencyTree> trees, List<DependencyTree> goldTrees) {
        Map<String, Double> result = this.evaluate(sentences, trees, goldTrees);
        return result == null || !result.containsKey("UASwoPunc") ? -1.0 : result.get("UASwoPunc");
    }
}

